/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.rtf.rtflib.rtfdoc;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfAttributes;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfStringConverter;

public class RtfLeader
extends RtfContainer {
    private RtfAttributes attrs;
    public static final String LEADER_TABLEAD = "tablead";
    public static final String LEADER_USETAB = "tabuse";
    public static final String LEADER_WIDTH = "lwidth";
    public static final String LEADER_DOTTED = "uld";
    public static final String LEADER_MIDDLEDOTTED = "uldash";
    public static final String LEADER_HYPHENS = "ulhwave";
    public static final String LEADER_UNDERLINE = "ulthdashdd";
    public static final String LEADER_EQUAL = "uldb";
    public static final String LEADER_THICK = "ulth";
    public static final String LEADER_TAB_DOTTED = "tldot";
    public static final String LEADER_TAB_MIDDLEDOTTED = "tlmdot";
    public static final String LEADER_TAB_HYPHENS = "tlhyph";
    public static final String LEADER_TAB_UNDERLINE = "tlul";
    public static final String LEADER_TAB_EQUAL = "tleq";
    public static final String LEADER_TAB_THICK = "tlth";
    public static final String LEADER_IGNORE_STYLE = "pard";
    public static final String LEADER_RULE_THICKNESS = "fs";
    public static final String LEADER_PATTERN_WIDTH = "expndtw";
    public static final String LEADER_ZERO_WIDTH = "zwbo";
    public static final int LEADER_STANDARD_WIDTH = 30;
    public static final String LEADER_UP = "up4";
    public static final String LEADER_EXPAND = "expnd-2";
    public static final String LEADER_TAB_VALUE = "tab";
    public static final String LEADER_TAB_RIGHT = "tqr";
    public static final String LEADER_TAB_WIDTH = "tx";

    RtfLeader(RtfContainer parent, Writer w, RtfAttributes attrs) throws IOException {
        super(parent, w);
        this.attrs = attrs;
    }

    @Override
    protected void writeRtfContent() throws IOException {
        int thickness = 30;
        String tablead = null;
        String tabwidth = null;
        Iterator it = this.attrs.nameIterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            if (!this.attrs.isSet(name)) continue;
            if (name.equals(LEADER_TABLEAD)) {
                tablead = this.attrs.getValue(LEADER_TABLEAD).toString();
                continue;
            }
            if (!name.equals(LEADER_WIDTH)) continue;
            tabwidth = this.attrs.getValue(LEADER_WIDTH).toString();
        }
        if (this.attrs.getValue(LEADER_RULE_THICKNESS) != null) {
            thickness += Integer.parseInt(this.attrs.getValue(LEADER_RULE_THICKNESS).toString()) / 1000 * 2;
            this.attrs.unset(LEADER_RULE_THICKNESS);
        }
        this.attrs.unset(LEADER_WIDTH);
        this.attrs.unset(LEADER_TABLEAD);
        if (this.attrs.getValue(LEADER_USETAB) != null) {
            this.attrs.unset(LEADER_USETAB);
            this.writeControlWord(LEADER_TAB_RIGHT);
            if (tablead != null) {
                this.writeControlWord(tablead);
            }
            this.writeControlWord(LEADER_TAB_WIDTH + tabwidth);
            this.writeGroupMark(true);
            this.writeControlWord(LEADER_IGNORE_STYLE);
            this.writeAttributes(this.attrs, null);
            this.writeControlWord(LEADER_EXPAND);
            this.writeControlWord(LEADER_TAB_VALUE);
            this.writeGroupMark(false);
        } else {
            this.writeControlWord(LEADER_IGNORE_STYLE);
            this.writeControlWord(LEADER_ZERO_WIDTH);
            this.writeGroupMark(true);
            this.writeControlWord(LEADER_RULE_THICKNESS + thickness);
            this.writeControlWord(LEADER_UP);
            super.writeAttributes(this.attrs, null);
            if (tablead != null) {
                this.writeControlWord(tablead);
            }
            for (double d = (double)Integer.parseInt(tabwidth) / 560.0 * 7.5; d >= 1.0; d -= 1.0) {
                RtfStringConverter.getInstance().writeRtfString(this.writer, " ");
            }
            this.writeGroupMark(false);
            this.writeControlWord(LEADER_ZERO_WIDTH);
        }
    }

    @Override
    public boolean isEmpty() {
        return false;
    }
}

