/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.cif;

import java.util.Map;
import javajs.util.BC;
import javajs.util.SB;

class BCIFDecoder {
    static final int IGNORE = 0;
    static final int INT = 1;
    static final int FIXED = 2;
    static final int STRING = 3;
    int dataType = 1;
    private String type;
    private String key;
    private Object[] encodings;
    private BCIFDecoder offsetDecoder;
    private BCIFDecoder dataDecoder;
    private BCIFDecoder maskDecoder;
    private Map<String, Object> data;
    private int btype;
    private int byteLen;
    private int srcType;
    private int mode;
    private static final int MODE_DELTA = 1;
    private static final int MODE_RUNLEN = 2;
    private static final int MODE_PACKED = 4;
    private static final int MODE_FIXED = 8;
    boolean unsigned;
    private int srcSize;
    private int rowCount;
    String catname;
    String name;
    private int byteCount;
    private int origin = Integer.MIN_VALUE;
    private float factor;
    private byte[] byteData;
    private String stringData;
    private int stringLen;
    private float[] floatDoubleData;
    private int[] intData;
    private int[] indices;
    private int[] mask;
    private int[] offsets;
    boolean isDecoded;
    private char kind;
    private int packingSize;
    private String dtype;
    static final String nullString = "\u0000";
    static final int UNKNOWN_INT = Integer.MIN_VALUE;
    private static int[] temp;
    public static final boolean doBuildStrings = false;

    public BCIFDecoder(String key, Map<String, Object> col, SB sb) {
        this(sb, key, col, null, null);
    }

    public BCIFDecoder(Map<String, Object> encoding, String ekey, Object byteData, SB sb) {
        this(sb, ekey, encoding, ekey, byteData);
    }

    private BCIFDecoder(SB sb, String key, Map<String, Object> map, String ekey, Object byteData) {
        Object data;
        this.key = key;
        Object object = data = byteData == null ? map.get("data") : byteData;
        if (data instanceof Map) {
            this.data = (Map)data;
            data = this.data.get("data");
        }
        if (data instanceof byte[]) {
            this.setByteData(data);
        }
        if (ekey == null) {
            if (this.data == null) {
                this.encodings = (Object[])map.get("encoding");
            } else {
                this.name = (String)map.get("name");
                this.encodings = (Object[])this.data.get("encoding");
                Map mask = (Map)map.get("mask");
                if (mask != null) {
                    this.maskDecoder = new BCIFDecoder(mask, null, null, sb);
                    this.maskDecoder.dtype = "m";
                }
            }
        } else {
            this.encodings = (Object[])map.get(ekey);
            this.dtype = ekey.substring(0, 1);
        }
        this.initializeEncodings(this.encodings, sb);
        if (sb != null) {
            this.type = this.debugGetDecoderType(this.encodings);
            if (this.maskDecoder != null) {
                this.type = this.type + ".mask." + this.maskDecoder.toString();
            }
            sb.append(this + "\n");
        }
    }

    BCIFDecoder setRowCount(int rowCount, String catName) {
        this.rowCount = rowCount;
        this.catname = catName;
        return this;
    }

    private void setByteData(Object data) {
        this.byteData = (byte[])data;
        this.byteLen = this.byteData.length;
    }

    public String toString() {
        return this.type + (this.dtype == null ? "" : this.dtype) + (this.btype == 0 ? "[" + this.byteLen + "]" : "(srcSize/rowcount=" + this.srcSize + "/" + this.rowCount + " mode=" + this.mode + " bt=" + this.btype + " bl=" + this.byteLen + " sl=" + this.stringLen + ")") + (this.key == null ? "" : ":" + this.key);
    }

    private static char getMapChar(Map<String, Object> ht, String key) {
        String s = (String)ht.get(key);
        return s != null && s.length() > 0 ? s.charAt(0) : (char)'\u0000';
    }

    protected static int geMapInt(Object o) {
        return o == null ? 0 : ((Number)o).intValue();
    }

    private static boolean getMapBool(Object o) {
        return o == Boolean.TRUE;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void initializeEncodings(Object[] encodings, SB sb) {
        int n = encodings.length;
        int i = 0;
        while (true) {
            block15: {
                if (i >= n) {
                    return;
                }
                Map encoding = (Map)encodings[i];
                int kind = BCIFDecoder.getMapChar(encoding, "kind");
                if (encoding.containsKey("min")) {
                    kind = 81;
                    this.dataType = 0;
                }
                if (this.kind == '\u0000') {
                    this.kind = (char)kind;
                }
                switch (kind) {
                    case 70: {
                        this.factor = BCIFDecoder.geMapInt(encoding.get("factor"));
                        this.dataType = 2;
                        this.mode |= 8;
                        break;
                    }
                    case 68: {
                        this.origin = BCIFDecoder.geMapInt(encoding.get("origin"));
                        this.mode |= 1;
                        break;
                    }
                    case 82: {
                        this.mode |= 2;
                        this.srcSize = BCIFDecoder.geMapInt(encoding.get("srcSize"));
                        break;
                    }
                    case 73: {
                        this.mode |= 4;
                        this.packingSize = BCIFDecoder.geMapInt(encoding.get("srcSize"));
                        if (this.srcSize == 0) {
                            this.srcSize = this.packingSize;
                        }
                        this.unsigned = BCIFDecoder.getMapBool(encoding.get("isUnsigned"));
                        break block15;
                    }
                    case 66: {
                        this.btype = BCIFDecoder.geMapInt(encoding.get("type"));
                        int n2 = this.btype == 33 ? 8 : (this.byteCount = this.btype == 32 ? 4 : 1 << (this.btype - 1) % 3);
                        if (this.btype >= 32) {
                            this.dataType = 2;
                        }
                        break block15;
                    }
                    case 83: {
                        this.dataType = 3;
                        this.stringData = (String)encoding.get("stringData");
                        this.stringLen = this.stringData.length();
                        this.dataDecoder = new BCIFDecoder(encoding, "dataEncoding", this.byteData, sb);
                        this.offsetDecoder = new BCIFDecoder(encoding, "offsetEncoding", encoding.get("offsets"), sb);
                        break block15;
                    }
                }
                if (this.srcType == 0) {
                    this.srcType = BCIFDecoder.geMapInt(encoding.get("srcType"));
                }
            }
            ++i;
        }
    }

    public BCIFDecoder finalizeDecoding(SB sb) {
        if (this.isDecoded) {
            return this;
        }
        if (sb != null) {
            sb.append("finalizing " + this + "\n");
        }
        this.isDecoded = true;
        int[] nArray = this.mask = this.maskDecoder == null ? null : this.maskDecoder.finalizeDecoding((SB)sb).intData;
        if (this.mask != null && !BCIFDecoder.haveCheckMask(this.mask)) {
            if (sb != null) {
                sb.append("no valid data (mask completely '.' or '?'\n");
            }
            this.dataType = 0;
            return null;
        }
        if (this.mask != null && sb != null) {
            sb.append("mask = " + BCIFDecoder.debugToStr(this.mask) + "\n");
        }
        if (this.dataDecoder != null) {
            this.indices = this.dataDecoder.finalizeDecoding((SB)sb).intData;
            this.offsets = this.offsetDecoder.finalizeDecoding((SB)sb).intData;
            if (sb != null) {
                sb.append("stringData = " + BCIFDecoder.debugToStr(this.stringData) + "\n");
                sb.append("indices = " + BCIFDecoder.debugToStr(this.indices) + "\n");
                sb.append("offsets = " + BCIFDecoder.debugToStr(this.offsets) + "\n");
            }
        } else {
            if (sb != null) {
                sb.append("bytes->int " + this.byteData.length / this.byteCount + " rc=" + this.rowCount + " ps=" + this.packingSize + "\n");
            }
            int[] run = null;
            int len = this.srcSize;
            if ((this.mode & 2) == 2) {
                run = BCIFDecoder.getTemp(this.srcSize);
                len = this.srcSize;
            }
            if ((this.mode & 4) == 4) {
                this.intData = BCIFDecoder.unpackInts(this.byteData, this.byteCount, len, this.unsigned, this.origin, run);
            } else if (this.btype == 32 || this.btype == 33) {
                this.floatDoubleData = this.bytesToFixedPt(this.byteData, this.btype == 32 ? 4 : 8);
            } else {
                this.intData = BCIFDecoder.bytesToInt(this.byteData, this.byteCount, len, this.unsigned, this.origin, run);
            }
        }
        return this;
    }

    private static boolean haveCheckMask(int[] mask) {
        int i = mask.length;
        while (--i >= 0) {
            if (mask[i] != 0) continue;
            return true;
        }
        return false;
    }

    public String getStringValue(int row) {
        if (this.dataType != 3 || this.mask != null && this.mask[row] != 0) {
            return nullString;
        }
        int pt = this.indices[row];
        return this.stringData.substring(this.offsets[pt++], pt == this.rowCount ? this.stringLen : this.offsets[pt]);
    }

    public int getIntValue(int row) {
        return this.dataType != 1 || this.mask != null && this.mask[row] != 0 ? Integer.MIN_VALUE : this.intData[row];
    }

    public float getFixedPtValue(int row) {
        return this.dataType != 2 || this.mask != null && this.mask[row] != 0 ? Float.NaN : (this.floatDoubleData == null ? (float)this.intData[row] / this.factor : this.floatDoubleData[row]);
    }

    private float[] bytesToFixedPt(byte[] b, int byteLen) {
        if (b == null) {
            return null;
        }
        int n = b.length / byteLen;
        float[] a = new float[n];
        try {
            switch (byteLen) {
                case 4: {
                    int i = 0;
                    int j = 0;
                    while (i < n) {
                        a[i] = BC.bytesToFloat(b, j, false);
                        ++i;
                        j += 4;
                    }
                    break;
                }
                case 8: {
                    int i = 0;
                    int j = 0;
                    while (i < n) {
                        a[i] = BC.bytesToDoubleToFloat(b, j, false);
                        ++i;
                        j += 8;
                    }
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return a;
    }

    public static int[] bytesToInt(byte[] b, int byteLen, int rowCount, boolean unsigned, int origin, int[] run) {
        int i;
        if (b == null) {
            return null;
        }
        int n = b.length / byteLen;
        int[] ret = new int[rowCount == 0 ? n : rowCount];
        int[] a = run == null ? ret : run;
        switch (byteLen) {
            case 1: {
                int ii;
                i = 0;
                int j = 0;
                while (i < n) {
                    ii = b[j] & 0xFF;
                    a[i] = unsigned ? ii : (ii > 239 ? ii - 256 : ii);
                    ++i;
                    ++j;
                }
                break;
            }
            case 2: {
                int ii;
                i = 0;
                int j = 0;
                while (i < n) {
                    ii = BC.bytesToShort(b, j, false);
                    a[i] = unsigned ? ii & 0xFFFF : ii;
                    ++i;
                    j += 2;
                }
                break;
            }
            case 4: {
                i = 0;
                int j = 0;
                while (i < n) {
                    a[i] = BC.bytesToInt(b, j, false);
                    ++i;
                    j += 4;
                }
                break;
            }
        }
        if (run != null) {
            int p = 0;
            int i2 = 0;
            while (i2 < n) {
                int val = a[i2++];
                int j = a[i2++];
                while (--j >= 0) {
                    ret[p++] = val;
                }
            }
        }
        if (origin != Integer.MIN_VALUE) {
            for (i = 0; i < rowCount; ++i) {
                origin = ret[i] = origin + ret[i];
            }
        }
        return ret;
    }

    public static int[] unpackInts(byte[] b, int byteLen, int srcSize, boolean unsigned, int origin, int[] run) {
        int i;
        if (b == null) {
            return null;
        }
        int[] ret = new int[srcSize];
        int[] a = run == null ? ret : run;
        switch (byteLen) {
            case 1: {
                int val;
                int max = unsigned ? 255 : 127;
                i = 0;
                int pt = 0;
                int n = b.length;
                int offset = 0;
                while (pt < n) {
                    val = b[pt++];
                    if (unsigned) {
                        val &= max;
                    }
                    if (val == max || val == -128) {
                        offset += val;
                        continue;
                    }
                    a[i++] = val + offset;
                    offset = 0;
                }
                break;
            }
            case 2: {
                int val;
                int max = unsigned ? 65535 : Short.MAX_VALUE;
                i = 0;
                int pt = 0;
                int n = b.length / 2;
                int offset = 0;
                while (pt < n) {
                    val = BC.bytesToShort(b, pt++ << 1, false);
                    if (unsigned) {
                        val &= max;
                    }
                    if (val == max || val == Short.MIN_VALUE) {
                        offset += val;
                        continue;
                    }
                    a[i++] = val + offset;
                    offset = 0;
                }
                break;
            }
        }
        if (run != null) {
            int p = 0;
            int i2 = 0;
            while (p < srcSize) {
                int val = a[i2];
                int j = a[++i2];
                while (--j >= 0) {
                    ret[p++] = val;
                }
                ++i2;
            }
        }
        if (origin != Integer.MIN_VALUE) {
            for (i = 0; i < srcSize; ++i) {
                origin = ret[i] = origin + ret[i];
            }
        }
        return ret;
    }

    public static int[] getTemp(int n) {
        if (temp == null || temp.length < n) {
            temp = new int[Math.max(n, 1000)];
        }
        return temp;
    }

    public static void clearTemp() {
        temp = null;
    }

    public Object debugDecode(SB sb) {
        this.finalizeDecoding(sb);
        switch (this.dataType) {
            case 1: {
                return this.getDebugDataIntColumn();
            }
            case 2: {
                return this.debugGetDataFloatColumn();
            }
            case 3: {
                return this.stringData;
            }
        }
        return null;
    }

    protected int[] getDebugDataIntColumn() {
        if (this.dataType != 1) {
            return null;
        }
        if (this.mask != null) {
            int i = this.rowCount;
            while (--i >= 0) {
                if (this.mask[i] == 0) continue;
                this.intData[i] = Integer.MIN_VALUE;
            }
        }
        return this.intData;
    }

    protected float[] debugGetDataFloatColumn() {
        if ((this.mode & 8) != 8) {
            return null;
        }
        float[] fixedData = new float[this.rowCount];
        int i = this.rowCount;
        while (--i >= 0) {
            fixedData[i] = this.mask != null && this.mask[i] != 0 ? Float.NaN : (float)this.intData[i] / this.factor;
        }
        return fixedData;
    }

    protected String[] debugGetDataStringColumn() {
        String[] data = new String[this.rowCount];
        int len = this.stringData.length();
        block5: for (int i = 0; i < this.rowCount; ++i) {
            switch (this.mask == null ? 0 : this.mask[i]) {
                case 0: {
                    int pt = this.indices[i];
                    data[i] = this.stringData.substring(this.offsets[pt++], pt == this.rowCount ? len : this.offsets[pt]);
                    continue block5;
                }
                case 1: {
                    data[i] = nullString;
                    continue block5;
                }
                case 2: {
                    data[i] = nullString;
                }
            }
        }
        return data;
    }

    private String debugGetDecoderType(Object[] encodings) {
        SB sb = new SB();
        int n = encodings.length;
        block6: for (int i = 0; i < n; ++i) {
            Map encoding = (Map)encodings[i];
            char kind = BCIFDecoder.getMapChar(encoding, "kind");
            if (encoding.containsKey("min")) {
                kind = 'Q';
            }
            sb.appendC(kind);
            switch (kind) {
                case 'B': {
                    sb.appendI(this.btype);
                    continue block6;
                }
                case 'D': 
                case 'F': 
                case 'R': {
                    break;
                }
                case 'S': {
                    sb.appendC('.');
                    sb.append(this.dataDecoder.toString());
                    sb.appendC('.');
                    sb.append(this.offsetDecoder.toString());
                    sb.appendC('.');
                    continue block6;
                }
                case 'I': {
                    sb.appendI(BCIFDecoder.geMapInt(encoding.get("byteCount")));
                    if (!this.unsigned) continue block6;
                    sb.appendC('u');
                    continue block6;
                }
                default: {
                    sb.appendC('?');
                    continue block6;
                }
            }
            sb.appendI(this.srcType);
        }
        return sb.toString();
    }

    private static String debugToStr(Object o) {
        if (o instanceof int[]) {
            return BCIFDecoder.debugToStrI((int[])o);
        }
        if (o instanceof byte[]) {
            return BCIFDecoder.debugToStrB((byte[])o);
        }
        if (o instanceof float[]) {
            return BCIFDecoder.debugToStrD((float[])o);
        }
        if (o instanceof String) {
            String s = (String)o;
            return s.length() < 100 ? s : s.substring(0, 100) + "..." + s.length();
        }
        return BCIFDecoder.debugToStrO((Object[])o);
    }

    private static String debugToStrO(Object[] o) {
        SB sb = new SB();
        int sep = 91;
        int n = Math.min(o.length, 20);
        for (int i = 0; i < n; ++i) {
            sb.appendC((char)sep).appendO(o[i]);
            sep = 44;
        }
        if (n < o.length) {
            sb.append("...").appendI(o.length);
        }
        sb.appendC(']');
        return sb.toString();
    }

    private static String debugToStrI(int[] o) {
        SB sb = new SB();
        int sep = 91;
        int n = Math.min(o.length, 20);
        for (int i = 0; i < n; ++i) {
            sb.appendC((char)sep).appendI(o[i]);
            sep = 44;
        }
        if (n < o.length) {
            sb.append("...").appendI(o.length);
        }
        sb.appendC(']');
        return sb.toString();
    }

    private static String debugToStrB(byte[] o) {
        SB sb = new SB();
        int sep = 91;
        int n = Math.min(o.length, 20);
        for (int i = 0; i < n; ++i) {
            sb.appendC((char)sep).appendI(o[i]);
            sep = 44;
        }
        if (n < o.length) {
            sb.append("...").appendI(o.length);
        }
        sb.appendC(']');
        return sb.toString();
    }

    private static String debugToStrD(float[] o) {
        SB sb = new SB();
        int sep = 91;
        int n = Math.min(o.length, 20);
        for (int i = 0; i < n; ++i) {
            sb.appendC((char)sep).appendD(o[i]);
            sep = 44;
        }
        if (n < o.length) {
            sb.append("...").appendI(o.length);
        }
        sb.appendC(']');
        return sb.toString();
    }
}

