/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xtal;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.Lst;
import javajs.util.PT;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.util.Logger;

public class PWmatReader
extends AtomSetCollectionReader {
    private int nAtoms;
    private boolean haveLattice;
    private boolean havePositions;
    private boolean haveMagnetic = false;
    private String global3 = ";STRESS_MASK;STRESS_EXTERNAL;PTENSOR_EXTERNAL;";

    @Override
    protected void initializeReader() throws Exception {
        if (!this.filteredPrecision) {
            this.precision = 12;
        }
        this.doApplySymmetry = true;
    }

    @Override
    protected boolean checkLine() throws Exception {
        if (this.nAtoms == 0) {
            this.readComments();
            this.setSpaceGroupName("P1");
            this.nAtoms = PT.parseInt(this.line);
            this.setFractionalCoordinates(true);
            return true;
        }
        this.removeComments();
        String lc = this.line.toLowerCase().trim();
        if (lc.length() == 0) {
            return true;
        }
        if (!this.haveLattice) {
            if (lc.startsWith("lattice")) {
                this.readUnitCell();
                this.haveLattice = true;
            }
            return true;
        }
        if (!this.havePositions) {
            if (lc.startsWith("position")) {
                this.readCoordinates();
                this.havePositions = true;
            }
            return true;
        }
        if (!this.readDataBlock(lc)) {
            this.continuing = false;
        }
        return true;
    }

    private void readComments() {
    }

    private void readUnitCell() throws Exception {
        float[] unitCellData = new float[3];
        this.addExplicitLatticeVector(0, this.fillFloatArray(this.getLine(), 0, unitCellData), 0);
        this.addExplicitLatticeVector(1, this.fillFloatArray(this.getLine(), 0, unitCellData), 0);
        this.addExplicitLatticeVector(2, this.fillFloatArray(this.getLine(), 0, unitCellData), 0);
    }

    private void readCoordinates() throws Exception {
        Lst<float[]> constraints = new Lst<float[]>();
        boolean haveConstraints = true;
        int i = 0;
        while (i++ < this.nAtoms && this.getLine() != null) {
            String[] tokens = this.getTokens();
            int z = Integer.parseInt(tokens[0]);
            this.addAtomXYZSymName((String[])tokens, (int)1, (String)PWmatReader.getElementSymbol((int)z), null).elementNumber = (short)z;
            haveConstraints = tokens.length >= 7 && haveConstraints;
            if (!haveConstraints) continue;
            constraints.addLast(new float[]{Float.parseFloat(tokens[4]), Float.parseFloat(tokens[5]), Float.parseFloat(tokens[6])});
        }
        float[] cx = new float[this.nAtoms];
        float[] cy = new float[this.nAtoms];
        float[] cz = new float[this.nAtoms];
        float[] c = new float[]{1.0f, 1.0f, 1.0f};
        i = this.nAtoms;
        while (--i >= 0) {
            if (haveConstraints) {
                c = (float[])constraints.get(i);
            }
            cx[i] = c[0];
            cy[i] = c[1];
            cz[i] = c[2];
        }
        this.setVectors("constraints", cx, cy, cz, this.nAtoms);
    }

    private boolean readDataBlock(String name) throws Exception {
        name = this.trimPWPropertyNameTo(name, " ([,");
        this.getLine();
        if (this.line == null) {
            return false;
        }
        String[] tokens = this.getTokens();
        switch (tokens.length) {
            case 1: 
            case 2: 
            case 3: {
                this.readItems(name, tokens.length - 1, null);
                return true;
            }
            case 4: {
                this.readVectors(name, 1, true);
                return true;
            }
        }
        Logger.error("PWmatReader block " + name.toUpperCase() + " ignored");
        return false;
    }

    private String trimPWPropertyNameTo(String name, String chars) {
        int i = chars.length();
        while (--i >= 0) {
            int pt = name.indexOf(chars.charAt(i));
            if (pt <= 0) continue;
            name = name.substring(0, pt);
        }
        return name;
    }

    private void readItems(String name, int offset, float[] values) throws Exception {
        boolean isGlobal;
        if (name.equalsIgnoreCase("magnetic")) {
            this.haveMagnetic = true;
        }
        if (isGlobal = PT.isOneOf(name.toUpperCase(), this.global3)) {
            String[] lines = new String[]{this.line, this.getLine(), this.getLine()};
            Map<String, Object> info = this.asc.getAtomSetAuxiliaryInfo(0);
            Hashtable<String, String[]> data = (Hashtable<String, String[]>)info.get("globalPWmatData");
            if (data == null) {
                data = new Hashtable<String, String[]>();
                info.put("globalPWmatData", data);
            }
            data.put(name, lines);
        } else {
            name = "pwm_" + name;
            if (values == null) {
                values = new float[this.nAtoms];
            } else {
                this.getLine();
            }
            int n = 0;
            int i = 0;
            while (true) {
                String[] tokens;
                if ((values[i] = Float.parseFloat((tokens = this.getTokens())[offset])) != 0.0f) {
                    ++n;
                }
                if (++i == this.nAtoms) break;
                this.getLine();
            }
            this.setProperties(name, values, n);
        }
    }

    private void setProperties(String name, float[] values, int n) {
        this.asc.setAtomProperties(name, values, this.asc.iSet, false);
        Logger.info("PWmatReader: " + name.toUpperCase() + " processed for " + n + " atoms");
        this.appendLoadNote("PWmatReader read property_" + name);
    }

    private void readVectors(String name, int offset, boolean haveLine) throws Exception {
        if (!haveLine) {
            this.getLine();
        }
        float[] valuesX = new float[this.nAtoms];
        float[] valuesY = new float[this.nAtoms];
        float[] valuesZ = new float[this.nAtoms];
        int n = 0;
        int i = 0;
        while (true) {
            String[] tokens;
            valuesY[i] = Float.parseFloat(tokens[offset + 1]);
            valuesZ[i] = Float.parseFloat(tokens[offset + 2]);
            tokens = this.getTokens();
            valuesX[i] = Float.parseFloat(tokens[offset]);
            if (valuesX[i] != 0.0f | valuesY[i] != 0.0f | valuesZ[i] != 0.0f) {
                ++n;
            }
            if (++i == this.nAtoms) break;
            this.getLine();
        }
        this.setVectors(name, valuesX, valuesY, valuesZ, n);
    }

    private String getLine() throws Exception {
        this.rd();
        return this.removeComments();
    }

    private String removeComments() {
        int pt;
        if (this.line != null && (pt = this.line.indexOf("#")) >= 0) {
            this.line = this.line.substring(0, pt).trim();
        }
        return this.line;
    }

    private void setVectors(String name, float[] valuesX, float[] valuesY, float[] valuesZ, int n) {
        name = "pwm_" + name;
        this.asc.setAtomProperties(name + "_x", valuesX, this.asc.iSet, false);
        this.asc.setAtomProperties(name + "_y", valuesY, this.asc.iSet, false);
        this.asc.setAtomProperties(name + "_z", valuesZ, this.asc.iSet, false);
        Logger.info("PWmatReader: " + name.toUpperCase() + " processed for " + n + " atoms");
        this.appendLoadNote("PWmatReader read property_" + name + "_x");
        this.appendLoadNote("PWmatReader read property_" + name + "_y");
        this.appendLoadNote("PWmatReader read property_" + name + "_z");
        if (name.equals("pwm_magnetic_xyz")) {
            for (int i = 0; i < this.nAtoms; ++i) {
                this.asc.addVibrationVector(i, valuesX[i], valuesY[i], valuesZ[i]);
            }
            this.addJmolScript("vectors 0.2;set vectorscentered");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void applySymmetryAndSetTrajectory() throws Exception {
        super.applySymmetryAndSetTrajectory();
        if (this.nAtoms != this.asc.ac) {
            this.nAtoms = this.asc.ac;
            Map p = (Map)this.asc.getAtomSetAuxiliaryInfoValue(this.asc.iSet, "atomProperties");
            if (p != null) {
                int[] map;
                Atom[] atoms = this.asc.atoms;
                int n = this.asc.bsAtoms == null ? this.nAtoms : this.asc.bsAtoms.cardinality();
                int[] nArray = map = n == this.nAtoms ? null : new int[this.nAtoms];
                if (map != null) {
                    boolean bl = false;
                    for (int j = 0; j < this.nAtoms; ++j) {
                        void var6_8;
                        if (!this.asc.bsAtoms.get(j)) continue;
                        map[j] = ++var6_8;
                    }
                }
                for (Map.Entry entry : p.entrySet()) {
                    String key = (String)entry.getKey();
                    if (!key.startsWith("pwm_")) continue;
                    float[] af = (float[])entry.getValue();
                    float[] af2 = new float[n];
                    for (int j = 0; j < this.nAtoms; ++j) {
                        af2[map == null ? j : map[j]] = af[atoms[j].atomSite];
                    }
                    entry.setValue(af2);
                }
            }
        }
    }

    @Override
    protected void finalizeSubclassReader() throws Exception {
        if (!this.haveMagnetic && this.asc.ac > 0) {
            this.setProperties("pwm_magnetic", new float[this.asc.ac], this.nAtoms);
        }
    }
}

