/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.dataflow.analyses;

import java.util.Collection;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.jruby.dirgra.Edge;
import org.jruby.ir.IRScope;
import org.jruby.ir.Operation;
import org.jruby.ir.dataflow.FlowGraphNode;
import org.jruby.ir.dataflow.analyses.LiveVariablesProblem;
import org.jruby.ir.dataflow.analyses.StoreLocalVarPlacementProblem;
import org.jruby.ir.instructions.BreakInstr;
import org.jruby.ir.instructions.ClosureAcceptingInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.instructions.ReturnBase;
import org.jruby.ir.instructions.StoreLocalVarInstr;
import org.jruby.ir.interpreter.FullInterpreterContext;
import org.jruby.ir.operands.ClosureLocalVariable;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.operands.WrappedIRClosure;
import org.jruby.ir.representations.BasicBlock;

public class StoreLocalVarPlacementNode
extends FlowGraphNode<StoreLocalVarPlacementProblem, StoreLocalVarPlacementNode> {
    Set<LocalVariable> inDirtyVars;
    Set<LocalVariable> outDirtyVars;
    Set<LocalVariable> dirtyVars;

    public StoreLocalVarPlacementNode(StoreLocalVarPlacementProblem prob, BasicBlock n) {
        super(prob, n);
    }

    @Override
    public void init() {
        this.outDirtyVars = new HashSet<LocalVariable>();
        if (this.getBB().isRescueEntry()) {
            this.inDirtyVars = new HashSet<LocalVariable>();
        }
    }

    @Override
    public void buildDataFlowVars(Instr i2) {
    }

    @Override
    public void applyPreMeetHandler() {
        BasicBlock bb = this.getBB();
        if (!bb.isRescueEntry()) {
            this.inDirtyVars = new HashSet<LocalVariable>();
            if (bb.isExitBB()) {
                LiveVariablesProblem lvp = (LiveVariablesProblem)((StoreLocalVarPlacementProblem)this.problem).getFIC().getDataFlowProblems().get("Live Variables Analysis");
                Collection<LocalVariable> liveVars = lvp.getLocalVarsLiveOnScopeEntry();
                if (liveVars != null) {
                    this.inDirtyVars.retainAll(liveVars);
                } else {
                    this.inDirtyVars.clear();
                }
            }
        }
    }

    @Override
    public void compute_MEET(Edge e, StoreLocalVarPlacementNode pred2) {
        if (!pred2.basicBlock.isRescueEntry()) {
            this.inDirtyVars.addAll(pred2.outDirtyVars);
        }
    }

    @Override
    public void initSolution() {
        this.dirtyVars = new HashSet<LocalVariable>(this.inDirtyVars);
    }

    @Override
    public void applyTransferFunction(Instr i2) {
        Variable v;
        boolean scopeBindingHasEscaped = ((StoreLocalVarPlacementProblem)this.problem).getFIC().bindingHasEscaped();
        if (i2 instanceof ClosureAcceptingInstr) {
            Operand o = ((ClosureAcceptingInstr)((Object)i2)).getClosureArg();
            if (o != null && o instanceof WrappedIRClosure) {
                FullInterpreterContext clfic = ((WrappedIRClosure)o).getClosure().getFullInterpreterContext();
                boolean spillAllVars = scopeBindingHasEscaped;
                HashSet<LocalVariable> newDirtyVars = new HashSet<LocalVariable>(this.dirtyVars);
                for (LocalVariable v2 : this.dirtyVars) {
                    if (!spillAllVars && !clfic.usesLocalVariable(v2) && !clfic.definesLocalVariable(v2)) continue;
                    newDirtyVars.remove(v2);
                }
                this.dirtyVars = newDirtyVars;
            } else if (scopeBindingHasEscaped) {
                this.dirtyVars.clear();
            } else {
                HashSet<LocalVariable> newDirtyVars = new HashSet<LocalVariable>(this.dirtyVars);
                for (LocalVariable v3 : this.dirtyVars) {
                    if (!(v3 instanceof ClosureLocalVariable) || !((ClosureLocalVariable)v3).isOuterScopeVar()) continue;
                    newDirtyVars.remove(v3);
                }
                this.dirtyVars = newDirtyVars;
            }
        } else if ((i2 instanceof ReturnBase || i2 instanceof BreakInstr) && !this.getBB().isExitBB()) {
            LiveVariablesProblem lvp = (LiveVariablesProblem)((StoreLocalVarPlacementProblem)this.problem).getFIC().getDataFlowProblems().get("Live Variables Analysis");
            Collection<LocalVariable> liveVars = lvp.getLocalVarsLiveOnScopeEntry();
            if (liveVars != null) {
                this.dirtyVars.retainAll(liveVars);
            } else {
                this.dirtyVars.clear();
            }
        }
        if (scopeBindingHasEscaped && i2.getOperation() == Operation.PUT_GLOBAL_VAR) {
            this.dirtyVars.clear();
        }
        if (i2.canRaiseException() && this.hasExceptionsRescued()) {
            this.dirtyVars.clear();
        }
        if (i2 instanceof ResultInstr && (v = ((ResultInstr)((Object)i2)).getResult()) instanceof LocalVariable && !v.isSelf()) {
            this.dirtyVars.add((LocalVariable)v);
        }
    }

    @Override
    public boolean solutionChanged() {
        return !this.outDirtyVars.equals(this.dirtyVars);
    }

    @Override
    public void finalizeSolution() {
        this.outDirtyVars = this.dirtyVars;
    }

    public String toString() {
        return "";
    }

    public boolean addStores(Map<Operand, Operand> varRenameMap, Set<LocalVariable> excTargetDirtyVars) {
        FullInterpreterContext fic = ((StoreLocalVarPlacementProblem)this.problem).getFIC();
        IRScope scope = fic.getScope();
        boolean addedStores = false;
        boolean scopeBindingHasEscaped = fic.bindingHasEscaped();
        ListIterator<Instr> instrs = this.basicBlock.getInstrs().listIterator();
        this.initSolution();
        while (instrs.hasNext()) {
            Variable v;
            Instr i2 = instrs.next();
            if (i2 instanceof ClosureAcceptingInstr) {
                Operand o = ((ClosureAcceptingInstr)((Object)i2)).getClosureArg();
                if (o != null && o instanceof WrappedIRClosure) {
                    FullInterpreterContext clfic = ((WrappedIRClosure)o).getClosure().getFullInterpreterContext();
                    instrs.previous();
                    boolean spillAllVars = scopeBindingHasEscaped;
                    HashSet<LocalVariable> newDirtyVars = new HashSet<LocalVariable>(this.dirtyVars);
                    for (LocalVariable v2 : this.dirtyVars) {
                        if (!spillAllVars && !clfic.usesLocalVariable(v2) && !clfic.definesLocalVariable(v2)) continue;
                        addedStores = true;
                        instrs.add(new StoreLocalVarInstr(scope, (Operand)((StoreLocalVarPlacementProblem)this.problem).getLocalVarReplacement(v2, varRenameMap), v2));
                        newDirtyVars.remove(v2);
                    }
                    this.dirtyVars = newDirtyVars;
                    instrs.next();
                } else if (scopeBindingHasEscaped) {
                    instrs.previous();
                    for (LocalVariable v3 : this.dirtyVars) {
                        addedStores = true;
                        instrs.add(new StoreLocalVarInstr(scope, (Operand)((StoreLocalVarPlacementProblem)this.problem).getLocalVarReplacement(v3, varRenameMap), v3));
                    }
                    instrs.next();
                    this.dirtyVars.clear();
                } else {
                    instrs.previous();
                    HashSet<LocalVariable> newDirtyVars = new HashSet<LocalVariable>(this.dirtyVars);
                    for (LocalVariable v4 : this.dirtyVars) {
                        if ((!(v4 instanceof ClosureLocalVariable) || !((ClosureLocalVariable)v4).isOuterScopeVar()) && (v4 instanceof ClosureLocalVariable || !scope.getScopeType().isClosureType())) continue;
                        addedStores = true;
                        instrs.add(new StoreLocalVarInstr(scope, (Operand)((StoreLocalVarPlacementProblem)this.problem).getLocalVarReplacement(v4, varRenameMap), v4));
                        newDirtyVars.remove(v4);
                    }
                    this.dirtyVars = newDirtyVars;
                    instrs.next();
                }
            } else if (i2 instanceof ReturnBase || i2 instanceof BreakInstr) {
                if (!this.basicBlock.isExitBB()) {
                    LiveVariablesProblem lvp = (LiveVariablesProblem)fic.getDataFlowProblems().get("Live Variables Analysis");
                    Collection<LocalVariable> liveVars = lvp.getLocalVarsLiveOnScopeEntry();
                    if (liveVars != null) {
                        this.dirtyVars.retainAll(liveVars);
                    } else {
                        this.dirtyVars.clear();
                    }
                }
                instrs.previous();
                boolean f = ((StoreLocalVarPlacementProblem)this.problem).addScopeExitStoreLocalVars(instrs, this.dirtyVars, varRenameMap);
                addedStores = addedStores || f;
                instrs.next();
                this.dirtyVars.clear();
            }
            if (scopeBindingHasEscaped && i2.getOperation() == Operation.PUT_GLOBAL_VAR || i2.getOperation() == Operation.THREAD_POLL) {
                instrs.previous();
                for (LocalVariable v5 : this.dirtyVars) {
                    addedStores = true;
                    instrs.add(new StoreLocalVarInstr(scope, (Operand)((StoreLocalVarPlacementProblem)this.problem).getLocalVarReplacement(v5, varRenameMap), v5));
                }
                instrs.next();
                this.dirtyVars.clear();
            }
            if (i2.canRaiseException()) {
                if (this.hasExceptionsRescued()) {
                    instrs.previous();
                    for (LocalVariable v5 : this.dirtyVars) {
                        addedStores = true;
                        instrs.add(new StoreLocalVarInstr(scope, (Operand)((StoreLocalVarPlacementProblem)this.problem).getLocalVarReplacement(v5, varRenameMap), v5));
                    }
                    instrs.next();
                    this.dirtyVars.clear();
                } else if (excTargetDirtyVars != null) {
                    excTargetDirtyVars.addAll(this.dirtyVars);
                }
            }
            if (!(i2 instanceof ResultInstr) || !((v = ((ResultInstr)((Object)i2)).getResult()) instanceof LocalVariable) || v.isSelf()) continue;
            LocalVariable lv = (LocalVariable)v;
            this.dirtyVars.add(lv);
            ((StoreLocalVarPlacementProblem)this.problem).getLocalVarReplacement(lv, varRenameMap);
        }
        if (this.basicBlock.isExitBB()) {
            if (instrs.hasPrevious()) {
                instrs.previous();
            }
            boolean f = ((StoreLocalVarPlacementProblem)this.problem).addScopeExitStoreLocalVars(instrs, this.dirtyVars, varRenameMap);
            addedStores = addedStores || f;
        }
        return addedStores;
    }
}

