/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.phaser.NamedCompilerPhase;
import org.jetbrains.kotlin.backend.common.phaser.PhaseBuildersKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.lower.PolymorphicSignatureLoweringKt;
import org.jetbrains.kotlin.backend.jvm.lower.VarargLoweringKt;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.builtins.UnsignedType;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\f\u0010\r\u001a\u00020\u000e*\u00020\u000fH\u0000\u001a\f\u0010\u0010\u001a\u00020\u000e*\u00020\u000fH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"-\u0010\u0006\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t`\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"ARRAY_OF_NAME", "", "PRIMITIVE_ARRAY_OF_NAMES", "", "getPRIMITIVE_ARRAY_OF_NAMES", "()Ljava/util/Set;", "varargPhase", "Lorg/jetbrains/kotlin/backend/common/phaser/NamedCompilerPhase;", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "Lorg/jetbrains/kotlin/backend/common/phaser/SameTypeNamedCompilerPhase;", "getVarargPhase", "()Lorg/jetbrains/kotlin/backend/common/phaser/NamedCompilerPhase;", "isArrayOf", "", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "isEmptyArray", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nVarargLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VarargLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/VarargLoweringKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,118:1\n1#2:119\n11065#3:120\n11400#3,3:121\n1549#4:124\n1620#4,3:125\n*S KotlinDebug\n*F\n+ 1 VarargLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/VarargLoweringKt\n*L\n97#1:120\n97#1:121,3\n98#1:124\n98#1:125,3\n*E\n"})
public final class VarargLoweringKt {
    @NotNull
    private static final NamedCompilerPhase<JvmBackendContext, IrFile> varargPhase;
    @NotNull
    private static final Set<String> PRIMITIVE_ARRAY_OF_NAMES;
    @NotNull
    public static final String ARRAY_OF_NAME = "arrayOf";

    @NotNull
    public static final NamedCompilerPhase<JvmBackendContext, IrFile> getVarargPhase() {
        return varargPhase;
    }

    @NotNull
    public static final Set<String> getPRIMITIVE_ARRAY_OF_NAMES() {
        return PRIMITIVE_ARRAY_OF_NAMES;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isArrayOf(@NotNull IrFunction $this$isArrayOf) {
        IrPackageFragment irPackageFragment;
        Intrinsics.checkNotNullParameter($this$isArrayOf, "<this>");
        IrDeclarationParent directParent = $this$isArrayOf.getParent();
        if (directParent instanceof IrClass) {
            irPackageFragment = IrUtilsKt.getPackageFragment((IrDeclaration)((Object)directParent));
        } else {
            if (!(directParent instanceof IrPackageFragment)) return false;
            irPackageFragment = (IrPackageFragment)directParent;
        }
        IrPackageFragment parent2 = irPackageFragment;
        if (!Intrinsics.areEqual(parent2.getPackageFqName(), StandardNames.BUILT_INS_PACKAGE_FQ_NAME)) return false;
        String it = $this$isArrayOf.getName().asString();
        boolean bl = false;
        if (!PRIMITIVE_ARRAY_OF_NAMES.contains(it)) {
            if (!Intrinsics.areEqual(it, ARRAY_OF_NAME)) return false;
        }
        boolean bl2 = true;
        if (!bl2) return false;
        if ($this$isArrayOf.getExtensionReceiverParameter() != null) return false;
        if ($this$isArrayOf.getDispatchReceiverParameter() != null) return false;
        if ($this$isArrayOf.getValueParameters().size() != 1) return false;
        if (!AdditionalIrUtilsKt.isVararg($this$isArrayOf.getValueParameters().get(0))) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isEmptyArray(@NotNull IrFunction $this$isEmptyArray) {
        Intrinsics.checkNotNullParameter($this$isEmptyArray, "<this>");
        if (!Intrinsics.areEqual($this$isEmptyArray.getName().asString(), "emptyArray")) return false;
        IrDeclarationParent irDeclarationParent = $this$isEmptyArray.getParent();
        IrPackageFragment irPackageFragment = irDeclarationParent instanceof IrPackageFragment ? (IrPackageFragment)irDeclarationParent : null;
        if (!Intrinsics.areEqual(irPackageFragment != null ? irPackageFragment.getPackageFqName() : null, StandardNames.BUILT_INS_PACKAGE_FQ_NAME)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        Enum type2;
        boolean bl;
        Collection collection;
        int n;
        Enum[] $this$mapTo$iv$iv;
        varargPhase = PhaseBuildersKt.makeIrFilePhase$default(varargPhase.1.INSTANCE, "VarargLowering", "Replace varargs with array arguments and lower arrayOf and emptyArray calls", SetsKt.setOf(PolymorphicSignatureLoweringKt.getPolymorphicSignaturePhase()), null, null, null, null, 240, null);
        Object $this$map$iv = PrimitiveType.values();
        boolean $i$f$map = false;
        PrimitiveType[] primitiveTypeArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((PrimitiveType[])$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n2 = $this$mapTo$iv$iv.length;
        for (n = 0; n < n2; ++n) {
            void var7_10;
            void var8_15 = var7_10 = $this$mapTo$iv$iv[n];
            collection = destination$iv$iv;
            bl = false;
            collection.add(type2.name());
        }
        $this$map$iv = UnsignedType.values();
        collection = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(((Enum[])$this$map$iv).length);
        $i$f$mapTo = false;
        int n3 = $this$mapTo$iv$iv.length;
        for (n = 0; n < n3; ++n) {
            void type3;
            Enum enum_;
            type2 = enum_ = $this$mapTo$iv$iv[n];
            Collection collection2 = destination$iv$iv;
            bl = false;
            String string2 = type3.getTypeName().asString();
            Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
            collection2.add(string2);
        }
        $this$map$iv = CollectionsKt.plus(collection, (Iterable)((List)destination$iv$iv));
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object t : $this$mapTo$iv$iv) {
            String string3 = (String)t;
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(CapitalizeDecapitalizeKt.toLowerCaseAsciiOnly(string3) + "ArrayOf");
        }
        PRIMITIVE_ARRAY_OF_NAMES = CollectionsKt.toSet((List)var3_3);
    }
}

