/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.diagnostics.ConeSimpleDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.resolve.transformers.ReturnTypeCalculator;
import org.jetbrains.kotlin.fir.scopes.FakeOverrideTypeCalculator;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.builder.FirErrorTypeRefBuilder;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/ReturnTypeCalculatorForFullBodyResolve;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/ReturnTypeCalculator;", "diagnosticKind", "Lorg/jetbrains/kotlin/fir/diagnostics/DiagnosticKind;", "reason", "", "(Lorg/jetbrains/kotlin/fir/diagnostics/DiagnosticKind;Ljava/lang/String;)V", "fakeOverrideTypeCalculator", "Lorg/jetbrains/kotlin/fir/scopes/FakeOverrideTypeCalculator;", "getFakeOverrideTypeCalculator", "()Lorg/jetbrains/kotlin/fir/scopes/FakeOverrideTypeCalculator;", "tryCalculateReturnTypeOrNull", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "Companion", "providers"})
@SourceDebugExtension(value={"SMAP\nReturnTypeCalculatorForFullBodyResolve.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReturnTypeCalculatorForFullBodyResolve.kt\norg/jetbrains/kotlin/fir/resolve/transformers/ReturnTypeCalculatorForFullBodyResolve\n+ 2 FirErrorTypeRefBuilder.kt\norg/jetbrains/kotlin/fir/types/builder/FirErrorTypeRefBuilderKt\n*L\n1#1,46:1\n60#2,4:47\n*S KotlinDebug\n*F\n+ 1 ReturnTypeCalculatorForFullBodyResolve.kt\norg/jetbrains/kotlin/fir/resolve/transformers/ReturnTypeCalculatorForFullBodyResolve\n*L\n43#1:47,4\n*E\n"})
public final class ReturnTypeCalculatorForFullBodyResolve
extends ReturnTypeCalculator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DiagnosticKind diagnosticKind;
    @NotNull
    private final String reason;
    @NotNull
    private static final ReturnTypeCalculatorForFullBodyResolve Default = new ReturnTypeCalculatorForFullBodyResolve(DiagnosticKind.RecursionInImplicitTypes, "Recursion with local function");
    @NotNull
    private static final ReturnTypeCalculatorForFullBodyResolve Contract = new ReturnTypeCalculatorForFullBodyResolve(DiagnosticKind.InferenceError, "Cannot calculate return type during full-body resolution (local class/object?)");

    private ReturnTypeCalculatorForFullBodyResolve(DiagnosticKind diagnosticKind, String reason) {
        this.diagnosticKind = diagnosticKind;
        this.reason = reason;
    }

    @Override
    @NotNull
    public FakeOverrideTypeCalculator getFakeOverrideTypeCalculator() {
        return FakeOverrideTypeCalculator.Forced.INSTANCE;
    }

    @Override
    @Nullable
    public FirResolvedTypeRef tryCalculateReturnTypeOrNull(@NotNull FirCallableDeclaration declaration) {
        FirErrorTypeRefBuilder firErrorTypeRefBuilder;
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        FirTypeRef returnTypeRef = declaration.getReturnTypeRef();
        if (returnTypeRef instanceof FirResolvedTypeRef) {
            return (FirResolvedTypeRef)returnTypeRef;
        }
        if (declaration.getOrigin().getFromSupertypes()) {
            return FakeOverrideTypeCalculator.Forced.INSTANCE.computeReturnType(declaration);
        }
        boolean $i$f$buildErrorTypeRef = false;
        FirErrorTypeRefBuilder $this$tryCalculateReturnTypeOrNull_u24lambda_u240 = firErrorTypeRefBuilder = new FirErrorTypeRefBuilder();
        boolean bl = false;
        $this$tryCalculateReturnTypeOrNull_u24lambda_u240.setDiagnostic(new ConeSimpleDiagnostic(this.reason + ": " + UtilsKt.render(declaration), this.diagnosticKind));
        return firErrorTypeRefBuilder.build();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/ReturnTypeCalculatorForFullBodyResolve$Companion;", "", "()V", "Contract", "Lorg/jetbrains/kotlin/fir/resolve/transformers/ReturnTypeCalculatorForFullBodyResolve;", "getContract", "()Lorg/jetbrains/kotlin/fir/resolve/transformers/ReturnTypeCalculatorForFullBodyResolve;", "Default", "getDefault", "providers"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ReturnTypeCalculatorForFullBodyResolve getDefault() {
            return Default;
        }

        @NotNull
        public final ReturnTypeCalculatorForFullBodyResolve getContract() {
            return Contract;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

