/*
 * Copyright (c) 2012, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_eu extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_gu = "gujaratera";
        final String metaValue_he = "hebreera";
        final String metaValue_la = "latina";
        final String metaValue_si = "sinhala";
        final Object[][] data = new Object[][] {
            { "ksh", "koloniera" },
            { "mwl", "mirandera" },
            { "Zsym", "ikurrak" },
            { "Zsye", "emotikonoa" },
            { "tem", "temnea" },
            { "teo", "tesoera" },
            { "rap", "rapa nui" },
            { "AC", "Ascension uhartea" },
            { "rar", "rarotongera" },
            { "tet", "tetuma" },
            { "AD", "Andorra" },
            { "AE", "Arabiar Emirerri Batuak" },
            { "nl_BE", "flandriera" },
            { "AF", "Afganistan" },
            { "AG", "Antigua eta Barbuda" },
            { "type.ca.ethiopic", "Egutegi etiopiarra" },
            { "AI", "Aingira" },
            { "key.tz", "Ordu-zona" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "AO", "Angola" },
            { "AQ", "Antartika" },
            { "AR", "Argentina" },
            { "AS", "Samoa Estatubatuarra" },
            { "AT", "Austria" },
            { "AU", "Australia" },
            { "AW", "Aruba" },
            { "en_US", "AEBko ingelesa" },
            { "AX", "Aland uharteak" },
            { "AZ", "Azerbaijan" },
            { "BA", "Bosnia-Herzegovina" },
            { "BB", "Barbados" },
            { "ceb", "cebuera" },
            { "BD", "Bangladesh" },
            { "kum", "kumykera" },
            { "BE", "Belgika" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgaria" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Saint Barth\u00e9lemy" },
            { "BM", "Bermuda" },
            { "myv", "erziera" },
            { "BN", "Brunei" },
            { "BO", "Bolivia" },
            { "BQ", "Karibeko Herbehereak" },
            { "BR", "Brasil" },
            { "BS", "Bahamak" },
            { "xog", "sogera" },
            { "BT", "Bhutan" },
            { "BV", "Bouvet uhartea" },
            { "BW", "Botswana" },
            { "BY", "Bielorrusia" },
            { "BZ", "Belize" },
            { "type.ca.persian", "Egutegi persiarra" },
            { "type.nu.hebr", "Zenbaki hebrearrak" },
            { "CA", "Kanada" },
            { "CC", "Cocos uharteak" },
            { "mzn", "mazandarandera" },
            { "CD", "Kongoko Errepublika Demokratikoa" },
            { "CF", "Afrika Erdiko Errepublika" },
            { "CG", "Kongo" },
            { "CH", "Suitza" },
            { "CI", "Boli Kosta" },
            { "CK", "Cook uharteak" },
            { "CL", "Txile" },
            { "CM", "Kamerun" },
            { "CN", "Txina" },
            { "CO", "Kolonbia" },
            { "CP", "Clipperton uhartea" },
            { "CR", "Costa Rica" },
            { "CU", "Kuba" },
            { "CV", "Cabo Verde" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Christmas uhartea" },
            { "CY", "Zipre" },
            { "CZ", "Txekia" },
            { "eka", "akajuka" },
            { "DE", "Alemania" },
            { "ace", "acehnera" },
            { "cgg", "chigera" },
            { "DG", "Diego Garc\u00eda" },
            { "type.nu.deva", "Digitu devanagariak" },
            { "DJ", "Djibuti" },
            { "DK", "Danimarka" },
            { "ach", "acholiera" },
            { "Brai", "braillea" },
            { "DM", "Dominika" },
            { "type.nu.armnlow", "Zenbaki armeniarrak minuskulaz" },
            { "DO", "Dominikar Errepublika" },
            { "gor", "gorontaloa" },
            { "zun", "zu\u00f1ia" },
            { "tig", "tigrea" },
            { "DZ", "Aljeria" },
            { "pag", "pangasinanera" },
            { "type.d0.hwidth", "Zabalera erdiko karaktere-bihurketa" },
            { "EA", "Ceuta eta Melilla" },
            { "pam", "pampangera" },
            { "EC", "Ekuador" },
            { "pap", "papiamentoa" },
            { "ada", "adangmera" },
            { "EE", "Estonia" },
            { "EG", "Egipto" },
            { "EH", "Mendebaldeko Sahara" },
            { "pau", "palauera" },
            { "chk", "chuukera" },
            { "chm", "mariera" },
            { "cho", "choctaw" },
            { "chr", "txerokiera" },
            { "ER", "Eritrea" },
            { "ES", "Espainia" },
            { "ET", "Etiopia" },
            { "EU", "Europar Batasuna" },
            { "type.ca.gregorian", "Egutegi gregoriarra" },
            { "EZ", "Eurogunea" },
            { "chy", "cheyennera" },
            { "type.nu.gujr", "Digitu gujaratarrak" },
            { "ady", "adigera" },
            { "FI", "Finlandia" },
            { "FJ", "Fiji" },
            { "FK", "Malvinak" },
            { "FM", "Mikronesia" },
            { "key.va", "Eskualdeko ezarpenen aldaera" },
            { "FO", "Faroe uharteak" },
            { "Taml", "tamilarra" },
            { "FR", "Frantzia" },
            { "root", "erroa" },
            { "type.ca.indian", "Indiar egutegia" },
            { "GA", "Gabon" },
            { "GB", "Erresuma Batua" },
            { "pcm", "Nigeriako pidgina" },
            { "GD", "Grenada" },
            { "GE", "Georgia" },
            { "GF", "Guyana Frantsesa" },
            { "GG", "Guernesey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Groenlandia" },
            { "GM", "Gambia" },
            { "GN", "Ginea" },
            { "GP", "Guadalupe" },
            { "GQ", "Ekuatore Ginea" },
            { "GR", "Grezia" },
            { "GS", "Hegoaldeko Georgia eta Hegoaldeko Sandwich uharteak" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Ginea Bissau" },
            { "tlh", "klingonera" },
            { "GY", "Guyana" },
            { "ckb", "sorania" },
            { "zxx", "ez dago eduki linguistikorik" },
            { "de_AT", "Austriako alemana" },
            { "HK", "Hong Kong Txinako AEB" },
            { "HM", "Heard eta McDonald uharteak" },
            { "HN", "Honduras" },
            { "HR", "Kroazia" },
            { "agq", "aghemera" },
            { "gsw", "alemana (Suitza)" },
            { "HT", "Haiti" },
            { "HU", "Hungaria" },
            { "IC", "Kanariak" },
            { "ID", "Indonesia" },
            { "IE", "Irlanda" },
            { "nap", "napoliera" },
            { "naq", "namera" },
            { "zza", "zazakia" },
            { "IL", "Israel" },
            { "IM", "Man uhartea" },
            { "IN", "India" },
            { "IO", "Indiako Ozeanoko lurralde britainiarra" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "Islandia" },
            { "IT", "Italia" },
            { "Zmth", "matematikako notazioa" },
            { "type.nu.thai", "Digitu thailandiarrak" },
            { "type.nu.beng", "digitu bengalarrak" },
            { "JE", "Jersey" },
            { "type.ca.islamic", "Islamiar egutegia" },
            { "JM", "Jamaika" },
            { "Beng", "bengaliarra" },
            { "JO", "Jordania" },
            { "JP", "Japonia" },
            { "ain", "ainuera" },
            { "guz", "gusiiera" },
            { "type.nu.knda", "Digitu kannadarrak" },
            { "de_CH", "aleman garaia (Suitza)" },
            { "type.co.phonetic", "Ordenatzeko irizpide fonetikoa" },
            { "type.ca.buddhist", "Egutegi budista" },
            { "KE", "Kenya" },
            { "419", "Latinoamerika" },
            { "KG", "Kirgizistan" },
            { "KH", "Kanbodia" },
            { "KI", "Kiribati" },
            { "KM", "Komoreak" },
            { "KN", "Saint Kitts eta Nevis" },
            { "Knda", "kanadarra" },
            { "fr_CA", "Kanadako frantsesa" },
            { "KP", "Ipar Korea" },
            { "KR", "Hego Korea" },
            { "fr_CH", "Suitzako frantsesa" },
            { "KW", "Kuwait" },
            { "tpi", "tok pisina" },
            { "KY", "Kaiman uharteak" },
            { "KZ", "Kazakhstan" },
            { "Cyrl", "zirilikoa" },
            { "LA", "Laos" },
            { "LB", "Libano" },
            { "LC", "Santa Luzia" },
            { "gwi", "gwich\u02bcin" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberia" },
            { "LS", "Lesotho" },
            { "LT", "Lituania" },
            { "LU", "Luxenburgo" },
            { "LV", "Letonia" },
            { "Kana", "katakana" },
            { "LY", "Libia" },
            { "lad", "ladinera" },
            { "vun", "vunjoa" },
            { "lag", "langiera" },
            { "Thaa", "thaana" },
            { "MA", "Maroko" },
            { "MC", "Monako" },
            { "MD", "Moldavia" },
            { "ME", "Montenegro" },
            { "MF", "San Martin" },
            { "MG", "Madagaskar" },
            { "MH", "Marshall Uharteak" },
            { "ale", "aleutera" },
            { "Thai", "thailandiarra" },
            { "type.nu.vaii", "Vai digituak" },
            { "MK", "Mazedonia" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Birmania)" },
            { "MN", "Mongolia" },
            { "new", "newarera" },
            { "MO", "Macau Txinako AEB" },
            { "MP", "Ipar Mariana uharteak" },
            { "MQ", "Martinika" },
            { "MR", "Mauritania" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "type.m0.ungegn", "UNGEGN bihurketa" },
            { "MU", "Maurizio" },
            { "alt", "hegoaldeko altaiera" },
            { "MV", "Maldivak" },
            { "MW", "Malawi" },
            { "MX", "Mexiko" },
            { "type.ca.japanese", "Japoniar egutegia" },
            { "MY", "Malaysia" },
            { "MZ", "Mozambike" },
            { "NA", "Namibia" },
            { "202", "Saharaz hegoaldeko Afrika" },
            { "type.ca.hebrew", "Hebrear egutegia" },
            { "type.co.dictionary", "Hurrenkera alfabetikoa" },
            { "NC", "Kaledonia Berria" },
            { "NE", "Niger" },
            { "NF", "Norfolk uhartea" },
            { "NG", "Nigeria" },
            { "trv", "tarokoa" },
            { "NI", "Nikaragua" },
            { "NL", "Herbehereak" },
            { "NO", "Norvegia" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "rof", "romboera" },
            { "NZ", "Zeelanda Berria" },
            { "OM", "Oman" },
            { "anp", "angikera" },
            { "crs", "seselwa frantses-kreolera" },
            { "PA", "Panama" },
            { "type.ca.islamic-civil", "Islamiar egutegi zibila" },
            { "en_GB", "Britainia Handiko ingelesa" },
            { "PE", "Peru" },
            { "PF", "Polinesia Frantsesa" },
            { "PG", "Papua Ginea Berria" },
            { "PH", "Filipinak" },
            { "PK", "Pakistan" },
            { "PL", "Polonia" },
            { "ewo", "ewondera" },
            { "PM", "Saint-Pierre eta Mikelune" },
            { "PN", "Pitcairn uharteak" },
            { "PR", "Puerto Rico" },
            { "PS", "Palestinako Lurraldeak" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "nia", "niasa" },
            { "type.nu.greklow", "Zenbaki grekoak minuskulaz" },
            { "PY", "Paraguai" },
            { "tum", "tumbukera" },
            { "Hebr", metaValue_he },
            { "QA", "Qatar" },
            { "%%SCOTLAND", "ESKOZIAR INGELESA" },
            { "niu", "niuera" },
            { "QO", "Mugaz kanpoko Ozeania" },
            { "lez", "lezgiera" },
            { "tvl", "tuvaluera" },
            { "001", "Mundua" },
            { "002", "Afrika" },
            { "003", "Ipar Amerika" },
            { "RE", "Reunion" },
            { "005", "Hego Amerika" },
            { "jbo", "lojbanera" },
            { "009", "Ozeania" },
            { "RO", "Errumania" },
            { "RS", "Serbia" },
            { "RU", "Errusia" },
            { "RW", "Ruanda" },
            { "SA", "Saudi Arabia" },
            { "SB", "Salomon Uharteak" },
            { "twq", "tasawaqa" },
            { "011", "Afrika mendebaldea" },
            { "SC", "Seychelleak" },
            { "SD", "Sudan" },
            { "013", "Erdialdeko Amerika" },
            { "SE", "Suedia" },
            { "014", "Afrika ekialdea" },
            { "015", "Afrika iparraldea" },
            { "SG", "Singapur" },
            { "SH", "Santa Helena" },
            { "type.lb.strict", "Lerro-jauziaren estilo zorrotza" },
            { "017", "Erdialdeko Afrika" },
            { "SI", "Eslovenia" },
            { "018", "Afrika hegoaldea" },
            { "SJ", "Svalbard eta Jan Mayen uharteak" },
            { "019", "Amerika" },
            { "SK", "Eslovakia" },
            { "SL", "Sierra Leona" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "arn", "maputxea" },
            { "arp", "arapahoa" },
            { "type.nu.taml", "Zenbaki tamilar tradizionalak" },
            { "SR", "Surinam" },
            { "SS", "Hego Sudan" },
            { "ST", "Sao Tome eta Principe" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Siria" },
            { "SZ", "Swazilandia" },
            { "TA", "Tristan da Cunha" },
            { "asa", "asua" },
            { "type.ms.ussystem", "Neurketa-sistema anglosaxoia" },
            { "021", "Amerika iparraldea" },
            { "TC", "Turk eta Caico uharteak" },
            { "yav", "jangbenera" },
            { "TD", "Txad" },
            { "TF", "Hegoaldeko lurralde frantsesak" },
            { "TG", "Togo" },
            { "TH", "Thailandia" },
            { "TJ", "Tajikistan" },
            { "029", "Karibea" },
            { "TK", "Tokelau" },
            { "TL", "Ekialdeko Timor" },
            { "ybb", "yemba" },
            { "type.co.searchjl", "Bilatu hangularen lehen kontsonantearen arabera" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunisia" },
            { "TO", "Tonga" },
            { "TR", "Turkia" },
            { "TT", "Trinidad eta Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "ast", "asturiera" },
            { "TZ", "Tanzania" },
            { "nmg", "kwasiera" },
            { "Zzzz", "idazkera ezezaguna" },
            { "UA", "Ukraina" },
            { "rup", "aromania" },
            { "030", "Asia ekialdea" },
            { "tyv", "tuvera" },
            { "sw_CD", "Kongoko swahilia" },
            { "034", "Asia hegoaldea" },
            { "035", "Asia hego-ekialdea" },
            { "UG", "Uganda" },
            { "type.co.pinyin", "Pinyin hurrenkera" },
            { "039", "Europa hegoaldea" },
            { "Sinh", metaValue_si },
            { "UM", "Ameriketako Estatu Batuetako Kanpoaldeko Uharte Txikiak" },
            { "UN", "Nazio Batuak" },
            { "US", "Ameriketako Estatu Batuak" },
            { "haw", "hawaiiera" },
            { "type.co.gb2312han", "Txinera sinplifikatuaren alfabetoa -GB2312" },
            { "UY", "Uruguai" },
            { "prg", "prusiera" },
            { "UZ", "Uzbekistan" },
            { "tzm", "Erdialdeko Atlaseko amazigera" },
            { "type.co.stroke", "Tarteen araberako hurrenkera" },
            { "nnh", "ngiemboonera" },
            { "VA", "Vatikano Hiria" },
            { "VC", "Saint Vincent eta Grenadinak" },
            { "VE", "Venezuela" },
            { "VG", "Birjina uharte britainiarrak" },
            { "VI", "Birjina uharte amerikarrak" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "nog", "nogaiera" },
            { "rwk", "rwaera" },
            { "053", "Australasia" },
            { "054", "Melanesia" },
            { "WF", "Wallis eta Futuna" },
            { "type.co.traditional", "Tradizionala" },
            { "057", "Mikronesia eskualdea" },
            { "jgo", "ngomba" },
            { "lkt", "lakotera" },
            { "type.nu.finance", "Finantza-zenbakiak" },
            { "wae", "walserera" },
            { "WS", "Samoa" },
            { "wal", "welayta" },
            { "war", "samerera" },
            { "awa", "awadhiera" },
            { "061", "Polinesia" },
            { "XK", "Kosovo" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "idatzi gabea" },
            { "YE", "Yemen" },
            { "nqo", "n\u2019koera" },
            { "type.co.standard", "Ordenatzeko irizpide estandarra" },
            { "YT", "Mayotte" },
            { "ZA", "Hegoafrika" },
            { "type.lb.loose", "Lerro-jauziaren estilo malgua" },
            { "Deva", "devanagaria" },
            { "type.nu.geor", "Zenbaki georgiarrak" },
            { "Hira", "hiragana" },
            { "ZM", "Zambia" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "Eskualde ezezaguna" },
            { "type.ms.metric", "Sistema metrikoa" },
            { "type.ca.iso8601", "ISO-8601 egutegia" },
            { "nso", "pediera" },
            { "type.nu.telu", "Digitu teluguarrak" },
            { "loz", "loziera" },
            { "jmc", "machamera" },
            { "type.nu.hansfin", "Finantzetarako zenbaki txinatar sinplifikatuak" },
            { "hil", "hiligainona" },
            { "type.nu.arabext", "Digitu arabiar-hindiko hedatuak" },
            { "nus", "nuerera" },
            { "dak", "dakotera" },
            { "type.nu.fullwide", "Zabalera osoko digituak" },
            { "dar", "dargvera" },
            { "dav", "taitera" },
            { "lrc", "iparraldeko lurera" },
            { "udm", "udmurtera" },
            { "Khmr", "khemerarra" },
            { "sad", "sandawea" },
            { "type.nu.roman", "Zenbaki erromatarrak" },
            { "sah", "sakhera" },
            { "saq", "samburuera" },
            { "sat", "santalera" },
            { "type.d0.npinyin", "Zenbakizko bihurketa" },
            { "type.nu.native", "Zenbaki-sistema" },
            { "sba", "ngambayera" },
            { "Guru", "gurmukhia" },
            { "lua", "txilubera" },
            { "type.d0.fwidth", "Zabalera osoko karaktere-bihurketa" },
            { "sbp", "sanguera" },
            { "nyn", "ankolera" },
            { "lun", "lundera" },
            { "luo", "luoera" },
            { "fil", "filipinera" },
            { "hmn", "hmong" },
            { "lus", "mizoa" },
            { "ban", "baliera" },
            { "luy", "luhyera" },
            { "bas", "basaa" },
            { "es_ES", "espainiera (Europa)" },
            { "sco", "eskoziera" },
            { "scn", "siziliera" },
            { "aa", "afarera" },
            { "ab", "abkhaziera" },
            { "af", "afrikaansa" },
            { "ak", "akanera" },
            { "am", "amharera" },
            { "an", "aragoiera" },
            { "Arab", "arabiarra" },
            { "Jpan", "japoniarra" },
            { "ar", "arabiera" },
            { "Hrkt", "silaba japoniarrak" },
            { "as", "assamera" },
            { "av", "avarera" },
            { "ay", "aimara" },
            { "az", "azerbaijanera" },
            { "ba", "bashkirrera" },
            { "type.co.unihan", "Radical trazuen hurrenkera" },
            { "be", "bielorrusiera" },
            { "bg", "bulgariera" },
            { "bi", "bislama" },
            { "bm", "bambarera" },
            { "bn", "bengalera" },
            { "bo", "tibetera" },
            { "dgr", "dogribera" },
            { "br", "bretoiera" },
            { "bs", "bosniera" },
            { "Mymr", "birmaniarra" },
            { "type.nu.laoo", "Digitu laostarrak" },
            { "seh", "senera" },
            { "ca", "katalana" },
            { "ses", "koyraboro sennia" },
            { "ce", "txetxeniera" },
            { "ch", "chamorrera" },
            { "%%REVISED", "BERRIKUSIA" },
            { "co", "korsikera" },
            { "Orya", "oriyarra" },
            { "cs", "txekiera" },
            { "cu", "Elizako eslaviera" },
            { "cv", "chuvashera" },
            { "cy", "galesa" },
            { "type.nu.ethi", "Zenbaki etiopiarrak" },
            { "da", "daniera" },
            { "pt_PT", "portugesa (Europa)" },
            { "de", "alemana" },
            { "type.cf.standard", "Moneta-formatu estandarra" },
            { "bem", "bembera" },
            { "type.nu.mong", "Digitu mongoliarrak" },
            { "dv", "divehiera" },
            { "es_419", "Latinoamerikako espainiera" },
            { "dz", "dzongkha" },
            { "bez", "benera" },
            { "type.ca.chinese", "Txinatar egutegia" },
            { "dje", "zarma" },
            { "type.nu.grek", "Zenbaki grekoak" },
            { "ee", "eweera" },
            { "type.lb.normal", "Lerro-jauziaren estilo arrunta" },
            { "ro_MD", "moldaviera" },
            { "el", "greziera" },
            { "en", "ingelesa" },
            { "eo", "esperantoa" },
            { "type.co.big5han", "Txinera tradizionalaren alfabetoa-Big5" },
            { "es", "espainiera" },
            { "et", "estoniera" },
            { "Hanb", "h\u00e4nera" },
            { "eu", "euskara" },
            { "Hang", "hangula" },
            { "shi", "tachelhita" },
            { "hsb", "goi-sorabiera" },
            { "Hani", "idazkera txinatarra" },
            { "shn", "shanera" },
            { "fa", "persiera" },
            { "Hans", "sinplifikatua" },
            { "type.nu.latn", "Digitu mendebaldarrak" },
            { "Hant", "tradizionala" },
            { "ff", "fula" },
            { "fi", "finlandiera" },
            { "fj", "fijiera" },
            { "fon", "fona" },
            { "yue", "kantonera" },
            { "fo", "faroera" },
            { "type.m0.bgn", "BGN bihurketa" },
            { "umb", "umbunduera" },
            { "fr", "frantsesa" },
            { "fy", "frisiera" },
            { "ga", "gaelikoa" },
            { "gd", "Eskoziako gaelikoa" },
            { "gl", "galiziera" },
            { "gn", "guaraniera" },
            { "bho", "bhojpurera" },
            { "und", "hizkuntza ezezaguna" },
            { "type.ca.ethiopic-amete-alem", "Amete Alem egutegi etiopiarra" },
            { "gu", metaValue_gu },
            { "gv", "manxera" },
            { "ha", "hausa" },
            { "he", metaValue_he },
            { "hi", "hindia" },
            { "hup", "hupera" },
            { "bin", "edoera" },
            { "hr", "kroaziera" },
            { "ht", "Haitiko kreolera" },
            { "hu", "hungariera" },
            { "hy", "armeniera" },
            { "hz", "herera" },
            { "ia", "interlingua" },
            { "Jamo", "jamo-bihurketa" },
            { "id", "indonesiera" },
            { "type.nu.tibt", "Digitu tibetarrak" },
            { "ie", "interlingue" },
            { "ig", "igboera" },
            { "ii", "Sichuango yiera" },
            { "io", "ido" },
            { "is", "islandiera" },
            { "it", "italiera" },
            { "iu", "inuitera" },
            { "ja", "japoniera" },
            { "Mlym", "malayalamera" },
            { "sma", "hegoaldeko samiera" },
            { "jv", "javera" },
            { "mad", "madurera" },
            { "smj", "lule samiera" },
            { "mag", "magahiera" },
            { "mai", "maithilera" },
            { "smn", "inari-samiera" },
            { "ka", "georgiera" },
            { "bla", "siksikera" },
            { "mak", "makasarera" },
            { "sms", "skolten samiera" },
            { "kg", "kikongoa" },
            { "ki", "kikuyuera" },
            { "mas", "masaiera" },
            { "kj", "kuanyama" },
            { "kk", "kazakhera" },
            { "kl", "groenlandiera" },
            { "km", "khemerera" },
            { "kn", "kannada" },
            { "ko", "koreera" },
            { "kr", "kanuriera" },
            { "ks", "kaxmirera" },
            { "ku", "kurduera" },
            { "kv", "komiera" },
            { "kw", "kornubiera" },
            { "ky", "kirgizera" },
            { "snk", "soninkera" },
            { "la", metaValue_la },
            { "lb", "luxenburgera" },
            { "type.nu.mlym", "Digitu malayalamarrak" },
            { "lg", "gandera" },
            { "li", "limburgera" },
            { "Tibt", "tibetarra" },
            { "ln", "lingala" },
            { "fur", "friuliera" },
            { "lo", "laosera" },
            { "type.ms.uksystem", "Neurketa-sistema inperiala" },
            { "lt", "lituaniera" },
            { "lu", "luba-katangera" },
            { "lv", "letoniera" },
            { "mg", "malgaxea" },
            { "mh", "marshallera" },
            { "type.co.ducet", "Unicode hurrenkera lehenetsia" },
            { "mi", "maoriera" },
            { "mk", "mazedoniera" },
            { "ml", "malabarera" },
            { "mn", "mongoliera" },
            { "mr", "marathera" },
            { "ms", "malaysiera" },
            { "mt", "maltera" },
            { "my", "birmaniera" },
            { "Armn", "armeniarra" },
            { "mdf", "mokxera" },
            { "dsb", "behe-sorabiera" },
            { "na", "nauruera" },
            { "type.co.search", "Bilaketa orokorra" },
            { "nb", "bokmala (Norvegia)" },
            { "nd", "iparraldeko ndebeleera" },
            { "ne", "nepalera" },
            { "ng", "ndongera" },
            { "nl", "nederlandera" },
            { "nn", "nynorsk norvegiera" },
            { "no", "norvegiera" },
            { "nr", "hegoaldeko ndebelera" },
            { "nv", "navahoera" },
            { "ny", "chewera" },
            { "kac", "jingpoera" },
            { "kab", "kabilera" },
            { "%%POLYTON", "POLITON" },
            { "oc", "okzitaniera" },
            { "kaj", "kaiji" },
            { "kam", "kambera" },
            { "men", "mendeera" },
            { "mer", "meruera" },
            { "type.nu.armn", "Zenbaki armeniarrak" },
            { "om", "oromoera" },
            { "or", "oriya" },
            { "os", "osetiera" },
            { "kbd", "kabardiera" },
            { "mfe", "Mauritaniako kreolera" },
            { "srn", "srananera" },
            { "pa", "punjabera" },
            { "dua", "dualera" },
            { "pl", "poloniera" },
            { "type.ca.dangi", "Dangi egutegia" },
            { "ps", "paxtuera" },
            { "pt", "portugesa" },
            { "key.co", "Ordenatzeko irizpidea" },
            { "pt_BR", "Brasilgo portugesa" },
            { "kcg", "kataba" },
            { "mgh", "makhuwa-meettoera" },
            { "key.cf", "Moneta-formatua" },
            { "key.ca", "Egutegia" },
            { "Laoo", "laosarra" },
            { "mgo", "metera" },
            { "type.hc.h23", "24 orduko sistema (0\u201323)" },
            { "type.hc.h24", "24 orduko sistema (1\u201324)" },
            { "ssy", "sahoa" },
            { "type.nu.mymr", "Digitu birmaniarrak" },
            { "qu", "kitxua" },
            { "brx", "bodoera" },
            { "kde", "makondera" },
            { "Ethi", "etiopiarra" },
            { "type.hc.h12", "12 orduko sistema (1\u201312)" },
            { "type.hc.h11", "12 orduko sistema (0\u201311)" },
            { "rm", "erretorromaniera" },
            { "rn", "rundiera" },
            { "key.cu", "Moneta" },
            { "ro", "errumaniera" },
            { "%%SAAHO", "SAHO" },
            { "type.nu.orya", "Digitu oriyarrak" },
            { "type.nu.hanidec", "Zenbaki hamartar txinatarrak" },
            { "ru", "errusiera" },
            { "rw", "kinyaruanda" },
            { "kea", "Cabo Verdeko kreola" },
            { "mic", "mikmakera" },
            { "suk", "sukumera" },
            { "en_AU", "Australiako ingelesa" },
            { "sa", "sanskritoa" },
            { "sc", "sardiniera" },
            { "sd", "sindhia" },
            { "se", "iparraldeko samiera" },
            { "min", "minangkabauera" },
            { "sg", "sangoa" },
            { "sh", "serbokroaziera" },
            { "si", metaValue_si },
            { "sk", "eslovakiera" },
            { "sl", "esloveniera" },
            { "sm", "samoera" },
            { "sn", "shonera" },
            { "so", "somaliera" },
            { "type.nu.arab", "Digitu arabiar-hindikoak" },
            { "sq", "albaniera" },
            { "sr", "serbiera" },
            { "ss", "swatiera" },
            { "type.cf.account", "Kontabilitateko moneta-formatua" },
            { "st", "hegoaldeko sothoera" },
            { "su", "sundanera" },
            { "sv", "suediera" },
            { "sw", "swahilia" },
            { "type.nu.hantfin", "Finantzetarako zenbaki txinatar tradizionalak" },
            { "ibb", "ibibioera" },
            { "iba", "ibanera" },
            { "ta", "tamilera" },
            { "142", "Asia" },
            { "143", "Asia erdialdea" },
            { "te", "telugua" },
            { "145", "Asia mendebaldea" },
            { "tg", "tajikera" },
            { "th", "thailandiera" },
            { "ti", "tigri\u00f1era" },
            { "bug", "buginera" },
            { "kfo", "koroa" },
            { "en_CA", "Kanadako ingelesa" },
            { "tk", "turkmenera" },
            { "tl", "tagalog" },
            { "tn", "tswanera" },
            { "to", "tongera" },
            { "dyo", "fonyi jolera" },
            { "type.nu.jpan", "Zenbaki japoniarrak" },
            { "tr", "turkiera" },
            { "ts", "tsongera" },
            { "swb", "komoreera" },
            { "tt", "tatarera" },
            { "tw", "twia" },
            { "ty", "tahitiera" },
            { "150", "Europa" },
            { "151", "Europa ekialdea" },
            { "154", "Europa iparraldea" },
            { "dzg", "dazaga" },
            { "155", "Europa mendebaldea" },
            { "ug", "uigurrera" },
            { "Kore", "korearra" },
            { "Zyyy", "ohikoa" },
            { "uk", "ukrainera" },
            { "type.ca.coptic", "Egutegi coptiarra" },
            { "ur", "urdua" },
            { "xal", "kalmykera" },
            { "uz", "uzbekera" },
            { "kha", "kashia" },
            { "nds_NL", "behe-saxoiera" },
            { "ve", "vendera" },
            { "type.ca.roc", "Minguo egutegia" },
            { "vi", "vietnamera" },
            { "khq", "koyra chiiniera" },
            { "key.hc", "Ordu-zikloa (12 vs 24)" },
            { "vo", "volap\u00fcka" },
            { "quc", "quicheera" },
            { "gaa", "ga" },
            { "wa", "waloiera" },
            { "gag", "gagauzera" },
            { "syr", "asiriera" },
            { "Grek", "greziarra" },
            { "wo", "wolofera" },
            { "zgh", "amazigera estandarra" },
            { "ar_001", "arabiera moderno estandarra" },
            { "Mong", "mongoliarra" },
            { "mni", "manipurera" },
            { "Latn", metaValue_la },
            { "type.nu.hans", "Zenbaki txinatar sinplifikatuak" },
            { "type.nu.hant", "Zenbaki txinatar tradizionalak" },
            { "xh", "xhosera" },
            { "type.nu.romanlow", "Zenbaki erromatarrak minuskulaz" },
            { "byn", "bilena" },
            { "moh", "mohawkera" },
            { "kkj", "kakoa" },
            { "yi", "yiddisha" },
            { "mos", "moreera" },
            { "yo", "jorubera" },
            { "type.nu.traditional", "Zenbaki tradizionalak" },
            { "es_MX", "Mexikoko espainiera" },
            { "vai", "vaiera" },
            { "kln", "kalenjinera" },
            { "zh", "txinera" },
            { "Bopo", "bopomofoa" },
            { "key.lb", "Lerro-jauziaren estiloa" },
            { "zu", "zuluera" },
            { "type.co.phonebook", "Telefonoen zerrenda" },
            { "Geor", "georgiarra" },
            { "kmb", "kimbundua" },
            { "type.nu.jpanfin", "Finantzetarako zenbaki japoniarrak" },
            { "gez", "ge\u2019ez" },
            { "type.co.reformed", "Erreformaren araberako hurrenkera" },
            { "ebu", "embua" },
            { "zh_Hans", "txinera soildua" },
            { "koi", "komi-permyakera" },
            { "kok", "konkanera" },
            { "zh_Hant", "txinera tradizionala" },
            { "kpe", "kpellea" },
            { "type.nu.khmr", "Digitu khmerarrak" },
            { "ilo", "ilokanera" },
            { "%%VALENCIA", "VALENTZIERA" },
            { "mua", "mudangera" },
            { "type.nu.guru", "Digitu gurmukhiak" },
            { "mul", "zenbait hizkuntza" },
            { "key.ms", "Neurketa-sistema" },
            { "mus", "creera" },
            { "gil", "gilbertera" },
            { "type.nu.tamldec", "Digitu tamilarrak" },
            { "krc", "karachayera-balkarera" },
            { "inh", "ingushera" },
            { "krl", "kareliera" },
            { "efi", "efikera" },
            { "key.nu", "Zenbakiak" },
            { "kru", "kurukhera" },
            { "ksb", "shambalera" },
            { "Telu", "teluguarra" },
            { "ksf", "bafiera" },
        };
        return data;
    }
}
