# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.1.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""
Standard module, see official documentation at
https://www.opencascade.com/doc/occt-7.7.0/refman/html/package_standard.html
"""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _Standard
else:
    import _Standard

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Standard.delete_SwigPyIterator

    def value(self):
        return _Standard.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _Standard.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _Standard.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _Standard.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _Standard.SwigPyIterator_equal(self, x)

    def copy(self):
        return _Standard.SwigPyIterator_copy(self)

    def next(self):
        return _Standard.SwigPyIterator_next(self)

    def __next__(self):
        return _Standard.SwigPyIterator___next__(self)

    def previous(self):
        return _Standard.SwigPyIterator_previous(self)

    def advance(self, n):
        return _Standard.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _Standard.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _Standard.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _Standard.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _Standard.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _Standard.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _Standard.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _Standard:
_Standard.SwigPyIterator_swigregister(SwigPyIterator)

def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error, method_name, class_name):
    return _Standard.process_exception(error, method_name, class_name)

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

import OCC.Core.NCollection

from enum import IntEnum
from OCC.Core.Exception import *

Standard_HandlerVoid = _Standard.Standard_HandlerVoid
Standard_HandlerJumped = _Standard.Standard_HandlerJumped
Standard_HandlerProcessed = _Standard.Standard_HandlerProcessed


class Standard_HandlerStatus(IntEnum):
	Standard_HandlerVoid = 0
	Standard_HandlerJumped = 1
	Standard_HandlerProcessed = 2
Standard_HandlerVoid = Standard_HandlerStatus.Standard_HandlerVoid
Standard_HandlerJumped = Standard_HandlerStatus.Standard_HandlerJumped
Standard_HandlerProcessed = Standard_HandlerStatus.Standard_HandlerProcessed


def Handle_Standard_Transient_Create():
    return _Standard.Handle_Standard_Transient_Create()

def Handle_Standard_Transient_DownCast(t):
    return _Standard.Handle_Standard_Transient_DownCast(t)

def Handle_Standard_Transient_IsNull(t):
    return _Standard.Handle_Standard_Transient_IsNull(t)

def Handle_Standard_Failure_Create():
    return _Standard.Handle_Standard_Failure_Create()

def Handle_Standard_Failure_DownCast(t):
    return _Standard.Handle_Standard_Failure_DownCast(t)

def Handle_Standard_Failure_IsNull(t):
    return _Standard.Handle_Standard_Failure_IsNull(t)

def Handle_Standard_OutOfMemory_Create():
    return _Standard.Handle_Standard_OutOfMemory_Create()

def Handle_Standard_OutOfMemory_DownCast(t):
    return _Standard.Handle_Standard_OutOfMemory_DownCast(t)

def Handle_Standard_OutOfMemory_IsNull(t):
    return _Standard.Handle_Standard_OutOfMemory_IsNull(t)

def Handle_Standard_Persistent_Create():
    return _Standard.Handle_Standard_Persistent_Create()

def Handle_Standard_Persistent_DownCast(t):
    return _Standard.Handle_Standard_Persistent_DownCast(t)

def Handle_Standard_Persistent_IsNull(t):
    return _Standard.Handle_Standard_Persistent_IsNull(t)

def Handle_Standard_Type_Create():
    return _Standard.Handle_Standard_Type_Create()

def Handle_Standard_Type_DownCast(t):
    return _Standard.Handle_Standard_Type_DownCast(t)

def Handle_Standard_Type_IsNull(t):
    return _Standard.Handle_Standard_Type_IsNull(t)
class standard(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def Allocate(*args):
        r"""

        Parameters
        ----------
        aSize: Standard_Size

        Return
        -------
        Standard_Address

        Description
        -----------
        Allocates memory blocks asize - bytes to allocate.

        """
        return _Standard.standard_Allocate(*args)

    @staticmethod
    def AllocateAligned(*args):
        r"""

        Parameters
        ----------
        theSize: Standard_Size
        theAlign: Standard_Size

        Return
        -------
        Standard_Address

        Description
        -----------
        Allocates aligned memory blocks. should be used with cpu instructions which require specific alignment. for example: sse requires 16 bytes, avx requires 32 bytes. @param thesize bytes to allocate @param thealign alignment in bytes.

        """
        return _Standard.standard_AllocateAligned(*args)

    @staticmethod
    def Purge(*args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Deallocates the storage retained on the free list and clears the list. returns non-zero if some memory has been actually freed.

        """
        return _Standard.standard_Purge(*args)

    @staticmethod
    def Reallocate(*args):
        r"""

        Parameters
        ----------
        aStorage: Standard_Address
        aNewSize: Standard_Size

        Return
        -------
        Standard_Address

        Description
        -----------
        Reallocates memory blocks astorage - previously allocated memory block anewsize - new size in bytes.

        """
        return _Standard.standard_Reallocate(*args)

    @staticmethod
    def StackTrace(*args):
        r"""

        Parameters
        ----------
        theBuffer: char *
        theBufferSize: int
        theNbTraces: int
        theContext: void * (optional, default to NULL)
        theNbTopSkip: int (optional, default to 0)

        Return
        -------
        bool

        Description
        -----------
        Appends backtrace to a message buffer. stack information might be incomplete in case of stripped binaries. implementation details: - not implemented for android, ios, qnx and uwp platforms. - on non-windows platform, this function is a wrapper to backtrace() system call. - on windows (win32) platform, the function loads dbghelp.dll dynamically, and no stack will be provided if this or companion libraries (symsrv.dll, srcsrv.dll, etc.) will not be found; .pdb symbols should be provided on windows platform to retrieve a meaningful stack; only x86_64 cpu architecture is currently implemented. @param thebuffer [in] [out] message buffer to extend @param thebuffersize [in] message buffer size @param thenbtraces [in] maximum number of stack traces @param thecontext [in] optional platform-dependent frame context; in case of dbghelp (windows) should be a pointer to context @param thenbtopskip [in] number of traces on top of the stack to skip return true on success.

        """
        return _Standard.standard_StackTrace(*args)

    __repr__ = _dumps_object

    @methodnotwrapped
    def Free(self):
    	pass

    @methodnotwrapped
    def FreeAligned(self):
    	pass


    def __init__(self):
        _Standard.standard_swiginit(self, _Standard.new_standard())
    __swig_destroy__ = _Standard.delete_standard

# Register standard in _Standard:
_Standard.standard_swigregister(standard)
class Standard_ArrayStreamBuffer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        theBegin: char *
        theSize: size_t

        Return
        -------
        None

        Description
        -----------
        Main constructor. passed pointer is stored as is (memory is not copied nor released with destructor). @param thebegin pointer to the beginning of pre-allocated buffer @param thesize length of pre-allocated buffer.

        """
        _Standard.Standard_ArrayStreamBuffer_swiginit(self, _Standard.new_Standard_ArrayStreamBuffer(*args))

    def Init(self, *args):
        r"""

        Parameters
        ----------
        theBegin: char *
        theSize: size_t

        Return
        -------
        None

        Description
        -----------
        (re)-initialize the stream. passed pointer is stored as is (memory is not copied nor released with destructor). @param thebegin pointer to the beginning of pre-allocated buffer @param thesize length of pre-allocated buffer.

        """
        return _Standard.Standard_ArrayStreamBuffer_Init(self, *args)

    def xsgetn(self, *args):
        r"""

        Parameters
        ----------
        thePtr: char *
        theCount: std::streamsize

        Return
        -------
        std::streamsize

        Description
        -----------
        Read a bunch of bytes at once.

        """
        return _Standard.Standard_ArrayStreamBuffer_xsgetn(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _Standard.delete_Standard_ArrayStreamBuffer

# Register Standard_ArrayStreamBuffer in _Standard:
_Standard.Standard_ArrayStreamBuffer_swigregister(Standard_ArrayStreamBuffer)
class Standard_Condition(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        theIsSet: bool

        Return
        -------
        None

        Description
        -----------
        Default constructor. @param theisset initial flag state.

        """
        _Standard.Standard_Condition_swiginit(self, _Standard.new_Standard_Condition(*args))

    def Check(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Do not wait for signal - just test it state. return true if get event.

        """
        return _Standard.Standard_Condition_Check(self, *args)

    def CheckReset(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Method perform two steps at-once - reset the event object and returns true if it was in signaling state. return true if event object was in signaling state.

        """
        return _Standard.Standard_Condition_CheckReset(self, *args)

    def Reset(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Reset event (unset signaling state).

        """
        return _Standard.Standard_Condition_Reset(self, *args)

    def Set(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Set event into signaling state.

        """
        return _Standard.Standard_Condition_Set(self, *args)

    def Wait(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Wait for event (infinity).

        Parameters
        ----------
        theTimeMilliseconds: int

        Return
        -------
        bool

        Description
        -----------
        Wait for signal requested time. @param thetimemilliseconds wait limit in milliseconds return true if get event.

        """
        return _Standard.Standard_Condition_Wait(self, *args)

    __repr__ = _dumps_object

    @methodnotwrapped
    def getHandle(self):
    	pass

    __swig_destroy__ = _Standard.delete_Standard_Condition

# Register Standard_Condition in _Standard:
_Standard.Standard_Condition_swigregister(Standard_Condition)
class Standard_ErrorHandler(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Create a errorhandler (to be used with try{}catch(){}). it uses the 'setjmp' and 'longjmp' routines.

        """
        _Standard.Standard_ErrorHandler_swiginit(self, _Standard.new_Standard_ErrorHandler(*args))

    def Catches(self, *args):
        r"""

        Parameters
        ----------
        aType: Standard_Type

        Return
        -------
        bool

        Description
        -----------
        Returns 'true' if the caught exception has the same type or inherits from 'atype'.

        """
        return _Standard.Standard_ErrorHandler_Catches(self, *args)

    def Destroy(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Unlinks and checks if there is a raised exception.

        """
        return _Standard.Standard_ErrorHandler_Destroy(self, *args)

    def Error(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Standard_Failure>

        Description
        -----------
        Returns the current error.

        """
        return _Standard.Standard_ErrorHandler_Error(self, *args)

    @staticmethod
    def IsInTryBlock(*args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Test if the code is currently running in a try block.

        """
        return _Standard.Standard_ErrorHandler_IsInTryBlock(*args)

    @staticmethod
    def LastCaughtError(*args):
        r"""
        Return
        -------
        opencascade::handle<Standard_Failure>

        Description
        -----------
        Returns the caught exception.

        """
        return _Standard.Standard_ErrorHandler_LastCaughtError(*args)

    def Unlink(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Removes handler from the handlers list.

        """
        return _Standard.Standard_ErrorHandler_Unlink(self, *args)

    __repr__ = _dumps_object

    @methodnotwrapped
    def Label(self):
    	pass

    __swig_destroy__ = _Standard.delete_Standard_ErrorHandler

# Register Standard_ErrorHandler in _Standard:
_Standard.Standard_ErrorHandler_swigregister(Standard_ErrorHandler)
class Standard_GUID(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        aGuid: str

        Return
        -------
        None

        Description
        -----------
        Build a guid from an ascii string with the following format: length: 36 char '00000000-0000-0000-0000-000000000000'.

        Parameters
        ----------
        aGuid: Standard_ExtString

        Return
        -------
        None

        Description
        -----------
        Build a guid from an unicode string with the following format: //! '00000000-0000-0000-0000-000000000000'.

        Parameters
        ----------
        a32b: int
        a16b1: Standard_ExtCharacter
        a16b2: Standard_ExtCharacter
        a16b3: Standard_ExtCharacter
        a8b1: Standard_Byte
        a8b2: Standard_Byte
        a8b3: Standard_Byte
        a8b4: Standard_Byte
        a8b5: Standard_Byte
        a8b6: Standard_Byte

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        aGuid: Standard_UUID

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        aGuid: Standard_GUID

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _Standard.Standard_GUID_swiginit(self, _Standard.new_Standard_GUID(*args))

    def Assign(self, *args):
        r"""

        Parameters
        ----------
        uid: Standard_GUID

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        uid: Standard_UUID

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _Standard.Standard_GUID_Assign(self, *args)

    @staticmethod
    def CheckGUIDFormat(*args):
        r"""

        Parameters
        ----------
        aGuid: str

        Return
        -------
        bool

        Description
        -----------
        Check the format of a guid string. it checks the size, the position of the '-' and the correct size of fields.

        """
        return _Standard.Standard_GUID_CheckGUIDFormat(*args)

    def Hash(self, *args):
        r"""

        Parameters
        ----------
        Upper: int

        Return
        -------
        int

        Description
        -----------
        Hash function for guid.

        """
        return _Standard.Standard_GUID_Hash(self, *args)

    @staticmethod
    def HashCode(*args):
        r"""

        Parameters
        ----------
        theGUID: Standard_GUID
        theUpperBound: int

        Return
        -------
        int

        Description
        -----------
        Computes a hash code for the given guid of the standard_integer type, in the range [1, theupperbound] @param theguid the guid which hash code is to be computed @param theupperbound the upper bound of the range a computing hash code must be within return a computed hash code, in the range [1, theupperbound].

        """
        return _Standard.Standard_GUID_HashCode(*args)

    @staticmethod
    def IsEqual(*args):
        r"""

        Parameters
        ----------
        string1: Standard_GUID
        string2: Standard_GUID

        Return
        -------
        bool

        Description
        -----------
        Returns true when the two guid are the same.

        """
        return _Standard.Standard_GUID_IsEqual(*args)

    def IsNotSame(self, *args):
        r"""

        Parameters
        ----------
        uid: Standard_GUID

        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _Standard.Standard_GUID_IsNotSame(self, *args)

    def IsSame(self, *args):
        r"""

        Parameters
        ----------
        uid: Standard_GUID

        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _Standard.Standard_GUID_IsSame(self, *args)

    def ShallowDumpToString(self):
        r"""ShallowDumpToString(Standard_GUID self) -> std::string"""
        return _Standard.Standard_GUID_ShallowDumpToString(self)

    def ToCString(self, *args):
        r"""

        Parameters
        ----------
        aStrGuid: Standard_PCharacter

        Return
        -------
        None

        Description
        -----------
        Translate the guid into ascii string the astrguid is allocated by user. the guid have the following format: //! '00000000-0000-0000-0000-000000000000'.

        """
        return _Standard.Standard_GUID_ToCString(self, *args)

    def ToExtString(self, *args):
        r"""

        Parameters
        ----------
        aStrGuid: Standard_PExtCharacter

        Return
        -------
        None

        Description
        -----------
        Translate the guid into unicode string the astrguid is allocated by user. the guid have the following format: //! '00000000-0000-0000-0000-000000000000'.

        """
        return _Standard.Standard_GUID_ToExtString(self, *args)

    def ToUUID(self, *args):
        r"""
        Return
        -------
        Standard_UUID

        Description
        -----------
        No available documentation.

        """
        return _Standard.Standard_GUID_ToUUID(self, *args)

    def __ne_wrapper__(self, other):
        r"""__ne_wrapper__(Standard_GUID self, Standard_GUID other) -> bool"""
        return _Standard.Standard_GUID___ne_wrapper__(self, other)

    def __ne__(self, right):
        try:
            return self.__ne_wrapper__(right)
        except:
            return True


    def __eq_wrapper__(self, other):
        r"""__eq_wrapper__(Standard_GUID self, Standard_GUID other) -> bool"""
        return _Standard.Standard_GUID___eq_wrapper__(self, other)

    def __eq__(self, right):
        try:
            return self.__eq_wrapper__(right)
        except:
            return False


    __repr__ = _dumps_object

    __swig_destroy__ = _Standard.delete_Standard_GUID

# Register Standard_GUID in _Standard:
_Standard.Standard_GUID_swigregister(Standard_GUID)
class Standard_MMgrRoot(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Allocate(self, *args):
        r"""

        Parameters
        ----------
        theSize: Standard_Size

        Return
        -------
        Standard_Address

        Description
        -----------
        Allocate specified number of bytes. the actually allocated space should be rounded up to double word size (4 bytes), as this is expected by implementation of some classes in occ (e.g. tcollection_asciistring).

        """
        return _Standard.Standard_MMgrRoot_Allocate(self, *args)

    def Free(self, *args):
        r"""

        Parameters
        ----------
        thePtr: Standard_Address

        Return
        -------
        None

        Description
        -----------
        Frees previously allocated memory at specified address.

        """
        return _Standard.Standard_MMgrRoot_Free(self, *args)

    def Purge(self, *args):
        r"""

        Parameters
        ----------
        isDestroyed: bool (optional, default to Standard_False)

        Return
        -------
        int

        Description
        -----------
        Purge internally cached unused memory blocks (if any) by releasing them to the operating system. must return non-zero if some memory has been actually released, or zero otherwise. if option isdestroyed is true, this means that memory manager is not expected to be used any more; note however that in general case it is still possible to have calls to that instance of memory manager after this (e.g. to free memory of static objects in occ). thus this option should command the memory manager to release any cached memory to the system and not cache any more, but still remain operable... //! default implementation does nothing and returns 0.

        """
        return _Standard.Standard_MMgrRoot_Purge(self, *args)

    def Reallocate(self, *args):
        r"""

        Parameters
        ----------
        thePtr: Standard_Address
        theSize: Standard_Size

        Return
        -------
        Standard_Address

        Description
        -----------
        Reallocate previously allocated memory to contain at least thesize bytes. in case of success, new pointer is returned.

        """
        return _Standard.Standard_MMgrRoot_Reallocate(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _Standard.delete_Standard_MMgrRoot

# Register Standard_MMgrRoot in _Standard:
_Standard.Standard_MMgrRoot_swigregister(Standard_MMgrRoot)
class Standard_Transient(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor.

        Parameters
        ----------
        &: Standard_Transient

        Return
        -------
        None

        Description
        -----------
        Copy constructor -- does nothing.

        """
        _Standard.Standard_Transient_swiginit(self, _Standard.new_Standard_Transient(*args))

    def DecrementRefCounter(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Decrements the reference counter of this object; returns the decremented value.

        """
        return _Standard.Standard_Transient_DecrementRefCounter(self, *args)

    def Delete(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Memory deallocator for transient classes.

        """
        return _Standard.Standard_Transient_Delete(self, *args)

    def DynamicType(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Standard_Type>

        Description
        -----------
        Returns a type descriptor about this object.

        """
        return _Standard.Standard_Transient_DynamicType(self, *args)

    def GetRefCount(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Get the reference counter of this object.

        """
        return _Standard.Standard_Transient_GetRefCount(self, *args)

    def IncrementRefCounter(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Increments the reference counter of this object.

        """
        return _Standard.Standard_Transient_IncrementRefCounter(self, *args)

    def IsInstance(self, *args):
        r"""

        Parameters
        ----------
        theType: Standard_Type

        Return
        -------
        bool

        Description
        -----------
        Returns a true value if this is an instance of type.

        Parameters
        ----------
        theTypeName: str

        Return
        -------
        bool

        Description
        -----------
        Returns a true value if this is an instance of typename.

        """
        return _Standard.Standard_Transient_IsInstance(self, *args)

    def IsKind(self, *args):
        r"""

        Parameters
        ----------
        theType: Standard_Type

        Return
        -------
        bool

        Description
        -----------
        Returns true if this is an instance of type or an instance of any class that inherits from type. note that multiple inheritance is not supported by occt rtti mechanism.

        Parameters
        ----------
        theTypeName: str

        Return
        -------
        bool

        Description
        -----------
        Returns true if this is an instance of typename or an instance of any class that inherits from typename. note that multiple inheritance is not supported by occt rtti mechanism.

        """
        return _Standard.Standard_Transient_IsKind(self, *args)

    def This(self, *args):
        r"""
        Return
        -------
        Standard_Transient *

        Description
        -----------
        Returns non-const pointer to this object (like const_cast). for protection against creating handle to objects allocated in stack or call from constructor, it will raise exception standard_programerror if reference counter is zero.

        """
        return _Standard.Standard_Transient_This(self, *args)

    @staticmethod
    def get_type_descriptor(*args):
        r"""
        Return
        -------
        opencascade::handle<Standard_Type>

        Description
        -----------
        Returns type descriptor of standard_transient class.

        """
        return _Standard.Standard_Transient_get_type_descriptor(*args)

    @staticmethod
    def get_type_name(*args):
        r"""
        Return
        -------
        char *

        Description
        -----------
        No available documentation.

        """
        return _Standard.Standard_Transient_get_type_name(*args)


    @staticmethod
    def DownCast(t):
      return Handle_Standard_Transient_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Standard.delete_Standard_Transient

# Register Standard_Transient in _Standard:
_Standard.Standard_Transient_swigregister(Standard_Transient)
class Standard_UUID(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    Data1 = property(_Standard.Standard_UUID_Data1_get, _Standard.Standard_UUID_Data1_set)
    Data2 = property(_Standard.Standard_UUID_Data2_get, _Standard.Standard_UUID_Data2_set)
    Data3 = property(_Standard.Standard_UUID_Data3_get, _Standard.Standard_UUID_Data3_set)
    Data4 = property(_Standard.Standard_UUID_Data4_get, _Standard.Standard_UUID_Data4_set)

    __repr__ = _dumps_object


    def __init__(self):
        _Standard.Standard_UUID_swiginit(self, _Standard.new_Standard_UUID())
    __swig_destroy__ = _Standard.delete_Standard_UUID

# Register Standard_UUID in _Standard:
_Standard.Standard_UUID_swigregister(Standard_UUID)
class Standard_Failure(Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates a status object of type 'failure'.

        Parameters
        ----------
        f: Standard_Failure

        Return
        -------
        None

        Description
        -----------
        Copy constructor.

        Parameters
        ----------
        theDesc: str

        Return
        -------
        None

        Description
        -----------
        Creates a status object of type 'failure'. @param thedesc [in] exception description.

        Parameters
        ----------
        theDesc: str
        theStackTrace: str

        Return
        -------
        None

        Description
        -----------
        Creates a status object of type 'failure' with stack trace. @param thedesc [in] exception description @param thestacktrace [in] associated stack trace.

        """
        _Standard.Standard_Failure_swiginit(self, _Standard.new_Standard_Failure(*args))

    @staticmethod
    def DefaultStackTraceLength(*args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the default length of stack trace to be captured by standard_failure constructor; 0 by default meaning no stack trace.

        """
        return _Standard.Standard_Failure_DefaultStackTraceLength(*args)

    def GetMessageString(self, *args):
        r"""
        Return
        -------
        str

        Description
        -----------
        Returns error message.

        """
        return _Standard.Standard_Failure_GetMessageString(self, *args)

    def GetStackString(self, *args):
        r"""
        Return
        -------
        str

        Description
        -----------
        Returns the stack trace string.

        """
        return _Standard.Standard_Failure_GetStackString(self, *args)

    def Jump(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Used to throw cascade exception from c signal handler. on platforms that do not allow throwing c++ exceptions from this handler (e.g. linux), uses longjump to get to the current active signal handler, and only then is converted to c++ exception.

        """
        return _Standard.Standard_Failure_Jump(self, *args)

    @staticmethod
    def NewInstance(*args):
        r"""

        Parameters
        ----------
        theMessage: str

        Return
        -------
        opencascade::handle<Standard_Failure>

        Description
        -----------
        Used to construct an instance of the exception object as a handle. shall be used to protect against possible construction of exception object in c stack, which is dangerous since some of methods require that object was allocated dynamically.

        Parameters
        ----------
        theMessage: str
        theStackTrace: str

        Return
        -------
        opencascade::handle<Standard_Failure>

        Description
        -----------
        Used to construct an instance of the exception object as a handle.

        """
        return _Standard.Standard_Failure_NewInstance(*args)

    def PrintToString(self):
        r"""PrintToString(Standard_Failure self) -> std::string"""
        return _Standard.Standard_Failure_PrintToString(self)

    @staticmethod
    def Raise(*args):
        r"""

        Parameters
        ----------
        aMessage: str (optional, default to )

        Return
        -------
        None

        Description
        -----------
        Raises an exception of type 'failure' and associates an error message to it. the message can be printed in an exception handler.

        Parameters
        ----------
        aReason: Standard_SStream

        Return
        -------
        None

        Description
        -----------
        Raises an exception of type 'failure' and associates an error message to it. the message can be constructed at run-time.

        """
        return _Standard.Standard_Failure_Raise(*args)

    def Reraise(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        aMessage: str

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        aReason: Standard_SStream

        Return
        -------
        None

        Description
        -----------
        Reraises a caught exception and changes its error message.

        """
        return _Standard.Standard_Failure_Reraise(self, *args)

    @staticmethod
    def SetDefaultStackTraceLength(*args):
        r"""

        Parameters
        ----------
        theNbStackTraces: int

        Return
        -------
        None

        Description
        -----------
        Sets default length of stack trace to be captured by standard_failure constructor.

        """
        return _Standard.Standard_Failure_SetDefaultStackTraceLength(*args)

    def SetMessageString(self, *args):
        r"""

        Parameters
        ----------
        theMessage: str

        Return
        -------
        None

        Description
        -----------
        Sets error message.

        """
        return _Standard.Standard_Failure_SetMessageString(self, *args)

    def SetStackString(self, *args):
        r"""

        Parameters
        ----------
        theStack: str

        Return
        -------
        None

        Description
        -----------
        Sets the stack trace string.

        """
        return _Standard.Standard_Failure_SetStackString(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Standard_Failure_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Standard.delete_Standard_Failure

# Register Standard_Failure in _Standard:
_Standard.Standard_Failure_swigregister(Standard_Failure)
class Standard_MMgrOpt(Standard_MMgrRoot):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        aClear: bool (optional, default to Standard_True)
        aMMap: bool (optional, default to Standard_True)
        aCellSize: Standard_Size (optional, default to 200)
        aNbPages: int (optional, default to 10000)
        aThreshold: Standard_Size (optional, default to 40000)

        Return
        -------
        None

        Description
        -----------
        Constructor. if aclear is true, the allocated emmory will be nullified. for description of other parameters, see description of the class above.

        """
        _Standard.Standard_MMgrOpt_swiginit(self, _Standard.new_Standard_MMgrOpt(*args))

    __repr__ = _dumps_object

    @methodnotwrapped
    def SetCallBackFunction(self):
    	pass

    __swig_destroy__ = _Standard.delete_Standard_MMgrOpt

# Register Standard_MMgrOpt in _Standard:
_Standard.Standard_MMgrOpt_swigregister(Standard_MMgrOpt)
class Standard_MMgrRaw(Standard_MMgrRoot):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        aClear: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Constructor; if aclear is true, the memory will be nullified upon allocation.

        """
        _Standard.Standard_MMgrRaw_swiginit(self, _Standard.new_Standard_MMgrRaw(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _Standard.delete_Standard_MMgrRaw

# Register Standard_MMgrRaw in _Standard:
_Standard.Standard_MMgrRaw_swigregister(Standard_MMgrRaw)
class Standard_MMgrTBBalloc(Standard_MMgrRoot):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        aClear: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Constructor; if aclear is true, the memory will be nullified upon allocation.

        """
        _Standard.Standard_MMgrTBBalloc_swiginit(self, _Standard.new_Standard_MMgrTBBalloc(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _Standard.delete_Standard_MMgrTBBalloc

# Register Standard_MMgrTBBalloc in _Standard:
_Standard.Standard_MMgrTBBalloc_swigregister(Standard_MMgrTBBalloc)
class Standard_OutOfMemory(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        theMessage: str (optional, default to 0)

        Return
        -------
        None

        Description
        -----------
        Constructor is kept public for backward compatibility.

        """
        _Standard.Standard_OutOfMemory_swiginit(self, _Standard.new_Standard_OutOfMemory(*args))

    def GetMessageString(self, *args):
        r"""
        Return
        -------
        str

        Description
        -----------
        Returns error message.

        """
        return _Standard.Standard_OutOfMemory_GetMessageString(self, *args)

    @staticmethod
    def NewInstance(*args):
        r"""

        Parameters
        ----------
        theMessage: str (optional, default to )

        Return
        -------
        opencascade::handle<Standard_OutOfMemory>

        Description
        -----------
        Returns global instance of exception.

        Parameters
        ----------
        theMessage: str
        theStackTrace: str

        Return
        -------
        opencascade::handle<Standard_OutOfMemory>

        Description
        -----------
        Returns global instance of exception.

        """
        return _Standard.Standard_OutOfMemory_NewInstance(*args)

    @staticmethod
    def Raise(*args):
        r"""

        Parameters
        ----------
        theMessage: str (optional, default to )

        Return
        -------
        None

        Description
        -----------
        Raises exception with specified message string.

        Parameters
        ----------
        theMessage: Standard_SStream

        Return
        -------
        None

        Description
        -----------
        Raises exception with specified message string.

        """
        return _Standard.Standard_OutOfMemory_Raise(*args)

    def SetMessageString(self, *args):
        r"""

        Parameters
        ----------
        aMessage: str

        Return
        -------
        None

        Description
        -----------
        Sets error message.

        """
        return _Standard.Standard_OutOfMemory_SetMessageString(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Standard_OutOfMemory_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Standard.delete_Standard_OutOfMemory

# Register Standard_OutOfMemory in _Standard:
_Standard.Standard_OutOfMemory_swigregister(Standard_OutOfMemory)
class Standard_Persistent(Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _Standard.Standard_Persistent_swiginit(self, _Standard.new_Standard_Persistent(*args))

    def GetTypeNum(self):
        r"""GetTypeNum(Standard_Persistent self) -> Standard_Integer"""
        return _Standard.Standard_Persistent_GetTypeNum(self)

    def SetTypeNum(self, value):
        r"""SetTypeNum(Standard_Persistent self, Standard_Integer value)"""
        return _Standard.Standard_Persistent_SetTypeNum(self, value)


    @staticmethod
    def DownCast(t):
      return Handle_Standard_Persistent_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Standard.delete_Standard_Persistent

# Register Standard_Persistent in _Standard:
_Standard.Standard_Persistent_swigregister(Standard_Persistent)
class Standard_Type(Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Name(self, *args):
        r"""
        Return
        -------
        str

        Description
        -----------
        Returns the given name of the class type (get_type_name).

        """
        return _Standard.Standard_Type_Name(self, *args)

    def Parent(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Standard_Type>

        Description
        -----------
        Returns descriptor of the base class in the hierarchy.

        """
        return _Standard.Standard_Type_Parent(self, *args)

    def PrintToString(self):
        r"""PrintToString(Standard_Type self) -> std::string"""
        return _Standard.Standard_Type_PrintToString(self)

    @staticmethod
    def Register(*args):
        r"""

        Parameters
        ----------
        theSystemName: char *
        theName: char *
        theSize: Standard_Size
        theParent: Standard_Type

        Return
        -------
        Standard_Type *

        Description
        -----------
        Register a type; returns either new or existing descriptor. //! @param thesystemname name of the class as returned by typeid(class).name() @param thename name of the class to be stored in name field @param thesize size of the class instance @param theparent base class in the transient hierarchy //! note that this function is intended for use by opencascade::type_instance only. .

        """
        return _Standard.Standard_Type_Register(*args)

    def Size(self, *args):
        r"""
        Return
        -------
        Standard_Size

        Description
        -----------
        Returns the size of the class instance in bytes.

        """
        return _Standard.Standard_Type_Size(self, *args)

    def SubType(self, *args):
        r"""

        Parameters
        ----------
        theOther: Standard_Type

        Return
        -------
        bool

        Description
        -----------
        Returns true if this type is the same as theother, or inherits from theother. note that multiple inheritance is not supported.

        Parameters
        ----------
        theOther: str

        Return
        -------
        bool

        Description
        -----------
        Returns true if this type is the same as theother, or inherits from theother. note that multiple inheritance is not supported.

        """
        return _Standard.Standard_Type_SubType(self, *args)

    def SystemName(self, *args):
        r"""
        Return
        -------
        str

        Description
        -----------
        Returns the system type name of the class (typeinfo.name).

        """
        return _Standard.Standard_Type_SystemName(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Standard_Type_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Standard.delete_Standard_Type

# Register Standard_Type in _Standard:
_Standard.Standard_Type_swigregister(Standard_Type)

@classnotwrapped
class Standard_AncestorIterator:
	pass

@classnotwrapped
class Standard_Static_Assert:
	pass

@classnotwrapped
class Standard_CLocaleSentry:
	pass

@classnotwrapped
class Standard_Mutex:
	pass

@classnotwrapped
class Standard_ReadLineBuffer:
	pass

@classnotwrapped
class Standard_ProgramError:
	pass

@classnotwrapped
class Standard_ReadBuffer:
	pass





@deprecated
def standard_Allocate(*args):
	return standard.Allocate(*args)

@deprecated
def standard_AllocateAligned(*args):
	return standard.AllocateAligned(*args)

@deprecated
def standard_Purge(*args):
	return standard.Purge(*args)

@deprecated
def standard_Reallocate(*args):
	return standard.Reallocate(*args)

@deprecated
def standard_StackTrace(*args):
	return standard.StackTrace(*args)

@deprecated
def Standard_ErrorHandler_IsInTryBlock(*args):
	return Standard_ErrorHandler.IsInTryBlock(*args)

@deprecated
def Standard_ErrorHandler_LastCaughtError(*args):
	return Standard_ErrorHandler.LastCaughtError(*args)

@deprecated
def Standard_GUID_CheckGUIDFormat(*args):
	return Standard_GUID.CheckGUIDFormat(*args)

@deprecated
def Standard_GUID_HashCode(*args):
	return Standard_GUID.HashCode(*args)

@deprecated
def Standard_GUID_IsEqual(*args):
	return Standard_GUID.IsEqual(*args)

@deprecated
def Standard_Failure_DefaultStackTraceLength(*args):
	return Standard_Failure.DefaultStackTraceLength(*args)

@deprecated
def Standard_Failure_NewInstance(*args):
	return Standard_Failure.NewInstance(*args)

@deprecated
def Standard_Failure_NewInstance(*args):
	return Standard_Failure.NewInstance(*args)

@deprecated
def Standard_Failure_Raise(*args):
	return Standard_Failure.Raise(*args)

@deprecated
def Standard_Failure_Raise(*args):
	return Standard_Failure.Raise(*args)

@deprecated
def Standard_Failure_SetDefaultStackTraceLength(*args):
	return Standard_Failure.SetDefaultStackTraceLength(*args)

@deprecated
def Standard_OutOfMemory_NewInstance(*args):
	return Standard_OutOfMemory.NewInstance(*args)

@deprecated
def Standard_OutOfMemory_NewInstance(*args):
	return Standard_OutOfMemory.NewInstance(*args)

@deprecated
def Standard_OutOfMemory_Raise(*args):
	return Standard_OutOfMemory.Raise(*args)

@deprecated
def Standard_OutOfMemory_Raise(*args):
	return Standard_OutOfMemory.Raise(*args)

@deprecated
def Standard_Type_Register(*args):
	return Standard_Type.Register(*args)



