import { EndpointParameterInstructions } from "@smithy/middleware-endpoint";
import { Command as $Command } from "@smithy/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@smithy/types";
import {
  CloudFormationClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../CloudFormationClient";
import { RollbackStackInput, RollbackStackOutput } from "../models/models_0";
export { __MetadataBearer, $Command };
export interface RollbackStackCommandInput extends RollbackStackInput {}
export interface RollbackStackCommandOutput
  extends RollbackStackOutput,
    __MetadataBearer {}
export declare class RollbackStackCommand extends $Command<
  RollbackStackCommandInput,
  RollbackStackCommandOutput,
  CloudFormationClientResolvedConfig
> {
  readonly input: RollbackStackCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: RollbackStackCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: CloudFormationClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<RollbackStackCommandInput, RollbackStackCommandOutput>;
  private serialize;
  private deserialize;
}
