/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.sun.media.rtp.SSRCCache;
import com.sun.media.rtp.SSRCInfo;
import java.util.Vector;
import javax.media.protocol.DataSource;
import javax.media.rtp.LocalParticipant;
import javax.media.rtp.Participant;
import javax.media.rtp.RTPStream;
import javax.media.rtp.ReceiveStream;
import javax.media.rtp.ReceptionStats;
import javax.media.rtp.rtcp.Feedback;
import javax.media.rtp.rtcp.Report;
import javax.media.rtp.rtcp.SenderReport;

public class RecvSSRCInfo
extends SSRCInfo
implements ReceiveStream,
SenderReport {
    RecvSSRCInfo(SSRCCache cache, int ssrc) {
        super(cache, ssrc);
    }

    RecvSSRCInfo(SSRCInfo info) {
        super(info);
    }

    public Participant getParticipant() {
        SSRCCache cache = this.getSSRCCache();
        if (this.sourceInfo instanceof LocalParticipant && cache.sm.IsNonParticipating()) {
            return null;
        }
        return this.sourceInfo;
    }

    public SenderReport getSenderReport() {
        return this;
    }

    public long getSSRC() {
        return this.ssrc;
    }

    public DataSource getDataSource() {
        return this.dsource;
    }

    public long getSenderPacketCount() {
        return this.lastSRpacketcount;
    }

    public long getSenderByteCount() {
        return this.lastSRoctetcount;
    }

    public long getNTPTimeStampMSW() {
        return this.lastSRntptimestamp >> 32 & 0xFFFFFFFFL;
    }

    public long getNTPTimeStampLSW() {
        return this.lastSRntptimestamp & 0xFFFFFFFFL;
    }

    public long getRTPTimeStamp() {
        return this.lastSRrtptimestamp;
    }

    public Feedback getSenderFeedback() {
        SSRCCache cache = this.getSSRCCache();
        Report report = null;
        Vector reports = null;
        Vector feedback = null;
        Feedback reportblk = null;
        try {
            LocalParticipant localpartc = cache.sm.getLocalParticipant();
            reports = localpartc.getReports();
            int i = 0;
            while (i < reports.size()) {
                report = (Report)reports.elementAt(i);
                feedback = report.getFeedbackReports();
                int j = 0;
                while (j < feedback.size()) {
                    reportblk = (Feedback)feedback.elementAt(j);
                    long ssrc = reportblk.getSSRC();
                    if (ssrc == this.getSSRC()) {
                        return reportblk;
                    }
                    ++j;
                }
                ++i;
            }
            return null;
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public RTPStream getStream() {
        return this;
    }

    public ReceptionStats getSourceReceptionStats() {
        return this.stats;
    }
}

