/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket;

import jakarta.websocket.Extension;
import jakarta.websocket.SendHandler;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.websocket.Constants;
import org.apache.tomcat.websocket.MessagePart;
import org.apache.tomcat.websocket.Transformation;
import org.apache.tomcat.websocket.TransformationResult;
import org.apache.tomcat.websocket.Util;
import org.apache.tomcat.websocket.WsExtension;
import org.apache.tomcat.websocket.WsExtensionParameter;

public class PerMessageDeflate
implements Transformation {
    private static final StringManager sm = StringManager.getManager(PerMessageDeflate.class);
    private static final String SERVER_NO_CONTEXT_TAKEOVER = "server_no_context_takeover";
    private static final String CLIENT_NO_CONTEXT_TAKEOVER = "client_no_context_takeover";
    private static final String SERVER_MAX_WINDOW_BITS = "server_max_window_bits";
    private static final String CLIENT_MAX_WINDOW_BITS = "client_max_window_bits";
    private static final int RSV_BITMASK = 4;
    private static final byte[] EOM_BYTES = new byte[]{0, 0, -1, -1};
    public static final String NAME = "permessage-deflate";
    private final boolean serverContextTakeover;
    private final int serverMaxWindowBits;
    private final boolean clientContextTakeover;
    private final int clientMaxWindowBits;
    private final boolean isServer;
    private final Inflater inflater = new Inflater(true);
    private final ByteBuffer readBuffer = ByteBuffer.allocate(Constants.DEFAULT_BUFFER_SIZE);
    private final Deflater deflater = new Deflater(-1, true);
    private final byte[] EOM_BUFFER = new byte[EOM_BYTES.length + 1];
    private volatile Transformation next;
    private volatile boolean skipDecompression = false;
    private volatile ByteBuffer writeBuffer = ByteBuffer.allocate(Constants.DEFAULT_BUFFER_SIZE);
    private volatile boolean firstCompressedFrameWritten = false;
    private volatile boolean emptyMessage = true;

    static PerMessageDeflate negotiate(List<List<Extension.Parameter>> list, boolean bl) {
        for (List<Extension.Parameter> list2 : list) {
            boolean bl2 = true;
            boolean bl3 = true;
            int n = -1;
            boolean bl4 = true;
            int n2 = -1;
            for (Extension.Parameter parameter : list2) {
                if (SERVER_NO_CONTEXT_TAKEOVER.equals(parameter.getName())) {
                    if (bl3) {
                        bl3 = false;
                        continue;
                    }
                    throw new IllegalArgumentException(sm.getString("perMessageDeflate.duplicateParameter", new Object[]{SERVER_NO_CONTEXT_TAKEOVER}));
                }
                if (CLIENT_NO_CONTEXT_TAKEOVER.equals(parameter.getName())) {
                    if (bl4) {
                        bl4 = false;
                        continue;
                    }
                    throw new IllegalArgumentException(sm.getString("perMessageDeflate.duplicateParameter", new Object[]{CLIENT_NO_CONTEXT_TAKEOVER}));
                }
                if (SERVER_MAX_WINDOW_BITS.equals(parameter.getName())) {
                    if (n == -1) {
                        n = Integer.parseInt(parameter.getValue());
                        if (n < 8 || n > 15) {
                            throw new IllegalArgumentException(sm.getString("perMessageDeflate.invalidWindowSize", new Object[]{SERVER_MAX_WINDOW_BITS, n}));
                        }
                        if (!bl || n == 15) continue;
                        bl2 = false;
                        break;
                    }
                    throw new IllegalArgumentException(sm.getString("perMessageDeflate.duplicateParameter", new Object[]{SERVER_MAX_WINDOW_BITS}));
                }
                if (CLIENT_MAX_WINDOW_BITS.equals(parameter.getName())) {
                    if (n2 == -1) {
                        if (parameter.getValue() == null) {
                            n2 = 15;
                        } else {
                            n2 = Integer.parseInt(parameter.getValue());
                            if (n2 < 8 || n2 > 15) {
                                throw new IllegalArgumentException(sm.getString("perMessageDeflate.invalidWindowSize", new Object[]{CLIENT_MAX_WINDOW_BITS, n2}));
                            }
                        }
                        if (bl || n2 == 15) continue;
                        bl2 = false;
                        break;
                    }
                    throw new IllegalArgumentException(sm.getString("perMessageDeflate.duplicateParameter", new Object[]{CLIENT_MAX_WINDOW_BITS}));
                }
                throw new IllegalArgumentException(sm.getString("perMessageDeflate.unknownParameter", new Object[]{parameter.getName()}));
            }
            if (!bl2) continue;
            return new PerMessageDeflate(bl3, n, bl4, n2, bl);
        }
        return null;
    }

    private PerMessageDeflate(boolean bl, int n, boolean bl2, int n2, boolean bl3) {
        this.serverContextTakeover = bl;
        this.serverMaxWindowBits = n;
        this.clientContextTakeover = bl2;
        this.clientMaxWindowBits = n2;
        this.isServer = bl3;
    }

    @Override
    public TransformationResult getMoreData(byte by, boolean bl, int n, ByteBuffer byteBuffer) throws IOException {
        if (Util.isControl(by)) {
            return this.next.getMoreData(by, bl, n, byteBuffer);
        }
        if (!Util.isContinuation(by)) {
            boolean bl2 = this.skipDecompression = (n & 4) == 0;
        }
        if (this.skipDecompression) {
            return this.next.getMoreData(by, bl, n, byteBuffer);
        }
        boolean bl3 = false;
        while (byteBuffer.remaining() > 0 || bl3) {
            int n2;
            try {
                n2 = this.inflater.inflate(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
            }
            catch (DataFormatException dataFormatException) {
                throw new IOException(sm.getString("perMessageDeflate.deflateFailed"), dataFormatException);
            }
            catch (NullPointerException nullPointerException) {
                throw new IOException(sm.getString("perMessageDeflate.alreadyClosed"), nullPointerException);
            }
            byteBuffer.position(byteBuffer.position() + n2);
            if (this.inflater.needsInput() && !bl3) {
                this.readBuffer.clear();
                TransformationResult transformationResult = this.next.getMoreData(by, bl, n ^ 4, this.readBuffer);
                this.inflater.setInput(this.readBuffer.array(), this.readBuffer.arrayOffset(), this.readBuffer.position());
                if (byteBuffer.hasRemaining()) {
                    if (TransformationResult.UNDERFLOW.equals((Object)transformationResult)) {
                        return transformationResult;
                    }
                    if (!TransformationResult.END_OF_FRAME.equals((Object)transformationResult) || this.readBuffer.position() != 0) continue;
                    if (bl) {
                        this.inflater.setInput(EOM_BYTES);
                        bl3 = true;
                        continue;
                    }
                    return TransformationResult.END_OF_FRAME;
                }
                if (this.readBuffer.position() > 0) {
                    return TransformationResult.OVERFLOW;
                }
                if (!bl) continue;
                this.inflater.setInput(EOM_BYTES);
                bl3 = true;
                continue;
            }
            if (n2 != 0) continue;
            if (bl && (this.isServer && !this.clientContextTakeover || !this.isServer && !this.serverContextTakeover)) {
                try {
                    this.inflater.reset();
                }
                catch (NullPointerException nullPointerException) {
                    throw new IOException(sm.getString("perMessageDeflate.alreadyClosed"), nullPointerException);
                }
            }
            return TransformationResult.END_OF_FRAME;
        }
        return TransformationResult.OVERFLOW;
    }

    @Override
    public boolean validateRsv(int n, byte by) {
        if (Util.isControl(by)) {
            if ((n & 4) != 0) {
                return false;
            }
            if (this.next == null) {
                return true;
            }
            return this.next.validateRsv(n, by);
        }
        int n2 = n;
        if ((n & 4) != 0) {
            n2 = n ^ 4;
        }
        if (this.next == null) {
            return true;
        }
        return this.next.validateRsv(n2, by);
    }

    @Override
    public Extension getExtensionResponse() {
        WsExtension wsExtension = new WsExtension(NAME);
        List list = wsExtension.getParameters();
        if (!this.serverContextTakeover) {
            list.add(new WsExtensionParameter(SERVER_NO_CONTEXT_TAKEOVER, null));
        }
        if (this.serverMaxWindowBits != -1) {
            list.add(new WsExtensionParameter(SERVER_MAX_WINDOW_BITS, Integer.toString(this.serverMaxWindowBits)));
        }
        if (!this.clientContextTakeover) {
            list.add(new WsExtensionParameter(CLIENT_NO_CONTEXT_TAKEOVER, null));
        }
        if (this.clientMaxWindowBits != -1) {
            list.add(new WsExtensionParameter(CLIENT_MAX_WINDOW_BITS, Integer.toString(this.clientMaxWindowBits)));
        }
        return wsExtension;
    }

    @Override
    public void setNext(Transformation transformation) {
        if (this.next == null) {
            this.next = transformation;
        } else {
            this.next.setNext(transformation);
        }
    }

    @Override
    public boolean validateRsvBits(int n) {
        if ((n & 4) != 0) {
            return false;
        }
        if (this.next == null) {
            return true;
        }
        return this.next.validateRsvBits(n | 4);
    }

    @Override
    public List<MessagePart> sendMessagePart(List<MessagePart> list) throws IOException {
        ArrayList<MessagePart> arrayList = new ArrayList<MessagePart>();
        for (MessagePart messagePart : list) {
            int n;
            ByteBuffer byteBuffer;
            byte by = messagePart.getOpCode();
            if (Util.isControl(by)) {
                arrayList.add(messagePart);
                continue;
            }
            boolean bl = messagePart.getPayload().limit() == 0;
            boolean bl2 = this.emptyMessage = this.emptyMessage && bl;
            if (this.emptyMessage && messagePart.isFin()) {
                arrayList.add(messagePart);
                continue;
            }
            ArrayList<MessagePart> arrayList2 = new ArrayList<MessagePart>();
            ByteBuffer byteBuffer2 = messagePart.getPayload();
            SendHandler sendHandler = messagePart.getIntermediateHandler();
            if (byteBuffer2.hasArray()) {
                this.deflater.setInput(byteBuffer2.array(), byteBuffer2.arrayOffset() + byteBuffer2.position(), byteBuffer2.remaining());
            } else {
                byte[] byArray = new byte[byteBuffer2.remaining()];
                byteBuffer2.get(byArray);
                this.deflater.setInput(byArray, 0, byArray.length);
            }
            int n2 = messagePart.isFin() ? 2 : 0;
            boolean bl3 = true;
            while (bl3) {
                MessagePart messagePart2;
                byteBuffer = this.writeBuffer;
                try {
                    n = this.deflater.deflate(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining(), n2);
                    byteBuffer.position(byteBuffer.position() + n);
                }
                catch (NullPointerException nullPointerException) {
                    throw new IOException(sm.getString("perMessageDeflate.alreadyClosed"), nullPointerException);
                }
                if (!messagePart.isFin() && byteBuffer.hasRemaining() && this.deflater.needsInput()) break;
                this.writeBuffer = ByteBuffer.allocate(Constants.DEFAULT_BUFFER_SIZE);
                byteBuffer.flip();
                boolean bl4 = messagePart.isFin();
                boolean bl5 = byteBuffer.limit() == byteBuffer.capacity();
                boolean bl6 = this.deflater.needsInput();
                long l = messagePart.getBlockingWriteTimeoutExpiry();
                if (bl4 && !bl5 && bl6) {
                    byteBuffer.limit(byteBuffer.limit() - EOM_BYTES.length);
                    messagePart2 = new MessagePart(true, this.getRsv(messagePart), by, byteBuffer, sendHandler, sendHandler, l);
                    bl3 = false;
                    this.startNewMessage();
                } else if (bl5 && !bl6) {
                    messagePart2 = new MessagePart(false, this.getRsv(messagePart), by, byteBuffer, sendHandler, sendHandler, l);
                } else if (!bl4 && bl5 && bl6) {
                    messagePart2 = new MessagePart(false, this.getRsv(messagePart), by, byteBuffer, sendHandler, sendHandler, l);
                    bl3 = false;
                } else if (bl4 && bl5 && bl6) {
                    int n3;
                    try {
                        n3 = this.deflater.deflate(this.EOM_BUFFER, 0, this.EOM_BUFFER.length, 2);
                    }
                    catch (NullPointerException nullPointerException) {
                        throw new IOException(sm.getString("perMessageDeflate.alreadyClosed"), nullPointerException);
                    }
                    if (n3 < this.EOM_BUFFER.length) {
                        byteBuffer.limit(byteBuffer.limit() - EOM_BYTES.length + n3);
                        messagePart2 = new MessagePart(true, this.getRsv(messagePart), by, byteBuffer, sendHandler, sendHandler, l);
                        bl3 = false;
                        this.startNewMessage();
                    } else {
                        this.writeBuffer.put(this.EOM_BUFFER, 0, n3);
                        messagePart2 = new MessagePart(false, this.getRsv(messagePart), by, byteBuffer, sendHandler, sendHandler, l);
                    }
                } else {
                    throw new IllegalStateException(sm.getString("perMessageDeflate.invalidState"));
                }
                arrayList2.add(messagePart2);
            }
            byteBuffer = messagePart.getEndHandler();
            n = arrayList2.size();
            if (n > 0) {
                ((MessagePart)arrayList2.get(n - 1)).setEndHandler((SendHandler)byteBuffer);
            }
            arrayList.addAll(arrayList2);
        }
        if (this.next == null) {
            return arrayList;
        }
        return this.next.sendMessagePart(arrayList);
    }

    private void startNewMessage() throws IOException {
        this.firstCompressedFrameWritten = false;
        this.emptyMessage = true;
        if (this.isServer && !this.serverContextTakeover || !this.isServer && !this.clientContextTakeover) {
            try {
                this.deflater.reset();
            }
            catch (NullPointerException nullPointerException) {
                throw new IOException(sm.getString("perMessageDeflate.alreadyClosed"), nullPointerException);
            }
        }
    }

    private int getRsv(MessagePart messagePart) {
        int n = messagePart.getRsv();
        if (!this.firstCompressedFrameWritten) {
            n += 4;
            this.firstCompressedFrameWritten = true;
        }
        return n;
    }

    @Override
    public void close() {
        this.next.close();
        this.inflater.end();
        this.deflater.end();
    }
}

