/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2;

import java.lang.management.ManagementFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.concurrent.Executor;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.apache.tomcat.dbcp.dbcp2.DelegatingConnection;
import org.apache.tomcat.dbcp.dbcp2.ObjectNameWrapper;
import org.apache.tomcat.dbcp.dbcp2.PoolableConnectionMXBean;
import org.apache.tomcat.dbcp.dbcp2.PoolingConnection;
import org.apache.tomcat.dbcp.dbcp2.Utils;
import org.apache.tomcat.dbcp.pool2.ObjectPool;

public class PoolableConnection
extends DelegatingConnection<Connection>
implements PoolableConnectionMXBean {
    private static MBeanServer MBEAN_SERVER;
    private final ObjectPool<PoolableConnection> pool;
    private final ObjectNameWrapper jmxObjectName;
    private PreparedStatement validationPreparedStatement;
    private String lastValidationSql;
    private boolean fatalSqlExceptionThrown;
    private final Collection<String> disconnectionSqlCodes;
    private final boolean fastFailValidation;

    public PoolableConnection(Connection connection, ObjectPool<PoolableConnection> objectPool, ObjectName objectName, Collection<String> collection, boolean bl) {
        super(connection);
        this.pool = objectPool;
        this.jmxObjectName = ObjectNameWrapper.wrap(objectName);
        this.disconnectionSqlCodes = collection;
        this.fastFailValidation = bl;
        if (objectName != null) {
            try {
                MBEAN_SERVER.registerMBean(this, objectName);
            }
            catch (InstanceAlreadyExistsException | MBeanRegistrationException | NotCompliantMBeanException jMException) {
                // empty catch block
            }
        }
    }

    public PoolableConnection(Connection connection, ObjectPool<PoolableConnection> objectPool, ObjectName objectName) {
        this(connection, objectPool, objectName, null, true);
    }

    @Override
    protected void passivate() throws SQLException {
        super.passivate();
        this.setClosedInternal(true);
        if (this.getDelegateInternal() instanceof PoolingConnection) {
            ((PoolingConnection)this.getDelegateInternal()).connectionReturnedToPool();
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        if (this.isClosedInternal()) {
            return true;
        }
        if (this.getDelegateInternal().isClosed()) {
            this.close();
            return true;
        }
        return false;
    }

    @Override
    public synchronized void close() throws SQLException {
        boolean bl;
        if (this.isClosedInternal()) {
            return;
        }
        try {
            bl = this.getDelegateInternal().isClosed();
        }
        catch (SQLException sQLException) {
            try {
                this.pool.invalidateObject(this);
            }
            catch (IllegalStateException illegalStateException) {
                this.passivate();
                this.getInnermostDelegate().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new SQLException("Cannot close connection (isClosed check failed)", sQLException);
        }
        if (bl) {
            try {
                this.pool.invalidateObject(this);
            }
            catch (IllegalStateException illegalStateException) {
                this.passivate();
                this.getInnermostDelegate().close();
            }
            catch (Exception exception) {
                throw new SQLException("Cannot close connection (invalidating pooled object failed)", exception);
            }
        } else {
            try {
                this.pool.returnObject(this);
            }
            catch (IllegalStateException illegalStateException) {
                this.passivate();
                this.getInnermostDelegate().close();
            }
            catch (RuntimeException | SQLException exception) {
                throw exception;
            }
            catch (Exception exception) {
                throw new SQLException("Cannot close connection (return to pool failed)", exception);
            }
        }
    }

    @Override
    public void reallyClose() throws SQLException {
        if (this.jmxObjectName != null) {
            this.jmxObjectName.unregisterMBean();
        }
        if (this.validationPreparedStatement != null) {
            try {
                this.validationPreparedStatement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        super.closeInternal();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        if (this.jmxObjectName != null) {
            this.jmxObjectName.unregisterMBean();
        }
        super.abort(executor);
    }

    @Override
    public String getToString() {
        return this.toString();
    }

    public void validate(String string, int n) throws SQLException {
        if (this.fastFailValidation && this.fatalSqlExceptionThrown) {
            throw new SQLException(Utils.getMessage("poolableConnection.validate.fastFail"));
        }
        if (string == null || string.isEmpty()) {
            if (n < 0) {
                n = 0;
            }
            if (!this.isValid(n)) {
                throw new SQLException("isValid() returned false");
            }
            return;
        }
        if (!string.equals(this.lastValidationSql)) {
            this.lastValidationSql = string;
            this.validationPreparedStatement = this.getInnermostDelegateInternal().prepareStatement(string);
        }
        if (n > 0) {
            this.validationPreparedStatement.setQueryTimeout(n);
        }
        try (ResultSet resultSet = this.validationPreparedStatement.executeQuery();){
            if (!resultSet.next()) {
                throw new SQLException("validationQuery didn't return a row");
            }
        }
    }

    private boolean isDisconnectionSqlException(SQLException sQLException) {
        boolean bl = false;
        String string = sQLException.getSQLState();
        if (string != null) {
            SQLException sQLException2;
            boolean bl2 = this.disconnectionSqlCodes == null ? string.startsWith("08") || Utils.DISCONNECTION_SQL_CODES.contains(string) : (bl = this.disconnectionSqlCodes.contains(string));
            if (!bl && (sQLException2 = sQLException.getNextException()) != null && sQLException2 != sQLException) {
                bl = this.isDisconnectionSqlException(sQLException.getNextException());
            }
        }
        return bl;
    }

    @Override
    protected void handleException(SQLException sQLException) throws SQLException {
        this.fatalSqlExceptionThrown |= this.isDisconnectionSqlException(sQLException);
        super.handleException(sQLException);
    }

    public Collection<String> getDisconnectionSqlCodes() {
        return this.disconnectionSqlCodes;
    }

    public boolean isFastFailValidation() {
        return this.fastFailValidation;
    }

    static {
        try {
            MBEAN_SERVER = ManagementFactory.getPlatformMBeanServer();
        }
        catch (Exception | NoClassDefFoundError throwable) {
            // empty catch block
        }
    }
}

