/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.util;

import java.util.concurrent.Callable;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.Parameters;
import org.openide.util.spi.MutexImplementation;

public final class LazyMutexImplementation
implements MutexImplementation {
    private final Callable<? extends MutexImplementation> provider;
    private MutexImplementation impl;

    public LazyMutexImplementation(Callable<? extends MutexImplementation> callable) {
        Parameters.notNull("provider", callable);
        this.provider = callable;
    }

    @Override
    public boolean isReadAccess() {
        return this.getDelegate().isReadAccess();
    }

    @Override
    public boolean isWriteAccess() {
        return this.getDelegate().isWriteAccess();
    }

    @Override
    public void writeAccess(Runnable runnable) {
        this.getDelegate().writeAccess(runnable);
    }

    @Override
    public <T> T writeAccess(Mutex.ExceptionAction<T> exceptionAction) throws MutexException {
        return this.getDelegate().writeAccess(exceptionAction);
    }

    @Override
    public void readAccess(Runnable runnable) {
        this.getDelegate().readAccess(runnable);
    }

    @Override
    public <T> T readAccess(Mutex.ExceptionAction<T> exceptionAction) throws MutexException {
        return this.getDelegate().readAccess(exceptionAction);
    }

    @Override
    public void postReadRequest(Runnable runnable) {
        this.getDelegate().postReadRequest(runnable);
    }

    @Override
    public void postWriteRequest(Runnable runnable) {
        this.getDelegate().postWriteRequest(runnable);
    }

    private synchronized MutexImplementation getDelegate() {
        if (this.impl == null) {
            try {
                this.impl = this.provider.call();
            }
            catch (Exception exception) {
                Exceptions.printStackTrace(exception);
            }
            assert (this.impl != null);
        }
        return this.impl;
    }
}

