import { SyntaxKind } from "../types.js";
import { skipTrivia, isIdentifierStart } from "../scanner.js";
export function getStart(sourceFile, node) {
    return getTokenPosOfNode(sourceFile, node);
}
function getTokenPosOfNode(sourceFile, node) {
    if (nodeIsMissing(node))
        return node.pos;
    return skipTrivia(sourceFile.content, node.pos);
}
function nodeIsMissing(node) {
    return node === undefined
        ? true
        : node.pos === node.end && node.pos >= 0 && node.kind !== SyntaxKind.EndOfFileToken;
}
export function syntaxNodesToRanges(doc, sourceFile, nodes) {
    return nodes.map(node => syntaxNodeToRange(doc, sourceFile, node));
}
export function syntaxNodeToRange(doc, sourceFile, node) {
    const start = getStart(sourceFile, node);
    return {
        start: doc.positionAt(start),
        end: doc.positionAt(node.end),
    };
}
export function escapeIdentifierText(text) {
    if (text === "")
        return quote("");
    if (text.includes("\"") || text.includes("\n")) {
        const esc = text
            .replace(/"/, "\\\"")
            .replace(/\n/, "\\\n");
        return quote(esc);
    }
    const ch = text.charCodeAt(0);
    if (!isIdentifierStart(ch) || text.includes(" "))
        return quote(text);
    return text;
}
const quote = (s) => "\"" + s + "\"";
export function assertNever(v) {
    throw new Error("Should not have reached this. Value: " + (v ?? ""));
}
//# sourceMappingURL=util.js.map