/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.lucene.search.function;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FilterLeafCollector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.opensearch.Version;
import org.opensearch.common.Nullable;
import org.opensearch.common.lucene.search.function.Functions;
import org.opensearch.common.lucene.search.function.MinScoreScorer;
import org.opensearch.script.ScoreScript;
import org.opensearch.script.Script;

public class ScriptScoreQuery
extends Query {
    private final Query subQuery;
    private final Script script;
    private final ScoreScript.LeafFactory scriptBuilder;
    private final Float minScore;
    private final String indexName;
    private final int shardId;
    private final Version indexVersion;
    private final String queryName;

    public ScriptScoreQuery(Query subQuery, Script script, ScoreScript.LeafFactory scriptBuilder, Float minScore, String indexName, int shardId, Version indexVersion) {
        this(subQuery, null, script, scriptBuilder, minScore, indexName, shardId, indexVersion);
    }

    public ScriptScoreQuery(Query subQuery, @Nullable String queryName, Script script, ScoreScript.LeafFactory scriptBuilder, Float minScore, String indexName, int shardId, Version indexVersion) {
        this.subQuery = subQuery;
        this.queryName = queryName;
        this.script = script;
        this.scriptBuilder = scriptBuilder;
        this.minScore = minScore;
        this.indexName = indexName;
        this.shardId = shardId;
        this.indexVersion = indexVersion;
    }

    public Query rewrite(IndexSearcher searcher) throws IOException {
        Query newQ = this.subQuery.rewrite(searcher);
        if (newQ != this.subQuery) {
            return new ScriptScoreQuery(newQ, this.queryName, this.script, this.scriptBuilder, this.minScore, this.indexName, this.shardId, this.indexVersion);
        }
        return super.rewrite(searcher);
    }

    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, final float boost) throws IOException {
        if (scoreMode == ScoreMode.COMPLETE_NO_SCORES && this.minScore == null) {
            return this.subQuery.createWeight(searcher, scoreMode, boost);
        }
        final boolean needsScore = this.scriptBuilder.needs_score();
        final ScoreMode subQueryScoreMode = needsScore ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
        final Weight subQueryWeight = this.subQuery.createWeight(searcher, subQueryScoreMode, 1.0f);
        return new Weight(this){

            public BulkScorer bulkScorer(LeafReaderContext context) throws IOException {
                if (ScriptScoreQuery.this.minScore == null) {
                    BulkScorer subQueryBulkScorer = subQueryWeight.bulkScorer(context);
                    if (subQueryBulkScorer == null) {
                        return null;
                    }
                    return new ScriptScoreBulkScorer(subQueryBulkScorer, subQueryScoreMode, this.makeScoreScript(context), boost);
                }
                return super.bulkScorer(context);
            }

            public Scorer scorer(LeafReaderContext context) throws IOException {
                Scorer subQueryScorer = subQueryWeight.scorer(context);
                if (subQueryScorer == null) {
                    return null;
                }
                Scorer scriptScorer = new ScriptScorer(this, this.makeScoreScript(context), subQueryScorer, subQueryScoreMode, boost, null);
                if (ScriptScoreQuery.this.minScore != null) {
                    scriptScorer = new MinScoreScorer(this, scriptScorer, ScriptScoreQuery.this.minScore.floatValue());
                }
                return scriptScorer;
            }

            public Explanation explain(LeafReaderContext context, int doc) throws IOException {
                Explanation subQueryExplanation = Functions.explainWithName(subQueryWeight.explain(context, doc), ScriptScoreQuery.this.queryName);
                if (!subQueryExplanation.isMatch()) {
                    return subQueryExplanation;
                }
                ScoreScript.ExplanationHolder explanationHolder = new ScoreScript.ExplanationHolder();
                ScriptScorer scorer = new ScriptScorer(this, this.makeScoreScript(context), subQueryWeight.scorer(context), subQueryScoreMode, 1.0f, explanationHolder);
                int newDoc = scorer.iterator().advance(doc);
                assert (doc == newDoc);
                float score = scorer.score();
                Explanation explanation = explanationHolder.get(score, (Explanation)(needsScore ? subQueryExplanation : null));
                if (explanation == null) {
                    String desc = "script score function, computed with script:\"" + ScriptScoreQuery.this.script + "\"";
                    if (needsScore) {
                        Explanation scoreExp = Explanation.match((Number)subQueryExplanation.getValue(), (String)"_score: ", (Explanation[])new Explanation[]{subQueryExplanation});
                        explanation = Explanation.match((Number)Float.valueOf(score), (String)desc, (Explanation[])new Explanation[]{scoreExp});
                    } else {
                        explanation = Explanation.match((Number)Float.valueOf(score), (String)desc, (Explanation[])new Explanation[0]);
                    }
                }
                if (boost != 1.0f) {
                    explanation = Explanation.match((Number)Float.valueOf(boost * explanation.getValue().floatValue()), (String)"Boosted score, product of:", (Explanation[])new Explanation[]{Explanation.match((Number)Float.valueOf(boost), (String)"boost", (Explanation[])new Explanation[0]), explanation});
                }
                if (ScriptScoreQuery.this.minScore != null && ScriptScoreQuery.this.minScore.floatValue() > explanation.getValue().floatValue()) {
                    explanation = Explanation.noMatch((String)("Score value is too low, expected at least " + ScriptScoreQuery.this.minScore + " but got " + explanation.getValue()), (Explanation[])new Explanation[]{explanation});
                }
                return explanation;
            }

            private ScoreScript makeScoreScript(LeafReaderContext context) throws IOException {
                ScoreScript scoreScript = ScriptScoreQuery.this.scriptBuilder.newInstance(context);
                scoreScript._setIndexName(ScriptScoreQuery.this.indexName);
                scoreScript._setShard(ScriptScoreQuery.this.shardId);
                scoreScript._setIndexVersion(ScriptScoreQuery.this.indexVersion);
                return scoreScript;
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                return ScriptScoreQuery.this.minScore == null;
            }
        };
    }

    public void visit(QueryVisitor visitor) {
        this.subQuery.visit(visitor.getSubVisitor(BooleanClause.Occur.MUST, (Query)this));
    }

    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append("script_score (").append(this.subQuery.toString(field));
        sb.append(Functions.nameOrEmptyArg(this.queryName)).append(", script: ");
        sb.append("{" + this.script.toString() + "}");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ScriptScoreQuery that = (ScriptScoreQuery)((Object)o);
        return this.shardId == that.shardId && this.subQuery.equals((Object)that.subQuery) && this.script.equals(that.script) && Objects.equals(this.minScore, that.minScore) && this.indexName.equals(that.indexName) && this.indexVersion.equals((Object)that.indexVersion) && Objects.equals(this.queryName, that.queryName);
    }

    public int hashCode() {
        return Objects.hash(this.subQuery, this.script, this.minScore, this.indexName, this.shardId, this.indexVersion, this.queryName);
    }

    private static class ScriptScoreBulkScorer
    extends BulkScorer {
        private final BulkScorer subQueryBulkScorer;
        private final ScoreMode subQueryScoreMode;
        private final ScoreScript scoreScript;
        private final float boost;

        ScriptScoreBulkScorer(BulkScorer subQueryBulkScorer, ScoreMode subQueryScoreMode, ScoreScript scoreScript, float boost) {
            this.subQueryBulkScorer = subQueryBulkScorer;
            this.subQueryScoreMode = subQueryScoreMode;
            this.scoreScript = scoreScript;
            this.boost = boost;
        }

        public int score(LeafCollector collector, Bits acceptDocs, int min, int max) throws IOException {
            return this.subQueryBulkScorer.score(this.wrapCollector(collector), acceptDocs, min, max);
        }

        private LeafCollector wrapCollector(LeafCollector collector) {
            return new FilterLeafCollector(collector){

                public void setScorer(Scorable scorer) throws IOException {
                    this.in.setScorer((Scorable)new ScriptScorable(scoreScript, scorer, subQueryScoreMode, boost, null));
                }
            };
        }

        public long cost() {
            return this.subQueryBulkScorer.cost();
        }
    }

    private static class ScriptScorable
    extends Scorable {
        private final ScoreScript scoreScript;
        private final Scorable subQueryScorer;
        private final float boost;
        private final ScoreScript.ExplanationHolder explanation;

        ScriptScorable(ScoreScript scoreScript, Scorable subQueryScorer, ScoreMode subQueryScoreMode, float boost, ScoreScript.ExplanationHolder explanation) {
            this.scoreScript = scoreScript;
            if (subQueryScoreMode == ScoreMode.COMPLETE) {
                scoreScript.setScorer(subQueryScorer);
            }
            this.subQueryScorer = subQueryScorer;
            this.boost = boost;
            this.explanation = explanation;
        }

        public float score() throws IOException {
            int docId = this.docID();
            this.scoreScript.setDocument(docId);
            float score = (float)this.scoreScript.execute(this.explanation);
            if (score < 0.0f || Float.isNaN(score)) {
                throw new IllegalArgumentException("script_score script returned an invalid score [" + score + "] for doc [" + docId + "]. Must be a non-negative score!");
            }
            return score * this.boost;
        }

        public int docID() {
            return this.subQueryScorer.docID();
        }
    }

    private static class ScriptScorer
    extends Scorer {
        private final ScoreScript scoreScript;
        private final Scorer subQueryScorer;
        private final float boost;
        private final ScoreScript.ExplanationHolder explanation;

        ScriptScorer(Weight weight, ScoreScript scoreScript, Scorer subQueryScorer, ScoreMode subQueryScoreMode, float boost, ScoreScript.ExplanationHolder explanation) {
            super(weight);
            this.scoreScript = scoreScript;
            if (subQueryScoreMode == ScoreMode.COMPLETE) {
                scoreScript.setScorer((Scorable)subQueryScorer);
            }
            this.subQueryScorer = subQueryScorer;
            this.boost = boost;
            this.explanation = explanation;
        }

        public float score() throws IOException {
            int docId = this.docID();
            this.scoreScript.setDocument(docId);
            float score = (float)this.scoreScript.execute(this.explanation);
            if (score < 0.0f || Float.isNaN(score)) {
                throw new IllegalArgumentException("script_score script returned an invalid score [" + score + "] for doc [" + docId + "]. Must be a non-negative score!");
            }
            return score * this.boost;
        }

        public int docID() {
            return this.subQueryScorer.docID();
        }

        public DocIdSetIterator iterator() {
            return this.subQueryScorer.iterator();
        }

        public float getMaxScore(int upTo) {
            return Float.MAX_VALUE;
        }
    }
}

