/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.opensearch.core.index.shard.ShardId;

public class ShardIndexingPressureTracker {
    private final ShardId shardId;
    private final AtomicLong primaryAndCoordinatingLimits;
    private final AtomicLong replicaLimits;
    private final OperationTracker coordinatingOperationTracker = new OperationTracker();
    private final OperationTracker primaryOperationTracker = new OperationTracker();
    private final OperationTracker replicaOperationTracker = new OperationTracker();
    private final CommonOperationTracker commonOperationTracker = new CommonOperationTracker();

    public ShardIndexingPressureTracker(ShardId shardId, long initialPrimaryAndCoordinatingLimits, long initialReplicaLimits) {
        this.shardId = shardId;
        this.primaryAndCoordinatingLimits = new AtomicLong(initialPrimaryAndCoordinatingLimits);
        this.replicaLimits = new AtomicLong(initialReplicaLimits);
    }

    public ShardId getShardId() {
        return this.shardId;
    }

    public long getPrimaryAndCoordinatingLimits() {
        return this.primaryAndCoordinatingLimits.get();
    }

    public boolean compareAndSetPrimaryAndCoordinatingLimits(long expectedValue, long newValue) {
        return this.primaryAndCoordinatingLimits.compareAndSet(expectedValue, newValue);
    }

    public long getReplicaLimits() {
        return this.replicaLimits.get();
    }

    public boolean compareAndSetReplicaLimits(long expectedValue, long newValue) {
        return this.replicaLimits.compareAndSet(expectedValue, newValue);
    }

    public OperationTracker getCoordinatingOperationTracker() {
        return this.coordinatingOperationTracker;
    }

    public OperationTracker getPrimaryOperationTracker() {
        return this.primaryOperationTracker;
    }

    public OperationTracker getReplicaOperationTracker() {
        return this.replicaOperationTracker;
    }

    public CommonOperationTracker getCommonOperationTracker() {
        return this.commonOperationTracker;
    }

    public static class CommonOperationTracker {
        private final AtomicLong currentCombinedCoordinatingAndPrimaryBytes = new AtomicLong();
        private final AtomicLong totalCombinedCoordinatingAndPrimaryBytes = new AtomicLong();

        public long getCurrentCombinedCoordinatingAndPrimaryBytes() {
            return this.currentCombinedCoordinatingAndPrimaryBytes.get();
        }

        public long incrementCurrentCombinedCoordinatingAndPrimaryBytes(long bytes) {
            return this.currentCombinedCoordinatingAndPrimaryBytes.addAndGet(bytes);
        }

        public long getTotalCombinedCoordinatingAndPrimaryBytes() {
            return this.totalCombinedCoordinatingAndPrimaryBytes.get();
        }

        public long incrementTotalCombinedCoordinatingAndPrimaryBytes(long bytes) {
            return this.totalCombinedCoordinatingAndPrimaryBytes.addAndGet(bytes);
        }
    }

    public static class PerformanceTracker {
        private final AtomicLong latencyInMillis = new AtomicLong();
        private volatile long lastSuccessfulRequestTimestamp = 0L;
        private final AtomicLong totalOutstandingRequests = new AtomicLong();
        private final AtomicLong throughputMovingAverage = new AtomicLong();
        private final ConcurrentLinkedQueue<Double> throughputMovingQueue = new ConcurrentLinkedQueue();

        public long getLatencyInMillis() {
            return this.latencyInMillis.get();
        }

        public long addLatencyInMillis(long latency) {
            return this.latencyInMillis.addAndGet(latency);
        }

        public long getLastSuccessfulRequestTimestamp() {
            return this.lastSuccessfulRequestTimestamp;
        }

        public void updateLastSuccessfulRequestTimestamp(long timeStamp) {
            this.lastSuccessfulRequestTimestamp = timeStamp;
        }

        public long getTotalOutstandingRequests() {
            return this.totalOutstandingRequests.get();
        }

        public long incrementTotalOutstandingRequests() {
            return this.totalOutstandingRequests.incrementAndGet();
        }

        public void resetTotalOutstandingRequests() {
            this.totalOutstandingRequests.set(0L);
        }

        public long getThroughputMovingAverage() {
            return this.throughputMovingAverage.get();
        }

        public long updateThroughputMovingAverage(long newAvg) {
            return this.throughputMovingAverage.getAndSet(newAvg);
        }

        public boolean addNewThroughout(Double newThroughput) {
            return this.throughputMovingQueue.offer(newThroughput);
        }

        public Double getFirstThroughput() {
            return this.throughputMovingQueue.poll();
        }

        public long getThroughputMovingQueueSize() {
            return this.throughputMovingQueue.size();
        }
    }

    public static class RejectionTracker {
        private final AtomicLong totalRejections = new AtomicLong();
        private final AtomicLong nodeLimitsBreachedRejections = new AtomicLong();
        private final AtomicLong lastSuccessfulRequestLimitsBreachedRejections = new AtomicLong();
        private final AtomicLong throughputDegradationLimitsBreachedRejections = new AtomicLong();

        public long getTotalRejections() {
            return this.totalRejections.get();
        }

        public long incrementTotalRejections() {
            return this.totalRejections.incrementAndGet();
        }

        public long getNodeLimitsBreachedRejections() {
            return this.nodeLimitsBreachedRejections.get();
        }

        public long incrementNodeLimitsBreachedRejections() {
            return this.nodeLimitsBreachedRejections.incrementAndGet();
        }

        public long getLastSuccessfulRequestLimitsBreachedRejections() {
            return this.lastSuccessfulRequestLimitsBreachedRejections.get();
        }

        public long incrementLastSuccessfulRequestLimitsBreachedRejections() {
            return this.lastSuccessfulRequestLimitsBreachedRejections.incrementAndGet();
        }

        public long getThroughputDegradationLimitsBreachedRejections() {
            return this.throughputDegradationLimitsBreachedRejections.get();
        }

        public long incrementThroughputDegradationLimitsBreachedRejections() {
            return this.throughputDegradationLimitsBreachedRejections.incrementAndGet();
        }
    }

    public static class StatsTracker {
        private final AtomicLong currentBytes = new AtomicLong();
        private final AtomicLong totalBytes = new AtomicLong();
        private final AtomicLong requestCount = new AtomicLong();

        public long getCurrentBytes() {
            return this.currentBytes.get();
        }

        public long incrementCurrentBytes(long bytes) {
            return this.currentBytes.addAndGet(bytes);
        }

        public long getTotalBytes() {
            return this.totalBytes.get();
        }

        public long incrementTotalBytes(long bytes) {
            return this.totalBytes.addAndGet(bytes);
        }

        public long getRequestCount() {
            return this.requestCount.get();
        }

        public long incrementRequestCount() {
            return this.requestCount.incrementAndGet();
        }
    }

    public static class OperationTracker {
        private final StatsTracker statsTracker = new StatsTracker();
        private final RejectionTracker rejectionTracker = new RejectionTracker();
        private final PerformanceTracker performanceTracker = new PerformanceTracker();

        public StatsTracker getStatsTracker() {
            return this.statsTracker;
        }

        public RejectionTracker getRejectionTracker() {
            return this.rejectionTracker;
        }

        public PerformanceTracker getPerformanceTracker() {
            return this.performanceTracker;
        }
    }
}

