/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.search;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opensearch.OpenSearchParseException;
import org.opensearch.common.Nullable;
import org.opensearch.common.regex.Regex;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.query.QueryShardException;
import org.opensearch.search.SearchModule;

public final class QueryParserHelper {
    private QueryParserHelper() {
    }

    public static Map<String, Float> parseFieldsAndWeights(List<String> fields) {
        HashMap<String, Float> fieldsAndWeights = new HashMap<String, Float>();
        for (String field : fields) {
            String fieldName;
            int boostIndex = field.indexOf(94);
            float boost = 1.0f;
            if (boostIndex != -1) {
                fieldName = field.substring(0, boostIndex);
                boost = Float.parseFloat(field.substring(boostIndex + 1));
            } else {
                fieldName = field;
            }
            if (fieldsAndWeights.containsKey(field)) {
                boost *= ((Float)fieldsAndWeights.get(field)).floatValue();
            }
            fieldsAndWeights.put(fieldName, Float.valueOf(boost));
        }
        return fieldsAndWeights;
    }

    public static Map<String, Float> resolveMappingFields(QueryShardContext context, Map<String, Float> fieldsAndWeights) {
        return QueryParserHelper.resolveMappingFields(context, fieldsAndWeights, null);
    }

    static Map<String, Float> resolveMappingFields(QueryShardContext context, Map<String, Float> fieldsAndWeights, String fieldSuffix) {
        HashMap<String, Float> resolvedFields = new HashMap<String, Float>();
        for (Map.Entry<String, Float> fieldEntry : fieldsAndWeights.entrySet()) {
            boolean allField = Regex.isMatchAllPattern(fieldEntry.getKey());
            boolean multiField = Regex.isSimpleMatchPattern(fieldEntry.getKey());
            float weight = fieldEntry.getValue() == null ? 1.0f : fieldEntry.getValue().floatValue();
            Map<String, Float> fieldMap = QueryParserHelper.resolveMappingField(context, fieldEntry.getKey(), weight, !multiField, !allField, fieldSuffix);
            for (Map.Entry<String, Float> field : fieldMap.entrySet()) {
                float boost = field.getValue().floatValue();
                if (resolvedFields.containsKey(field.getKey())) {
                    boost *= ((Float)resolvedFields.get(field.getKey())).floatValue();
                }
                resolvedFields.put(field.getKey(), Float.valueOf(boost));
            }
        }
        QueryParserHelper.checkForTooManyFields(resolvedFields.size(), context, null);
        return resolvedFields;
    }

    /*
     * WARNING - void declaration
     */
    static Map<String, Float> resolveMappingField(QueryShardContext context, String fieldOrPattern, float weight, boolean acceptAllTypes, boolean acceptMetadataField, String fieldSuffix) {
        Set<String> allFields = context.simpleMatchToIndexNames(fieldOrPattern);
        HashMap<String, Float> fields = new HashMap<String, Float>();
        for (String string : allFields) {
            void var9_9;
            String resolvedFieldName;
            void var9_12;
            MappedFieldType fieldType;
            if (fieldSuffix != null && context.fieldMapper(string + fieldSuffix) != null) {
                String string2 = string + fieldSuffix;
            }
            if ((fieldType = context.getMapperService().fieldType((String)var9_12)) == null || !acceptMetadataField && fieldType.name().startsWith("_")) continue;
            if (!acceptAllTypes) {
                try {
                    fieldType.termQuery("", context);
                }
                catch (UnsupportedOperationException | QueryShardException e) {
                    continue;
                }
                catch (IllegalArgumentException | OpenSearchParseException e) {
                    // empty catch block
                }
            }
            if (allFields.contains(resolvedFieldName = fieldType.name())) {
                String string3 = resolvedFieldName;
            }
            float w = fields.getOrDefault(var9_9, Float.valueOf(1.0f)).floatValue();
            fields.put((String)var9_9, Float.valueOf(w * weight));
        }
        return fields;
    }

    static void checkForTooManyFields(int numberOfFields, QueryShardContext context, @Nullable String inputPattern) {
        Integer limit = SearchModule.INDICES_MAX_CLAUSE_COUNT_SETTING.get(context.getIndexSettings().getSettings());
        if (numberOfFields > limit) {
            StringBuilder errorMsg = new StringBuilder("field expansion ");
            if (inputPattern != null) {
                errorMsg.append("for [" + inputPattern + "] ");
            }
            errorMsg.append("matches too many fields, limit: " + limit + ", got: " + numberOfFields);
            throw new IllegalArgumentException(errorMsg.toString());
        }
    }

    public static boolean hasAllFieldsWildcard(Collection<String> fields) {
        return fields.stream().anyMatch(Regex::isMatchAllPattern);
    }
}

