/*
 * Decompiled with CFR 0.152.
 */
package org.passay;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.passay.PasswordData;
import org.passay.Rule;
import org.passay.RuleResult;
import org.passay.RuleResultDetail;

public class LengthComplexityRule
implements Rule {
    public static final String ERROR_CODE = "INSUFFICIENT_COMPLEXITY";
    public static final String ERROR_CODE_RULES = "INSUFFICIENT_COMPLEXITY_RULES";
    private final Map<Interval, List<Rule>> rules = new HashMap<Interval, List<Rule>>();
    private boolean reportFailure = true;
    private boolean reportRuleFailures = true;

    public void addRules(String interval, List<Rule> l) {
        if (l == null || l.isEmpty()) {
            throw new IllegalArgumentException("Rules cannot be empty or null");
        }
        Interval i = new Interval(interval);
        for (Interval existingInterval : this.rules.keySet()) {
            if (!existingInterval.intersects(i)) continue;
            throw new IllegalArgumentException("Interval " + i + " intersects existing interval " + existingInterval);
        }
        this.rules.put(i, l);
    }

    public void addRules(String interval, Rule ... r) {
        this.addRules(interval, r != null ? Arrays.asList(r) : null);
    }

    public boolean getReportFailure() {
        return this.reportFailure;
    }

    public void setReportFailure(boolean b) {
        this.reportFailure = b;
    }

    public boolean getReportRuleFailures() {
        return this.reportRuleFailures;
    }

    public void setReportRuleFailures(boolean b) {
        this.reportRuleFailures = b;
    }

    public Map<Interval, List<? extends Rule>> getRules() {
        return Collections.unmodifiableMap(this.rules);
    }

    @Override
    public RuleResult validate(PasswordData passwordData) {
        int passwordLength = passwordData.getPassword().length();
        List<Rule> rulesByLength = this.getRulesByLength(passwordLength);
        if (rulesByLength == null) {
            return new RuleResult(false, new RuleResultDetail(ERROR_CODE_RULES, this.createRuleResultDetailParameters(passwordLength, 0, 0)));
        }
        int successCount = 0;
        RuleResult result = new RuleResult();
        for (Rule rule : rulesByLength) {
            RuleResult rr = rule.validate(passwordData);
            if (!rr.isValid()) {
                if (this.reportRuleFailures) {
                    result.getDetails().addAll(rr.getDetails());
                }
            } else {
                ++successCount;
            }
            result.getMetadata().merge(rr.getMetadata());
        }
        if (successCount < rulesByLength.size()) {
            result.setValid(false);
            if (this.reportFailure) {
                result.addError(ERROR_CODE, this.createRuleResultDetailParameters(passwordLength, successCount, rulesByLength.size()));
            }
        }
        return result;
    }

    private List<Rule> getRulesByLength(int length) {
        return this.rules.entrySet().stream().filter(e -> ((Interval)e.getKey()).includes(length)).map(Map.Entry::getValue).findFirst().orElse(null);
    }

    protected Map<String, Object> createRuleResultDetailParameters(int length, int success, int ruleCount) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put("passwordLength", length);
        m.put("successCount", success);
        m.put("ruleCount", ruleCount);
        return m;
    }

    public String toString() {
        return String.format("%s@%h::rules=%s,reportRuleFailures=%s", this.getClass().getName(), this.hashCode(), this.rules, this.reportRuleFailures);
    }

    public static class Interval {
        private static final Pattern INTERVAL_PATTERN = Pattern.compile("^([(\\[])(\\d+),(\\d+|\\*)([)\\]])$");
        private final String boundsPattern;
        private final int lower;
        private final int upper;

        Interval(String pattern) {
            Matcher m = INTERVAL_PATTERN.matcher(pattern);
            if (!m.matches()) {
                throw new IllegalArgumentException("Invalid interval notation: " + pattern);
            }
            String lowerType = m.group(1);
            String lowerVal = m.group(2);
            String upperVal = m.group(3);
            String upperType = m.group(4);
            this.lower = Integer.parseInt(lowerVal) + ("(".equals(lowerType) ? 1 : 0);
            this.upper = "*".equals(upperVal) ? Integer.MAX_VALUE : Integer.parseInt(upperVal) - (")".equals(upperType) ? 1 : 0);
            this.boundsPattern = pattern;
            if (this.upper < this.lower) {
                throw new IllegalArgumentException("Invalid interval notation: " + pattern + " produced an empty set");
            }
        }

        public boolean includes(int i) {
            return this.lower <= i && i <= this.upper;
        }

        public boolean intersects(Interval i) {
            return this.includes(i.lower) || this.includes(i.upper);
        }

        public String toString() {
            return this.boundsPattern;
        }
    }
}

