/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.util.function.Function;
import javax.annotation.Nullable;
import org.gradle.cache.AsyncCacheAccess;
import org.gradle.cache.FileLock;
import org.gradle.cache.MultiProcessSafePersistentIndexedCache;
import org.gradle.cache.internal.MultiProcessSafeAsyncPersistentIndexedCache;

public class AsyncCacheAccessDecoratedCache<K, V>
implements MultiProcessSafeAsyncPersistentIndexedCache<K, V> {
    private final AsyncCacheAccess asyncCacheAccess;
    private final MultiProcessSafePersistentIndexedCache<K, V> persistentCache;

    public AsyncCacheAccessDecoratedCache(AsyncCacheAccess asyncCacheAccess, MultiProcessSafePersistentIndexedCache<K, V> persistentCache) {
        this.asyncCacheAccess = asyncCacheAccess;
        this.persistentCache = persistentCache;
    }

    public String toString() {
        return "{async-cache cache: " + this.persistentCache + "}";
    }

    @Override
    @Nullable
    public V get(K key) {
        return (V)this.asyncCacheAccess.read(() -> this.persistentCache.getIfPresent(key));
    }

    @Override
    public V get(K key, Function<? super K, ? extends V> producer, Runnable completion) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putLater(K key, V value, Runnable completion) {
        try {
            this.asyncCacheAccess.enqueue(() -> {
                try {
                    this.persistentCache.put(key, value);
                }
                finally {
                    completion.run();
                }
            });
        }
        catch (RuntimeException e) {
            completion.run();
            throw e;
        }
    }

    @Override
    public void removeLater(K key, Runnable completion) {
        try {
            this.asyncCacheAccess.enqueue(() -> {
                try {
                    this.persistentCache.remove(key);
                }
                finally {
                    completion.run();
                }
            });
        }
        catch (RuntimeException e) {
            completion.run();
            throw e;
        }
    }

    @Override
    public void afterLockAcquire(FileLock.State currentCacheState) {
        this.persistentCache.afterLockAcquire(currentCacheState);
    }

    @Override
    public void finishWork() {
        this.persistentCache.finishWork();
    }

    @Override
    public void beforeLockRelease(FileLock.State currentCacheState) {
        this.persistentCache.beforeLockRelease(currentCacheState);
    }
}

