/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.jvm.internal;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.ExtensiblePolymorphicDomainObjectContainer;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.dsl.DependencyAdder;
import org.gradle.api.artifacts.dsl.DependencyFactory;
import org.gradle.api.internal.artifacts.dsl.dependencies.DefaultDependencyAdder;
import org.gradle.api.internal.tasks.AbstractTaskDependency;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.internal.tasks.testing.filter.DefaultTestFilter;
import org.gradle.api.internal.tasks.testing.junit.JUnitTestFramework;
import org.gradle.api.internal.tasks.testing.junitplatform.JUnitPlatformTestFramework;
import org.gradle.api.internal.tasks.testing.testng.TestNGTestFramework;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.jvm.JvmComponentDependencies;
import org.gradle.api.plugins.jvm.JvmTestSuite;
import org.gradle.api.plugins.jvm.JvmTestSuiteTarget;
import org.gradle.api.plugins.jvm.internal.DefaultJvmComponentDependencies;
import org.gradle.api.plugins.jvm.internal.DefaultJvmTestSuiteTarget;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskDependency;

public abstract class DefaultJvmTestSuite
implements JvmTestSuite {
    private static final VersionedTestingFramework NO_OPINION = new VersionedTestingFramework(Frameworks.NONE, "unset");
    private final ExtensiblePolymorphicDomainObjectContainer<JvmTestSuiteTarget> targets;
    private final SourceSet sourceSet;
    private final String name;
    private final JvmComponentDependencies dependencies;
    private boolean attachedDependencies;
    private final Action<Void> attachDependencyAction;

    protected abstract Property<VersionedTestingFramework> getVersionedTestingFramework();

    @Inject
    public DefaultJvmTestSuite(String name, DependencyFactory dependencyFactory, ConfigurationContainer configurations, SourceSetContainer sourceSets) {
        this.name = name;
        this.sourceSet = (SourceSet)sourceSets.create(this.getName());
        Configuration compileOnly = configurations.getByName(this.sourceSet.getCompileOnlyConfigurationName());
        Configuration implementation = configurations.getByName(this.sourceSet.getImplementationConfigurationName());
        Configuration runtimeOnly = configurations.getByName(this.sourceSet.getRuntimeOnlyConfigurationName());
        Configuration annotationProcessor = configurations.getByName(this.sourceSet.getAnnotationProcessorConfigurationName());
        this.targets = this.getObjectFactory().polymorphicDomainObjectContainer(JvmTestSuiteTarget.class);
        this.targets.registerBinding(JvmTestSuiteTarget.class, DefaultJvmTestSuiteTarget.class);
        this.dependencies = (JvmComponentDependencies)this.getObjectFactory().newInstance(DefaultJvmComponentDependencies.class, new Object[]{this.getObjectFactory().newInstance(DefaultDependencyAdder.class, new Object[]{implementation}), this.getObjectFactory().newInstance(DefaultDependencyAdder.class, new Object[]{compileOnly}), this.getObjectFactory().newInstance(DefaultDependencyAdder.class, new Object[]{runtimeOnly}), this.getObjectFactory().newInstance(DefaultDependencyAdder.class, new Object[]{annotationProcessor})});
        this.attachedDependencies = false;
        this.attachDependencyAction = x -> this.attachDependenciesForTestFramework(dependencyFactory, this.dependencies.getImplementation());
        if (!name.equals("test")) {
            this.useJUnitJupiter();
        } else {
            this.getVersionedTestingFramework().convention((Object)NO_OPINION);
        }
        this.addDefaultTestTarget();
        HashMap frameworkLookup = new HashMap(3);
        this.targets.withType(JvmTestSuiteTarget.class).configureEach(target -> target.getTestTask().configure(task -> task.getTestFrameworkProperty().convention(this.getVersionedTestingFramework().map(vtf -> {
            switch (((VersionedTestingFramework)vtf).type) {
                case JUNIT4: 
                case NONE: {
                    return frameworkLookup.computeIfAbsent(((VersionedTestingFramework)vtf).type, f -> new JUnitTestFramework(task, (DefaultTestFilter)task.getFilter()));
                }
                case JUNIT_JUPITER: 
                case SPOCK: 
                case KOTLIN_TEST: {
                    return frameworkLookup.computeIfAbsent(((VersionedTestingFramework)vtf).type, f -> new JUnitPlatformTestFramework((DefaultTestFilter)task.getFilter()));
                }
                case TESTNG: {
                    return frameworkLookup.computeIfAbsent(((VersionedTestingFramework)vtf).type, f -> new TestNGTestFramework(task, task.getClasspath(), (DefaultTestFilter)task.getFilter(), this.getObjectFactory()));
                }
            }
            throw new IllegalStateException("do not know how to handle " + vtf);
        }))));
    }

    private void attachDependenciesForTestFramework(DependencyFactory dependencyFactory, DependencyAdder implementation) {
        if (!this.attachedDependencies) {
            implementation.add(this.getVersionedTestingFramework().map(framework -> {
                switch (((VersionedTestingFramework)framework).type) {
                    case JUNIT4: 
                    case JUNIT_JUPITER: 
                    case SPOCK: 
                    case TESTNG: 
                    case KOTLIN_TEST: {
                        return dependencyFactory.create((CharSequence)((VersionedTestingFramework)framework).type.getDependency(((VersionedTestingFramework)framework).version));
                    }
                }
                throw new IllegalStateException("do not know how to handle " + framework);
            }));
            this.attachedDependencies = true;
        }
    }

    public String getName() {
        return this.name;
    }

    @Inject
    public abstract ObjectFactory getObjectFactory();

    @Inject
    public abstract ProviderFactory getProviderFactory();

    @Override
    public SourceSet getSources() {
        return this.sourceSet;
    }

    @Override
    public void sources(Action<? super SourceSet> configuration) {
        configuration.execute((Object)this.getSources());
    }

    public ExtensiblePolymorphicDomainObjectContainer<JvmTestSuiteTarget> getTargets() {
        return this.targets;
    }

    public void addDefaultTestTarget() {
        String target = this.getName().equals("test") ? "test" : this.getName();
        this.targets.register(target);
    }

    @Override
    public void useJUnit() {
        this.useJUnit(Frameworks.JUNIT4.defaultVersion);
    }

    @Override
    public void useJUnit(String version) {
        this.useJUnit((Provider<String>)this.getProviderFactory().provider(() -> version));
    }

    @Override
    public void useJUnit(Provider<String> version) {
        this.setFrameworkTo(Frameworks.JUNIT4, version);
    }

    @Override
    public void useJUnitJupiter() {
        this.useJUnitJupiter(Frameworks.JUNIT_JUPITER.defaultVersion);
    }

    @Override
    public void useJUnitJupiter(String version) {
        this.useJUnitJupiter((Provider<String>)this.getProviderFactory().provider(() -> version));
    }

    @Override
    public void useJUnitJupiter(Provider<String> version) {
        this.setFrameworkTo(Frameworks.JUNIT_JUPITER, version);
    }

    @Override
    public void useSpock() {
        this.useSpock(Frameworks.SPOCK.defaultVersion);
    }

    @Override
    public void useSpock(String version) {
        this.useSpock((Provider<String>)this.getProviderFactory().provider(() -> version));
    }

    @Override
    public void useSpock(Provider<String> version) {
        this.setFrameworkTo(Frameworks.SPOCK, version);
    }

    @Override
    public void useKotlinTest() {
        this.useKotlinTest(Frameworks.KOTLIN_TEST.defaultVersion);
    }

    @Override
    public void useKotlinTest(String version) {
        this.useKotlinTest((Provider<String>)this.getProviderFactory().provider(() -> version));
    }

    @Override
    public void useKotlinTest(Provider<String> version) {
        this.setFrameworkTo(Frameworks.KOTLIN_TEST, version);
    }

    @Override
    public void useTestNG() {
        this.useTestNG(Frameworks.TESTNG.defaultVersion);
    }

    @Override
    public void useTestNG(String version) {
        this.useTestNG((Provider<String>)this.getProviderFactory().provider(() -> version));
    }

    @Override
    public void useTestNG(Provider<String> version) {
        this.setFrameworkTo(Frameworks.TESTNG, version);
    }

    private void setFrameworkTo(Frameworks framework, Provider<String> versionProvider) {
        this.getVersionedTestingFramework().set(versionProvider.map(v -> new VersionedTestingFramework(framework, (String)v)));
        this.attachDependencyAction.execute(null);
    }

    @Override
    public JvmComponentDependencies getDependencies() {
        return this.dependencies;
    }

    @Override
    public void dependencies(Action<? super JvmComponentDependencies> action) {
        action.execute((Object)this.dependencies);
    }

    public TaskDependency getBuildDependencies() {
        return new AbstractTaskDependency(){

            public void visitDependencies(TaskDependencyResolveContext context) {
                DefaultJvmTestSuite.this.getTargets().forEach(arg_0 -> ((TaskDependencyResolveContext)context).add(arg_0));
            }
        };
    }

    private static class VersionedTestingFramework {
        private final Frameworks type;
        private final String version;

        private VersionedTestingFramework(Frameworks type, String version) {
            Preconditions.checkNotNull((Object)version);
            this.type = type;
            this.version = version;
        }
    }

    public static enum Frameworks {
        JUNIT4("junit:junit", "4.13.2"),
        JUNIT_JUPITER("org.junit.jupiter:junit-jupiter", "5.8.2"),
        SPOCK("org.spockframework:spock-core", "2.1-groovy-3.0"),
        KOTLIN_TEST("org.jetbrains.kotlin:kotlin-test-junit5", "1.7.10"),
        TESTNG("org.testng:testng", "7.5"),
        NONE(null, null);

        @Nullable
        private final String module;
        @Nullable
        private final String defaultVersion;

        private Frameworks(String module, String defaultVersion) {
            Preconditions.checkArgument((module != null && defaultVersion != null || module == null && defaultVersion == null ? 1 : 0) != 0, (Object)"Either module and version must both be null, or neither be null.");
            this.module = module;
            this.defaultVersion = defaultVersion;
        }

        @Nullable
        public String getDefaultVersion() {
            return this.defaultVersion;
        }

        @Nullable
        public String getDependency() {
            return this.getDependency(this.getDefaultVersion());
        }

        @Nullable
        public String getDependency(String version) {
            if (null != this.module) {
                return this.module + ":" + version;
            }
            return null;
        }
    }
}

