#!/usr/bin/python

# ----------------------------------------------------------------------------
#
#  Copyright (C) 2018-2022 Fons Adriaensen <fons@linuxaudio.org>
#    
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http:#www.gnu.org/licenses/>.
#
# ----------------------------------------------------------------------------


import sys
import signal
import globdef
from PyQt5 import QtWidgets
from zita_jacktools.jackmatrix import JackMatrix
from mainwin import Mainwindow


# Define input and output port names.
#
inputs = [ '1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12' ]
outputs = [ 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H' ]
jackname = 'Matrix'


# Create the JackMatrix.
#
jmatrix = JackMatrix (len (inputs), len (outputs), 0.1, jackname)


# Connect inputs and outputs.
#
#jmat.connect_input (0, '...')
#jmat.connect_input (1, '...')
#
#jmat.connect_output (0, '...')
#jmat.connect_output (1, '...')


# Start PyQt5 app.
#
signal.signal (signal.SIGINT, signal.SIG_DFL)
app = QtWidgets.QApplication (sys.argv)
# Comment next line for default light theme.
globdef.darkpal (app)
Mainwindow (inputs, outputs, jmatrix, jackname)
sys.exit (app.exec_())


