/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api.builtin.stringvalidation;

import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.builtin.stringvalidation.StringValidator;
import org.netbeans.validation.localization.LocalizationSupport;

final class IpAddressValidator
extends StringValidator {
    IpAddressValidator() {
    }

    @Override
    public void validate(Problems problems, String compName, String s) {
        if (s.startsWith(".") || s.endsWith(".")) {
            problems.append(LocalizationSupport.getMessage(IpAddressValidator.class, "HOST_STARTS_OR_ENDS_WITH_PERIOD", s));
            return;
        }
        if (s.indexOf(32) >= 0 || s.indexOf(9) >= 0) {
            problems.append(LocalizationSupport.getMessage(IpAddressValidator.class, "IP_ADDRESS_CONTAINS_WHITESPACE", compName, s));
            return;
        }
        String[] parts = s.split("\\.");
        if (parts.length > 4) {
            problems.append(LocalizationSupport.getMessage(IpAddressValidator.class, "TOO_MANY_LABELS", s));
            return;
        }
        if (parts.length < 4) {
            problems.append(LocalizationSupport.getMessage(IpAddressValidator.class, "ADDR_PART_BAD", s));
            return;
        }
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            if (i == parts.length - 1 && part.indexOf(58) > 0) {
                if (part.endsWith(":")) {
                    problems.append(LocalizationSupport.getMessage(IpAddressValidator.class, "TOO_MANY_COLONS", compName, s));
                    return;
                }
                String[] pts = part.split(":");
                try {
                    int addr = Integer.parseInt(pts[0]);
                    if (addr < 0) {
                        problems.append(LocalizationSupport.getMessage(IpAddressValidator.class, "ADDR_PART_NEGATIVE", pts[1]));
                        return;
                    }
                    if (addr > 255) {
                        problems.append(LocalizationSupport.getMessage(IpAddressValidator.class, "ADDR_PART_HIGH", pts[1]));
                        return;
                    }
                }
                catch (NumberFormatException e) {
                    problems.append(LocalizationSupport.getMessage(IpAddressValidator.class, "ADDR_PART_BAD", pts.length >= 2 ? pts[1] : "''"));
                    return;
                }
                if (pts.length == 2 && pts[1].length() == 0) {
                    problems.append(LocalizationSupport.getMessage(IpAddressValidator.class, "INVALID_PORT", compName, ""));
                    return;
                }
                if (pts.length == 1) {
                    problems.append(LocalizationSupport.getMessage(IpAddressValidator.class, "INVALID_PORT", compName, ""));
                    return;
                }
                if (pts.length <= 1) continue;
                try {
                    int port = Integer.parseInt(pts[1]);
                    if (port < 0) {
                        problems.append(LocalizationSupport.getMessage(IpAddressValidator.class, "NEGATIVE_PORT", pts[1]));
                        return;
                    }
                    if (port < 65536) continue;
                    problems.append(LocalizationSupport.getMessage(IpAddressValidator.class, "PORT_TOO_HIGH", pts[1]));
                    return;
                }
                catch (NumberFormatException e) {
                    problems.append(LocalizationSupport.getMessage(IpAddressValidator.class, "INVALID_PORT", compName, pts[1]));
                    return;
                }
            }
            try {
                int addr = Integer.parseInt(part);
                if (addr < 0) {
                    problems.append(LocalizationSupport.getMessage(IpAddressValidator.class, "ADDR_PART_NEGATIVE", part));
                    return;
                }
                if (addr <= 255) continue;
                problems.append(LocalizationSupport.getMessage(IpAddressValidator.class, "ADDR_PART_HIGH", part));
                return;
            }
            catch (NumberFormatException e) {
                problems.append(LocalizationSupport.getMessage(IpAddressValidator.class, "ADDR_PART_BAD", part));
                return;
            }
        }
    }
}

