/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.exporter.plugin;

import javax.swing.JPanel;
import org.gephi.io.exporter.plugin.ExporterCSV;
import org.gephi.io.exporter.spi.Exporter;
import org.gephi.io.exporter.spi.ExporterUI;
import org.gephi.ui.exporter.plugin.AbstractExporterSettings;
import org.gephi.ui.exporter.plugin.UIExporterCSVPanel;
import org.openide.util.NbBundle;

public class UIExporterCSV
implements ExporterUI {
    private final ExporterCSVSettings settings = new ExporterCSVSettings();
    private UIExporterCSVPanel panel;
    private ExporterCSV exporterCSV;

    public void setup(Exporter exporter) {
        this.exporterCSV = (ExporterCSV)exporter;
        this.settings.load(this.exporterCSV);
        if (this.panel != null) {
            this.panel.setup(this.exporterCSV);
        }
    }

    public void unsetup(boolean update) {
        if (update) {
            this.panel.unsetup(this.exporterCSV);
            this.settings.save(this.exporterCSV);
        }
        this.panel = null;
        this.exporterCSV = null;
    }

    public JPanel getPanel() {
        this.panel = new UIExporterCSVPanel();
        return this.panel;
    }

    public boolean isUIForExporter(Exporter exporter) {
        return exporter instanceof ExporterCSV;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(UIExporterCSV.class, (String)"UIExporterCSV.name");
    }

    private static class ExporterCSVSettings
    extends AbstractExporterSettings {
        private static final String EDGE_WEIGHT = "CSV_edgeWeight";
        private static final String WRITE_ZERO = "CSV_writeZero";
        private static final String HEADER = "CSV_header";
        private static final String LIST = "CSV_list";
        private static final ExporterCSV DEFAULT = new ExporterCSV();

        private ExporterCSVSettings() {
        }

        private void save(ExporterCSV exporterCSV) {
            this.put(EDGE_WEIGHT, exporterCSV.isEdgeWeight());
            this.put(WRITE_ZERO, exporterCSV.isWriteZero());
            this.put(HEADER, exporterCSV.isHeader());
            this.put(LIST, exporterCSV.isList());
        }

        private void load(ExporterCSV exporterCSV) {
            exporterCSV.setEdgeWeight(this.get(EDGE_WEIGHT, DEFAULT.isEdgeWeight()));
            exporterCSV.setWriteZero(this.get(WRITE_ZERO, DEFAULT.isWriteZero()));
            exporterCSV.setHeader(this.get(HEADER, DEFAULT.isHeader()));
            exporterCSV.setList(this.get(LIST, DEFAULT.isList()));
        }
    }
}

