from ytmusicapi.parsers.browsing import *

TRENDS = {"ARROW_DROP_UP": "up", "ARROW_DROP_DOWN": "down", "ARROW_CHART_NEUTRAL": "neutral"}


def parse_chart_song(data):
    parsed = parse_song_flat(data)
    parsed.update(parse_ranking(data))
    return parsed


def parse_chart_artist(data):
    subscribers = get_flex_column_item(data, 1)
    if subscribers:
        subscribers = nav(subscribers, TEXT_RUN_TEXT).split(" ")[0]

    parsed = {
        "title": nav(get_flex_column_item(data, 0), TEXT_RUN_TEXT),
        "browseId": nav(data, NAVIGATION_BROWSE_ID),
        "subscribers": subscribers,
        "thumbnails": nav(data, THUMBNAILS),
    }
    parsed.update(parse_ranking(data))
    return parsed


def parse_ranking(data):
    return {
        "rank": nav(data, ["customIndexColumn", "musicCustomIndexColumnRenderer", *TEXT_RUN_TEXT]),
        "trend": TRENDS[nav(data, ["customIndexColumn", "musicCustomIndexColumnRenderer", *ICON_TYPE])],
    }
