/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2.datasources;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.apache.tomcat.dbcp.dbcp2.Utils;
import org.apache.tomcat.dbcp.dbcp2.datasources.PooledConnectionAndInfo;
import org.apache.tomcat.dbcp.dbcp2.datasources.PooledConnectionManager;
import org.apache.tomcat.dbcp.dbcp2.datasources.UserPassKey;
import org.apache.tomcat.dbcp.pool2.ObjectPool;
import org.apache.tomcat.dbcp.pool2.PooledObject;
import org.apache.tomcat.dbcp.pool2.PooledObjectFactory;
import org.apache.tomcat.dbcp.pool2.impl.DefaultPooledObject;

final class CPDSConnectionFactory
implements PooledObjectFactory<PooledConnectionAndInfo>,
ConnectionEventListener,
PooledConnectionManager {
    private static final String NO_KEY_MESSAGE = "close() was called on a Connection, but I have no record of the underlying PooledConnection.";
    private final ConnectionPoolDataSource cpds;
    private final String validationQuery;
    private final Duration validationQueryTimeoutDuration;
    private final boolean rollbackAfterValidation;
    private ObjectPool<PooledConnectionAndInfo> pool;
    private UserPassKey userPassKey;
    private Duration maxConnDuration = Duration.ofMillis(-1L);
    private final Set<PooledConnection> validatingSet = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<PooledConnection, PooledConnectionAndInfo> pcMap = new ConcurrentHashMap<PooledConnection, PooledConnectionAndInfo>();

    CPDSConnectionFactory(ConnectionPoolDataSource connectionPoolDataSource, String string, Duration duration, boolean bl, String string2, char[] cArray) {
        this.cpds = connectionPoolDataSource;
        this.validationQuery = string;
        this.validationQueryTimeoutDuration = duration;
        this.userPassKey = new UserPassKey(string2, cArray);
        this.rollbackAfterValidation = bl;
    }

    CPDSConnectionFactory(ConnectionPoolDataSource connectionPoolDataSource, String string, Duration duration, boolean bl, String string2, String string3) {
        this(connectionPoolDataSource, string, duration, bl, string2, Utils.toCharArray(string3));
    }

    @Deprecated
    CPDSConnectionFactory(ConnectionPoolDataSource connectionPoolDataSource, String string, int n, boolean bl, String string2, char[] cArray) {
        this.cpds = connectionPoolDataSource;
        this.validationQuery = string;
        this.validationQueryTimeoutDuration = Duration.ofSeconds(n);
        this.userPassKey = new UserPassKey(string2, cArray);
        this.rollbackAfterValidation = bl;
    }

    @Deprecated
    CPDSConnectionFactory(ConnectionPoolDataSource connectionPoolDataSource, String string, int n, boolean bl, String string2, String string3) {
        this(connectionPoolDataSource, string, n, bl, string2, Utils.toCharArray(string3));
    }

    @Override
    public void activateObject(PooledObject<PooledConnectionAndInfo> pooledObject) throws SQLException {
        this.validateLifetime(pooledObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closePool(String string) throws SQLException {
        CPDSConnectionFactory cPDSConnectionFactory = this;
        synchronized (cPDSConnectionFactory) {
            if (string == null || !string.equals(this.userPassKey.getUserName())) {
                return;
            }
        }
        try {
            this.pool.close();
        }
        catch (Exception exception) {
            throw new SQLException("Error closing connection pool", exception);
        }
    }

    @Override
    public void connectionClosed(ConnectionEvent connectionEvent) {
        PooledConnection pooledConnection = (PooledConnection)connectionEvent.getSource();
        if (!this.validatingSet.contains(pooledConnection)) {
            PooledConnectionAndInfo pooledConnectionAndInfo = this.pcMap.get(pooledConnection);
            if (pooledConnectionAndInfo == null) {
                throw new IllegalStateException(NO_KEY_MESSAGE);
            }
            try {
                this.pool.returnObject(pooledConnectionAndInfo);
            }
            catch (Exception exception) {
                System.err.println("CLOSING DOWN CONNECTION AS IT COULD NOT BE RETURNED TO THE POOL");
                pooledConnection.removeConnectionEventListener(this);
                try {
                    this.doDestroyObject(pooledConnectionAndInfo);
                }
                catch (Exception exception2) {
                    System.err.println("EXCEPTION WHILE DESTROYING OBJECT " + pooledConnectionAndInfo);
                    exception2.printStackTrace();
                }
            }
        }
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
        PooledConnection pooledConnection = (PooledConnection)connectionEvent.getSource();
        if (null != connectionEvent.getSQLException()) {
            System.err.println("CLOSING DOWN CONNECTION DUE TO INTERNAL ERROR (" + connectionEvent.getSQLException() + ")");
        }
        pooledConnection.removeConnectionEventListener(this);
        PooledConnectionAndInfo pooledConnectionAndInfo = this.pcMap.get(pooledConnection);
        if (pooledConnectionAndInfo == null) {
            throw new IllegalStateException(NO_KEY_MESSAGE);
        }
        try {
            this.pool.invalidateObject(pooledConnectionAndInfo);
        }
        catch (Exception exception) {
            System.err.println("EXCEPTION WHILE DESTROYING OBJECT " + pooledConnectionAndInfo);
            exception.printStackTrace();
        }
    }

    @Override
    public void destroyObject(PooledObject<PooledConnectionAndInfo> pooledObject) throws SQLException {
        this.doDestroyObject(pooledObject.getObject());
    }

    private void doDestroyObject(PooledConnectionAndInfo pooledConnectionAndInfo) throws SQLException {
        PooledConnection pooledConnection = pooledConnectionAndInfo.getPooledConnection();
        pooledConnection.removeConnectionEventListener(this);
        this.pcMap.remove(pooledConnection);
        pooledConnection.close();
    }

    char[] getPasswordCharArray() {
        return this.userPassKey.getPasswordCharArray();
    }

    public ObjectPool<PooledConnectionAndInfo> getPool() {
        return this.pool;
    }

    @Override
    public void invalidate(PooledConnection pooledConnection) throws SQLException {
        PooledConnectionAndInfo pooledConnectionAndInfo = this.pcMap.get(pooledConnection);
        if (pooledConnectionAndInfo == null) {
            throw new IllegalStateException(NO_KEY_MESSAGE);
        }
        try {
            this.pool.invalidateObject(pooledConnectionAndInfo);
            this.pool.close();
        }
        catch (Exception exception) {
            throw new SQLException("Error invalidating connection", exception);
        }
    }

    @Override
    public synchronized PooledObject<PooledConnectionAndInfo> makeObject() {
        try {
            PooledConnection pooledConnection = null;
            pooledConnection = this.userPassKey.getUserName() == null ? this.cpds.getPooledConnection() : this.cpds.getPooledConnection(this.userPassKey.getUserName(), this.userPassKey.getPassword());
            if (pooledConnection == null) {
                throw new IllegalStateException("Connection pool data source returned null from getPooledConnection");
            }
            pooledConnection.addConnectionEventListener(this);
            PooledConnectionAndInfo pooledConnectionAndInfo = new PooledConnectionAndInfo(pooledConnection, this.userPassKey);
            this.pcMap.put(pooledConnection, pooledConnectionAndInfo);
            return new DefaultPooledObject<PooledConnectionAndInfo>(pooledConnectionAndInfo);
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.getMessage());
        }
    }

    @Override
    public void passivateObject(PooledObject<PooledConnectionAndInfo> pooledObject) throws SQLException {
        this.validateLifetime(pooledObject);
    }

    public void setMaxConn(Duration duration) {
        this.maxConnDuration = duration;
    }

    @Deprecated
    public void setMaxConnLifetime(Duration duration) {
        this.maxConnDuration = duration;
    }

    @Deprecated
    public void setMaxConnLifetimeMillis(long l) {
        this.setMaxConnLifetime(Duration.ofMillis(l));
    }

    public synchronized void setPassword(char[] cArray) {
        this.userPassKey = new UserPassKey(this.userPassKey.getUserName(), cArray);
    }

    @Override
    public synchronized void setPassword(String string) {
        this.userPassKey = new UserPassKey(this.userPassKey.getUserName(), string);
    }

    public void setPool(ObjectPool<PooledConnectionAndInfo> objectPool) {
        this.pool = objectPool;
    }

    public synchronized String toString() {
        StringBuilder stringBuilder = new StringBuilder(super.toString());
        stringBuilder.append("[cpds=");
        stringBuilder.append(this.cpds);
        stringBuilder.append(", validationQuery=");
        stringBuilder.append(this.validationQuery);
        stringBuilder.append(", validationQueryTimeoutDuration=");
        stringBuilder.append(this.validationQueryTimeoutDuration);
        stringBuilder.append(", rollbackAfterValidation=");
        stringBuilder.append(this.rollbackAfterValidation);
        stringBuilder.append(", pool=");
        stringBuilder.append(this.pool);
        stringBuilder.append(", maxConnDuration=");
        stringBuilder.append(this.maxConnDuration);
        stringBuilder.append(", validatingSet=");
        stringBuilder.append(this.validatingSet);
        stringBuilder.append(", pcMap=");
        stringBuilder.append(this.pcMap);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private void validateLifetime(PooledObject<PooledConnectionAndInfo> pooledObject) throws SQLException {
        Utils.validateLifetime(pooledObject, this.maxConnDuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean validateObject(PooledObject<PooledConnectionAndInfo> pooledObject) {
        try {
            this.validateLifetime(pooledObject);
        }
        catch (Exception exception) {
            return false;
        }
        boolean bl = false;
        PooledConnection pooledConnection = pooledObject.getObject().getPooledConnection();
        Connection connection = null;
        this.validatingSet.add(pooledConnection);
        if (null == this.validationQuery) {
            Duration duration = this.validationQueryTimeoutDuration;
            if (duration.isNegative()) {
                duration = Duration.ZERO;
            }
            try {
                connection = pooledConnection.getConnection();
                bl = connection.isValid((int)duration.getSeconds());
                return bl;
            }
            catch (SQLException sQLException) {
                bl = false;
                return bl;
            }
            finally {
                Utils.closeQuietly((AutoCloseable)connection);
                this.validatingSet.remove(pooledConnection);
            }
        }
        Statement statement = null;
        ResultSet resultSet = null;
        this.validatingSet.add(pooledConnection);
        try {
            connection = pooledConnection.getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery(this.validationQuery);
            bl = resultSet.next();
            if (this.rollbackAfterValidation) {
                connection.rollback();
            }
            Utils.closeQuietly((AutoCloseable)resultSet);
        }
        catch (Exception exception) {
            bl = false;
            return bl;
        }
        Utils.closeQuietly((AutoCloseable)statement);
        Utils.closeQuietly((AutoCloseable)connection);
        this.validatingSet.remove(pooledConnection);
        return bl;
        finally {
            Utils.closeQuietly(resultSet);
            Utils.closeQuietly((AutoCloseable)statement);
            Utils.closeQuietly((AutoCloseable)connection);
            this.validatingSet.remove(pooledConnection);
        }
    }
}

