/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.core.properties;

import java.awt.event.ActionEvent;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.properties.PropertiesSupport;
import org.graalvm.visualvm.core.ui.actions.SingleDataSourceAction;
import org.openide.util.NbBundle;

class EditPropertiesAction
extends SingleDataSourceAction<DataSource> {
    private static EditPropertiesAction instance;

    public static synchronized EditPropertiesAction instance() {
        if (instance == null) {
            instance = new EditPropertiesAction();
        }
        return instance;
    }

    @Override
    protected void actionPerformed(DataSource dataSource, ActionEvent actionEvent) {
        PropertiesSupport.sharedInstance().openProperties(dataSource);
    }

    @Override
    protected boolean isEnabled(DataSource dataSource) {
        return PropertiesSupport.sharedInstance().hasProperties(dataSource);
    }

    private EditPropertiesAction() {
        super(DataSource.class);
        this.putValue("Name", NbBundle.getMessage(EditPropertiesAction.class, (String)"ACT_Properties"));
        this.putValue("ShortDescription", NbBundle.getMessage(EditPropertiesAction.class, (String)"DESCR_Properties"));
    }
}

