/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.graalvm.application.type;

import java.util.Properties;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.application.jvm.Jvm;
import org.graalvm.visualvm.application.type.ApplicationType;
import org.graalvm.visualvm.application.type.MainClassApplicationTypeFactory;
import org.graalvm.visualvm.graalvm.application.type.GraalVMApplicationType;
import org.openide.util.NbBundle;

public class GraalVMApplicationTypeFactory
extends MainClassApplicationTypeFactory {
    private static final String MAIN_CLASS = "com.oracle.graalvm.Main";
    private static final String LEGACY_MAIN_CLASS = "com.oracle.graalvm.launcher.LegacyLauncher";
    private static final String JAVASCRIPT_MAIN_CLASS = "com.oracle.truffle.js.shell.JSLauncher";
    private static final String R_LEGACY_MAIN_CLASS = "com.oracle.truffle.r.legacylauncher.LegacyLauncher";
    private static final String R_MAIN_CLASS = "com.oracle.truffle.r.launcher.RMain";
    private static final String RUBY_MAIN_CLASS = "org.truffleruby.launcher.RubyLauncher";
    private static final String PYTHON_MAIN_CLASS = "com.oracle.graal.python.shell.GraalPythonMain";
    private static final String PYTHON_EE_MAIN_CLASS = "com.oracle.graal.python.enterprise.shell.GraalPythonEnterpriseMain";
    private static final String LLVM_MAIN_CLASS = "com.oracle.truffle.llvm.launcher.LLVMLauncher";
    private static final String GRAAL_SYSPROP_ID = "graalvm.home";
    private static final String GRAAL_SYSPROP1_ID = "org.graalvm.home";
    private static final String LAUNCHER_SYSPROP_ID = "org.graalvm.launcher.class";
    private static final String JVM_ARG_GRAAL_ID = "-Dgraalvm.home=";
    private static final String JVM_ARG_GRAAL1_ID = "-Dgraal.CompilerConfiguration=";
    private static final String ARG_GRAAL_ID = "--";
    private static final String JVM_ARG_NODEJS_ID = "-Dtruffle.js.DirectByteBuffer=true";
    private static final String JVM_ARG_NODEJS1_ID = "-Dtruffle.js.DebugPropertyName=GraalJsDebug";
    private static final String JAVASCRIPT_ID = "com.oracle.truffle.js.shell.Shell";
    private static final String R_ID = "com.oracle.truffle.r.engine.shell.RCommand";
    private static final String LEGACY_RSCRIPT_ID = "com.oracle.truffle.r.launcher.RscriptCommand";
    private static final String LEGACY_R_ID = "com.oracle.truffle.r.launcher.RCommand";
    private static final String RUBY_ID = "org.truffleruby.Main";
    private static final String NODEJS_ID = "node.js";
    private static final String PYTHON_ID = "GraalPythonMain";
    private static final String LLVM_ID = "LLVM";

    private boolean isGraalVM(Jvm jvm, String mainClass) {
        if (MAIN_CLASS.equals(mainClass) || LEGACY_MAIN_CLASS.equals(mainClass)) {
            return true;
        }
        if (JAVASCRIPT_MAIN_CLASS.equals(mainClass)) {
            return true;
        }
        if (R_MAIN_CLASS.equals(mainClass)) {
            return true;
        }
        if (R_LEGACY_MAIN_CLASS.equals(mainClass)) {
            return true;
        }
        if (RUBY_MAIN_CLASS.equals(mainClass)) {
            return true;
        }
        if (PYTHON_MAIN_CLASS.equals(mainClass)) {
            return true;
        }
        if (PYTHON_EE_MAIN_CLASS.equals(mainClass)) {
            return true;
        }
        if (LLVM_MAIN_CLASS.equals(mainClass)) {
            return true;
        }
        if (mainClass == null || mainClass.isEmpty()) {
            Properties sysProp;
            String args = jvm.getJvmArgs();
            if (args != null && (args.contains(JVM_ARG_GRAAL_ID) || args.contains(JVM_ARG_GRAAL1_ID) || args.contains(JVM_ARG_NODEJS_ID))) {
                return true;
            }
            if (jvm.isGetSystemPropertiesSupported() && (sysProp = jvm.getSystemProperties()) != null && (sysProp.getProperty(GRAAL_SYSPROP_ID) != null || sysProp.getProperty(GRAAL_SYSPROP1_ID) != null)) {
                return true;
            }
        }
        return false;
    }

    private String getLangID(Jvm jvm) {
        String[] argArr;
        Properties sysProp;
        String args = jvm.getMainArgs();
        String mainClass = jvm.getMainClass();
        if ((mainClass == null || mainClass.isEmpty()) && jvm.isGetSystemPropertiesSupported() && (sysProp = jvm.getSystemProperties()) != null) {
            mainClass = sysProp.getProperty(LAUNCHER_SYSPROP_ID);
        }
        if (LEGACY_MAIN_CLASS.equals(mainClass) && args != null && (argArr = args.split(" +")).length > 1) {
            return argArr[1];
        }
        if (JAVASCRIPT_MAIN_CLASS.equals(mainClass)) {
            return JAVASCRIPT_ID;
        }
        if (R_MAIN_CLASS.equals(mainClass)) {
            return R_ID;
        }
        if (R_LEGACY_MAIN_CLASS.equals(mainClass)) {
            return R_ID;
        }
        if (RUBY_MAIN_CLASS.equals(mainClass)) {
            return RUBY_ID;
        }
        if (PYTHON_MAIN_CLASS.equals(mainClass)) {
            return PYTHON_ID;
        }
        if (PYTHON_EE_MAIN_CLASS.equals(mainClass)) {
            return PYTHON_ID;
        }
        if (LLVM_MAIN_CLASS.equals(mainClass)) {
            return LLVM_ID;
        }
        if (args != null && (argArr = args.split(" +")).length > 2 && ARG_GRAAL_ID.equals(argArr[1])) {
            return argArr[2];
        }
        return null;
    }

    private String getName(String lang) {
        if (lang == null) {
            return this.getMessage("LBL_GraalVM");
        }
        switch (lang) {
            case "com.oracle.truffle.js.shell.Shell": {
                return this.getMessage("LBL_Graalvm_Javascript");
            }
            case "com.oracle.truffle.r.engine.shell.RCommand": 
            case "com.oracle.truffle.r.launcher.RCommand": {
                return this.getMessage("LBL_Graalvm_R");
            }
            case "com.oracle.truffle.r.launcher.RscriptCommand": {
                return this.getMessage("LBL_Graalvm_Rscript");
            }
            case "org.truffleruby.Main": {
                return this.getMessage("LBL_Graalvm_Ruby");
            }
            case "node.js": {
                return this.getMessage("LBL_Graalvm_Nodejs");
            }
            case "GraalPythonMain": {
                return this.getMessage("LBL_Graalvm_Python");
            }
            case "LLVM": {
                return this.getMessage("LBL_Graalvm_LLVM");
            }
        }
        return lang;
    }

    String getMessage(String string) {
        return NbBundle.getMessage(GraalVMApplicationTypeFactory.class, (String)string);
    }

    public ApplicationType createApplicationTypeFor(Application app, Jvm jvm, String mainClass) {
        if (this.isGraalVM(jvm, mainClass)) {
            String jvmArgs;
            String langId = this.getLangID(jvm);
            if (langId == null && (mainClass == null || mainClass.isEmpty()) && ((jvmArgs = jvm.getJvmArgs()).contains(JVM_ARG_NODEJS_ID) || jvmArgs.contains(JVM_ARG_NODEJS1_ID))) {
                langId = NODEJS_ID;
            }
            String name = this.getName(langId);
            return new GraalVMApplicationType(app, jvm, name);
        }
        return null;
    }
}

