/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.instrumentation;

import java.io.ByteArrayOutputStream;
import org.graalvm.visualvm.lib.jfluid.classfile.DynamicClassInfo;
import org.graalvm.visualvm.lib.jfluid.global.CommonConstants;
import org.graalvm.visualvm.lib.jfluid.instrumentation.CPExtensionsRepository;
import org.graalvm.visualvm.lib.jfluid.instrumentation.Injector;

class MethodEntryExitCallsInjector
extends Injector
implements CommonConstants {
    protected static byte[] injCode1;
    protected static int injCodeLen1;
    protected static int injCodeMethodIdxPos1;
    protected static int injCodeMethodIdPos1;
    protected static byte[] injCode2;
    protected static int injCodeLen2;
    protected static int injCodeMethodIdxPos2;
    protected static int injCodeMethodIdPos2;
    protected static byte[] injCode3;
    protected static int injCodeLen3;
    protected static int injCodeMethodIdxPos3;
    protected static int injCodeMethodIdPos3;
    protected int baseRootCPoolCount;
    protected int injType;
    protected int methodId;

    MethodEntryExitCallsInjector(DynamicClassInfo clazz, int normalInstrBaseCPoolCount, int rootInstrBaseCPoolCount, int methodIdx, int injType, int methodId) {
        super(clazz, methodIdx);
        this.injType = injType;
        this.methodId = methodId;
        this.baseCPoolCount = normalInstrBaseCPoolCount;
        this.baseRootCPoolCount = rootInstrBaseCPoolCount;
    }

    @Override
    public byte[] instrumentMethod() {
        int totalReturns = 0;
        for (int bci = 0; bci < this.bytecodesLength; bci += this.opcodeLength(bci)) {
            int bc = this.bytecodes[bci] & 0xFF;
            if (bc < 172 || bc > 177) continue;
            ++totalReturns;
        }
        this.injectMethodEntry();
        this.injectMethodExits(totalReturns);
        this.injectGlobalCatch();
        ++this.maxStack;
        return this.createPackedMethodInfo();
    }

    private static void initializeInjectedCode() {
        injCodeLen1 = 8;
        injCode1 = new byte[injCodeLen1];
        MethodEntryExitCallsInjector.injCode1[0] = 17;
        injCodeMethodIdPos1 = 1;
        MethodEntryExitCallsInjector.injCode1[3] = -72;
        injCodeMethodIdxPos1 = 4;
        MethodEntryExitCallsInjector.injCode1[7] = 0;
        MethodEntryExitCallsInjector.injCode1[6] = 0;
        injCodeLen2 = 9;
        injCode2 = new byte[injCodeLen2];
        MethodEntryExitCallsInjector.injCode2[0] = 76;
        MethodEntryExitCallsInjector.injCode2[1] = 17;
        injCodeMethodIdPos2 = 2;
        MethodEntryExitCallsInjector.injCode2[4] = -72;
        injCodeMethodIdxPos2 = 5;
        MethodEntryExitCallsInjector.injCode2[7] = 43;
        MethodEntryExitCallsInjector.injCode2[8] = -65;
        injCodeLen3 = 8;
        injCode3 = new byte[injCodeLen3];
        MethodEntryExitCallsInjector.injCode3[0] = 89;
        MethodEntryExitCallsInjector.injCode3[1] = 17;
        injCodeMethodIdPos3 = 2;
        MethodEntryExitCallsInjector.injCode3[4] = -72;
        injCodeMethodIdxPos3 = 5;
        MethodEntryExitCallsInjector.injCode3[7] = 0;
    }

    private void injectGlobalCatch() {
        int targetMethodIdx = this.injType == 2 || this.injType == 5 ? CPExtensionsRepository.rootContents_MarkerExitMethodIdx + this.baseRootCPoolCount : CPExtensionsRepository.normalContents_MethodExitMethodIdx + this.baseCPoolCount;
        MethodEntryExitCallsInjector.putU2(injCode2, injCodeMethodIdPos2, this.methodId);
        MethodEntryExitCallsInjector.putU2(injCode2, injCodeMethodIdxPos2, targetMethodIdx);
        int origLen = this.bytecodesLength;
        boolean bci = false;
        int lastInstrBCI = this.bytecodesLength;
        this.appendCode(injCode2, injCodeLen2);
        this.addExceptionTableEntry(0, lastInstrBCI, origLen, 0);
        this.addGlobalCatchStackMapTableEntry(lastInstrBCI);
        if (this.maxLocals < 2) {
            this.maxLocals = 2;
        }
    }

    private void injectMethodEntry() {
        int targetMethodIdx = 0;
        targetMethodIdx = this.injType == 1 || this.injType == 4 ? CPExtensionsRepository.rootContents_RootEntryMethodIdx + this.baseRootCPoolCount : (this.injType == 2 || this.injType == 5 ? CPExtensionsRepository.rootContents_MarkerEntryMethodIdx + this.baseRootCPoolCount : CPExtensionsRepository.normalContents_MethodEntryMethodIdx + this.baseCPoolCount);
        MethodEntryExitCallsInjector.putU2(injCode1, injCodeMethodIdxPos1, targetMethodIdx);
        MethodEntryExitCallsInjector.putU2(injCode1, injCodeMethodIdPos1, this.methodId);
        this.injectCodeAndRewrite(injCode1, injCodeLen1, 0, true);
        if (this.injType == 2 || this.injType == 5) {
            int parIndex;
            ByteArrayOutputStream code = new ByteArrayOutputStream();
            String parTypes = this.getParTypes();
            if (this.clazz.isMethodStatic(this.methodIdx)) {
                parIndex = 0;
            } else {
                parIndex = 1;
                if (!"<init>".equals(this.clazz.getMethodName(this.methodIdx))) {
                    this.getParInvocationCode('L', 0, code);
                }
            }
            block3: for (char vmParType : parTypes.toCharArray()) {
                this.getParInvocationCode(vmParType, parIndex, code);
                switch (vmParType) {
                    case 'D': 
                    case 'J': {
                        parIndex += 2;
                        continue block3;
                    }
                    default: {
                        ++parIndex;
                    }
                }
            }
            int padding = (4 - code.size() % 4) % 4;
            for (int i = 0; i < padding; ++i) {
                code.write(0);
            }
            this.injectCodeAndRewrite(code.toByteArray(), code.size(), 0, true);
        }
    }

    private void injectMethodExits(int totalReturns) {
        int targetMethodIdx;
        int targetParMethodIdx = -1;
        if (this.injType == 2 || this.injType == 5) {
            targetMethodIdx = CPExtensionsRepository.rootContents_MarkerExitMethodIdx + this.baseRootCPoolCount;
            targetParMethodIdx = CPExtensionsRepository.rootContents_MarkerExitParMethodIdx + this.baseRootCPoolCount;
        } else {
            targetMethodIdx = CPExtensionsRepository.normalContents_MethodExitMethodIdx + this.baseCPoolCount;
        }
        MethodEntryExitCallsInjector.putU2(injCode1, injCodeMethodIdxPos1, targetMethodIdx);
        if (targetParMethodIdx != -1) {
            MethodEntryExitCallsInjector.putU2(injCode3, injCodeMethodIdPos3, this.methodId);
            MethodEntryExitCallsInjector.putU2(injCode3, injCodeMethodIdxPos3, targetParMethodIdx);
        }
        block0: for (int i = 0; i < totalReturns; ++i) {
            int retIdx = -1;
            for (int bci = 0; bci < this.bytecodesLength; bci += this.opcodeLength(bci)) {
                int bc = this.bytecodes[bci] & 0xFF;
                if (bc < 172 || bc > 177 || ++retIdx != i) continue;
                if (bc == 176 && targetParMethodIdx != -1) {
                    this.injectCodeAndRewrite(injCode3, injCodeLen3, bci, true);
                    continue block0;
                }
                this.injectCodeAndRewrite(injCode1, injCodeLen1, bci, true);
                continue block0;
            }
        }
    }

    private String getParTypes() {
        String sig = this.clazz.getMethodSignature(this.methodIdx);
        int idx1 = sig.indexOf(40) + 1;
        int idx2 = sig.lastIndexOf(41);
        StringBuilder paramsBuf = new StringBuilder();
        if (idx2 > 0) {
            String paramsString = sig.substring(idx1, idx2);
            boolean arrayIndicator = false;
            int curPos = 0;
            while (curPos < paramsString.length()) {
                char nextChar;
                while (paramsString.charAt(curPos) == '[') {
                    arrayIndicator = true;
                    ++curPos;
                }
                if ((nextChar = paramsString.charAt(curPos++)) == 'L') {
                    while (paramsString.charAt(curPos) != ';') {
                        ++curPos;
                    }
                    ++curPos;
                }
                if (arrayIndicator) {
                    paramsBuf.append('L');
                    continue;
                }
                paramsBuf.append(nextChar);
            }
        }
        return paramsBuf.toString();
    }

    private void getParInvocationCode(char vmParType, int i, ByteArrayOutputStream code) {
        switch (vmParType) {
            case 'Z': {
                this.getIloadCode(i, code);
                this.getInvokeStatic(CPExtensionsRepository.miContents_AddParBooleanMethodIdx + this.baseRootCPoolCount, code);
                break;
            }
            case 'C': {
                this.getIloadCode(i, code);
                this.getInvokeStatic(CPExtensionsRepository.miContents_AddParCharMethodIdx + this.baseRootCPoolCount, code);
                break;
            }
            case 'B': {
                this.getIloadCode(i, code);
                this.getInvokeStatic(CPExtensionsRepository.miContents_AddParByteMethodIdx + this.baseRootCPoolCount, code);
                break;
            }
            case 'S': {
                this.getIloadCode(i, code);
                this.getInvokeStatic(CPExtensionsRepository.miContents_AddParShortMethodIdx + this.baseRootCPoolCount, code);
                break;
            }
            case 'I': {
                this.getIloadCode(i, code);
                this.getInvokeStatic(CPExtensionsRepository.miContents_AddParIntMethodIdx + this.baseRootCPoolCount, code);
                break;
            }
            case 'J': {
                this.getLloadCode(i, code);
                this.getInvokeStatic(CPExtensionsRepository.miContents_AddParLongMethodIdx + this.baseRootCPoolCount, code);
                break;
            }
            case 'F': {
                this.getFloadCode(i, code);
                this.getInvokeStatic(CPExtensionsRepository.miContents_AddParFloatMethodIdx + this.baseRootCPoolCount, code);
                break;
            }
            case 'D': {
                this.getDloadCode(i, code);
                this.getInvokeStatic(CPExtensionsRepository.miContents_AddParDoubleMethodIdx + this.baseRootCPoolCount, code);
                break;
            }
            case 'L': {
                this.getAloadCode(i, code);
                this.getInvokeStatic(CPExtensionsRepository.miContents_AddParObjectMethodIdx + this.baseRootCPoolCount, code);
            }
        }
    }

    private void getIloadCode(int index, ByteArrayOutputStream code) {
        switch (index) {
            case 0: {
                code.write(26);
                break;
            }
            case 1: {
                code.write(27);
                break;
            }
            case 2: {
                code.write(28);
                break;
            }
            case 3: {
                code.write(29);
                break;
            }
            default: {
                code.write(21);
                code.write(index);
            }
        }
    }

    private void getLloadCode(int index, ByteArrayOutputStream code) {
        switch (index) {
            case 0: {
                code.write(30);
                break;
            }
            case 1: {
                code.write(31);
                break;
            }
            case 2: {
                code.write(32);
                break;
            }
            case 3: {
                code.write(33);
                break;
            }
            default: {
                code.write(22);
                code.write(index);
            }
        }
    }

    private void getFloadCode(int index, ByteArrayOutputStream code) {
        switch (index) {
            case 0: {
                code.write(34);
                break;
            }
            case 1: {
                code.write(35);
                break;
            }
            case 2: {
                code.write(36);
                break;
            }
            case 3: {
                code.write(37);
                break;
            }
            default: {
                code.write(23);
                code.write(index);
            }
        }
    }

    private void getDloadCode(int index, ByteArrayOutputStream code) {
        switch (index) {
            case 0: {
                code.write(38);
                break;
            }
            case 1: {
                code.write(39);
                break;
            }
            case 2: {
                code.write(40);
                break;
            }
            case 3: {
                code.write(41);
                break;
            }
            default: {
                code.write(24);
                code.write(index);
            }
        }
    }

    private void getAloadCode(int index, ByteArrayOutputStream code) {
        switch (index) {
            case 0: {
                code.write(42);
                break;
            }
            case 1: {
                code.write(43);
                break;
            }
            case 2: {
                code.write(44);
                break;
            }
            case 3: {
                code.write(45);
                break;
            }
            default: {
                code.write(25);
                code.write(index);
            }
        }
    }

    private void getInvokeStatic(int cpIndex, ByteArrayOutputStream code) {
        code.write(184);
        code.write(cpIndex >> 8 & 0xFF);
        code.write(cpIndex & 0xFF);
    }

    static {
        MethodEntryExitCallsInjector.initializeInjectedCode();
    }
}

