'''OpenGL extension NV.conservative_raster_underestimation

This module customises the behaviour of the 
OpenGL.raw.GL.NV.conservative_raster_underestimation to provide a more 
Python-friendly API

Overview (from the spec)
	
	The extension NV_conservative_raster provides a new rasterization mode 
	known as "Overestimated Conservative Rasterization", where any pixel that 
	is partially covered, even if no sample location is covered, is treated as 
	fully covered and a corresponding fragment will be shaded.  There is also 
	an "Underestimated Conservative Rasterization" variant, where only the 
	pixels that are completely covered by the primitive are rasterized. 
	
	This extension provides the underestimated conservative rasterization 
	information for each fragment in the fragment shader through a new
	built-in gl_FragFullyCoveredNV.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/NV/conservative_raster_underestimation.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.NV.conservative_raster_underestimation import *
from OpenGL.raw.GL.NV.conservative_raster_underestimation import _EXTENSION_NAME

def glInitConservativeRasterUnderestimationNV():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION