/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { DefaultIterableDifferFactory } from './differs/default_iterable_differ';
import { DefaultKeyValueDifferFactory } from './differs/default_keyvalue_differ';
import { IterableDiffers } from './differs/iterable_differs';
import { KeyValueDiffers } from './differs/keyvalue_differs';
export { WrappedValue, devModeEqual } from './change_detection_util';
export { ChangeDetectorRef } from './change_detector_ref';
export { ChangeDetectionStrategy, ChangeDetectorStatus, isDefaultChangeDetectionStrategy } from './constants';
export { DefaultIterableDifferFactory } from './differs/default_iterable_differ';
export { DefaultIterableDiffer } from './differs/default_iterable_differ';
export { DefaultKeyValueDifferFactory } from './differs/default_keyvalue_differ';
export { IterableDiffers } from './differs/iterable_differs';
export { KeyValueDiffers } from './differs/keyvalue_differs';
export { SimpleChange } from '../interface/simple_change';
/**
 * Structural diffing for `Object`s and `Map`s.
 */
var keyValDiff = [new DefaultKeyValueDifferFactory()];
/**
 * Structural diffing for `Iterable` types such as `Array`s.
 */
var iterableDiff = [new DefaultIterableDifferFactory()];
export var defaultIterableDiffers = new IterableDiffers(iterableDiff);
export var defaultKeyValueDiffers = new KeyValueDiffers(keyValDiff);
//# sourceMappingURL=data:application/json;base64,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