/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { makeDecorator } from '../util/decorators';
import { getInjectableDef, ɵɵdefineInjectable } from './interface/defs';
import { compileInjectable as render3CompileInjectable } from './jit/injectable';
import { convertInjectableProviderToFactory } from './util';
var ɵ0 = function (type, meta) { return SWITCH_COMPILE_INJECTABLE(type, meta); };
/**
 * Injectable decorator and metadata.
 *
 * @Annotation
 * @publicApi
 */
export var Injectable = makeDecorator('Injectable', undefined, undefined, undefined, ɵ0);
/**
 * Supports @Injectable() in JIT mode for Render2.
 */
function render2CompileInjectable(injectableType, options) {
    if (options && options.providedIn !== undefined && !getInjectableDef(injectableType)) {
        injectableType.ngInjectableDef = ɵɵdefineInjectable({
            token: injectableType,
            providedIn: options.providedIn,
            factory: convertInjectableProviderToFactory(injectableType, options),
        });
    }
}
export var SWITCH_COMPILE_INJECTABLE__POST_R3__ = render3CompileInjectable;
var SWITCH_COMPILE_INJECTABLE__PRE_R3__ = render2CompileInjectable;
var SWITCH_COMPILE_INJECTABLE = SWITCH_COMPILE_INJECTABLE__PRE_R3__;
export { ɵ0 };
//# sourceMappingURL=data:application/json;base64,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