/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
/*
 * This file exists to support compilation of @angular/core in Ivy mode.
 *
 * When the Angular compiler processes a compilation unit, it normally writes imports to
 * @angular/core. When compiling the core package itself this strategy isn't usable. Instead, the
 * compiler writes imports to this file.
 *
 * Only a subset of such imports are supported - core is not allowed to declare components or pipes.
 * A check in ngtsc's `R3SymbolsImportRewriter` validates this condition. The rewriter is only used
 * when compiling @angular/core and is responsible for translating an external name (prefixed with
 * ɵ) to the internal symbol name as exported below.
 *
 * The below symbols are used for @Injectable and @NgModule compilation.
 */
export { ɵɵinject } from './di/injector_compatibility';
export { ɵɵdefineInjectable, ɵɵdefineInjector } from './di/interface/defs';
export { ɵɵdefineNgModule } from './render3/definition';
export { setClassMetadata } from './render3/metadata';
export { NgModuleFactory } from './render3/ng_module_ref';
/**
 * The existence of this constant (in this particular file) informs the Angular compiler that the
 * current program is actually @angular/core, which needs to be compiled specially.
 */
export var ITS_JUST_ANGULAR = true;
//# sourceMappingURL=data:application/json;base64,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