/*
 * Decompiled with CFR 0.152.
 */
package mediathek.javafx.tool;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javafx.application.Platform;
import javafx.scene.paint.Color;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class JavaFxUtils {
    private static final Logger logger = LogManager.getLogger(JavaFxUtils.class);

    public static void invokeInFxThreadAndWait(Runnable run) {
        if (Platform.isFxApplicationThread()) {
            run.run();
            return;
        }
        try {
            FutureTask<Object> future = new FutureTask<Object>(run, null);
            Platform.runLater(future);
            future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("invokeInFxThreadAndWait() failed", (Throwable)e);
        }
    }

    public static Color toFXColor(@NotNull java.awt.Color awtColor) {
        int r = awtColor.getRed();
        int g2 = awtColor.getGreen();
        int b = awtColor.getBlue();
        int a = awtColor.getAlpha();
        double opacity = (double)a / 255.0;
        return Color.rgb(r, g2, b, opacity);
    }
}

