/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.intervals;

import java.io.IOException;
import org.apache.lucene.queries.intervals.IntervalIterator;
import org.apache.lucene.queries.intervals.IntervalMatchesIterator;
import org.apache.lucene.search.MatchesIterator;
import org.apache.lucene.search.Query;

final class IntervalMatches {
    IntervalMatches() {
    }

    static IntervalMatchesIterator asMatches(final IntervalIterator iterator2, final IntervalMatchesIterator source2, int doc) throws IOException {
        if (source2 == null) {
            return null;
        }
        if (iterator2.advance(doc) != doc) {
            return null;
        }
        if (iterator2.nextInterval() == Integer.MAX_VALUE) {
            return null;
        }
        return new IntervalMatchesIterator(){
            boolean cached = true;

            @Override
            public boolean next() throws IOException {
                if (this.cached) {
                    this.cached = false;
                    return true;
                }
                return iterator2.nextInterval() != Integer.MAX_VALUE;
            }

            @Override
            public int startPosition() {
                return iterator2.start();
            }

            @Override
            public int endPosition() {
                return iterator2.end();
            }

            @Override
            public int startOffset() throws IOException {
                return source2.startOffset();
            }

            @Override
            public int endOffset() throws IOException {
                return source2.endOffset();
            }

            @Override
            public int gaps() {
                return iterator2.gaps();
            }

            @Override
            public int width() {
                return iterator2.width();
            }

            @Override
            public MatchesIterator getSubMatches() throws IOException {
                return source2.getSubMatches();
            }

            @Override
            public Query getQuery() {
                return source2.getQuery();
            }
        };
    }

    static IntervalIterator wrapMatches(final IntervalMatchesIterator mi, final int doc) {
        return new IntervalIterator(){
            State state = State.UNPOSITIONED;

            @Override
            public int start() {
                if (this.state == State.NO_MORE_INTERVALS) {
                    return Integer.MAX_VALUE;
                }
                assert (this.state == State.ITERATING);
                return mi.startPosition();
            }

            @Override
            public int end() {
                if (this.state == State.NO_MORE_INTERVALS) {
                    return Integer.MAX_VALUE;
                }
                assert (this.state == State.ITERATING);
                return mi.endPosition();
            }

            @Override
            public int gaps() {
                assert (this.state == State.ITERATING);
                return mi.gaps();
            }

            @Override
            public int width() {
                assert (this.state == State.ITERATING);
                return mi.width();
            }

            @Override
            public int nextInterval() throws IOException {
                assert (this.state == State.ITERATING);
                if (mi.next()) {
                    return mi.startPosition();
                }
                this.state = State.NO_MORE_INTERVALS;
                return Integer.MAX_VALUE;
            }

            @Override
            public float matchCost() {
                return 1.0f;
            }

            @Override
            public int docID() {
                switch (this.state) {
                    case UNPOSITIONED: {
                        return -1;
                    }
                    case ITERATING: 
                    case NO_MORE_INTERVALS: {
                        return doc;
                    }
                }
                return Integer.MAX_VALUE;
            }

            @Override
            public int nextDoc() {
                switch (this.state) {
                    case UNPOSITIONED: {
                        this.state = State.ITERATING;
                        return doc;
                    }
                    case ITERATING: 
                    case NO_MORE_INTERVALS: {
                        this.state = State.EXHAUSTED;
                        break;
                    }
                }
                return Integer.MAX_VALUE;
            }

            @Override
            public int advance(int target) {
                if (target == doc) {
                    this.state = State.ITERATING;
                    return doc;
                }
                this.state = State.EXHAUSTED;
                return Integer.MAX_VALUE;
            }

            @Override
            public long cost() {
                return 1L;
            }
        };
    }

    static enum State {
        UNPOSITIONED,
        ITERATING,
        NO_MORE_INTERVALS,
        EXHAUSTED;

    }
}

