/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.reindex;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.client.node.NodeClient;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.core.tasks.TaskId;
import org.opensearch.index.reindex.AbstractBaseReindexRestHandler;
import org.opensearch.index.reindex.RethrottleAction;
import org.opensearch.index.reindex.RethrottleRequest;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.admin.cluster.RestListTasksAction;

public class RestRethrottleAction
extends BaseRestHandler {
    private final Supplier<DiscoveryNodes> nodesInCluster;

    public RestRethrottleAction(Supplier<DiscoveryNodes> nodesInCluster) {
        this.nodesInCluster = nodesInCluster;
    }

    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.POST, "/_update_by_query/{taskId}/_rethrottle"), new RestHandler.Route(RestRequest.Method.POST, "/_delete_by_query/{taskId}/_rethrottle"), new RestHandler.Route(RestRequest.Method.POST, "/_reindex/{taskId}/_rethrottle")));
    }

    public String getName() {
        return "rethrottle_action";
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) {
        RethrottleRequest internalRequest = new RethrottleRequest();
        internalRequest.setTaskId(new TaskId(request.param("taskId")));
        Float requestsPerSecond = AbstractBaseReindexRestHandler.parseRequestsPerSecond(request);
        if (requestsPerSecond == null) {
            throw new IllegalArgumentException("requests_per_second is a required parameter");
        }
        internalRequest.setRequestsPerSecond(requestsPerSecond.floatValue());
        String groupBy = request.param("group_by", "nodes");
        return channel -> client.execute((ActionType)RethrottleAction.INSTANCE, (ActionRequest)internalRequest, RestListTasksAction.listTasksResponseListener(this.nodesInCluster, (String)groupBy, (RestChannel)channel));
    }
}

