/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.multiplexer.video;

import com.sun.media.BasicPlugIn;
import com.sun.media.Log;
import com.sun.media.datasink.RandomAccess;
import com.sun.media.multiplexer.BasicMux;
import java.awt.Dimension;
import java.util.Hashtable;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.AudioFormat;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.FileTypeDescriptor;

public class QuicktimeMux
extends BasicMux {
    private int removeCount = 0;
    private boolean sourceConnected = false;
    private boolean sinkConnected = false;
    private boolean closed = false;
    private boolean opened = false;
    private int debugCounter = 0;
    private Hashtable streamNumberHash;
    private TrakInfo[] trakInfoArray;
    private int dataSize = 0;
    private Format[] rgbFormats;
    private Format[] yuvFormats;
    private int[] scaleOffsets;
    private boolean[] endOfMediaStatus;
    private int numberOfEoms = 0;
    private int numberOfTracks = 0;
    private int numberOfSupportedTracks = 0;
    private static final String VIDEO = "vide";
    private static final String AUDIO = "soun";
    private long mdatOffset;
    private long moovOffset;
    private int mdatLength;
    private int moovLength;
    private long mvhdDurationOffset;
    private static Hashtable audioFourccMapper = new Hashtable();
    private static Hashtable videoFourccMapper = new Hashtable();
    private final int movieTimeScale = 60000;
    private final int DEFAULT_FRAME_RATE = 15;
    private final int DEFAULT_FRAME_DURATION = 4000;
    private final int TRAK_ENABLED = 1;
    private final int TRAK_IN_MOVIE = 2;
    private static final int DATA_SELF_REFERENCE_FLAG = 1;
    private static final boolean ALWAYS_USE_ONE_ENTRY_FOR_STTS = false;
    private static final int EPSILON_DURATION = 1000000;
    private static final int MVHD_ATOM_SIZE = 100;
    private static final int TKHD_ATOM_SIZE = 84;
    private static final int MDHD_ATOM_SIZE = 24;
    private boolean requireTwoPass = true;
    Format bigEndian = new AudioFormat(null, -1.0, -1, -1, 1, -1);

    public QuicktimeMux() {
        this.supportedInputs = new Format[2];
        this.supportedInputs[0] = new AudioFormat(null);
        this.supportedInputs[1] = new VideoFormat(null);
        this.supportedOutputs = new ContentDescriptor[1];
        this.supportedOutputs[0] = new FileTypeDescriptor("video.quicktime");
        int NS = -1;
        this.rgbFormats = new Format[]{new RGBFormat(null, NS, Format.byteArray, NS, 16, 31744, 992, 31, 2, NS, 0, 0), new RGBFormat(null, NS, Format.byteArray, NS, 24, 1, 2, 3, 3, NS, 0, NS), new RGBFormat(null, NS, Format.byteArray, NS, 32, 2, 3, 4, 4, NS, 0, NS)};
        this.yuvFormats = new Format[]{new YUVFormat(null, NS, Format.byteArray, NS, 96, NS, NS, 0, 1, 3)};
    }

    public String getName() {
        return "Quicktime Multiplexer";
    }

    public Format setInputFormat(Format input, int trackID) {
        if (this.trakInfoArray == null) {
            this.trakInfoArray = new TrakInfo[this.numTracks];
            this.endOfMediaStatus = new boolean[this.numTracks];
        }
        if (!(input instanceof VideoFormat) && !(input instanceof AudioFormat)) {
            this.trakInfoArray[trackID] = new TrakInfo();
            this.trakInfoArray[trackID].format = input;
            this.trakInfoArray[trackID].supported = false;
            return input;
        }
        String encoding = input.getEncoding();
        if (input instanceof VideoFormat) {
            if (videoFourccMapper.get(encoding.toLowerCase()) == null) {
                return null;
            }
            if (encoding.equalsIgnoreCase("rgb") && BasicPlugIn.matches(input, this.rgbFormats) == null) {
                return null;
            }
            if (encoding.equalsIgnoreCase("yuv") && BasicPlugIn.matches(input, this.yuvFormats) == null) {
                return null;
            }
            VideoTrakInfo vti = new VideoTrakInfo();
            this.trakInfoArray[trackID] = vti;
            vti.supported = true;
            vti.type = VIDEO;
            vti.encoding = encoding;
            vti.format = input;
            vti.videoFormat = null;
        } else if (input instanceof AudioFormat) {
            if (encoding.equalsIgnoreCase("LINEAR")) {
                AudioFormat af = (AudioFormat)input;
                if (af.getSampleSizeInBits() > 8) {
                    if (af.getSigned() == 0) {
                        return null;
                    }
                    if (af.getEndian() == 0) {
                        return null;
                    }
                    if (af.getEndian() == -1) {
                        input = af.intersects(this.bigEndian);
                    }
                }
            } else if (audioFourccMapper.get(encoding.toLowerCase()) == null) {
                return null;
            }
            AudioTrakInfo ati = new AudioTrakInfo();
            this.trakInfoArray[trackID] = ati;
            ati.supported = true;
            ati.type = AUDIO;
            ati.encoding = encoding;
            ati.format = input;
            ati.audioFormat = (AudioFormat)input;
            ati.frameSizeInBytes = ati.audioFormat.getFrameSizeInBits() / 8;
            if (ati.frameSizeInBytes <= 0) {
                ati.frameSizeInBytes = ati.audioFormat.getSampleSizeInBits() * ati.audioFormat.getChannels() / 8;
            }
            if (encoding.equalsIgnoreCase("ima4")) {
                ati.samplesPerBlock = 64;
            } else if (encoding.equalsIgnoreCase("gsm")) {
                ati.samplesPerBlock = 160;
            } else if (encoding.equalsIgnoreCase("MAC3")) {
                ati.samplesPerBlock = 6;
            } else if (encoding.equalsIgnoreCase("MAC6")) {
                ati.samplesPerBlock = 6;
            }
        }
        if (this.trakInfoArray[trackID].supported) {
            ++this.numberOfSupportedTracks;
        }
        this.inputs[trackID] = input;
        return input;
    }

    public synchronized int doProcess(Buffer buffer, int trackID) {
        Object obj;
        if (buffer.isEOM() && !this.endOfMediaStatus[trackID]) {
            this.endOfMediaStatus[trackID] = true;
            ++this.numberOfEoms;
            if (this.numberOfEoms == this.numTracks) {
                return super.doProcess(buffer, trackID);
            }
            return 0;
        }
        if (!this.trakInfoArray[trackID].initFormat) {
            if (this.trakInfoArray[trackID] instanceof VideoTrakInfo) {
                VideoTrakInfo vti = (VideoTrakInfo)this.trakInfoArray[trackID];
                vti.videoFormat = (VideoFormat)buffer.getFormat();
                vti.frameRate = vti.videoFormat.getFrameRate();
                if (vti.frameRate > 0.0f) {
                    vti.frameDuration = (int)((double)(1.0f / vti.frameRate * 60000.0f) + 0.5);
                } else {
                    vti.frameRate = 15.0f;
                    vti.frameDuration = 4000;
                }
            }
            this.trakInfoArray[trackID].initFormat = true;
        }
        if ((obj = buffer.getData()) == null) {
            return 1;
        }
        byte[] data = (byte[])obj;
        if (data == null) {
            return 1;
        }
        int length = buffer.getLength();
        this.dataSize += length;
        TrakInfo trakInfo = this.trakInfoArray[trackID];
        this.write(data, 0, length);
        int chunkOffset = this.filePointer - length;
        int chunkOffsetsIndex = trakInfo.chunkOffsetsIndex++;
        int numChunkOffsetsArraysUsed = trakInfo.numChunkOffsetsArraysUsed++;
        trakInfo.chunkOffsetsArray[numChunkOffsetsArraysUsed - 1][chunkOffsetsIndex] = chunkOffset;
        if (++chunkOffsetsIndex >= 1000) {
            trakInfo.chunkOffsetsIndex = 0;
            trakInfo.chunkOffsetsArray[numChunkOffsetsArraysUsed] = new int[1000];
            if (++numChunkOffsetsArraysUsed >= 1000) {
                System.err.println("Cannot create quicktime file with more than " + 1000 * 1000 + " chunks ");
                return 1;
            }
        }
        String type = trakInfo.type;
        VideoTrakInfo vti = null;
        AudioTrakInfo ati = null;
        if (type.equals(VIDEO)) {
            boolean keyframe;
            vti = (VideoTrakInfo)trakInfo;
            int sampleSizeIndex = vti.sampleSizeIndex++;
            int numSampleSizeArraysUsed = vti.numSampleSizeArraysUsed;
            vti.sampleSize[numSampleSizeArraysUsed - 1][sampleSizeIndex] = length;
            if (vti.constantSampleSize && length != vti.sampleSize[0][0]) {
                vti.constantSampleSize = false;
            }
            if (vti.minDuration >= 0L) {
                long timeStamp = buffer.getTimeStamp();
                if (timeStamp <= -1L) {
                    vti.minDuration = -1L;
                } else if (vti.totalFrames > 0) {
                    long durationOfBufferData = timeStamp - vti.previousTimeStamp;
                    if (durationOfBufferData < vti.minDuration) {
                        vti.minDuration = durationOfBufferData;
                    } else if (durationOfBufferData > vti.maxDuration) {
                        vti.maxDuration = durationOfBufferData;
                    }
                    int timeStampIndex = vti.timeStampIndex++;
                    int numTimeStampArraysUsed = vti.numTimeStampArraysUsed++;
                    vti.timeStamps[numTimeStampArraysUsed - 1][timeStampIndex] = durationOfBufferData;
                    if (++timeStampIndex >= 1000) {
                        vti.timeStampIndex = 0;
                        vti.timeStamps[numTimeStampArraysUsed] = new long[1000];
                        if (++numTimeStampArraysUsed >= 1000) {
                            System.err.println("Cannot create quicktime file with more than " + 1000 * 1000 + " frames ");
                            return 1;
                        }
                    }
                }
                vti.previousTimeStamp = timeStamp;
            }
            if (++sampleSizeIndex >= 2000) {
                vti.sampleSizeIndex = 0;
                vti.sampleSize[numSampleSizeArraysUsed] = new int[2000];
                ++vti.numSampleSizeArraysUsed;
                if (++numSampleSizeArraysUsed >= 1000) {
                    System.err.println("Cannot create quicktime file with more than " + 1000 * 2000 + " samples ");
                    return 1;
                }
            }
            boolean bl = keyframe = (buffer.getFlags() & 0x10) > 0;
            if (keyframe) {
                int keyFrameIndex = vti.keyFrameIndex++;
                int numKeyFrameArraysUsed = vti.numKeyFrameArraysUsed++;
                vti.keyFrames[numKeyFrameArraysUsed - 1][keyFrameIndex] = vti.totalFrames + 1;
                if (++keyFrameIndex >= 1000) {
                    vti.keyFrameIndex = 0;
                    vti.keyFrames[numKeyFrameArraysUsed] = new int[1000];
                    if (++numKeyFrameArraysUsed >= 1000) {
                        System.err.println("Cannot create quicktime file with more than " + 1000 * 1000 + " keyframes ");
                        return 1;
                    }
                }
            }
        } else {
            ati = (AudioTrakInfo)trakInfo;
            int samplesPerChunk = length / ati.frameSizeInBytes * ati.samplesPerBlock;
            ati.numSamples += samplesPerChunk;
            if (ati.previousSamplesPerChunk != samplesPerChunk) {
                int samplesPerChunkIndex = ati.samplesPerChunkIndex;
                int numSamplesPerChunkArraysUsed = ati.numSamplesPerChunkArraysUsed++;
                ati.samplesPerChunkArray[numSamplesPerChunkArraysUsed - 1][samplesPerChunkIndex] = trakInfo.totalFrames + 1;
                ati.samplesPerChunkArray[numSamplesPerChunkArraysUsed - 1][++samplesPerChunkIndex] = samplesPerChunk;
                ++samplesPerChunkIndex;
                ati.samplesPerChunkIndex = samplesPerChunkIndex++;
                ati.previousSamplesPerChunk = samplesPerChunk;
                if (samplesPerChunkIndex >= 1000) {
                    ati.samplesPerChunkIndex = 0;
                    ati.samplesPerChunkArray[numSamplesPerChunkArraysUsed] = new int[1000];
                    if (++numSamplesPerChunkArraysUsed >= 1000) {
                        System.err.println("Cannot create quicktime file with more than " + 1000 * 1000 + " chunks ");
                        return 1;
                    }
                }
            }
        }
        ++trakInfo.totalFrames;
        return 0;
    }

    protected void writeHeader() {
        this.mdatOffset = this.filePointer;
        this.bufClear();
        this.bufWriteInt(0);
        this.bufWriteBytes("mdat");
        this.bufFlush();
        this.dataSize = 0;
    }

    public boolean requireTwoPass() {
        return this.requireTwoPass;
    }

    protected void writeFooter() {
        this.moovOffset = this.filePointer;
        this.seek((int)this.mdatOffset);
        this.bufClear();
        this.mdatLength = 8 + this.dataSize;
        this.bufWriteInt(this.mdatLength);
        this.bufFlush();
        this.seek((int)this.moovOffset);
        this.writeMOOV();
        int maxTrackDuration = -1;
        int i = 0;
        while (i < this.numTracks) {
            if (this.trakInfoArray[i].supported) {
                this.writeSize(this.trakInfoArray[i].tkhdDurationOffset, this.trakInfoArray[i].duration);
                if (this.trakInfoArray[i].type.equals(VIDEO)) {
                    this.writeSize(this.trakInfoArray[i].mdhdDurationOffset, this.trakInfoArray[i].duration);
                }
                if (this.trakInfoArray[i].duration > maxTrackDuration) {
                    maxTrackDuration = this.trakInfoArray[i].duration;
                }
            }
            ++i;
        }
        this.writeSize(this.mvhdDurationOffset, maxTrackDuration);
        if (this.requireTwoPass && this.sth != null && this.sth instanceof RandomAccess) {
            RandomAccess st = (RandomAccess)((Object)this.sth);
            if (st.write(-1L, this.moovLength + this.mdatLength)) {
                this.updateSTCO();
                this.write(null, 0, -1);
                st.write(this.moovOffset, this.moovLength);
                st.write(this.mdatOffset, this.mdatLength);
            } else {
                System.err.println("No space to write streamable file");
            }
            st.write(-1L, -1);
        }
    }

    private int writeMOOV() {
        long offset = this.filePointer;
        this.bufClear();
        this.bufWriteInt(0);
        this.bufWriteBytes("moov");
        this.bufFlush();
        int size = 8;
        size += this.writeMVHD();
        int i = 0;
        while (i < this.numTracks) {
            if (this.trakInfoArray[i].supported) {
                size += this.writeTRAK(i, this.trakInfoArray[i].type);
            }
            ++i;
        }
        this.moovLength = size;
        return this.writeSize(offset, size);
    }

    private int writeMVHD() {
        this.bufClear();
        this.bufWriteInt(108);
        this.bufWriteBytes("mvhd");
        this.bufWriteInt(0);
        this.bufWriteInt(0);
        this.bufWriteInt(0);
        this.bufWriteInt(60000);
        this.mvhdDurationOffset = this.filePointer;
        this.bufWriteInt(0);
        this.bufWriteInt(65536);
        this.bufWriteShort((short)255);
        this.bufWriteInt(0);
        this.bufWriteInt(0);
        this.bufWriteShort((short)0);
        this.bufFlush();
        this.writeMatrix();
        this.bufClear();
        this.bufWriteInt(0);
        this.bufWriteInt(0);
        this.bufWriteInt(0);
        this.bufWriteInt(0);
        this.bufWriteInt(0);
        this.bufWriteInt(0);
        this.bufWriteInt(this.numberOfSupportedTracks + 1);
        this.bufFlush();
        return 108;
    }

    private int writeSize(long offset, int size) {
        long currentOffset = this.filePointer;
        this.seek((int)offset);
        this.bufClear();
        this.bufWriteInt(size);
        this.bufFlush();
        this.seek((int)currentOffset);
        return size;
    }

    private int writeTRAK(int streamNumber, String type) {
        long offset = this.filePointer;
        this.bufClear();
        this.bufWriteInt(0);
        this.bufWriteBytes("trak");
        this.bufFlush();
        int size = 8;
        size += this.writeTKHD(streamNumber, type);
        return this.writeSize(offset, size += this.writeMDIA(streamNumber, type));
    }

    private int writeTKHD(int streamNumber, String type) {
        int width = 0;
        int height = 0;
        int duration = 0;
        int volume = 0;
        if (type.equals(VIDEO)) {
            VideoTrakInfo videoTrakInfo = (VideoTrakInfo)this.trakInfoArray[streamNumber];
            Dimension size = null;
            VideoFormat vf = videoTrakInfo.videoFormat;
            if (vf != null) {
                size = vf.getSize();
            }
            if (size != null) {
                width = size.width;
                height = size.height;
            }
            duration = videoTrakInfo.duration;
        } else {
            AudioTrakInfo audioTrakInfo = (AudioTrakInfo)this.trakInfoArray[streamNumber];
            float sampleRate = (int)audioTrakInfo.audioFormat.getSampleRate();
            float epsilon = 0.01f;
            audioTrakInfo.duration = duration = (int)((float)audioTrakInfo.numSamples / sampleRate * 60000.0f + epsilon);
            volume = 255;
        }
        this.bufClear();
        this.bufWriteInt(92);
        this.bufWriteBytes("tkhd");
        this.bufWriteInt(3);
        this.bufWriteInt(0);
        this.bufWriteInt(0);
        this.bufWriteInt(streamNumber + 1);
        this.bufWriteInt(0);
        this.trakInfoArray[streamNumber].tkhdDurationOffset = this.filePointer;
        this.bufWriteInt(duration);
        this.bufWriteInt(0);
        this.bufWriteInt(0);
        this.bufWriteShort((short)0);
        this.bufWriteShort((short)0);
        this.bufWriteShort((short)volume);
        this.bufWriteShort((short)0);
        this.bufFlush();
        this.writeMatrix();
        this.bufClear();
        this.bufWriteInt(width * 65536);
        this.bufWriteInt(height * 65536);
        this.bufFlush();
        return 92;
    }

    private int writeMDIA(int streamNumber, String type) {
        long offset = this.filePointer;
        this.bufClear();
        this.bufWriteInt(0);
        this.bufWriteBytes("mdia");
        this.bufFlush();
        int size = 8;
        size += this.writeMDHD(streamNumber, type);
        size += this.writeMhlrHdlr(streamNumber, type);
        return this.writeSize(offset, size += this.writeMINF(streamNumber, type));
    }

    private void writeMatrix() {
        this.bufClear();
        this.bufWriteInt(65536);
        this.bufWriteInt(0);
        this.bufWriteInt(0);
        this.bufWriteInt(0);
        this.bufWriteInt(65536);
        this.bufWriteInt(0);
        this.bufWriteInt(0);
        this.bufWriteInt(0);
        this.bufWriteInt(0x40000000);
        this.bufFlush();
    }

    private int writeMDHD(int streamNumber, String type) {
        int timeScale = 0;
        int duration = 0;
        if (type.equals(VIDEO)) {
            timeScale = 60000;
            VideoTrakInfo videoTrakInfo = (VideoTrakInfo)this.trakInfoArray[streamNumber];
            duration = videoTrakInfo.duration;
        } else {
            AudioTrakInfo audioTrakInfo = (AudioTrakInfo)this.trakInfoArray[streamNumber];
            timeScale = (int)audioTrakInfo.audioFormat.getSampleRate();
            duration = audioTrakInfo.numSamples;
        }
        this.bufClear();
        this.bufWriteInt(32);
        this.bufWriteBytes("mdhd");
        this.bufWriteInt(1);
        this.bufWriteInt(0);
        this.bufWriteInt(0);
        this.bufWriteInt(timeScale);
        this.trakInfoArray[streamNumber].mdhdDurationOffset = this.filePointer;
        this.bufWriteInt(duration);
        this.bufWriteShort((short)0);
        this.bufWriteShort((short)0);
        this.bufFlush();
        return 32;
    }

    private int writeMINF(int streamNumber, String type) {
        long offset = this.filePointer;
        this.bufClear();
        this.bufWriteInt(0);
        this.bufWriteBytes("minf");
        this.bufFlush();
        int size = 8;
        size = type.equals(VIDEO) ? (size += this.writeVMHD(streamNumber, type)) : (size += this.writeSMHD(streamNumber, type));
        size += this.writeDHlrHdlr(streamNumber, type);
        size += this.writeDINF(streamNumber, type);
        return this.writeSize(offset, size += this.writeSTBL(streamNumber, type));
    }

    private int writeVMHD(int streamNumber, String type) {
        this.bufClear();
        this.bufWriteInt(20);
        this.bufWriteBytes("vmhd");
        this.bufWriteInt(1);
        this.bufWriteShort((short)64);
        this.bufWriteShort((short)Short.MIN_VALUE);
        this.bufWriteShort((short)Short.MIN_VALUE);
        this.bufWriteShort((short)Short.MIN_VALUE);
        this.bufFlush();
        return 20;
    }

    private int writeSMHD(int streamNumber, String type) {
        this.bufClear();
        this.bufWriteInt(16);
        this.bufWriteBytes("smhd");
        this.bufWriteInt(0);
        this.bufWriteShort((short)0);
        this.bufWriteShort((short)0);
        this.bufFlush();
        return 16;
    }

    private int writeMhlrHdlr(int streamNumber, String type) {
        this.bufClear();
        this.bufWriteInt(36);
        this.bufWriteBytes("hdlr");
        this.bufWriteInt(0);
        this.bufWriteBytes("mhlr");
        this.bufWriteBytes(type);
        this.bufWriteBytes("    ");
        this.bufWriteInt(0);
        this.bufWriteInt(0);
        this.bufWriteBytes("    ");
        this.bufFlush();
        return 36;
    }

    private int writeDHlrHdlr(int streamNumber, String type) {
        this.bufClear();
        this.bufWriteInt(36);
        this.bufWriteBytes("hdlr");
        this.bufWriteInt(0);
        this.bufWriteBytes("dhlr");
        this.bufWriteBytes("alis");
        this.bufWriteBytes("    ");
        this.bufWriteInt(0);
        this.bufWriteInt(0);
        this.bufWriteBytes("    ");
        this.bufFlush();
        return 36;
    }

    private int writeDINF(int streamNumber, String type) {
        this.bufClear();
        this.bufWriteInt(36);
        this.bufWriteBytes("dinf");
        this.bufWriteInt(28);
        this.bufWriteBytes("dref");
        this.bufWriteInt(0);
        this.bufWriteInt(1);
        this.bufWriteInt(12);
        this.bufWriteBytes("alis");
        this.bufWriteInt(1);
        this.bufFlush();
        return 36;
    }

    private int writeSTBL(int streamNumber, String type) {
        long offset = this.filePointer;
        this.bufClear();
        this.bufWriteInt(0);
        this.bufWriteBytes("stbl");
        this.bufFlush();
        int size = 8;
        size += this.writeSTSD(streamNumber, type);
        size += this.writeSTTS(streamNumber, type);
        size += this.writeSTSS(streamNumber, type);
        size += this.writeSTSC(streamNumber, type);
        size += this.writeSTSZ(streamNumber, type);
        return this.writeSize(offset, size += this.writeSTCO(streamNumber, type));
    }

    private int writeSTSD(int streamNumber, String type) {
        long offset = this.filePointer;
        this.bufClear();
        this.bufWriteInt(0);
        this.bufWriteBytes("stsd");
        int size = 8;
        this.bufWriteInt(0);
        this.bufWriteInt(1);
        this.bufFlush();
        size += 8;
        size = type.equals(VIDEO) ? (size += this.writeVideoSampleDescription(streamNumber, type)) : (size += this.writeAudioSampleDescription(streamNumber, type));
        return this.writeSize(offset, size);
    }

    private int writeVideoSampleDescription(int streamNumber, String type) {
        int bitsPerPixel;
        VideoTrakInfo videoTrakInfo = (VideoTrakInfo)this.trakInfoArray[streamNumber];
        int width = videoTrakInfo.videoFormat.getSize().width;
        int height = videoTrakInfo.videoFormat.getSize().height;
        long offset = this.filePointer;
        this.bufClear();
        this.bufWriteInt(0);
        int size = 4;
        String encoding = videoTrakInfo.encoding;
        String fourcc = null;
        if (encoding.equalsIgnoreCase("rgb")) {
            RGBFormat rgbFormat = (RGBFormat)videoTrakInfo.format;
            bitsPerPixel = rgbFormat.getBitsPerPixel();
            fourcc = "raw ";
        } else {
            fourcc = (String)videoFourccMapper.get(encoding.toLowerCase());
            bitsPerPixel = 24;
        }
        this.bufWriteBytes(fourcc);
        size += 4;
        this.bufWriteInt(0);
        this.bufWriteShort((short)0);
        size += 6;
        this.bufWriteShort((short)1);
        size += 2;
        this.bufWriteShort((short)0);
        this.bufWriteShort((short)0);
        this.bufWriteBytes("appl");
        this.bufWriteInt(1023);
        this.bufWriteInt(1023);
        this.bufWriteShort((short)width);
        this.bufWriteShort((short)height);
        this.bufWriteInt(0x480000);
        this.bufWriteInt(0x480000);
        this.bufWriteInt(0);
        this.bufWriteShort((short)1);
        this.bufWriteBytes(fourcc);
        this.bufWriteBytes("                            ");
        this.bufWriteShort((short)bitsPerPixel);
        this.bufWriteShort((short)-1);
        this.bufFlush();
        return this.writeSize(offset, size += 70);
    }

    private int writeAudioSampleDescription(int streamNumber, String type) {
        AudioTrakInfo audioTrakInfo = (AudioTrakInfo)this.trakInfoArray[streamNumber];
        AudioFormat audioFormat = audioTrakInfo.audioFormat;
        int channels = audioFormat.getChannels();
        int sampleSizeInBits = audioFormat.getSampleSizeInBits();
        int sampleRate = (int)audioFormat.getSampleRate();
        long offset = this.filePointer;
        this.bufClear();
        this.bufWriteInt(0);
        int size = 4;
        String encoding = audioTrakInfo.encoding;
        String fourcc = encoding.equalsIgnoreCase("LINEAR") ? (sampleSizeInBits == 8 && audioFormat.getSigned() == 0 ? "raw " : "twos") : (String)audioFourccMapper.get(encoding.toLowerCase());
        this.bufWriteBytes(fourcc);
        size += 4;
        this.bufWriteInt(0);
        this.bufWriteShort((short)0);
        size += 6;
        this.bufWriteShort((short)1);
        size += 2;
        this.bufWriteShort((short)0);
        this.bufWriteShort((short)0);
        this.bufWriteInt(0);
        this.bufWriteShort((short)channels);
        this.bufWriteShort((short)sampleSizeInBits);
        this.bufWriteShort((short)0);
        this.bufWriteShort((short)0);
        this.bufWriteInt(sampleRate * 65536);
        this.bufFlush();
        return this.writeSize(offset, size += 20);
    }

    private int writeSTTS(int streamNumber, String type) {
        long offset = this.filePointer;
        this.bufClear();
        this.bufWriteInt(0);
        this.bufWriteBytes("stts");
        int size = 8;
        this.bufWriteInt(0);
        size += 4;
        if (type.equals(VIDEO)) {
            VideoTrakInfo vti = (VideoTrakInfo)this.trakInfoArray[streamNumber];
            if (vti.minDuration <= -1L || vti.maxDuration - vti.minDuration < 1000000L) {
                this.bufWriteInt(1);
                size += 4;
                this.bufWriteInt(vti.totalFrames);
                this.bufWriteInt(vti.frameDuration);
                vti.duration = vti.totalFrames * vti.frameDuration;
                size += 8;
            } else {
                int entriesPerLoop;
                int numLoops;
                this.bufWriteInt(vti.totalFrames);
                size += 4;
                vti.duration = 0;
                long[][] timeStamps = vti.timeStamps;
                int indexi = 0;
                int indexj = 0;
                long timeStamp = 0L;
                int numEntries = vti.totalFrames - 1;
                int bytesPerLoop = 8;
                int actualBufSize = (this.maxBufSize - 200) / bytesPerLoop * bytesPerLoop;
                int requiredSize = numEntries * bytesPerLoop;
                if (requiredSize <= actualBufSize) {
                    numLoops = 1;
                    entriesPerLoop = numEntries;
                } else {
                    numLoops = requiredSize / actualBufSize;
                    if ((float)requiredSize / (float)actualBufSize > (float)numLoops) {
                        ++numLoops;
                    }
                    entriesPerLoop = actualBufSize / bytesPerLoop;
                }
                int ii = 0;
                while (ii < numLoops) {
                    int jj = 0;
                    while (jj < entriesPerLoop) {
                        this.bufWriteInt(1);
                        timeStamp = timeStamps[indexi][indexj++];
                        int dur = (int)(0.5 + (double)timeStamp / 1.0E9 * 60000.0);
                        this.bufWriteInt(dur);
                        vti.duration += dur;
                        size += 8;
                        if (indexj >= 1000) {
                            ++indexi;
                            indexj = 0;
                        }
                        ++jj;
                    }
                    this.bufFlush();
                    this.bufClear();
                    if (ii == numLoops - 2) {
                        entriesPerLoop = numEntries - (numLoops - 1) * entriesPerLoop;
                    }
                    ++ii;
                }
                if (vti.totalFrames > 1) {
                    this.bufWriteInt(1);
                    int dur = (int)((double)timeStamp / 1.0E9 * 60000.0);
                    this.bufWriteInt(dur);
                    size += 8;
                    vti.duration += dur;
                }
            }
            int i = 0;
            while (i < vti.numTimeStampArraysUsed) {
                vti.timeStamps[i] = null;
                ++i;
            }
        } else {
            AudioTrakInfo ati = (AudioTrakInfo)this.trakInfoArray[streamNumber];
            this.bufWriteInt(1);
            size += 4;
            this.bufWriteInt(ati.numSamples);
            this.bufWriteInt(1);
            size += 8;
        }
        if (this.bufLength > 0) {
            this.bufFlush();
        }
        return this.writeSize(offset, size);
    }

    private int writeSTSS(int streamNumber, String type) {
        int entriesPerLoop;
        int numLoops;
        if (!type.equals(VIDEO)) {
            return 0;
        }
        VideoTrakInfo vti = (VideoTrakInfo)this.trakInfoArray[streamNumber];
        int numKeyFrameArraysUsed = vti.numKeyFrameArraysUsed;
        int numKeyFrames = (numKeyFrameArraysUsed - 1) * 1000 + vti.keyFrameIndex;
        if (numKeyFrames == 0) {
            Log.warning("Error: There should be atleast 1 keyframe in the track. All frames are now treated as keyframes");
            return 0;
        }
        if (numKeyFrames == vti.totalFrames) {
            int i = 0;
            while (i < numKeyFrameArraysUsed) {
                vti.keyFrames[i] = null;
                ++i;
            }
            return 0;
        }
        long offset = this.filePointer;
        this.bufClear();
        this.bufWriteInt(0);
        this.bufWriteBytes("stss");
        int size = 8;
        this.bufWriteInt(0);
        size += 4;
        int[][] keyFrames = vti.keyFrames;
        this.bufWriteInt(numKeyFrames);
        size += 4;
        int numEntries = numKeyFrames;
        int bytesPerLoop = 4;
        int actualBufSize = (this.maxBufSize - 200) / bytesPerLoop * bytesPerLoop;
        int requiredSize = numEntries * bytesPerLoop;
        if (requiredSize <= actualBufSize) {
            numLoops = 1;
            entriesPerLoop = numEntries;
        } else {
            numLoops = requiredSize / actualBufSize;
            if ((float)requiredSize / (float)actualBufSize > (float)numLoops) {
                ++numLoops;
            }
            entriesPerLoop = actualBufSize / bytesPerLoop;
        }
        int indexi = 0;
        int indexj = 0;
        int ii = 0;
        while (ii < numLoops) {
            int jj = 0;
            while (jj < entriesPerLoop) {
                this.bufWriteInt(keyFrames[indexi][indexj++]);
                if (indexj >= 1000) {
                    ++indexi;
                    indexj = 0;
                }
                ++jj;
            }
            this.bufFlush();
            this.bufClear();
            if (ii == numLoops - 2) {
                entriesPerLoop = numEntries - (numLoops - 1) * entriesPerLoop;
            }
            ++ii;
        }
        return this.writeSize(offset, size += numKeyFrames * 4);
    }

    private int writeSTSC(int streamNumber, String type) {
        long offset = this.filePointer;
        this.bufClear();
        this.bufWriteInt(0);
        this.bufWriteBytes("stsc");
        int size = 8;
        this.bufWriteInt(0);
        size += 4;
        if (type.equals(VIDEO)) {
            VideoTrakInfo vti = (VideoTrakInfo)this.trakInfoArray[streamNumber];
            this.bufWriteInt(1);
            size += 4;
            this.bufWriteInt(1);
            this.bufWriteInt(1);
            this.bufWriteInt(1);
            size += 12;
        } else {
            int entriesPerLoop;
            int numLoops;
            AudioTrakInfo ati = (AudioTrakInfo)this.trakInfoArray[streamNumber];
            int numberOfEntries = ((ati.numSamplesPerChunkArraysUsed - 1) * 1000 + ati.samplesPerChunkIndex) / 2;
            this.bufWriteInt(numberOfEntries);
            size += 4;
            int numEntries = numberOfEntries;
            int bytesPerLoop = 12;
            int actualBufSize = (this.maxBufSize - 200) / bytesPerLoop * bytesPerLoop;
            int requiredSize = numEntries * bytesPerLoop;
            if (requiredSize <= actualBufSize) {
                numLoops = 1;
                entriesPerLoop = numEntries;
            } else {
                numLoops = requiredSize / actualBufSize;
                if ((float)requiredSize / (float)actualBufSize > (float)numLoops) {
                    ++numLoops;
                }
                entriesPerLoop = actualBufSize / bytesPerLoop;
            }
            int indexi = 0;
            int indexj = 0;
            int[][] samplesPerChunkArray = ati.samplesPerChunkArray;
            int ii = 0;
            while (ii < numLoops) {
                int jj = 0;
                while (jj < entriesPerLoop) {
                    this.bufWriteInt(samplesPerChunkArray[indexi][indexj++]);
                    this.bufWriteInt(samplesPerChunkArray[indexi][indexj++]);
                    this.bufWriteInt(1);
                    if (indexj >= 1000) {
                        ++indexi;
                        indexj = 0;
                    }
                    ++jj;
                }
                this.bufFlush();
                this.bufClear();
                if (ii == numLoops - 2) {
                    entriesPerLoop = numEntries - (numLoops - 1) * entriesPerLoop;
                }
                ++ii;
            }
            size += numberOfEntries * 12;
        }
        if (this.bufLength > 0) {
            this.bufFlush();
        }
        return this.writeSize(offset, size);
    }

    private int writeSTSZ(int streamNumber, String type) {
        long offset = this.filePointer;
        this.bufClear();
        this.bufWriteInt(0);
        this.bufWriteBytes("stsz");
        int size = 8;
        this.bufWriteInt(0);
        size += 4;
        TrakInfo trakInfo = this.trakInfoArray[streamNumber];
        if (type.equals(AUDIO)) {
            this.bufWriteInt(1);
            this.bufWriteInt(((AudioTrakInfo)trakInfo).numSamples);
            size += 8;
        } else if (type.equals(VIDEO)) {
            VideoTrakInfo vti = (VideoTrakInfo)trakInfo;
            int numSampleSizeArraysUsed = vti.numSampleSizeArraysUsed;
            int numberOfEntries = trakInfo.totalFrames;
            if (trakInfo.constantSampleSize) {
                int sampleSize = vti.sampleSize[0][0];
                this.bufWriteInt(sampleSize);
                this.bufWriteInt(numberOfEntries);
                size += 8;
            } else {
                int entriesPerLoop;
                int numLoops;
                int[][] sampleSize = vti.sampleSize;
                this.bufWriteInt(0);
                this.bufWriteInt(numberOfEntries);
                size += 8;
                int numEntries = numberOfEntries;
                int bytesPerLoop = 4;
                int actualBufSize = (this.maxBufSize - 200) / bytesPerLoop * bytesPerLoop;
                int requiredSize = numEntries * bytesPerLoop;
                if (requiredSize <= actualBufSize) {
                    numLoops = 1;
                    entriesPerLoop = numEntries;
                } else {
                    numLoops = requiredSize / actualBufSize;
                    if ((float)requiredSize / (float)actualBufSize > (float)numLoops) {
                        ++numLoops;
                    }
                    entriesPerLoop = actualBufSize / bytesPerLoop;
                }
                int indexi = 0;
                int indexj = 0;
                int ii = 0;
                while (ii < numLoops) {
                    int jj = 0;
                    while (jj < entriesPerLoop) {
                        this.bufWriteInt(sampleSize[indexi][indexj++]);
                        if (indexj >= 2000) {
                            ++indexi;
                            indexj = 0;
                        }
                        ++jj;
                    }
                    this.bufFlush();
                    this.bufClear();
                    if (ii == numLoops - 2) {
                        entriesPerLoop = numEntries - (numLoops - 1) * entriesPerLoop;
                    }
                    ++ii;
                }
                size += numberOfEntries * 4;
            }
            int i = 0;
            while (i < numSampleSizeArraysUsed) {
                vti.sampleSize[i] = null;
                ++i;
            }
        }
        if (this.bufLength > 0) {
            this.bufFlush();
        }
        return this.writeSize(offset, size);
    }

    private int writeSTCO(int streamNumber, String type) {
        int entriesPerLoop;
        int numLoops;
        long offset = this.filePointer;
        this.bufClear();
        this.bufWriteInt(0);
        this.bufWriteBytes("stco");
        int size = 8;
        this.bufWriteInt(0);
        size += 4;
        TrakInfo trakInfo = this.trakInfoArray[streamNumber];
        int numChunkOffsetsArraysUsed = trakInfo.numChunkOffsetsArraysUsed;
        int[][] chunkOffsetsArray = trakInfo.chunkOffsetsArray;
        this.bufWriteInt(trakInfo.totalFrames);
        size += 4;
        int numEntries = trakInfo.totalFrames;
        int bytesPerLoop = 4;
        int actualBufSize = (this.maxBufSize - 200) / bytesPerLoop * bytesPerLoop;
        int requiredSize = numEntries * bytesPerLoop;
        if (requiredSize <= actualBufSize) {
            numLoops = 1;
            entriesPerLoop = numEntries;
        } else {
            numLoops = requiredSize / actualBufSize;
            if ((float)requiredSize / (float)actualBufSize > (float)numLoops) {
                ++numLoops;
            }
            entriesPerLoop = actualBufSize / bytesPerLoop;
        }
        int indexi = 0;
        int indexj = 0;
        trakInfo.chunkOffsetOffset = this.filePointer;
        int ii = 0;
        while (ii < numLoops) {
            int jj = 0;
            while (jj < entriesPerLoop) {
                int off = (int)((long)chunkOffsetsArray[indexi][indexj++] - this.mdatOffset);
                this.bufWriteInt(off);
                if (indexj >= 1000) {
                    ++indexi;
                    indexj = 0;
                }
                ++jj;
            }
            this.bufFlush();
            this.bufClear();
            if (ii == numLoops - 2) {
                entriesPerLoop = numEntries - (numLoops - 1) * entriesPerLoop;
            }
            ++ii;
        }
        return this.writeSize(offset, size += trakInfo.totalFrames * 4);
    }

    private void updateSTCO() {
        int streamNumber = 0;
        while (streamNumber < this.trakInfoArray.length) {
            int entriesPerLoop;
            int numLoops;
            TrakInfo trakInfo = this.trakInfoArray[streamNumber];
            int numChunkOffsetsArraysUsed = trakInfo.numChunkOffsetsArraysUsed;
            int[][] chunkOffsetsArray = trakInfo.chunkOffsetsArray;
            int chunkOffsetOffset = trakInfo.chunkOffsetOffset;
            this.seek(chunkOffsetOffset);
            this.bufClear();
            int numEntries = trakInfo.totalFrames;
            int bytesPerLoop = 4;
            int actualBufSize = (this.maxBufSize - 200) / bytesPerLoop * bytesPerLoop;
            int requiredSize = numEntries * bytesPerLoop;
            if (requiredSize <= actualBufSize) {
                numLoops = 1;
                entriesPerLoop = numEntries;
            } else {
                numLoops = requiredSize / actualBufSize;
                if ((float)requiredSize / (float)actualBufSize > (float)numLoops) {
                    ++numLoops;
                }
                entriesPerLoop = actualBufSize / bytesPerLoop;
            }
            int indexi = 0;
            int indexj = 0;
            int ii = 0;
            while (ii < numLoops) {
                int jj = 0;
                while (jj < entriesPerLoop) {
                    int off = chunkOffsetsArray[indexi][indexj++] + this.moovLength;
                    this.bufWriteInt(off);
                    if (indexj >= 1000) {
                        ++indexi;
                        indexj = 0;
                    }
                    ++jj;
                }
                this.bufFlush();
                this.bufClear();
                if (ii == numLoops - 2) {
                    entriesPerLoop = numEntries - (numLoops - 1) * entriesPerLoop;
                }
                ++ii;
            }
            ++streamNumber;
        }
    }

    static {
        audioFourccMapper.put("alaw", "alaw");
        audioFourccMapper.put("ulaw", "ulaw");
        audioFourccMapper.put("ima4", "ima4");
        audioFourccMapper.put("gsm", "agsm");
        audioFourccMapper.put("MAC3", "MAC3");
        audioFourccMapper.put("MAC6", "MAC6");
        videoFourccMapper.put("rgb", "rgb");
        videoFourccMapper.put("cvid", "cvid");
        videoFourccMapper.put("jpeg", "jpeg");
        videoFourccMapper.put("h261", "h261");
        videoFourccMapper.put("h263", "h263");
        videoFourccMapper.put("iv32", "iv32");
        videoFourccMapper.put("iv41", "iv41");
        videoFourccMapper.put("iv50", "iv50");
        videoFourccMapper.put("mjpg", "mjpg");
        videoFourccMapper.put("mjpa", "mjpa");
        videoFourccMapper.put("mjpb", "mjpb");
        videoFourccMapper.put("mpeg", "mpeg");
        videoFourccMapper.put("rpza", "rpza");
        videoFourccMapper.put("yuv", "yuv2");
    }

    private class AudioTrakInfo
    extends TrakInfo {
        AudioFormat audioFormat;
        final int IMA4_SAMPLES_PER_BLOCK = 64;
        final int GSM_SAMPLES_PER_BLOCK = 160;
        final int MAC3_SAMPLES_PER_BLOCK = 6;
        final int MAC6_SAMPLES_PER_BLOCK = 6;
        int samplesPerBlock = 1;
        int numSamples = 0;
        int frameSizeInBytes;
        final int MAX_SAMPLESPERCHUNK_NUMARRAYS = 1000;
        final int MAX_SAMPLESPERCHUNK_ARRAYSIZE = 1000;
        int numSamplesPerChunkArraysUsed = 1;
        int samplesPerChunkIndex = 0;
        int[][] samplesPerChunkArray = new int[1000][];
        int previousSamplesPerChunk = -1;

        public AudioTrakInfo() {
            this.samplesPerChunkArray[0] = new int[1000];
            this.samplesPerChunkArray[0][0] = 1;
            this.samplesPerChunkArray[0][1] = -1;
        }
    }

    private class VideoTrakInfo
    extends TrakInfo {
        VideoFormat videoFormat;
        float frameRate;
        int frameDuration;
        final int MAX_SAMPLE_SIZE_NUMARRAYS = 1000;
        final int MAX_SAMPLE_SIZE_ARRAYSIZE = 2000;
        int numSampleSizeArraysUsed = 1;
        int sampleSizeIndex = 0;
        int[][] sampleSize;
        final int MAX_KEYFRAME_NUMARRAYS = 1000;
        final int MAX_KEYFRAME_ARRAYSIZE = 1000;
        int numKeyFrameArraysUsed = 1;
        int keyFrameIndex = 0;
        int[][] keyFrames;
        final int MAX_TIMESTAMP_NUMARRAYS = 1000;
        final int MAX_TIMESTAMP_ARRAYSIZE = 1000;
        int numTimeStampArraysUsed = 1;
        int timeStampIndex = 0;
        long[][] timeStamps;
        long minDuration = Long.MAX_VALUE;
        long maxDuration = -1L;
        long previousTimeStamp;

        public VideoTrakInfo() {
            this.sampleSize = new int[1000][];
            this.sampleSize[0] = new int[2000];
            this.keyFrames = new int[1000][];
            this.keyFrames[0] = new int[1000];
            this.timeStamps = new long[1000][];
            this.timeStamps[0] = new long[1000];
        }

        public String toString() {
            return super.toString() + " \n frameRate " + this.frameRate + " : frameDuration " + this.frameDuration;
        }
    }

    private class TrakInfo {
        boolean initFormat = false;
        boolean supported = false;
        String type;
        String encoding;
        Format format;
        long tkhdDurationOffset = -1L;
        long mdhdDurationOffset = -1L;
        int totalFrames = 0;
        int duration;
        boolean constantSampleSize = true;
        final int MAX_CHUNKOFFSETS_NUMARRAYS = 1000;
        final int MAX_CHUNKOFFSETS_ARRAYSIZE = 1000;
        int numChunkOffsetsArraysUsed = 1;
        int chunkOffsetsIndex = 0;
        int[][] chunkOffsetsArray = new int[1000][];
        int chunkOffsetOffset;

        public TrakInfo() {
            this.chunkOffsetsArray[0] = new int[1000];
        }

        public String toString() {
            if (!this.supported) {
                System.out.println("No support for format " + this.format);
            }
            return this.type + ": " + this.encoding + " : totalFrames " + this.totalFrames;
        }
    }
}

