/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.sampling;

import com.yahoo.sketches.BoundsOnBinomialProportions;
import java.util.Random;

final class SamplingUtil {
    private static final double DEFAULT_KAPPA = 2.0;
    public static final Random rand = new Random();

    private SamplingUtil() {
    }

    static int getAdjustedSize(int maxSize, int resizeTarget) {
        if ((long)(maxSize - (resizeTarget << 1)) < 0L) {
            return maxSize;
        }
        return resizeTarget;
    }

    static double nextDoubleExcludeZero() {
        double r = rand.nextDouble();
        while (r == 0.0) {
            r = rand.nextDouble();
        }
        return r;
    }

    static int startingSubMultiple(int lgTarget, int lgRf, int lgMin) {
        return lgTarget <= lgMin ? lgMin : (lgRf == 0 ? lgTarget : (lgTarget - lgMin) % lgRf + lgMin);
    }

    static double pseudoHypergeometricUBonP(long n, int k, double samplingRate) {
        double adjustedKappa = 2.0 * Math.sqrt(1.0 - samplingRate);
        return BoundsOnBinomialProportions.approximateUpperBoundOnP(n, k, adjustedKappa);
    }

    static double pseudoHypergeometricLBonP(long n, int k, double samplingRate) {
        double adjustedKappa = 2.0 * Math.sqrt(1.0 - samplingRate);
        return BoundsOnBinomialProportions.approximateLowerBoundOnP(n, k, adjustedKappa);
    }
}

