/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.util;

import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import io.swagger.util.ObjectMapperFactory;

public class Json {
    private static ObjectMapper mapper;
    private static ObjectMapper pathMapper;
    private static ObjectMapper responseMapper;

    public static ObjectMapper mapper() {
        if (mapper == null) {
            mapper = ObjectMapperFactory.createJson();
        }
        return mapper;
    }

    public static ObjectWriter pretty() {
        return Json.mapper().writer(new DefaultPrettyPrinter());
    }

    public static String pretty(Object o) {
        try {
            return Json.pretty().writeValueAsString(o);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void prettyPrint(Object o) {
        try {
            System.out.println(Json.pretty().writeValueAsString(o).replace("\r", ""));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static ObjectMapper pathMapper() {
        if (pathMapper == null) {
            pathMapper = ObjectMapperFactory.createJson(false, true);
        }
        return pathMapper;
    }

    protected static ObjectMapper responseMapper() {
        if (responseMapper == null) {
            responseMapper = ObjectMapperFactory.createJson(false, false);
        }
        return responseMapper;
    }
}

