/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.date;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.GJChronology;
import org.joda.time.chrono.GregorianChronology;
import org.joda.time.chrono.JulianChronology;
import org.joni.Regex;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyKernel;
import org.jruby.RubyMarshal;
import org.jruby.RubyMatchData;
import org.jruby.RubyNoMethodError;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyRational;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.RubyTime;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.date.DateUtils;
import org.jruby.ext.date.RubyDateTime;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.ConvertBytes;
import org.jruby.util.Numeric;
import org.jruby.util.RegexpOptions;
import org.jruby.util.RubyDateParser;
import org.jruby.util.TimeZoneConverter;
import org.jruby.util.TypeConverter;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

@JRubyClass(name={"Date"})
public class RubyDate
extends RubyObject {
    static final Logger LOG = LoggerFactory.getLogger(RubyDate.class);
    static final GJChronology CHRONO_ITALY_UTC = GJChronology.getInstance(DateTimeZone.UTC);
    static final int ITALY = 2299161;
    static final int ENGLAND = 2361222;
    private static final double JULIAN_INFINITY = Double.POSITIVE_INFINITY;
    static final long JULIAN = Long.MAX_VALUE;
    private static final double GREGORIAN_INFINITY = Double.NEGATIVE_INFINITY;
    static final long GREGORIAN = Long.MIN_VALUE;
    static final int REFORM_BEGIN_YEAR = 1582;
    static final int REFORM_END_YEAR = 1930;
    DateTime dt;
    int off;
    long start = 2299161L;
    long subMillisNum = 0L;
    long subMillisDen = 1L;
    static final DateTime defaultDateTime = new DateTime(-4713, 1, 1, 0, 0, CHRONO_ITALY_UTC);
    static final int DAY_IN_SECONDS = 86400;
    static final int DAY_MS = 86400000;
    private RubyFixnum DAY_MS_CACHE;
    private static final ByteList UTC_ZONE = new ByteList(new byte[]{43, 48, 48, 58, 48, 48}, false);
    private static final int HOUR_IN_SECONDS = 3600;
    private static final int MINUTE_IN_SECONDS = 60;
    private static final int MJD_EPOCH_IN_CJD = 2400001;
    private static final int LD_EPOCH_IN_CJD = 2299160;
    static final int SUB_MS_PRECISION = 1000000000;
    private static final int REFORM_BEGIN_JD = 2298874;
    private static final int REFORM_END_JD = 2426355;
    private static final ByteList TO_S_FORMAT = new ByteList(ByteList.plain("%.4d-%02d-%02d"), false);
    private static final String DEFAULT_FORMAT = "%F";
    private static final ByteList DEFAULT_FORMAT_BYTES;
    private static final ByteList[] ABBR_DAYS;
    private static final ByteList _parse_time;
    private static final ByteList _parse_time2;
    private static final ByteList[] ABBR_MONTHS;
    private static final ByteList _parse_day;
    private static final ByteList _parse_mon;
    private static final ByteList _parse_year;
    private static final ByteList _parse_mday;
    private static final ByteList _parse_eu;
    private static final ByteList _parse_us;
    private static final ByteList _parse_iso;
    private static final ByteList _parse_sla;
    private static final ByteList _parse_dot;
    private static final ByteList _parse_bc;
    private static final ByteList _parse_frag;
    private static final ByteList SPACE;
    private static final ByteList _parse_impl;
    private static final int HAVE_ALPHA = 1;
    private static final int HAVE_DIGIT = 2;
    private static final int HAVE_DASH = 4;
    private static final int HAVE_DOT = 8;
    private static final int HAVE_SLASH = 16;
    private static final int HAVE_COLON = 64;
    private static final int HAVE_M_m = 128;
    private static final int HAVE_H_h = 256;
    private static final int HAVE_S_s = 512;
    private static final int HAVE_B_b = 1024;

    static RubyClass createDateClass(Ruby runtime2) {
        RubyClass Date2 = runtime2.defineClass("Date", runtime2.getObject(), RubyDate::new);
        Date2.setReifiedClass(RubyDate.class);
        Date2.includeModule(runtime2.getComparable());
        Date2.defineAnnotatedMethods(RubyDate.class);
        Date2.setConstant("ITALY", runtime2.newFixnum(2299161));
        Date2.setConstant("ENGLAND", runtime2.newFixnum(2361222));
        Date2.setConstant("VERSION", runtime2.newString("3.2.2"));
        RubyClass dateError = runtime2.defineClassUnder("Error", runtime2.getArgumentError(), runtime2.getArgumentError().getAllocator(), Date2);
        runtime2.setDateError(dateError);
        return Date2;
    }

    static RubyClass getDate(Ruby runtime2) {
        return (RubyClass)runtime2.getObject().getConstantAt("Date");
    }

    static RubyClass getDateTime(Ruby runtime2) {
        return (RubyClass)runtime2.getObject().getConstantAt("DateTime");
    }

    protected RubyDate(Ruby runtime2, RubyClass klass) {
        this(runtime2, klass, defaultDateTime);
    }

    public RubyDate(Ruby runtime2, RubyClass klass, DateTime dt) {
        super(runtime2, klass);
        this.dt = dt;
    }

    public RubyDate(Ruby runtime2, DateTime dt) {
        this(runtime2, RubyDate.getDate(runtime2), dt);
    }

    RubyDate(Ruby runtime2, RubyClass klass, DateTime dt, int off, long start2) {
        super(runtime2, klass);
        this.dt = dt;
        this.off = off;
        this.start = start2;
    }

    RubyDate(Ruby runtime2, RubyClass klass, DateTime dt, int off, long start2, long subMillisNum, long subMillisDen) {
        super(runtime2, klass);
        this.dt = dt;
        this.off = off;
        this.start = start2;
        this.subMillisNum = subMillisNum;
        this.subMillisDen = subMillisDen;
    }

    public RubyDate(Ruby runtime2, long millis, Chronology chronology) {
        super(runtime2, RubyDate.getDate(runtime2));
        this.dt = new DateTime(millis, chronology);
    }

    RubyDate(ThreadContext context, RubyClass klass, IRubyObject ajd2, Chronology chronology, int off) {
        this(context, klass, ajd2, chronology, off, 2299161L);
    }

    RubyDate(ThreadContext context, RubyClass klass, IRubyObject ajd2, int off, long start2) {
        this(context, klass, ajd2, RubyDate.getChronology(context, start2, off), off, start2);
    }

    RubyDate(ThreadContext context, RubyClass klass, IRubyObject ajd2, long[] rest, int off, long start2) {
        this(context, klass, ajd2, RubyDate.getChronology(context, start2, off), off, start2);
        if (rest[0] != 0L) {
            this.adjustWithDayFraction(context, this.dt, rest);
        }
    }

    private RubyDate(ThreadContext context, RubyClass klass, IRubyObject ajd2, Chronology chronology, int off, long start2) {
        super(context.runtime, klass);
        this.dt = new DateTime(this.initMillis(context, ajd2), chronology);
        this.off = off;
        this.start = start2;
    }

    final RubyDate newInstance(ThreadContext context, DateTime dt, int off, long start2) {
        return this.newInstance(context, dt, off, start2, this.subMillisNum, this.subMillisDen);
    }

    RubyDate newInstance(ThreadContext context, DateTime dt, int off, long start2, long subNum, long subDen) {
        return new RubyDate(context.runtime, this.getMetaClass(), dt, off, start2, subNum, subDen);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public RubyDate initialize(ThreadContext context, IRubyObject dt) {
        this.dt = (DateTime)JavaUtil.unwrapJavaValue(dt);
        return this;
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public RubyDate initialize(ThreadContext context, IRubyObject ajd2, IRubyObject of) {
        this.initialize(context, ajd2, of, 2299161L);
        return this;
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public RubyDate initialize(ThreadContext context, IRubyObject ajd2, IRubyObject of, IRubyObject sg) {
        this.initialize(context, ajd2, of, RubyDate.val2sg(context, sg));
        return this;
    }

    private void initialize(ThreadContext context, IRubyObject arg2, IRubyObject of, long start2) {
        int off;
        this.off = off = RubyDate.val2off(context, of);
        this.start = start2;
        if (arg2 instanceof JavaProxy) {
            this.dt = (DateTime)JavaUtil.unwrapJavaValue(arg2);
            return;
        }
        this.dt = new DateTime(this.initMillis(context, arg2), RubyDate.getChronology(context, start2, off));
    }

    private long initMillis(ThreadContext context, IRubyObject ajd2) {
        IRubyObject val;
        Ruby runtime2 = context.runtime;
        if (ajd2 instanceof RubyFixnum) {
            val = ((RubyFixnum)ajd2).op_minus(context, 2440587L);
            val = ((RubyFixnum)val).op_mul(context, 86400000L);
            val = ((RubyInteger)val).op_plus(context, RubyFixnum.newFixnum(runtime2, 43200000L));
        } else {
            RubyRational _UNIX_EPOCH_IN_AJD = RubyRational.newRational(runtime2, -4881175L, 2L);
            val = _UNIX_EPOCH_IN_AJD.op_plus(context, ajd2);
            val = this.DAY_MS(context).op_mul(context, val);
        }
        if (val instanceof RubyFixnum) {
            return ((RubyFixnum)val).getLongValue();
        }
        Object millis = ((RubyArray)(val = ((RubyNumeric)val).divmod(context, RubyFixnum.one(context.runtime)))).eltInternal(0);
        if (!(millis instanceof RubyFixnum)) {
            throw runtime2.newArgumentError("Date out of range: millis=" + millis + " (" + millis.getMetaClass() + ")");
        }
        Object subMillis = ((RubyArray)val).eltInternal(1);
        this.subMillisNum = ((RubyNumeric)subMillis).numerator(context).convertToInteger().getLongValue();
        this.subMillisDen = ((RubyNumeric)subMillis).denominator(context).convertToInteger().getLongValue();
        return ((RubyFixnum)millis).getLongValue();
    }

    private RubyFixnum DAY_MS(ThreadContext context) {
        RubyFixnum v = this.DAY_MS_CACHE;
        if (v == null) {
            v = this.DAY_MS_CACHE = context.runtime.newFixnum(86400000);
        }
        return v;
    }

    @Override
    public IRubyObject initialize_copy(IRubyObject original) {
        RubyDate from = (RubyDate)original;
        this.dt = from.dt;
        this.off = from.off;
        this.start = from.start;
        this.subMillisNum = from.subMillisNum;
        this.subMillisDen = from.subMillisDen;
        return this;
    }

    @JRubyMethod(name={"new!"}, meta=true, visibility=Visibility.PRIVATE)
    public static RubyDate new_(ThreadContext context, IRubyObject self2) {
        if (self2 == RubyDate.getDateTime(context.runtime)) {
            return new RubyDateTime(context.runtime, 0L, CHRONO_ITALY_UTC);
        }
        return new RubyDate(context.runtime, 0L, CHRONO_ITALY_UTC);
    }

    @JRubyMethod(name={"new!"}, meta=true, visibility=Visibility.PRIVATE)
    public static RubyDate new_(ThreadContext context, IRubyObject self2, IRubyObject ajd2) {
        if (ajd2 instanceof JavaProxy) {
            if (self2 == RubyDate.getDateTime(context.runtime)) {
                return new RubyDateTime(context.runtime, (RubyClass)self2, (DateTime)JavaUtil.unwrapJavaValue(ajd2));
            }
            return new RubyDate(context.runtime, (RubyClass)self2, (DateTime)JavaUtil.unwrapJavaValue(ajd2));
        }
        if (self2 == RubyDate.getDateTime(context.runtime)) {
            return new RubyDateTime(context, (RubyClass)self2, ajd2, CHRONO_ITALY_UTC, 0);
        }
        return new RubyDate(context, (RubyClass)self2, ajd2, CHRONO_ITALY_UTC, 0);
    }

    @JRubyMethod(name={"new!"}, meta=true, visibility=Visibility.PRIVATE)
    public static RubyDate new_(ThreadContext context, IRubyObject self2, IRubyObject ajd2, IRubyObject of) {
        if (self2 == RubyDate.getDateTime(context.runtime)) {
            return new RubyDateTime(context.runtime, (RubyClass)self2).initialize(context, ajd2, of);
        }
        return new RubyDate(context.runtime, (RubyClass)self2).initialize(context, ajd2, of);
    }

    @JRubyMethod(name={"new!"}, meta=true, visibility=Visibility.PRIVATE)
    public static RubyDate new_(ThreadContext context, IRubyObject self2, IRubyObject ajd2, IRubyObject of, IRubyObject sg) {
        if (self2 == RubyDate.getDateTime(context.runtime)) {
            return new RubyDateTime(context.runtime, (RubyClass)self2).initialize(context, ajd2, of, sg);
        }
        return new RubyDate(context.runtime, (RubyClass)self2).initialize(context, ajd2, of, sg);
    }

    @JRubyMethod(name={"civil"}, alias={"new"}, meta=true)
    public static RubyDate civil(ThreadContext context, IRubyObject self2) {
        return new RubyDate(context.runtime, (RubyClass)self2, defaultDateTime);
    }

    @JRubyMethod(name={"civil"}, alias={"new"}, meta=true)
    public static RubyDate civil(ThreadContext context, IRubyObject self2, IRubyObject year2) {
        return new RubyDate(context.runtime, (RubyClass)self2, RubyDate.civilImpl(context, year2));
    }

    static RaiseException newDateError(ThreadContext context, String message2) {
        throw context.runtime.newRaiseException(context.runtime.getDateError(), message2);
    }

    static DateTime civilImpl(ThreadContext context, IRubyObject year2) {
        DateTime dt;
        int y = RubyDate.getYear(year2);
        try {
            dt = defaultDateTime.withYear(y);
        }
        catch (IllegalArgumentException ex) {
            throw RubyDate.newDateError(context, "invalid date");
        }
        return dt;
    }

    @JRubyMethod(name={"civil"}, alias={"new"}, meta=true)
    public static RubyDate civil(ThreadContext context, IRubyObject self2, IRubyObject year2, IRubyObject month2) {
        return new RubyDate(context.runtime, (RubyClass)self2, RubyDate.civilImpl(context, year2, month2));
    }

    static DateTime civilImpl(ThreadContext context, IRubyObject year2, IRubyObject month2) {
        DateTime dt;
        int y = RubyDate.getYear(year2);
        int m = RubyDate.getMonth(month2);
        Chronology chronology = defaultDateTime.getChronology();
        long millis = defaultDateTime.getMillis();
        try {
            millis = chronology.year().set(millis, y);
            millis = chronology.monthOfYear().set(millis, m);
            dt = defaultDateTime.withMillis(millis);
        }
        catch (IllegalArgumentException ex) {
            throw RubyDate.newDateError(context, "invalid date");
        }
        return dt;
    }

    @JRubyMethod(name={"civil"}, alias={"new"}, meta=true)
    public static RubyDate civil(ThreadContext context, IRubyObject self2, IRubyObject year2, IRubyObject month2, IRubyObject mday2) {
        return RubyDate.civilImpl(context, (RubyClass)self2, year2, month2, mday2, 2299161L);
    }

    private static RubyDate civilImpl(ThreadContext context, RubyClass klass, IRubyObject year2, IRubyObject month2, IRubyObject mday2, long sg) {
        int y = sg > 0L ? RubyDate.getYear(year2) : year2.convertToInteger().getIntValue();
        int m = RubyDate.getMonth(month2);
        long[] rest = new long[]{0L, 1L};
        int d = (int)RubyDateTime.getDay(context, mday2, rest);
        DateTime dt = RubyDate.civilDate(context, y, m, d, RubyDate.getChronology(context, sg, 0));
        RubyDate date2 = new RubyDate(context.runtime, klass, dt, 0, sg);
        if (rest[0] != 0L) {
            date2.adjustWithDayFraction(context, dt, rest);
        }
        return date2;
    }

    @JRubyMethod(name={"civil"}, alias={"new"}, meta=true, optional=4, checkArity=false)
    public static RubyDate civil(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        int argc = Arity.checkArgumentCount(context, args2, 0, 4);
        switch (argc) {
            case 0: {
                return RubyDate.civil(context, self2);
            }
            case 1: {
                return RubyDate.civil(context, self2, args2[0]);
            }
            case 2: {
                return RubyDate.civil(context, self2, args2[0], args2[1]);
            }
            case 3: {
                return RubyDate.civil(context, self2, args2[0], args2[1], args2[2]);
            }
        }
        long sg = RubyDate.val2sg(context, args2[3]);
        return RubyDate.civilImpl(context, (RubyClass)self2, args2[0], args2[1], args2[2], sg);
    }

    public static DateTime civilDate(ThreadContext context, int y, int m, int d, Chronology chronology) {
        DateTime dt;
        try {
            if (d >= 0) {
                dt = new DateTime(y, m, d, 0, 0, chronology);
            } else {
                dt = new DateTime(y, m, 1, 0, 0, chronology);
                long ms = dt.getMillis();
                int last2 = chronology.dayOfMonth().getMaximumValue(ms);
                ms = chronology.dayOfMonth().set(ms, last2 + d + 1);
                dt = dt.withMillis(ms);
            }
        }
        catch (IllegalArgumentException ex) {
            RubyDate.debug(context, "invalid date", ex);
            throw RubyDate.newDateError(context, "invalid date");
        }
        return dt;
    }

    static int getYear(IRubyObject year2) {
        int y = year2.convertToInteger().getIntValue();
        return y <= 0 ? --y : y;
    }

    static int getMonth(IRubyObject month2) {
        int m = month2.convertToInteger().getIntValue();
        return m < 0 ? m + 13 : m;
    }

    @JRubyMethod(name={"valid_civil?"}, alias={"valid_date?"}, meta=true, required=3, optional=1, checkArity=false)
    public static IRubyObject valid_civil_p(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        int argc = Arity.checkArgumentCount(context, args2, 3, 4);
        long sg = argc > 3 ? RubyDate.val2sg(context, args2[3]) : 2299161L;
        Long jd2 = RubyDate.validCivilImpl(args2[0], args2[1], args2[2], sg);
        return jd2 == null ? context.fals : context.tru;
    }

    static Long validCivilImpl(IRubyObject year2, IRubyObject month2, IRubyObject day, long sg) {
        int y = year2.convertToInteger().getIntValue();
        int m = RubyDate.getMonth(month2);
        int d = day.convertToInteger().getIntValue();
        return DateUtils._valid_civil_p(y, m, d, sg);
    }

    @JRubyMethod(name={"_valid_time?"}, meta=true, visibility=Visibility.PRIVATE)
    public static IRubyObject _valid_time_p(ThreadContext context, IRubyObject self2, IRubyObject h, IRubyObject m, IRubyObject s2) {
        long sec2;
        long min2;
        long hour2 = RubyDate.normIntValue(h, 24);
        if (DateUtils.valid_time_p(hour2, min2 = RubyDate.normIntValue(m, 60), sec2 = RubyDate.normIntValue(s2, 60))) {
            return RubyDate.timeToDayFraction(context, (int)hour2, (int)min2, (int)sec2);
        }
        return context.nil;
    }

    private static long normIntValue(IRubyObject val, int negOffset) {
        long v = val instanceof RubyFixnum ? ((RubyFixnum)val).getLongValue() : val.convertToInteger().getLongValue();
        return v < 0L ? v + (long)negOffset : v;
    }

    static RubyNumeric timeToDayFraction(ThreadContext context, int hour2, int min2, int sec2) {
        return (RubyNumeric)RubyRational.newRationalCanonicalize(context, hour2 * 3600 + min2 * 60 + sec2, 86400L);
    }

    @JRubyMethod(name={"jd"}, meta=true)
    public static RubyDate jd(ThreadContext context, IRubyObject self2) {
        return new RubyDate(context.runtime, (RubyClass)self2, defaultDateTime);
    }

    @JRubyMethod(name={"jd"}, meta=true)
    public static RubyDate jd(ThreadContext context, IRubyObject self2, IRubyObject jd2) {
        return RubyDate.jdImpl(context, self2, jd2, 2299161L);
    }

    @JRubyMethod(name={"jd"}, meta=true)
    public static RubyDate jd(ThreadContext context, IRubyObject self2, IRubyObject jd2, IRubyObject sg) {
        return RubyDate.jdImpl(context, self2, jd2, RubyDate.val2sg(context, sg));
    }

    private static RubyDate jdImpl(ThreadContext context, IRubyObject self2, IRubyObject jd2, long sg) {
        long[] rest = new long[]{0L, 1L};
        long jdi = RubyDateTime.getDay(context, jd2, rest);
        RubyNumeric ajd2 = RubyDate.jd_to_ajd(context, jdi);
        return new RubyDate(context, (RubyClass)self2, (IRubyObject)ajd2, rest, 0, sg);
    }

    private void adjustWithDayFraction(ThreadContext context, DateTime dt, long[] rest) {
        RubyFixnum zero = RubyFixnum.zero(context.runtime);
        int ival = RubyDateTime.getHour(context, zero, rest);
        dt = dt.plusHours(ival);
        if (rest[0] != 0L) {
            ival = RubyDateTime.getMinute(context, zero, rest);
            dt = dt.plusMinutes(ival);
            if (rest[0] != 0L) {
                ival = RubyDateTime.getSecond(context, zero, rest);
                dt = dt.plusSeconds(ival);
                long r0 = rest[0];
                long r1 = rest[1];
                if (r0 != 0L) {
                    long millis = 1000L * r0 / r1;
                    dt = dt.plusMillis((int)millis);
                    this.subMillisNum = 1000L * r0 - millis * r1;
                    this.subMillisDen = r1;
                    this.normalizeSubMillis();
                }
            }
        }
        this.dt = dt;
    }

    final RubyDate normalizeSubMillis() {
        long subNum = this.subMillisNum;
        long subDen = this.subMillisDen;
        if (subNum == 0L) {
            this.subMillisDen = 1L;
        } else {
            long gcd2 = Numeric.i_gcd(subNum, subDen);
            this.subMillisNum = subNum / gcd2;
            this.subMillisDen = subDen / gcd2;
        }
        return this;
    }

    @JRubyMethod(name={"valid_jd?"}, meta=true)
    public static IRubyObject valid_jd_p(ThreadContext context, IRubyObject self2, IRubyObject jd2) {
        return RubyDate.validJDArg(context, jd2) ? context.tru : context.fals;
    }

    @JRubyMethod(name={"valid_jd?"}, meta=true)
    public static IRubyObject valid_jd_p(ThreadContext context, IRubyObject self2, IRubyObject jd2, IRubyObject sg) {
        return RubyDate.validJDArg(context, jd2) ? context.tru : context.fals;
    }

    private static boolean validJDArg(ThreadContext context, IRubyObject jd2) {
        return jd2 != context.nil && jd2 != context.fals && !(jd2 instanceof RubySymbol);
    }

    @JRubyMethod(name={"_valid_jd?"}, meta=true, visibility=Visibility.PRIVATE)
    public static IRubyObject _valid_jd_p(IRubyObject self2, IRubyObject jd2) {
        return jd2;
    }

    @JRubyMethod(name={"_valid_jd?"}, meta=true, visibility=Visibility.PRIVATE)
    public static IRubyObject _valid_jd_p(IRubyObject self2, IRubyObject jd2, IRubyObject sg) {
        return jd2;
    }

    @JRubyMethod(name={"ordinal"}, meta=true, optional=3, checkArity=false)
    public static RubyDate ordinal(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        long[] rest;
        IRubyObject day;
        int d;
        int argc = Arity.checkArgumentCount(context, args2, 0, 3);
        long sg = argc > 2 ? RubyDate.val2sg(context, args2[2]) : 2299161L;
        IRubyObject year2 = argc > 0 ? args2[0] : RubyFixnum.newFixnum(context.runtime, -4712L);
        Long jd2 = RubyDate.validOrdinalImpl(year2, d = (int)RubyDateTime.getDay(context, day = argc > 1 ? args2[1] : RubyFixnum.newFixnum(context.runtime, 1L), rest = new long[]{0L, 1L}), sg);
        if (jd2 == null) {
            throw RubyDate.newDateError(context, "invalid date");
        }
        return new RubyDate(context, (RubyClass)self2, (IRubyObject)RubyDate.jd_to_ajd(context, jd2), rest, 0, sg);
    }

    @JRubyMethod(name={"valid_ordinal?"}, meta=true, required=2, optional=1, checkArity=false)
    public static IRubyObject valid_ordinal_p(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        int argc = Arity.checkArgumentCount(context, args2, 2, 3);
        long sg = argc > 2 ? RubyDate.val2sg(context, args2[2]) : 2299161L;
        Long jd2 = RubyDate.validOrdinalImpl(args2[0], args2[1], sg);
        return jd2 == null ? context.fals : context.tru;
    }

    static Long validOrdinalImpl(IRubyObject year2, IRubyObject day, long sg) {
        return RubyDate.validOrdinalImpl(year2, day.convertToInteger().getIntValue(), sg);
    }

    private static Long validOrdinalImpl(IRubyObject year2, int day, long sg) {
        int y = year2.convertToInteger().getIntValue();
        return DateUtils._valid_ordinal_p(y, day, sg);
    }

    @Deprecated
    @JRubyMethod(name={"_valid_ordinal?"}, meta=true, required=2, optional=1, checkArity=false, visibility=Visibility.PRIVATE)
    public static IRubyObject _valid_ordinal_p(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        int argc = Arity.checkArgumentCount(context, args2, 2, 3);
        long sg = argc > 2 ? RubyDate.val2sg(context, args2[2]) : Long.MIN_VALUE;
        Long jd2 = RubyDate.validOrdinalImpl(args2[0], args2[1], sg);
        return jd2 == null ? context.nil : RubyFixnum.newFixnum(context.runtime, jd2);
    }

    @Deprecated
    @JRubyMethod(name={"_valid_ordinal?"}, required=2, optional=1, checkArity=false, visibility=Visibility.PRIVATE)
    public IRubyObject _valid_ordinal_p(ThreadContext context, IRubyObject[] args2) {
        return RubyDate._valid_ordinal_p(context, null, args2);
    }

    @JRubyMethod(name={"commercial"}, meta=true, optional=4, checkArity=false)
    public static RubyDate commercial(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        long sg;
        IRubyObject day;
        IRubyObject week;
        int argc;
        IRubyObject year2 = argc > 0 ? args2[0] : RubyFixnum.newFixnum(context.runtime, -4712L);
        Long jd2 = RubyDate.validCommercialImpl(year2, week = argc > 1 ? args2[1] : RubyFixnum.newFixnum(context.runtime, 1L), day = argc > 2 ? args2[2] : RubyFixnum.newFixnum(context.runtime, 1L), sg = (argc = Arity.checkArgumentCount(context, args2, 0, 4)) > 3 ? RubyDate.val2sg(context, args2[3]) : 2299161L);
        if (jd2 == null) {
            throw RubyDate.newDateError(context, "invalid date");
        }
        return new RubyDate(context, (RubyClass)self2, (IRubyObject)RubyDate.jd_to_ajd(context, jd2), 0, sg);
    }

    @JRubyMethod(name={"valid_commercial?"}, meta=true, required=3, optional=1, checkArity=false)
    public static IRubyObject valid_commercial_p(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        int argc = Arity.checkArgumentCount(context, args2, 3, 4);
        long sg = argc > 3 ? RubyDate.val2sg(context, args2[3]) : 2299161L;
        Long jd2 = RubyDate.validCommercialImpl(args2[0], args2[1], args2[2], sg);
        return jd2 == null ? context.fals : context.tru;
    }

    static Long validCommercialImpl(IRubyObject year2, IRubyObject week, IRubyObject day, long sg) {
        int y = year2.convertToInteger().getIntValue();
        int w = week.convertToInteger().getIntValue();
        int d = day.convertToInteger().getIntValue();
        return DateUtils._valid_commercial_p(y, w, d, sg);
    }

    @Deprecated
    @JRubyMethod(name={"_valid_commercial?"}, meta=true, required=3, optional=1, checkArity=false, visibility=Visibility.PRIVATE)
    public static IRubyObject _valid_commercial_p(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        int argc = Arity.checkArgumentCount(context, args2, 3, 4);
        long sg = argc > 3 ? RubyDate.val2sg(context, args2[3]) : Long.MIN_VALUE;
        Long jd2 = RubyDate.validCommercialImpl(args2[0], args2[1], args2[2], sg);
        return jd2 == null ? context.nil : RubyFixnum.newFixnum(context.runtime, jd2);
    }

    @Deprecated
    @JRubyMethod(name={"_valid_weeknum?"}, meta=true, required=4, optional=1, checkArity=false, visibility=Visibility.PRIVATE)
    public static IRubyObject _valid_weeknum_p(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        int argc = Arity.checkArgumentCount(context, args2, 4, 5);
        long sg = argc > 4 ? RubyDate.val2sg(context, args2[4]) : Long.MIN_VALUE;
        int y = args2[0].convertToInteger().getIntValue();
        int w = args2[1].convertToInteger().getIntValue();
        int d = args2[2].convertToInteger().getIntValue();
        int f = args2[3].convertToInteger().getIntValue();
        Long jd2 = DateUtils._valid_weeknum_p(y, w, d, f, sg);
        return jd2 == null ? context.nil : RubyFixnum.newFixnum(context.runtime, jd2);
    }

    @JRubyMethod(meta=true)
    public static RubyDate today(ThreadContext context, IRubyObject self2) {
        return new RubyDate(context.runtime, (RubyClass)self2, RubyDate.todayDate(context, CHRONO_ITALY_UTC));
    }

    @JRubyMethod(meta=true)
    public static RubyDate today(ThreadContext context, IRubyObject self2, IRubyObject sg) {
        long start2 = RubyDate.val2sg(context, sg);
        Chronology chrono = RubyDate.getChronology(context, start2, 0);
        return new RubyDate(context.runtime, (RubyClass)self2, RubyDate.todayDate(context, chrono), 0, start2);
    }

    private static DateTime todayDate(ThreadContext context, Chronology chrono) {
        org.joda.time.LocalDate today2 = new org.joda.time.LocalDate(RubyTime.getLocalTimeZone(context.runtime));
        return new DateTime(today2.getYear(), today2.getMonthOfYear(), today2.getDayOfMonth(), 0, 0, chrono);
    }

    @JRubyMethod(name={"_valid_civil?"}, meta=true, required=3, optional=1, checkArity=false)
    public static IRubyObject _valid_civil_p(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        int argc = Arity.checkArgumentCount(context, args2, 3, 4);
        long sg = argc > 3 ? RubyDate.val2sg(context, args2[3]) : Long.MIN_VALUE;
        Long jd2 = RubyDate.validCivilImpl(args2[0], args2[1], args2[2], sg);
        return jd2 == null ? context.nil : RubyFixnum.newFixnum(context.runtime, jd2);
    }

    @Deprecated
    @JRubyMethod(name={"_valid_civil?"}, required=3, optional=1, checkArity=false, visibility=Visibility.PRIVATE)
    public IRubyObject _valid_civil_p(ThreadContext context, IRubyObject[] args2) {
        return RubyDate._valid_civil_p(context, null, args2);
    }

    public DateTime getDateTime() {
        return this.dt;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof RubyDate) {
            return this.equals((RubyDate)other);
        }
        return false;
    }

    public final boolean equals(RubyDate that) {
        return this.start == that.start && this.dt.equals(that.dt) && this.subMillisNum == that.subMillisNum && this.subMillisDen == that.subMillisDen;
    }

    @Override
    @JRubyMethod(name={"eql?"}, required=1)
    public IRubyObject eql_p(IRubyObject other) {
        if (other instanceof RubyDate) {
            return this.getRuntime().newBoolean(this.equals((RubyDate)other));
        }
        return this.getRuntime().getFalse();
    }

    @Override
    @JRubyMethod(name={"==="}, required=1)
    public IRubyObject op_eqq(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyDate) {
            return Numeric.f_equal(context, this.jd(context), ((RubyDate)other).jd(context));
        }
        if (other instanceof RubyNumeric) {
            return Numeric.f_equal(context, (IRubyObject)this.jd(context), other);
        }
        return this.fallback_eqq(context, other);
    }

    private IRubyObject fallback_eqq(ThreadContext context, IRubyObject other) {
        RubyArray res;
        IRubyObject $ex = context.getErrorInfo();
        try {
            res = (RubyArray)other.callMethod(context, "coerce", this);
        }
        catch (RaiseException ex) {
            context.setErrorInfo($ex);
            if (ex.getException() instanceof RubyNoMethodError) {
                return context.nil;
            }
            throw ex;
        }
        return Numeric.f_equal(context, res.eltInternal(0), res.eltInternal(1));
    }

    @Override
    @JRubyMethod(name={"<=>"}, required=1)
    public IRubyObject op_cmp(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyDate) {
            return context.runtime.newFixnum(this.cmp(context, (RubyDate)other));
        }
        if (other instanceof RubyNumeric) {
            return Numeric.f_cmp(context, this.ajd(context), other);
        }
        return this.fallback_cmp(context, other);
    }

    private int cmp(ThreadContext context, RubyDate that) {
        int cmp2 = this.dt.compareTo(that.dt);
        if (cmp2 == 0) {
            if (this.subMillisDen == 1L && that.subMillisDen == 1L) {
                long subNum1 = this.subMillisNum;
                long subNum2 = that.subMillisNum;
                if (subNum1 < subNum2) {
                    return -1;
                }
                if (subNum1 > subNum2) {
                    return 1;
                }
                return 0;
            }
            return this.cmpSubMillis(context, that);
        }
        return cmp2;
    }

    private int cmpSubMillis(ThreadContext context, RubyDate that) {
        RubyNumeric diff = this.subMillisDiff(context, that);
        return diff.isZero() ? 0 : (Numeric.f_negative_p(context, diff) ? -1 : 1);
    }

    private IRubyObject fallback_cmp(ThreadContext context, IRubyObject other) {
        RubyArray res;
        IRubyObject $ex = context.getErrorInfo();
        try {
            res = (RubyArray)other.callMethod(context, "coerce", this);
        }
        catch (RaiseException ex) {
            context.setErrorInfo($ex);
            if (ex.getException() instanceof RubyNoMethodError) {
                return context.nil;
            }
            throw ex;
        }
        return Numeric.f_cmp(context, res.eltInternal(0), res.eltInternal(1));
    }

    @Override
    public int hashCode() {
        return (int)(this.dt.getMillis() ^ this.dt.getMillis() >>> 32);
    }

    @JRubyMethod
    public RubyFixnum hash(ThreadContext context) {
        return this.hashImpl(context.runtime);
    }

    private RubyFixnum hashImpl(Ruby runtime2) {
        return new RubyFixnum(runtime2, this.dt.getMillis());
    }

    @Override
    public RubyFixnum hash() {
        return this.hashImpl(this.getRuntime());
    }

    @JRubyMethod
    public RubyFixnum jd(ThreadContext context) {
        return RubyFixnum.newFixnum(context.runtime, this.getJulianDayNumber());
    }

    public final long getJulianDayNumber() {
        return DateTimeUtils.toJulianDayNumber(this.dt.getMillis() + (long)(this.off * 1000));
    }

    @JRubyMethod(name={"julian?"})
    public RubyBoolean julian_p(ThreadContext context) {
        return RubyBoolean.newBoolean(context, this.isJulian());
    }

    @JRubyMethod(name={"gregorian?"})
    public RubyBoolean gregorian_p(ThreadContext context) {
        return RubyBoolean.newBoolean(context, !this.isJulian());
    }

    public final boolean isJulian() {
        if (this.start == Long.MAX_VALUE) {
            return true;
        }
        if (this.start == Long.MIN_VALUE) {
            return false;
        }
        return this.getJulianDayNumber() < this.start;
    }

    @JRubyMethod
    public IRubyObject ajd(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        long num = 210866760000000L + this.dt.getMillis();
        if (this.subMillisDen == 1L) {
            return RubyRational.newInstance(context, RubyFixnum.newFixnum(runtime2, num += this.subMillisNum), this.DAY_MS(context));
        }
        RubyNumeric val = (RubyNumeric)RubyFixnum.newFixnum(runtime2, num).op_plus(context, this.subMillis(runtime2));
        return RubyRational.newRationalConvert(context, val, this.DAY_MS(context));
    }

    @JRubyMethod
    public IRubyObject amjd(ThreadContext context) {
        RubyRational _MJD_EPOCH_IN_AJD = RubyRational.newRational(context.runtime, -4800001L, 2L);
        return _MJD_EPOCH_IN_AJD.op_plus(context, this.ajd(context));
    }

    @JRubyMethod
    public IRubyObject start(ThreadContext context) {
        Chronology chrono = this.dt.getChronology();
        if (chrono instanceof GregorianChronology) {
            return this.getMetaClass().getConstant("GREGORIAN");
        }
        if (chrono instanceof JulianChronology) {
            return this.getMetaClass().getConstant("JULIAN");
        }
        long cutover = DateTimeUtils.toJulianDayNumber(((GJChronology)chrono).getGregorianCutover().getMillis());
        return new RubyFixnum(context.runtime, cutover);
    }

    final int adjustJodaYear(int year2) {
        if (year2 < 0 && this.isJulian()) {
            return ++year2;
        }
        return year2;
    }

    @JRubyMethod(name={"year"})
    public RubyInteger year(ThreadContext context) {
        return RubyFixnum.newFixnum(context.runtime, this.adjustJodaYear(this.dt.getYear()));
    }

    @JRubyMethod(name={"yday"})
    public RubyInteger yday(ThreadContext context) {
        return RubyFixnum.newFixnum(context.runtime, this.dt.getDayOfYear());
    }

    @JRubyMethod(name={"mon"}, alias={"month"})
    public RubyInteger mon(ThreadContext context) {
        return RubyFixnum.newFixnum(context.runtime, this.dt.getMonthOfYear());
    }

    @JRubyMethod(name={"mday"}, alias={"day"})
    public RubyInteger mday(ThreadContext context) {
        return RubyFixnum.newFixnum(context.runtime, this.dt.getDayOfMonth());
    }

    @JRubyMethod(name={"day_fraction"})
    public RubyNumeric day_fraction(ThreadContext context) {
        long ms = (long)this.dt.getSecondOfDay() * 1000L + (long)this.dt.getMillisOfSecond();
        if (this.subMillisDen == 1L) {
            return (RubyNumeric)RubyRational.newRationalCanonicalize(context, ms + this.subMillisNum, 86400000L);
        }
        Ruby runtime2 = context.runtime;
        RubyNumeric sum2 = RubyRational.newRational(runtime2, ms, 1L).op_plus(context, this.subMillis(runtime2));
        return sum2.convertToRational().op_div(context, RubyFixnum.newFixnum(runtime2, 86400000L));
    }

    @JRubyMethod(name={"hour"}, visibility=Visibility.PRIVATE)
    public RubyInteger hour(ThreadContext context) {
        return RubyFixnum.newFixnum(context.runtime, this.dt.getHourOfDay());
    }

    @JRubyMethod(name={"min"}, alias={"minute"}, visibility=Visibility.PRIVATE)
    public RubyInteger minute(ThreadContext context) {
        return RubyFixnum.newFixnum(context.runtime, this.dt.getMinuteOfHour());
    }

    @JRubyMethod(name={"sec"}, alias={"second"}, visibility=Visibility.PRIVATE)
    public RubyInteger second(ThreadContext context) {
        return RubyFixnum.newFixnum(context.runtime, this.dt.getSecondOfMinute());
    }

    @JRubyMethod(name={"sec_fraction"}, alias={"second_fraction"}, visibility=Visibility.PRIVATE)
    public RubyNumeric sec_fraction(ThreadContext context) {
        long ms = this.dt.getMillisOfSecond();
        if (this.subMillisDen == 1L) {
            return (RubyNumeric)RubyRational.newRationalCanonicalize(context, ms + this.subMillisNum, 1000L);
        }
        Ruby runtime2 = context.runtime;
        RubyNumeric sum2 = RubyRational.newRational(runtime2, ms, 1L).op_plus(context, this.subMillis(runtime2));
        return sum2.convertToRational().op_div(context, RubyFixnum.newFixnum(runtime2, 1000L));
    }

    @JRubyMethod
    public RubyInteger cwyear(ThreadContext context) {
        return RubyFixnum.newFixnum(context.runtime, this.adjustJodaYear(this.dt.getWeekyear()));
    }

    @JRubyMethod
    public RubyInteger cweek(ThreadContext context) {
        return RubyFixnum.newFixnum(context.runtime, this.dt.getWeekOfWeekyear());
    }

    @JRubyMethod
    public RubyInteger cwday(ThreadContext context) {
        return RubyFixnum.newFixnum(context.runtime, this.dt.getDayOfWeek());
    }

    @JRubyMethod
    public RubyInteger wday(ThreadContext context) {
        return RubyFixnum.newFixnum(context.runtime, this.dt.getDayOfWeek() % 7);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public RubyString zone(ThreadContext context) {
        if (this.off == 0) {
            return RubyString.newUsAsciiStringShared(context.runtime, UTC_ZONE);
        }
        return RubyString.newUsAsciiStringNoCopy(context.runtime, RubyDate.of2str(this.off));
    }

    private static ByteList of2str(int of) {
        byte s2 = (byte)(of < 0 ? 45 : 43);
        int a = of < 0 ? -of : of;
        int h = a / 3600;
        int m = a % 3600 / 60;
        ByteList str = new ByteList(6);
        str.append(s2);
        String digs = Integer.toString(h);
        if (digs.length() == 1) {
            str.append(48).append(digs.charAt(0));
        } else if (digs.length() == 2) {
            str.append(digs.charAt(0)).append(digs.charAt(1));
        } else {
            RubyDate.append(str, digs);
        }
        str.append(58);
        digs = Integer.toString(m);
        if (digs.length() == 1) {
            str.append(48).append(digs.charAt(0));
        } else if (digs.length() == 2) {
            str.append(digs.charAt(0)).append(digs.charAt(1));
        } else {
            RubyDate.append(str, digs);
        }
        return str;
    }

    private static void append(ByteList out, String val) {
        for (int i2 = 0; i2 < val.length(); ++i2) {
            out.append(val.charAt(i2));
        }
    }

    @JRubyMethod
    public IRubyObject mjd(ThreadContext context) {
        return RubyFixnum.newFixnum(context.runtime, this.getJulianDayNumber() - 2400001L);
    }

    @JRubyMethod
    public IRubyObject ld(ThreadContext context) {
        return RubyFixnum.newFixnum(context.runtime, this.getJulianDayNumber() - 2299160L);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject offset(ThreadContext context) {
        int offset2 = this.dt.getChronology().getZone().getOffset(this.dt);
        return RubyRational.newRationalCanonicalize(context, offset2, 86400000L);
    }

    @JRubyMethod(optional=1, checkArity=false, visibility=Visibility.PRIVATE)
    public IRubyObject new_offset(ThreadContext context, IRubyObject[] args2) {
        int argc = Arity.checkArgumentCount(context, args2, 0, 1);
        IRubyObject of = argc > 0 ? args2[0] : RubyFixnum.zero(context.runtime);
        int off = RubyDate.val2off(context, of);
        DateTime dt = this.dt.withChronology(RubyDate.getChronology(context, this.start, off));
        return this.newInstance(context, dt, off, this.start);
    }

    @JRubyMethod
    public IRubyObject new_start(ThreadContext context) {
        return this.newStart(context, 2299161L);
    }

    @JRubyMethod
    public IRubyObject new_start(ThreadContext context, IRubyObject sg) {
        return this.newStart(context, RubyDate.val2sg(context, sg));
    }

    private RubyDate newStart(ThreadContext context, long start2) {
        DateTime dt = this.dt.withChronology(RubyDate.getChronology(context, start2, this.off));
        return this.newInstance(context, dt, this.off, start2, this.subMillisNum, this.subMillisDen);
    }

    @JRubyMethod
    public IRubyObject italy(ThreadContext context) {
        return this.newStart(context, 2299161L);
    }

    @JRubyMethod
    public IRubyObject england(ThreadContext context) {
        return this.newStart(context, 2361222L);
    }

    @JRubyMethod
    public IRubyObject julian(ThreadContext context) {
        return this.newStart(context, Long.MAX_VALUE);
    }

    @JRubyMethod
    public IRubyObject gregorian(ThreadContext context) {
        return this.newStart(context, Long.MIN_VALUE);
    }

    @JRubyMethod(name={"julian_leap?"}, meta=true)
    public static IRubyObject julian_leap_p(ThreadContext context, IRubyObject self2, IRubyObject year2) {
        RubyInteger y = year2.convertToInteger();
        return RubyBoolean.newBoolean(context, RubyDate.isJulianLeap(y.getLongValue()));
    }

    @JRubyMethod(name={"gregorian_leap?"}, alias={"leap?"}, meta=true)
    public static IRubyObject gregorian_leap_p(ThreadContext context, IRubyObject self2, IRubyObject year2) {
        RubyInteger y = year2.convertToInteger();
        return RubyBoolean.newBoolean(context, RubyDate.isGregorianLeap(y.getLongValue()));
    }

    private static boolean isJulianLeap(long year2) {
        return year2 % 4L == 0L;
    }

    private static boolean isGregorianLeap(long year2) {
        long uy;
        long l = uy = year2 >= 0L ? year2 : -year2;
        if ((uy & 3L) != 0L) {
            return false;
        }
        long century = uy / 100L;
        if (uy != century * 100L) {
            return true;
        }
        return (century & 3L) == 0L;
    }

    @JRubyMethod(name={"leap?"})
    public IRubyObject leap_p(ThreadContext context) {
        long year2 = this.dt.getYear();
        return RubyBoolean.newBoolean(context, this.isJulian() ? RubyDate.isJulianLeap(year2) : RubyDate.isGregorianLeap(year2));
    }

    @JRubyMethod(name={"+"})
    public IRubyObject op_plus(ThreadContext context, IRubyObject n) {
        if (n instanceof RubyFixnum) {
            int days = n.convertToInteger().getIntValue();
            return this.newInstance(context, this.dt.plusDays(days), this.off, this.start);
        }
        if (n instanceof RubyNumeric) {
            return this.op_plus_numeric(context, (RubyNumeric)n);
        }
        throw context.runtime.newTypeError("expected numeric");
    }

    RubyDate op_plus_numeric(ThreadContext context, RubyNumeric n) {
        long subDen;
        long subNum;
        Ruby runtime2 = context.runtime;
        RubyNumeric val = (RubyNumeric)RubyFixnum.newFixnum(runtime2, 86400000L).op_mul(context, n);
        RubyArray res = (RubyArray)val.divmod(context, RubyFixnum.one(runtime2));
        long ms = ((RubyInteger)res.eltInternal(0)).getLongValue();
        RubyNumeric sub3 = (RubyNumeric)res.eltInternal(1);
        RubyNumeric sub_millis = this.subMillis(runtime2);
        if (!sub3.isZero()) {
            if (sub3 instanceof RubyFloat) {
                sub3 = RubyDate.roundToPrecision(context, (RubyFloat)sub3, 1000000000L);
                sub_millis = (RubyNumeric)sub_millis.op_plus(context, sub3);
            } else {
                sub_millis = (RubyNumeric)sub_millis.op_plus(context, sub3);
            }
        }
        if ((subNum = sub_millis.numerator(context).convertToInteger().getLongValue()) / (subDen = sub_millis.denominator(context).convertToInteger().getLongValue()) >= 1L) {
            subNum -= subDen;
            ++ms;
        }
        return this.newInstance(context, this.dt.plus(ms), this.off, this.start, subNum, subDen).normalizeSubMillis();
    }

    static RubyNumeric roundToPrecision(ThreadContext context, RubyFloat sub3, long precision2) {
        long s2 = Math.round(sub3.getDoubleValue() * (double)precision2);
        return (RubyNumeric)RubyRational.newRationalCanonicalize(context, s2, precision2);
    }

    @JRubyMethod(name={"-"})
    public IRubyObject op_minus(ThreadContext context, IRubyObject n) {
        if (n instanceof RubyFixnum) {
            int days = n.convertToInteger().getIntValue();
            return this.newInstance(context, this.dt.plusDays(-days), this.off, this.start);
        }
        if (n instanceof RubyNumeric) {
            return this.op_plus_numeric(context, (RubyNumeric)((RubyNumeric)n).op_uminus(context));
        }
        if (n instanceof RubyDate) {
            return this.op_minus_date(context, (RubyDate)n);
        }
        throw context.runtime.newTypeError("expected numeric or date");
    }

    private RubyNumeric op_minus_date(ThreadContext context, RubyDate that) {
        long diff = this.dt.getMillis() - that.dt.getMillis();
        RubyNumeric diffMillis = (RubyNumeric)RubyRational.newRationalCanonicalize(context, diff, 86400000L);
        RubyNumeric subDiff = this.subMillisDiff(context, that);
        if (!subDiff.isZero()) {
            subDiff = subDiff.convertToRational().op_div(context, RubyFixnum.newFixnum(context.runtime, 86400000L));
            return (RubyNumeric)diffMillis.op_plus(context, subDiff);
        }
        return diffMillis;
    }

    private RubyNumeric subMillisDiff(ThreadContext context, RubyDate that) {
        Ruby runtime2 = context.runtime;
        long subNum1 = this.subMillisNum;
        long subNum2 = that.subMillisNum;
        if (subNum2 == 0L) {
            return RubyRational.newRational(runtime2, subNum1, this.subMillisDen);
        }
        if (subNum1 == 0L) {
            return RubyRational.newRational(runtime2, -subNum2, that.subMillisDen);
        }
        if (this.subMillisDen == 1L && that.subMillisDen == 1L) {
            return (RubyInteger)RubyFixnum.newFixnum(runtime2, subNum1).op_minus(context, subNum2);
        }
        return this.subMillis(runtime2).op_minus(context, that.subMillis(runtime2));
    }

    final RubyRational subMillis(Ruby runtime2) {
        return RubyRational.newRational(runtime2, this.subMillisNum, this.subMillisDen);
    }

    @JRubyMethod(name={"next"}, alias={"succ"})
    public IRubyObject next(ThreadContext context) {
        return this.next_day(context);
    }

    @JRubyMethod
    public IRubyObject next_day(ThreadContext context) {
        return this.newInstance(context, this.dt.plusDays(1), this.off, this.start);
    }

    @JRubyMethod
    public IRubyObject next_day(ThreadContext context, IRubyObject n) {
        return this.newInstance(context, this.dt.plusDays(RubyDate.simpleIntDiff(n)), this.off, this.start);
    }

    @JRubyMethod
    public IRubyObject prev_day(ThreadContext context) {
        return this.newInstance(context, this.dt.plusDays(-1), this.off, this.start);
    }

    @JRubyMethod
    public IRubyObject prev_day(ThreadContext context, IRubyObject n) {
        return this.newInstance(context, this.dt.plusDays(-RubyDate.simpleIntDiff(n)), this.off, this.start);
    }

    @JRubyMethod
    public IRubyObject next_month(ThreadContext context) {
        return this.newInstance(context, this.dt.plusMonths(1), this.off, this.start);
    }

    @JRubyMethod
    public IRubyObject next_month(ThreadContext context, IRubyObject n) {
        return this.newInstance(context, this.dt.plusMonths(RubyDate.simpleIntDiff(n)), this.off, this.start);
    }

    @JRubyMethod
    public IRubyObject prev_month(ThreadContext context) {
        return this.newInstance(context, this.dt.plusMonths(-1), this.off, this.start);
    }

    @JRubyMethod
    public IRubyObject prev_month(ThreadContext context, IRubyObject n) {
        return this.newInstance(context, this.dt.plusMonths(-RubyDate.simpleIntDiff(n)), this.off, this.start);
    }

    private static int simpleIntDiff(IRubyObject n) {
        int days = n.convertToInteger().getIntValue();
        if (n instanceof RubyRational && ((RubyRational)n).getDenominator().getLongValue() != 1L) {
            return days + 1;
        }
        return days;
    }

    @JRubyMethod(name={">>"})
    public IRubyObject shift_fw(ThreadContext context, IRubyObject n) {
        return this.next_month(context, n);
    }

    @JRubyMethod(name={"<<"})
    public IRubyObject shift_bw(ThreadContext context, IRubyObject n) {
        return this.prev_month(context, n);
    }

    @JRubyMethod
    public IRubyObject next_year(ThreadContext context) {
        return this.newInstance(context, this.dt.plusYears(1), this.off, this.start);
    }

    @JRubyMethod
    public IRubyObject next_year(ThreadContext context, IRubyObject n) {
        return this.prevNextYear(context, n, false);
    }

    @JRubyMethod
    public IRubyObject prev_year(ThreadContext context) {
        return this.newInstance(context, this.dt.plusYears(-1), this.off, this.start);
    }

    @JRubyMethod
    public IRubyObject prev_year(ThreadContext context, IRubyObject n) {
        return this.prevNextYear(context, n, true);
    }

    private RubyDate prevNextYear(ThreadContext context, IRubyObject n, boolean negate2) {
        long months = RubyDate.timesIntDiff(context, n, 12);
        if (negate2) {
            months = -months;
        }
        int years = RubyNumeric.checkInt(context.runtime, months / 12L);
        return this.newInstance(context, this.dt.plusYears(years).plusMonths((int)(months % 12L)), this.off, this.start);
    }

    static long timesIntDiff(ThreadContext context, IRubyObject n, int times2) {
        IRubyObject mul = RubyFixnum.newFixnum(context.runtime, times2).op_mul(context, n);
        return ((RubyNumeric)mul).round(context).convertToInteger().getLongValue();
    }

    @JRubyMethod
    public IRubyObject marshal_dump(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        return context.runtime.newArrayNoCopy(this.ajd(context), RubyRational.newRationalCanonicalize(context, this.off, 86400L), RubyFixnum.newFixnum(runtime2, this.start));
    }

    @JRubyMethod(meta=true)
    public static RubyDate _load(ThreadContext context, IRubyObject klass, IRubyObject str) {
        IRubyObject a = RubyMarshal.load(context, null, new IRubyObject[]{str}, null);
        RubyDate obj = (RubyDate)((RubyClass)klass).allocate();
        return obj.marshal_load(context, a);
    }

    @JRubyMethod
    public RubyDate marshal_load(ThreadContext context, IRubyObject a) {
        Object sg;
        Object of;
        Object ajd2;
        this.checkFrozen();
        if (!(a instanceof RubyArray)) {
            throw context.runtime.newTypeError("expected an array");
        }
        RubyArray ary = (RubyArray)a;
        switch (ary.size()) {
            case 2: {
                ajd2 = RubyDate.valMinusOneHalf(context, ary.eltInternal(0));
                of = RubyFixnum.zero(context.runtime);
                sg = ary.eltInternal(1);
                if (Numeric.k_numeric_p(sg)) break;
                sg = RubyFloat.newFloat(context.runtime, sg.isTrue() ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY);
                break;
            }
            case 3: {
                ajd2 = ary.eltInternal(0);
                of = ary.eltInternal(1);
                sg = ary.eltInternal(2);
                break;
            }
            case 6: {
                Object jd2 = ary.eltInternal(1);
                Object df = ary.eltInternal(2);
                Object sf = ary.eltInternal(3);
                of = ary.eltInternal(4);
                sg = ary.eltInternal(5);
                of = RubyDate.newRationalConvert(context, of, 86400L);
                ajd2 = this.marshal_load_6(context, (IRubyObject)jd2, (IRubyObject)df, (IRubyObject)sf);
                break;
            }
            default: {
                throw context.runtime.newTypeError("invalid size: " + ary.size());
            }
        }
        return this.initialize(context, (IRubyObject)ajd2, (IRubyObject)of, (IRubyObject)sg);
    }

    private IRubyObject marshal_load_6(ThreadContext context, IRubyObject jd2, IRubyObject df, IRubyObject sf) {
        IRubyObject ajd2 = RubyDate.valMinusOneHalf(context, jd2);
        if (!((RubyNumeric)df).isZero()) {
            ajd2 = RubyDate.newRationalConvert(context, df, 86400L).op_plus(context, ajd2);
        }
        if (!((RubyNumeric)sf).isZero()) {
            ajd2 = RubyDate.newRationalConvert(context, sf, 86400000000000L).op_plus(context, ajd2);
        }
        return ajd2;
    }

    private static IRubyObject valMinusOneHalf(ThreadContext context, IRubyObject val) {
        return RubyRational.newRational(context.runtime, -1L, 2L).op_plus(context, val);
    }

    static RubyRational newRationalConvert(ThreadContext context, IRubyObject num, long den) {
        return (RubyRational)RubyRational.newRationalConvert(context, num, context.runtime.newFixnum(den));
    }

    private static double jd_to_ajd(long jd2) {
        return (double)jd2 - 0.5;
    }

    static RubyNumeric jd_to_ajd(ThreadContext context, long jd2) {
        return RubyRational.newRational(context.runtime, jd2 * 2L - 1L, 2L);
    }

    static RubyNumeric jd_to_ajd(ThreadContext context, long jd2, RubyNumeric fr, int of_sec) {
        return RubyDate.jd_to_ajd(context, RubyFixnum.newFixnum(context.runtime, jd2), fr, of_sec);
    }

    static RubyNumeric jd_to_ajd(ThreadContext context, RubyNumeric jd2, RubyNumeric fr, int of_sec) {
        RubyNumeric tmp = jd2;
        if (of_sec != 0) {
            tmp = (RubyNumeric)tmp.op_plus(context, RubyRational.newRationalCanonicalize(context, -of_sec, 86400L));
        }
        RubyRational MINUS_HALF = RubyRational.newRational(context.runtime, -1L, 2L);
        return (RubyNumeric)((RubyNumeric)tmp.op_plus(context, fr)).op_plus(context, MINUS_HALF);
    }

    @JRubyMethod(meta=true, required=2, optional=1, checkArity=false, visibility=Visibility.PRIVATE)
    public static RubyNumeric jd_to_ajd(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        int argc = Arity.checkArgumentCount(context, args2, 2, 3);
        RubyNumeric jd2 = (RubyNumeric)args2[0];
        RubyNumeric fr = (RubyNumeric)args2[1];
        int of_sec = 0;
        if (argc > 2 && !((RubyNumeric)args2[2]).isZero()) {
            RubyNumeric of = (RubyNumeric)Numeric.f_mul(context, args2[2], (IRubyObject)RubyFixnum.newFixnum(context.runtime, 86400L));
            of_sec = of.getIntValue();
        }
        return RubyDate.jd_to_ajd(context, jd2, fr, of_sec);
    }

    public static Chronology getChronology(ThreadContext context, long sg, int off) {
        DateTimeZone zone2;
        if (off == 0) {
            if (sg == 2299161L) {
                return CHRONO_ITALY_UTC;
            }
            zone2 = DateTimeZone.UTC;
        } else {
            try {
                zone2 = DateTimeZone.forOffsetMillis(off * 1000);
            }
            catch (IllegalArgumentException ex) {
                RubyDate.debug(context, "invalid offset", ex);
                throw context.runtime.newArgumentError("invalid offset: " + off);
            }
        }
        return RubyDate.getChronology(context, sg, zone2);
    }

    static Chronology getChronology(ThreadContext context, long sg, DateTimeZone zone2) {
        if (sg == 2299161L) {
            return GJChronology.getInstance(zone2);
        }
        if (sg == Long.MAX_VALUE) {
            return JulianChronology.getInstance(zone2);
        }
        if (sg == Long.MIN_VALUE) {
            return GregorianChronology.getInstance(zone2);
        }
        org.joda.time.Instant cutover = new org.joda.time.Instant(DateTimeUtils.fromJulianDay(RubyDate.jd_to_ajd(sg)));
        try {
            return GJChronology.getInstance(zone2, cutover);
        }
        catch (IllegalArgumentException ex) {
            RubyDate.debug(context, "invalid date", ex);
            throw RubyDate.newDateError(context, "invalid date");
        }
    }

    static long val2sg(ThreadContext context, IRubyObject sg) {
        return RubyDate.getValidStart(context, sg.convertToFloat().getDoubleValue(), 2299161);
    }

    static long valid_sg(ThreadContext context, IRubyObject sg) {
        return RubyDate.getValidStart(context, sg.convertToFloat().getDoubleValue(), 0);
    }

    static long getValidStart(ThreadContext context, double sg, int DEFAULT_SG) {
        if (sg == Double.NEGATIVE_INFINITY || sg == Double.POSITIVE_INFINITY) {
            return (long)sg;
        }
        if (Double.isNaN(sg) || sg < 2298874.0 && sg > 2426355.0) {
            RubyKernel.warn(context, null, RubyString.newString(context.runtime, "invalid start is ignored"));
            return DEFAULT_SG;
        }
        return (long)sg;
    }

    static int val2off(ThreadContext context, IRubyObject of) {
        int off = DateUtils.offset_to_sec(context, of);
        if (off == Integer.MIN_VALUE) {
            RubyKernel.warn(context, null, RubyString.newString(context.runtime, "invalid offset is ignored"));
            return 0;
        }
        return off;
    }

    static void debug(ThreadContext context, String msg, Exception ex) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(msg, ex);
        } else if (context.runtime.isDebug()) {
            LOG.info(msg, ex);
        }
    }

    @Override
    public final IRubyObject inspect() {
        return this.inspect(this.getRuntime().getCurrentContext());
    }

    @JRubyMethod
    public RubyString inspect(ThreadContext context) {
        int off = this.off;
        int s2 = (this.dt.getHourOfDay() * 60 + this.dt.getMinuteOfHour()) * 60 + this.dt.getSecondOfMinute() - off;
        long ns = (long)(this.dt.getMillisOfSecond() * 1000000) + this.subMillisNum * 1000000L / this.subMillisDen;
        ByteList str = new ByteList(54);
        str.append(35).append(60);
        str.append(this.getMetaClass().to_s().getByteList());
        str.append(58).append(32);
        str.append(this.to_s(context).getByteList());
        str.append(32).append(40).append(40);
        str.append(ConvertBytes.longToByteList(this.getJulianDayNumber(), 10));
        str.append(106).append(44);
        str.append(ConvertBytes.longToByteList(s2, 10));
        str.append(115).append(44);
        str.append(ConvertBytes.longToByteList(ns, 10));
        str.append(110).append(41);
        str.append(44);
        if (off >= 0) {
            str.append(43);
        }
        str.append(ConvertBytes.longToByteList(off, 10));
        str.append(115).append(44);
        if (this.start == Long.MIN_VALUE) {
            str.append(45).append(73).append(110).append(102);
        } else if (this.start == Long.MAX_VALUE) {
            str.append(73).append(110).append(102);
        } else {
            str.append(ConvertBytes.longToByteList(this.start, 10));
        }
        str.append(106).append(41).append(62);
        return RubyString.newUsAsciiStringNoCopy(context.runtime, str);
    }

    @Override
    public final IRubyObject to_s() {
        return this.to_s(this.getRuntime().getCurrentContext());
    }

    @JRubyMethod
    public RubyString to_s(ThreadContext context) {
        return RubyDate.format(context, TO_S_FORMAT, this.year(context), this.mon(context), this.mday(context));
    }

    static RubyString format(ThreadContext context, ByteList fmt, IRubyObject ... args2) {
        RubyString str = RubyString.newStringLight(context.runtime, fmt);
        return str.op_format(context, RubyArray.newArrayNoCopy(context.runtime, args2));
    }

    @JRubyMethod
    public RubyDate to_date() {
        return this;
    }

    @JRubyMethod
    public RubyDateTime to_datetime(ThreadContext context) {
        return new RubyDateTime(context.runtime, RubyDate.getDateTime(context.runtime), this.dt.withTimeAtStartOfDay(), this.off, this.start);
    }

    @JRubyMethod
    public RubyTime to_time(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        DateTime dt = this.dt;
        dt = new DateTime(this.adjustJodaYear(dt.getYear()), dt.getMonthOfYear(), dt.getDayOfMonth(), 0, 0, 0, RubyTime.getLocalTimeZone(runtime2));
        return new RubyTime(runtime2, runtime2.getTime(), dt);
    }

    @JRubyMethod
    public RubyString strftime(ThreadContext context) {
        return this.strftime(context, RubyString.newStringLight(context.runtime, DEFAULT_FORMAT_BYTES));
    }

    @JRubyMethod
    public RubyString strftime(ThreadContext context, IRubyObject fmt) {
        RubyRational subMillis = this.subMillisNum == 0L ? null : RubyRational.newRational(context.runtime, this.subMillisNum, this.subMillisDen);
        RubyString format = context.getRubyDateFormatter().compileAndFormat(fmt.convertToString().getByteList(), true, this.dt, 0L, subMillis);
        return format;
    }

    @JRubyMethod(meta=true)
    public static IRubyObject _strptime(ThreadContext context, IRubyObject self2, IRubyObject string2) {
        return RubyDate.parse(context, string2, DEFAULT_FORMAT);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject _strptime(ThreadContext context, IRubyObject self2, IRubyObject string2, IRubyObject format) {
        string2 = string2.convertToString();
        format = format.convertToString();
        return RubyDate.parse(context, string2, ((RubyString)format).decodeString());
    }

    static IRubyObject parse(ThreadContext context, IRubyObject string2, String format) {
        string2 = TypeConverter.checkStringType(context.runtime, string2);
        return new RubyDateParser().parse(context, format, (RubyString)string2);
    }

    public static IRubyObject _strptime(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        switch (args2.length) {
            case 1: {
                return RubyDate._strptime(context, self2, args2[0]);
            }
            case 2: {
                return RubyDate._strptime(context, self2, args2[0], args2[1]);
            }
        }
        throw context.runtime.newArgumentError(args2.length, 1);
    }

    @JRubyMethod(name={"zone_to_diff"}, meta=true, visibility=Visibility.PRIVATE)
    public static IRubyObject zone_to_diff(ThreadContext context, IRubyObject self2, IRubyObject zone2) {
        int offset2 = TimeZoneConverter.dateZoneToDiff(zone2.asJavaString());
        if (offset2 == Integer.MIN_VALUE) {
            return context.nil;
        }
        return RubyFixnum.newFixnum(context.runtime, offset2);
    }

    @JRubyMethod(name={"i"}, meta=true, visibility=Visibility.PRIVATE)
    public static RubyInteger _i(ThreadContext context, IRubyObject self2, IRubyObject val) {
        return (RubyInteger)TypeConverter.convertToInteger(context, val, 10);
    }

    @JRubyMethod(name={"comp_year69"}, meta=true, visibility=Visibility.PRIVATE)
    public static RubyInteger _comp_year69(ThreadContext context, IRubyObject self2, IRubyObject year2) {
        RubyInteger y = RubyDate._i(context, self2, year2);
        if (((RubyString)year2).strLength() < 4) {
            long yi = y.getLongValue();
            return RubyFixnum.newFixnum(context.runtime, yi >= 69L ? yi + 1900L : yi + 2000L);
        }
        return y;
    }

    private static int day_num(RubyString s2) {
        ByteList sb = s2.getByteList();
        for (int i2 = 0; i2 < ABBR_DAYS.length; ++i2) {
            if (sb.caseInsensitiveCmp(ABBR_DAYS[i2]) != 0) continue;
            return i2;
        }
        return -1;
    }

    static IRubyObject _parse_time(ThreadContext context, IRubyObject self2, RubyString str, RubyHash hash2) {
        Ruby runtime2 = context.runtime;
        RubyRegexp re = RubyDate.newRegexpFromCache(runtime2, _parse_time, 3);
        IRubyObject sub3 = RubyDate.subSpace(context, str, re);
        if (sub3 != context.nil) {
            RubyMatchData match2 = (RubyMatchData)sub3;
            RubyString s1 = (RubyString)match2.at(1);
            RubyString s2 = RubyDate.matchOrNull(context, match2, 2);
            if (s2 != null) {
                hash2.fastASet(runtime2.newSymbol("zone"), s2);
            }
            if ((sub3 = (re = RubyDate.newRegexpFromCache(runtime2, _parse_time2, 3)).match_m(context, (IRubyObject)s1, false)) != context.nil) {
                match2 = (RubyMatchData)sub3;
                RubyString m = (RubyString)match2.at(1);
                RubyInteger hour2 = (RubyInteger)m.to_i();
                hash2.fastASet(runtime2.newSymbol("hour"), hour2);
                m = RubyDate.matchOrNull(context, match2, 2);
                if (m != null) {
                    hash2.fastASet(runtime2.newSymbol("min"), m.to_i());
                }
                if ((m = RubyDate.matchOrNull(context, match2, 3)) != null) {
                    hash2.fastASet(runtime2.newSymbol("sec"), m.to_i());
                }
                if ((m = RubyDate.matchOrNull(context, match2, 4)) != null) {
                    RubyInteger den = (RubyInteger)RubyFixnum.newFixnum(runtime2, 10L).op_pow(context, m.length());
                    hash2.fastASet(runtime2.newSymbol("sec_fraction"), RubyRational.newInstance(context, (RubyInteger)m.to_i(), den));
                }
                if ((m = RubyDate.matchOrNull(context, match2, 5)) != null) {
                    hour2 = (RubyInteger)hour2.op_mod(context, 12L);
                    if (m.length() == 1 && RubyDate.strPtr(m, 'p') || RubyDate.strPtr(m, 'P')) {
                        hour2 = (RubyInteger)hour2.op_plus(context, 12L);
                    }
                    hash2.fastASet(runtime2.newSymbol("hour"), hour2);
                }
            } else {
                hash2.fastASet(runtime2.newSymbol("hour"), RubyFixnum.zero(runtime2));
            }
            return context.tru;
        }
        return sub3;
    }

    private static int mon_num(RubyString s2) {
        ByteList sb = s2.getByteList();
        for (int i2 = 0; i2 < ABBR_MONTHS.length; ++i2) {
            if (sb.caseInsensitiveCmp(ABBR_MONTHS[i2]) != 0) continue;
            return i2 + 1;
        }
        return -1;
    }

    static IRubyObject _parse_day(ThreadContext context, IRubyObject self2, RubyString str, RubyHash hash2) {
        Ruby runtime2 = context.runtime;
        RubyRegexp re = RubyDate.newRegexpFromCache(runtime2, _parse_day, 1);
        IRubyObject sub3 = RubyDate.subSpace(context, str, re);
        if (sub3 != context.nil) {
            int day = RubyDate.day_num((RubyString)((RubyMatchData)sub3).at(1));
            hash2.fastASet(runtime2.newSymbol("wday"), RubyFixnum.newFixnum(runtime2, day));
            return context.tru;
        }
        return sub3;
    }

    static IRubyObject _parse_mon(ThreadContext context, IRubyObject self2, RubyString str, RubyHash hash2) {
        Ruby runtime2 = context.runtime;
        RubyRegexp re = RubyDate.newRegexpFromCache(runtime2, _parse_mon, 1);
        IRubyObject sub3 = RubyDate.subSpace(context, str, re);
        if (sub3 != context.nil) {
            int mon2 = RubyDate.mon_num((RubyString)((RubyMatchData)sub3).at(1));
            hash2.fastASet(runtime2.newSymbol("mon"), RubyFixnum.newFixnum(runtime2, mon2));
            return context.tru;
        }
        return sub3;
    }

    static IRubyObject _parse_year(ThreadContext context, IRubyObject self2, RubyString str, RubyHash hash2) {
        Ruby runtime2 = context.runtime;
        RubyRegexp re = RubyRegexp.newRegexp(runtime2, _parse_year);
        IRubyObject sub3 = RubyDate.subSpace(context, str, re);
        if (sub3 != context.nil) {
            hash2.fastASet(runtime2.newSymbol("year"), ((RubyString)((RubyMatchData)sub3).at(1)).to_i());
            return context.tru;
        }
        return sub3;
    }

    static IRubyObject _parse_mday(ThreadContext context, IRubyObject self2, RubyString str, RubyHash hash2) {
        Ruby runtime2 = context.runtime;
        RubyRegexp re = RubyDate.newRegexpFromCache(runtime2, _parse_mday, 1);
        IRubyObject sub3 = RubyDate.subSpace(context, str, re);
        if (sub3 != context.nil) {
            hash2.fastASet(runtime2.newSymbol("mday"), ((RubyString)((RubyMatchData)sub3).at(1)).to_i());
            return context.tru;
        }
        return sub3;
    }

    static IRubyObject _parse_eu(ThreadContext context, IRubyObject self2, RubyString str, RubyHash hash2) {
        Ruby runtime2 = context.runtime;
        RubyRegexp re = RubyDate.newRegexpFromCache(runtime2, _parse_eu, 1);
        IRubyObject sub3 = RubyDate.subSpace(context, str, re);
        if (sub3 != context.nil) {
            RubyMatchData match2 = (RubyMatchData)sub3;
            RubyString d = (RubyString)match2.at(1);
            RubyString mon2 = (RubyString)match2.at(2);
            mon2 = RubyString.newString(runtime2, ConvertBytes.longToByteList(RubyDate.mon_num(mon2)));
            RubyString b2 = RubyDate.matchOrNull(context, match2, 3);
            RubyString y = RubyDate.matchOrNull(context, match2, 4);
            RubyDate.s3e(context, hash2, y, mon2, d, b2 != null && b2.length() > 1 && (b2.charAt(0) == 'B' || b2.charAt(0) == 'b'));
            return context.tru;
        }
        return sub3;
    }

    static IRubyObject _parse_us(ThreadContext context, IRubyObject self2, RubyString str, RubyHash hash2) {
        Ruby runtime2 = context.runtime;
        RubyRegexp re = RubyDate.newRegexpFromCache(runtime2, _parse_us, 1);
        IRubyObject sub3 = RubyDate.subSpace(context, str, re);
        if (sub3 != context.nil) {
            RubyMatchData match2 = (RubyMatchData)sub3;
            RubyString mon2 = (RubyString)match2.at(1);
            mon2 = RubyString.newString(runtime2, ConvertBytes.longToByteList(RubyDate.mon_num(mon2)));
            RubyString d = (RubyString)match2.at(2);
            RubyString b2 = RubyDate.matchOrNull(context, match2, 3);
            RubyString y = RubyDate.matchOrNull(context, match2, 4);
            RubyDate.s3e(context, hash2, y, mon2, d, b2 != null && b2.length() > 1 && (b2.charAt(0) == 'B' || b2.charAt(0) == 'b'));
            return context.tru;
        }
        return sub3;
    }

    private static RubyRegexp newRegexpFromCache(Ruby runtime2, ByteList str, int opts) {
        RegexpOptions options2 = RegexpOptions.fromEmbeddedOptions(opts);
        Regex pattern = RubyRegexp.getRegexpFromCache(runtime2, str, str.getEncoding(), options2);
        return new RubyRegexp(runtime2, pattern, str, options2);
    }

    private static RubyString matchOrNull(ThreadContext context, RubyMatchData match2, int i2) {
        IRubyObject val = match2.at(i2);
        return val == context.nil ? null : (RubyString)val;
    }

    static IRubyObject _parse_iso(ThreadContext context, IRubyObject self2, RubyString str, RubyHash hash2) {
        Ruby runtime2 = context.runtime;
        RubyRegexp re = RubyRegexp.newRegexp(runtime2, _parse_iso);
        IRubyObject sub3 = RubyDate.subSpace(context, str, re);
        if (sub3 != context.nil) {
            RubyMatchData match2 = (RubyMatchData)sub3;
            RubyDate.s3e(context, hash2, (RubyString)match2.at(1), (RubyString)match2.at(2), (RubyString)match2.at(3), false);
            return context.tru;
        }
        return sub3;
    }

    static IRubyObject _parse_sla(ThreadContext context, IRubyObject self2, RubyString str, RubyHash hash2) {
        return RubyDate.parse_sla_dot(context, _parse_sla, str, hash2);
    }

    static IRubyObject _parse_dot(ThreadContext context, IRubyObject self2, RubyString str, RubyHash hash2) {
        return RubyDate.parse_sla_dot(context, _parse_dot, str, hash2);
    }

    private static IRubyObject parse_sla_dot(ThreadContext context, ByteList pattern, RubyString str, RubyHash hash2) {
        Ruby runtime2 = context.runtime;
        RubyRegexp re = RubyRegexp.newRegexp(runtime2, pattern);
        IRubyObject sub3 = RubyDate.subSpace(context, str, re);
        if (sub3 != context.nil) {
            RubyMatchData match2 = (RubyMatchData)sub3;
            RubyString y = RubyDate.matchOrNull(context, match2, 1);
            RubyString mon2 = RubyDate.matchOrNull(context, match2, 2);
            RubyString d = RubyDate.matchOrNull(context, match2, 3);
            RubyDate.s3e(context, hash2, y, mon2, d, false);
            return context.tru;
        }
        return sub3;
    }

    static void parse_bc(ThreadContext context, IRubyObject self2, RubyString str, RubyHash hash2) {
        boolean bc;
        Ruby runtime2 = context.runtime;
        RubyRegexp re = RubyDate.newRegexpFromCache(runtime2, _parse_bc, 1);
        IRubyObject sub3 = RubyDate.subSpace(context, str, re);
        if (sub3 != context.nil) {
            // empty if block
        }
        boolean bl = bc = sub3 != context.nil;
        if (bc || RubyDate.hashGetTest(context, hash2, "_bc")) {
            RubyInteger y = (RubyInteger)RubyDate.hashGet(context, hash2, "year");
            if (y != null) {
                RubyDate.set_hash(context, hash2, "year", y.negate().op_plus(context, 1L));
            }
            if ((y = (RubyInteger)RubyDate.hashGet(context, hash2, "cwyear")) != null) {
                RubyDate.set_hash(context, hash2, "cwyear", y.negate().op_plus(context, 1L));
            }
        }
    }

    static void parse_frag(ThreadContext context, IRubyObject self2, RubyString str, RubyHash hash2) {
        RubyInteger v;
        long vi;
        RubyRegexp re;
        Ruby runtime2 = context.runtime;
        IRubyObject sub3 = null;
        if (RubyDate.hashGet(context, hash2, "hour") != null && RubyDate.hashGet(context, hash2, "mday") == null && (sub3 = RubyDate.subSpace(context, str, re = RubyDate.newRegexpFromCache(runtime2, _parse_frag, 1))) != context.nil && 1L <= (vi = (v = (RubyInteger)((RubyString)((RubyMatchData)sub3).at(1)).to_i()).getLongValue()) && vi <= 31L) {
            hash2.fastASet(runtime2.newSymbol("mday"), v);
        }
        if (RubyDate.hashGet(context, hash2, "mday") != null && RubyDate.hashGet(context, hash2, "hour") == null) {
            RubyInteger v2;
            long vi2;
            if (sub3 == null) {
                re = RubyDate.newRegexpFromCache(runtime2, _parse_frag, 1);
                sub3 = RubyDate.subSpace(context, str, re);
            }
            if (sub3 != context.nil && 0L <= (vi2 = (v2 = (RubyInteger)((RubyString)((RubyMatchData)sub3).at(1)).to_i()).getLongValue()) && vi2 <= 24L) {
                hash2.fastASet(runtime2.newSymbol("hour"), v2);
            }
        }
    }

    private static IRubyObject hashGet(ThreadContext context, RubyHash hash2, String key2) {
        IRubyObject val = hash2.fastARef(context.runtime.newSymbol(key2));
        if (val == null || val == context.nil) {
            return null;
        }
        return val;
    }

    private static boolean hashGetTest(ThreadContext context, RubyHash hash2, String key2) {
        IRubyObject val = hash2.fastARef(context.runtime.newSymbol(key2));
        if (val == null || val == context.nil) {
            return false;
        }
        return val.isTrue();
    }

    private static IRubyObject subSpace(ThreadContext context, RubyString str, RubyRegexp reg) {
        return str.subBangFast(context, reg, RubyString.newStringShared(context.runtime, SPACE));
    }

    public static IRubyObject _parse_jis(ThreadContext context, IRubyObject self2, IRubyObject str, IRubyObject h) {
        return Helpers.invoke(context, self2, "_parse_jis", str, h);
    }

    public static IRubyObject _parse_vms(ThreadContext context, IRubyObject self2, IRubyObject str, IRubyObject h) {
        return Helpers.invoke(context, self2, "_parse_vms", str, h);
    }

    public static IRubyObject _parse_iso2(ThreadContext context, IRubyObject self2, IRubyObject str, IRubyObject h) {
        return Helpers.invoke(context, self2, "_parse_iso2", str, h);
    }

    public static IRubyObject _parse_ddd(ThreadContext context, IRubyObject self2, IRubyObject str, IRubyObject h) {
        return Helpers.invoke(context, self2, "_parse_ddd", str, h);
    }

    @JRubyMethod(name={"_parse_impl"}, meta=true, visibility=Visibility.PRIVATE)
    public static IRubyObject _parse_impl(ThreadContext context, IRubyObject self2, IRubyObject s2, IRubyObject h) {
        IRubyObject zone2;
        Ruby runtime2 = context.runtime;
        RubyString str = (RubyString)s2;
        RubyHash hash2 = (RubyHash)h;
        int flags2 = RubyDate.check_class(str = str.gsubFast(context, RubyRegexp.newRegexp(runtime2, _parse_impl), RubyString.newStringShared(context.runtime, SPACE), Block.NULL_BLOCK));
        if ((flags2 & 1) == 1) {
            RubyDate._parse_day(context, self2, str, hash2);
        }
        if ((flags2 & 2) == 2 && (flags2 & 0x3C0) != 0) {
            RubyDate._parse_time(context, self2, str, hash2);
        }
        RubyDate.do_parse(context, self2, str, hash2, flags2);
        if ((flags2 & 0x400) == 1024) {
            RubyDate.parse_bc(context, self2, str, hash2);
        }
        if ((flags2 & 2) == 2) {
            RubyDate.parse_frag(context, self2, str, hash2);
        }
        if (RubyDate.hashGetTest(context, hash2, "_comp")) {
            long yi;
            RubyInteger y = (RubyInteger)RubyDate.hashGet(context, hash2, "cwyear");
            if (y != null && (yi = y.getLongValue()) >= 0L && yi <= 99L) {
                RubyDate.set_hash(context, hash2, "cwyear", y.op_plus(context, yi >= 69L ? 1900L : 2000L));
            }
            if ((y = (RubyInteger)RubyDate.hashGet(context, hash2, "year")) != null && (yi = y.getLongValue()) >= 0L && yi <= 99L) {
                RubyDate.set_hash(context, hash2, "year", y.op_plus(context, yi >= 69L ? 1900L : 2000L));
            }
        }
        if (RubyDate.hashGet(context, hash2, "offset") == null && (zone2 = RubyDate.hashGet(context, hash2, "zone")) != null) {
            RubyDate.set_hash(context, hash2, "offset", RubyDate.zone_to_diff(context, self2, zone2));
        }
        hash2.fastDelete(runtime2.newSymbol("_bc"));
        hash2.fastDelete(runtime2.newSymbol("_comp"));
        return hash2;
    }

    private static void do_parse(ThreadContext context, IRubyObject self2, RubyString str, RubyHash hash2, int flags2) {
        IRubyObject res;
        if ((flags2 & 3) == 3) {
            res = RubyDate._parse_eu(context, self2, str, hash2);
            if (res != context.nil) {
                return;
            }
            res = RubyDate._parse_us(context, self2, str, hash2);
            if (res != context.nil) {
                return;
            }
        }
        if ((flags2 & 6) == 6 && (res = RubyDate._parse_iso(context, self2, str, hash2)) != context.nil) {
            return;
        }
        if ((flags2 & 0xA) == 10 && (res = RubyDate._parse_jis(context, self2, str, hash2)) != context.nil) {
            return;
        }
        if ((flags2 & 7) == 7 && (res = RubyDate._parse_vms(context, self2, str, hash2)) != context.nil) {
            return;
        }
        if ((flags2 & 0x12) == 18 && (res = RubyDate._parse_sla(context, self2, str, hash2)) != context.nil) {
            return;
        }
        if ((flags2 & 0xA) == 10 && (res = RubyDate._parse_dot(context, self2, str, hash2)) != context.nil) {
            return;
        }
        if ((flags2 & 2) == 2 && (res = RubyDate._parse_iso2(context, self2, str, hash2)) != context.nil) {
            return;
        }
        if ((flags2 & 2) == 2 && (res = RubyDate._parse_year(context, self2, str, hash2)) != context.nil) {
            return;
        }
        if ((flags2 & 1) == 1 && (res = RubyDate._parse_mon(context, self2, str, hash2)) != context.nil) {
            return;
        }
        if ((flags2 & 2) == 2 && (res = RubyDate._parse_mday(context, self2, str, hash2)) != context.nil) {
            return;
        }
        if ((flags2 & 2) == 2 && (res = RubyDate._parse_ddd(context, self2, str, hash2)) != context.nil) {
            return;
        }
    }

    private static int check_class(RubyString s2) {
        int flags2 = 0;
        block10: for (int i2 = 0; i2 < s2.length(); ++i2) {
            char c = s2.charAt(i2);
            switch (c) {
                case '-': {
                    flags2 |= 4;
                    continue block10;
                }
                case '.': {
                    flags2 |= 8;
                    continue block10;
                }
                case '/': {
                    flags2 |= 0x10;
                    continue block10;
                }
                case ':': {
                    flags2 |= 0x40;
                    continue block10;
                }
                case 'B': 
                case 'b': {
                    flags2 |= 0x401;
                    continue block10;
                }
                case 'M': 
                case 'm': {
                    flags2 |= 0x81;
                    continue block10;
                }
                case 'H': 
                case 'h': {
                    flags2 |= 0x101;
                    continue block10;
                }
                case 'S': 
                case 's': {
                    flags2 |= 0x201;
                    continue block10;
                }
                default: {
                    if (RubyDate.isDigit(c)) {
                        flags2 |= 2;
                        continue block10;
                    }
                    if (!RubyDate.isAlpha(c)) continue block10;
                    flags2 |= 1;
                }
            }
        }
        return flags2;
    }

    @JRubyMethod(name={"subs"}, meta=true, visibility=Visibility.PRIVATE)
    public static IRubyObject _subs(ThreadContext context, IRubyObject self2, IRubyObject str, IRubyObject reg) {
        return RubyDate.subSpace(context, (RubyString)str, (RubyRegexp)reg);
    }

    @JRubyMethod(name={"match"}, meta=true, visibility=Visibility.PRIVATE)
    public static IRubyObject _match(ThreadContext context, IRubyObject self2, IRubyObject reg, IRubyObject str) {
        return ((RubyRegexp)reg).match_m(context, str, false);
    }

    @JRubyMethod(name={"s3e"}, meta=true, required=4, optional=1, checkArity=false, visibility=Visibility.PRIVATE)
    public static IRubyObject _s3e(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        int argc = Arity.checkArgumentCount(context, args2, 4, 5);
        IRubyObject nil = context.nil;
        RubyString y = args2[1] == nil ? null : (RubyString)args2[1];
        RubyString m = args2[2] == nil ? null : (RubyString)args2[2];
        RubyString d = args2[3] == nil ? null : (RubyString)args2[3];
        return RubyDate.s3e(context, (RubyHash)args2[0], y, m, d, argc > 4 ? args2[4].isTrue() : false);
    }

    private static IRubyObject s3e(ThreadContext context, RubyHash hash2, RubyString y, RubyString m, RubyString d, boolean bc) {
        int ep;
        int bp;
        int s2;
        RubyString od;
        RubyString om;
        RubyString oy;
        Boolean comp = null;
        if (d == null && y != null && m != null) {
            oy = y;
            om = m;
            y = od = d;
            m = oy;
            d = om;
        }
        if (y == null) {
            if (d != null && d.strLength() > 2) {
                y = d;
                d = null;
            } else if (d != null && RubyDate.strPtr(d, '\'')) {
                y = d;
                d = null;
            }
        }
        if (y != null) {
            int ep2;
            char c;
            bp = s2 = RubyDate.skipNonDigitsAndSign(y);
            char c2 = c = s2 < y.strLength() ? y.charAt(s2) : (char)'\u0000';
            if (c == '+' || c == '-') {
                ++s2;
            }
            if ((ep2 = RubyDate.skipDigits(y, s2)) != y.strLength()) {
                oy = y;
                y = d;
                d = (RubyString)oy.substr19(context.runtime, bp, ep2 - bp);
            }
        }
        if (m != null && (RubyDate.strPtr(m, '\'') || m.strLength() > 2)) {
            oy = y;
            om = m;
            od = d;
            y = om;
            m = od;
            d = oy;
        }
        if (d != null && (RubyDate.strPtr(d, '\'') || d.strLength() > 2)) {
            oy = y;
            y = od = d;
            d = oy;
        }
        if (y != null) {
            int ep3;
            char c;
            int s3;
            boolean sign2 = false;
            int bp2 = s3 = RubyDate.skipNonDigitsAndSign(y);
            char c3 = c = s3 < y.strLength() ? y.charAt(s3) : (char)'\u0000';
            if (c == '+' || c == '-') {
                ++s3;
                sign2 = true;
            }
            if (sign2) {
                comp = false;
            }
            if ((ep3 = RubyDate.skipDigits(y, s3)) - s3 > 2) {
                comp = false;
            }
            RubyInteger iy = RubyDate.cstr2num(context.runtime, y, bp2, ep3);
            if (bc) {
                iy = (RubyInteger)iy.negate().op_plus(context, 1L);
            }
            RubyDate.set_hash(context, hash2, "year", iy);
        }
        if (m != null) {
            bp = s2 = RubyDate.skipNonDigitsAndSign(m);
            ep = RubyDate.skipDigits(m, s2);
            RubyDate.set_hash(context, hash2, "mon", RubyDate.cstr2num(context.runtime, m, bp, ep));
        }
        if (d != null) {
            bp = s2 = RubyDate.skipNonDigitsAndSign(d);
            ep = RubyDate.skipDigits(d, s2);
            RubyDate.set_hash(context, hash2, "mday", RubyDate.cstr2num(context.runtime, d, bp, ep));
        }
        if (comp != null) {
            RubyDate.set_hash(context, hash2, "_comp", RubyBoolean.newBoolean(context, (boolean)comp));
        }
        return hash2;
    }

    private static void set_hash(ThreadContext context, RubyHash hash2, String key2, IRubyObject val) {
        hash2.fastASet(context.runtime.newSymbol(key2), val);
    }

    private static RubyInteger cstr2num(Ruby runtime2, RubyString str, int bp, int ep) {
        if (bp == ep) {
            return RubyFixnum.zero(runtime2);
        }
        return ConvertBytes.byteListToInum(runtime2, str.getByteList(), bp, ep, 10, true);
    }

    private static boolean strPtr(RubyString str, char c) {
        return str.strLength() > 0 && str.charAt(0) == c;
    }

    private static boolean isDigit(char c) {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': {
                return true;
            }
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return true;
            }
        }
        return false;
    }

    private static boolean isAlpha(char c) {
        return Character.isLetter(c);
    }

    private static int skipNonDigitsAndSign(RubyString str) {
        char c;
        int s2;
        for (s2 = 0; s2 < str.length() && !RubyDate.isDigit(c = str.charAt(s2)) && c != '+' && c != '-'; ++s2) {
        }
        return s2;
    }

    private static int skipDigits(RubyString str, int off) {
        int i2;
        for (i2 = off; i2 < str.length(); ++i2) {
            if (RubyDate.isDigit(str.charAt(i2))) continue;
            return i2;
        }
        return i2;
    }

    public int getYear() {
        return this.dt.getYear();
    }

    public int getMonth() {
        return this.dt.getMonthOfYear();
    }

    public int getDay() {
        return this.dt.getDayOfMonth();
    }

    public int getHour() {
        return this.dt.getHourOfDay();
    }

    public int getMinute() {
        return this.dt.getMinuteOfHour();
    }

    public int getSecond() {
        return this.dt.getSecondOfMinute();
    }

    public int getNanos() {
        Ruby runtime2 = this.getRuntime();
        ThreadContext context = runtime2.getCurrentContext();
        RubyNumeric usec2 = (RubyNumeric)this.subMillis(runtime2).op_mul(context, RubyFixnum.newFixnum(runtime2, 1000000L));
        return (int)usec2.getLongValue();
    }

    public java.util.Date toDate() {
        return this.dt.toDate();
    }

    public Instant toInstant() {
        return Instant.ofEpochMilli(this.dt.getMillis()).plusNanos(this.getNanos());
    }

    public LocalDate toLocalDate() {
        return LocalDate.of(this.getYear(), this.getMonth(), this.getDay());
    }

    @Override
    public Class getJavaClass() {
        return java.util.Date.class;
    }

    @Override
    public <T> T toJava(Class<T> target) {
        if (target == java.util.Date.class || target == Comparable.class || target == Object.class) {
            return target.cast(this.toDate());
        }
        if (target == Calendar.class || target == GregorianCalendar.class) {
            return target.cast(this.dt.toGregorianCalendar());
        }
        if (target.isAssignableFrom(DateTime.class) && target != Serializable.class) {
            return target.cast(this.dt);
        }
        if (target == Date.class) {
            return target.cast(new Date(this.dt.getMillis()));
        }
        if (target == Time.class) {
            return target.cast(new Time(this.dt.getMillis()));
        }
        if (target == Timestamp.class) {
            Timestamp timestamp = new Timestamp(this.dt.getMillis());
            timestamp.setNanos(this.getNanos());
            return target.cast(timestamp);
        }
        if (target != Serializable.class) {
            if (target.isAssignableFrom(Instant.class)) {
                return (T)this.toInstant();
            }
            if (target.isAssignableFrom(LocalDate.class)) {
                return (T)this.toLocalDate();
            }
        }
        return super.toJava(target);
    }

    static {
        TO_S_FORMAT.setEncoding(USASCIIEncoding.INSTANCE);
        DEFAULT_FORMAT_BYTES = ByteList.create(DEFAULT_FORMAT);
        DEFAULT_FORMAT_BYTES.setEncoding(USASCIIEncoding.INSTANCE);
        ABBR_DAYS = new ByteList[]{new ByteList(new byte[]{115, 117, 110}, (Encoding)USASCIIEncoding.INSTANCE), new ByteList(new byte[]{109, 111, 110}, (Encoding)USASCIIEncoding.INSTANCE), new ByteList(new byte[]{116, 117, 101}, (Encoding)USASCIIEncoding.INSTANCE), new ByteList(new byte[]{119, 101, 100}, (Encoding)USASCIIEncoding.INSTANCE), new ByteList(new byte[]{116, 104, 117}, (Encoding)USASCIIEncoding.INSTANCE), new ByteList(new byte[]{102, 114, 105}, (Encoding)USASCIIEncoding.INSTANCE), new ByteList(new byte[]{115, 97, 116}, (Encoding)USASCIIEncoding.INSTANCE)};
        _parse_time = ByteList.create("((?:\\d+\\s*:\\s*\\d+(?:\\s*:\\s*\\d+(?:[,.]\\d+)?)?|\\d+\\s*h(?:\\s*\\d+m?(?:\\s*\\d+s?)?)?)(?:\\s*[ap](?:m\\b|\\.m\\.))?|\\d+\\s*[ap](?:m\\b|\\.m\\.))(?:\\s*((?:gmt|utc?)?[-+]\\d+(?:[,.:]\\d+(?::\\d+)?)?|(?-i:[[:alpha:].\\s]+)(?:standard|daylight)\\stime\\b|(?-i:[[:alpha:]]+)(?:\\sdst)?\\b))?");
        _parse_time.setEncoding(USASCIIEncoding.INSTANCE);
        _parse_time2 = ByteList.create("\\A(\\d+)h?(?:\\s*:?\\s*(\\d+)m?(?:\\s*:?\\s*(\\d+)(?:[,.](\\d+))?s?)?)?(?:\\s*([ap])(?:m\\b|\\.m\\.))?");
        _parse_time2.setEncoding(USASCIIEncoding.INSTANCE);
        ABBR_MONTHS = new ByteList[]{new ByteList(new byte[]{106, 97, 110}, (Encoding)USASCIIEncoding.INSTANCE), new ByteList(new byte[]{102, 101, 98}, (Encoding)USASCIIEncoding.INSTANCE), new ByteList(new byte[]{109, 97, 114}, (Encoding)USASCIIEncoding.INSTANCE), new ByteList(new byte[]{97, 112, 114}, (Encoding)USASCIIEncoding.INSTANCE), new ByteList(new byte[]{109, 97, 121}, (Encoding)USASCIIEncoding.INSTANCE), new ByteList(new byte[]{106, 117, 110}, (Encoding)USASCIIEncoding.INSTANCE), new ByteList(new byte[]{106, 117, 108}, (Encoding)USASCIIEncoding.INSTANCE), new ByteList(new byte[]{97, 117, 103}, (Encoding)USASCIIEncoding.INSTANCE), new ByteList(new byte[]{115, 101, 112}, (Encoding)USASCIIEncoding.INSTANCE), new ByteList(new byte[]{111, 99, 116}, (Encoding)USASCIIEncoding.INSTANCE), new ByteList(new byte[]{110, 111, 118}, (Encoding)USASCIIEncoding.INSTANCE), new ByteList(new byte[]{100, 101, 99}, (Encoding)USASCIIEncoding.INSTANCE)};
        _parse_day = ByteList.create("\\b(sun|mon|tue|wed|thu|fri|sat)[^-\\d\\s]*");
        _parse_day.setEncoding(USASCIIEncoding.INSTANCE);
        _parse_mon = ByteList.create("\\b(jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec)\\S*");
        _parse_mon.setEncoding(USASCIIEncoding.INSTANCE);
        _parse_year = ByteList.create("'(\\d+)\\b");
        _parse_year.setEncoding(USASCIIEncoding.INSTANCE);
        _parse_mday = ByteList.create("(\\d+)(st|nd|rd|th)\\b");
        _parse_mday.setEncoding(USASCIIEncoding.INSTANCE);
        _parse_eu = ByteList.create("('?\\d+)[^-\\d\\s]*\\s*(jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec)[^-\\d\\s']*(?:\\s*(c(?:e|\\.e\\.)|b(?:ce|\\.c\\.e\\.)|a(?:d|\\.d\\.)|b(?:c|\\.c\\.))?\\s*('?-?\\d+(?:(?:st|nd|rd|th)\\b)?))?");
        _parse_eu.setEncoding(USASCIIEncoding.INSTANCE);
        _parse_us = ByteList.create("\\b(jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec)[^-\\d\\s']*\\s*('?\\d+)[^-\\d\\s']*(?:\\s*,?\\s*(c(?:e|\\.e\\.)|b(?:ce|\\.c\\.e\\.)|a(?:d|\\.d\\.)|b(?:c|\\.c\\.))?\\s*('?-?\\d+))?");
        _parse_us.setEncoding(USASCIIEncoding.INSTANCE);
        _parse_iso = ByteList.create("('?[-+]?\\d+)-(\\d+)-('?-?\\d+)");
        _parse_iso.setEncoding(USASCIIEncoding.INSTANCE);
        _parse_sla = ByteList.create("('?-?\\d+)/\\s*('?\\d+)(?:\\D\\s*('?-?\\d+))?");
        _parse_sla.setEncoding(USASCIIEncoding.INSTANCE);
        _parse_dot = ByteList.create("('?-?\\d+)\\.\\s*('?\\d+)\\.\\s*('?-?\\d+)");
        _parse_dot.setEncoding(USASCIIEncoding.INSTANCE);
        _parse_bc = ByteList.create("\\b(bc\\b|bce\\b|b\\.c\\.|b\\.c\\.e\\.)");
        _parse_bc.setEncoding(USASCIIEncoding.INSTANCE);
        _parse_frag = ByteList.create("\\A\\s*(\\d{1,2})\\s*\\z");
        _parse_frag.setEncoding(USASCIIEncoding.INSTANCE);
        SPACE = new ByteList(new byte[]{32}, false);
        _parse_impl = ByteList.create("[^-+',.\\/:@[:alnum:]\\[\\]]+");
        _parse_impl.setEncoding(USASCIIEncoding.INSTANCE);
    }
}

