/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk.kms;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.encryptionsdk.CryptoAlgorithm;
import com.amazonaws.encryptionsdk.DataKey;
import com.amazonaws.encryptionsdk.EncryptedDataKey;
import com.amazonaws.encryptionsdk.MasterKey;
import com.amazonaws.encryptionsdk.MasterKeyProvider;
import com.amazonaws.encryptionsdk.exception.AwsCryptoException;
import com.amazonaws.encryptionsdk.internal.AwsKmsCmkArnInfo;
import com.amazonaws.encryptionsdk.internal.VersionInfo;
import com.amazonaws.encryptionsdk.kms.KmsMethods;
import com.amazonaws.services.kms.AWSKMS;
import com.amazonaws.services.kms.model.DecryptRequest;
import com.amazonaws.services.kms.model.DecryptResult;
import com.amazonaws.services.kms.model.EncryptRequest;
import com.amazonaws.services.kms.model.EncryptResult;
import com.amazonaws.services.kms.model.GenerateDataKeyRequest;
import com.amazonaws.services.kms.model.GenerateDataKeyResult;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public final class AwsKmsMrkAwareMasterKey
extends MasterKey<AwsKmsMrkAwareMasterKey>
implements KmsMethods {
    private static final String USER_AGENT = VersionInfo.loadUserAgent();
    private final AWSKMS kmsClient_;
    private final List<String> grantTokens_ = new ArrayList<String>();
    private final String awsKmsIdentifier_;
    private final MasterKeyProvider<AwsKmsMrkAwareMasterKey> sourceProvider_;

    private static <T extends AmazonWebServiceRequest> T updateUserAgent(T request) {
        request.getRequestClientOptions().appendUserAgent(USER_AGENT);
        return request;
    }

    static AwsKmsMrkAwareMasterKey getInstance(AWSKMS kms, String awsKmsIdentifier, MasterKeyProvider<AwsKmsMrkAwareMasterKey> provider) {
        return new AwsKmsMrkAwareMasterKey(awsKmsIdentifier, kms, provider);
    }

    private AwsKmsMrkAwareMasterKey(String awsKmsIdentifier, AWSKMS kmsClient, MasterKeyProvider<AwsKmsMrkAwareMasterKey> provider) {
        AwsKmsCmkArnInfo.validAwsKmsIdentifier(awsKmsIdentifier);
        if (kmsClient == null) {
            throw new IllegalArgumentException("AwsKmsMrkAwareMasterKey must be configured with an AWS KMS client.");
        }
        if (provider == null) {
            throw new IllegalArgumentException("AwsKmsMrkAwareMasterKey must be configured with a source provider.");
        }
        this.kmsClient_ = kmsClient;
        this.awsKmsIdentifier_ = awsKmsIdentifier;
        this.sourceProvider_ = provider;
    }

    @Override
    public String getProviderId() {
        return this.sourceProvider_.getDefaultProviderId();
    }

    @Override
    public String getKeyId() {
        return this.awsKmsIdentifier_;
    }

    @Override
    public void setGrantTokens(List<String> grantTokens) {
        this.grantTokens_.clear();
        this.grantTokens_.addAll(grantTokens);
    }

    @Override
    public List<String> getGrantTokens() {
        return this.grantTokens_;
    }

    @Override
    public void addGrantToken(String grantToken) {
        this.grantTokens_.add(grantToken);
    }

    @Override
    public DataKey<AwsKmsMrkAwareMasterKey> generateDataKey(CryptoAlgorithm algorithm, Map<String, String> encryptionContext) {
        GenerateDataKeyResult gdkResult = this.kmsClient_.generateDataKey(AwsKmsMrkAwareMasterKey.updateUserAgent(new GenerateDataKeyRequest().withKeyId(this.awsKmsIdentifier_).withNumberOfBytes(Integer.valueOf(algorithm.getDataKeyLength())).withEncryptionContext(encryptionContext).withGrantTokens(this.grantTokens_)));
        if (gdkResult.getPlaintext().limit() != algorithm.getDataKeyLength()) {
            throw new IllegalStateException("Received an unexpected number of bytes from KMS");
        }
        byte[] rawKey = new byte[algorithm.getDataKeyLength()];
        gdkResult.getPlaintext().get(rawKey);
        String gdkResultKeyId = gdkResult.getKeyId();
        if (AwsKmsCmkArnInfo.parseInfoFromKeyArn(gdkResultKeyId) == null) {
            throw new IllegalStateException("Received an empty or invalid keyId from KMS");
        }
        byte[] encryptedKey = new byte[gdkResult.getCiphertextBlob().remaining()];
        gdkResult.getCiphertextBlob().get(encryptedKey);
        SecretKeySpec key = new SecretKeySpec(rawKey, algorithm.getDataKeyAlgo());
        return new DataKey<AwsKmsMrkAwareMasterKey>(key, encryptedKey, gdkResultKeyId.getBytes(StandardCharsets.UTF_8), this);
    }

    @Override
    public DataKey<AwsKmsMrkAwareMasterKey> encryptDataKey(CryptoAlgorithm algorithm, Map<String, String> encryptionContext, DataKey<?> dataKey) {
        SecretKey key = dataKey.getKey();
        if (!key.getFormat().equals("RAW")) {
            throw new IllegalArgumentException("Only RAW encoded keys are supported");
        }
        try {
            EncryptResult encryptResult = this.kmsClient_.encrypt(AwsKmsMrkAwareMasterKey.updateUserAgent(new EncryptRequest().withKeyId(this.awsKmsIdentifier_).withPlaintext(ByteBuffer.wrap(key.getEncoded())).withEncryptionContext(encryptionContext).withGrantTokens(this.grantTokens_)));
            byte[] edk = new byte[encryptResult.getCiphertextBlob().remaining()];
            encryptResult.getCiphertextBlob().get(edk);
            String encryptResultKeyId = encryptResult.getKeyId();
            if (AwsKmsCmkArnInfo.parseInfoFromKeyArn(encryptResultKeyId) == null) {
                throw new IllegalStateException("Received an empty or invalid keyId from KMS");
            }
            return new DataKey<AwsKmsMrkAwareMasterKey>(dataKey.getKey(), edk, encryptResultKeyId.getBytes(StandardCharsets.UTF_8), this);
        }
        catch (AmazonServiceException asex) {
            throw new AwsCryptoException(asex);
        }
    }

    @Override
    public DataKey<AwsKmsMrkAwareMasterKey> decryptDataKey(CryptoAlgorithm algorithm, Collection<? extends EncryptedDataKey> encryptedDataKeys, Map<String, String> encryptionContext) throws AwsCryptoException {
        ArrayList exceptions = new ArrayList();
        String providerId = this.getProviderId();
        return encryptedDataKeys.stream().filter(edk -> AwsKmsMrkAwareMasterKey.filterEncryptedDataKeys(providerId, this.awsKmsIdentifier_, edk)).map(edk -> {
            try {
                return AwsKmsMrkAwareMasterKey.decryptSingleEncryptedDataKey(this, this.kmsClient_, this.awsKmsIdentifier_, this.grantTokens_, algorithm, edk, encryptionContext);
            }
            catch (AmazonServiceException amazonServiceException) {
                exceptions.add(amazonServiceException);
                return null;
            }
        }).filter(Objects::nonNull).findFirst().orElseThrow(() -> this.buildCannotDecryptDksException(exceptions));
    }

    static DataKey<AwsKmsMrkAwareMasterKey> decryptSingleEncryptedDataKey(AwsKmsMrkAwareMasterKey masterKey, AWSKMS client, String awsKmsIdentifier, List<String> grantTokens, CryptoAlgorithm algorithm, EncryptedDataKey edk, Map<String, String> encryptionContext) {
        DecryptResult decryptResult = client.decrypt(AwsKmsMrkAwareMasterKey.updateUserAgent(new DecryptRequest().withCiphertextBlob(ByteBuffer.wrap(edk.getEncryptedDataKey())).withEncryptionContext(encryptionContext).withGrantTokens(grantTokens).withKeyId(awsKmsIdentifier)));
        String decryptResultKeyId = decryptResult.getKeyId();
        if (decryptResultKeyId == null) {
            throw new IllegalStateException("Received an empty keyId from KMS");
        }
        if (!awsKmsIdentifier.equals(decryptResultKeyId)) {
            throw new IllegalStateException("Received an invalid response from KMS Decrypt call: Unexpected keyId.");
        }
        if (decryptResult.getPlaintext().limit() != algorithm.getDataKeyLength()) {
            throw new IllegalStateException("Received an unexpected number of bytes from KMS");
        }
        byte[] rawKey = new byte[algorithm.getDataKeyLength()];
        decryptResult.getPlaintext().get(rawKey);
        return new DataKey<AwsKmsMrkAwareMasterKey>(new SecretKeySpec(rawKey, algorithm.getDataKeyAlgo()), edk.getEncryptedDataKey(), edk.getProviderInformation(), masterKey);
    }

    static boolean filterEncryptedDataKeys(String providerId, String awsKmsIdentifier_, EncryptedDataKey edk) {
        String edkKeyId = new String(edk.getProviderInformation(), StandardCharsets.UTF_8);
        AwsKmsCmkArnInfo providerArnInfo = AwsKmsCmkArnInfo.parseInfoFromKeyArn(edkKeyId);
        if (providerArnInfo == null || !"key".equals(providerArnInfo.getResourceType())) {
            throw new IllegalStateException("Invalid provider info in message.");
        }
        return edk.getProviderId().equals(providerId) && AwsKmsCmkArnInfo.awsKmsArnMatchForDecrypt(awsKmsIdentifier_, edkKeyId);
    }
}

