module acl_direction_splitter #
(
    parameter WIDTH_D = 256,
    parameter S_WIDTH_A = 26,
    parameter NUM_BANKS = 2,
    parameter M_WIDTH_A = S_WIDTH_A+$clog2(WIDTH_D/8), 
    parameter BURSTCOUNT_WIDTH = 6,
    parameter BYTEENABLE_WIDTH = WIDTH_D,
    parameter MAX_PENDING_READS = 64
)
(
    input clk,
    input resetn,

    // Agent port
    input [S_WIDTH_A-1:0] agent_address,  // Word address
    input [WIDTH_D-1:0] agent_writedata,
    input agent_read,
    input agent_write,
    input [BURSTCOUNT_WIDTH-1:0] agent_burstcount,
    input [BYTEENABLE_WIDTH-1:0] agent_byteenable,
    output agent_waitrequest,
    output [WIDTH_D-1:0] agent_readdata,
    output agent_readdatavalid,

    output [M_WIDTH_A-1:0] r_address,  // Byte address
    output r_read,
    output [BURSTCOUNT_WIDTH-1:0] r_burstcount,
    input r_waitrequest,
    input [WIDTH_D-1:0] r_readdata,
    input r_readdatavalid,

    output [M_WIDTH_A-1:0] w_address,  // Byte address
    output [WIDTH_D-1:0] w_writedata,
    output w_write,
    output [BURSTCOUNT_WIDTH-1:0] w_burstcount,
    output [BYTEENABLE_WIDTH-1:0] w_byteenable,
    input w_waitrequest
);

assign r_read = agent_read;
assign r_burstcount = agent_burstcount;
assign r_address = {agent_address,{$clog2(WIDTH_D/8){1'b0}}}; //byteaddr

assign w_write = agent_write;
assign w_writedata = agent_writedata;
assign w_burstcount = agent_burstcount;
assign w_address = {agent_address,{$clog2(WIDTH_D/8){1'b0}}}; //byteaddr
assign w_byteenable = agent_byteenable;

assign agent_waitrequest = (agent_read & r_waitrequest) | (agent_write & w_waitrequest);
assign agent_readdata = r_readdata;
assign agent_readdatavalid = r_readdatavalid;

endmodule
