module unpipeline #
(
    parameter WIDTH_D = 256,
    parameter S_WIDTH_A = 26,
    parameter M_WIDTH_A = S_WIDTH_A+$clog2(WIDTH_D/8),
    parameter BURSTCOUNT_WIDTH = 1,
    parameter BYTEENABLE_WIDTH = WIDTH_D,
    parameter MAX_PENDING_READS = 64
)
(
    input clk,
    input resetn,

    // Agent port
    input [S_WIDTH_A-1:0] agent_address,  // Word address
    input [WIDTH_D-1:0] agent_writedata,
    input agent_read,
    input agent_write,
    input [BURSTCOUNT_WIDTH-1:0] agent_burstcount,
    input [BYTEENABLE_WIDTH-1:0] agent_byteenable,
    output agent_waitrequest,
    output [WIDTH_D-1:0] agent_readdata,
    output agent_readdatavalid,

    output [M_WIDTH_A-1:0] host_address,  // Byte address
    output [WIDTH_D-1:0] host_writedata,
    output host_read,
    output host_write,
    output [BYTEENABLE_WIDTH-1:0] host_byteenable,
    input host_waitrequest,
    input [WIDTH_D-1:0] host_readdata
);


assign host_read = agent_read;
assign host_write = agent_write;
assign host_writedata = agent_writedata;
assign host_address = {agent_address,{$clog2(WIDTH_D/8){1'b0}}}; //byteaddr
assign host_byteenable = agent_byteenable;
assign agent_waitrequest = host_waitrequest;
assign agent_readdatavalid = agent_read & ~host_waitrequest;
assign agent_readdata = host_readdata;

endmodule
