/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.cif;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.BinaryDocument;
import javajs.util.CifDataParser;
import javajs.util.Lst;
import javajs.util.MessagePackReader;
import javajs.util.SB;
import org.jmol.adapter.readers.cif.BCIFDecoder;
import org.jmol.adapter.readers.cif.BCIFReader;

class BCIFDataParser
extends CifDataParser {
    private BCIFReader rdr;
    private String categoryName;
    private int rowCount;
    private Object[] columnMaps;
    private BCIFDecoder[] columnDcoders;
    private int rowPt;
    int ifield;
    float dfield;
    String fieldStr;
    boolean fieldIsValid;
    private Hashtable<String, BCIFDecoder> cifMap;
    public String header;

    public BCIFDataParser(BCIFReader bcifReader, boolean debugging) {
        this.rdr = bcifReader;
        this.debugging = debugging;
    }

    private BCIFDecoder getDecoder(String key, Map<String, Object> col, int rowCount, String catName) {
        SB sb = null;
        BCIFDecoder d = new BCIFDecoder(key, col, sb).setRowCount(rowCount, catName).finalizeDecoding(null);
        return d == null || d.dataType == 0 ? null : d;
    }

    public void initializeCategory(String catName, int rowCount, Object[] columns) {
        this.columnMaps = columns;
        this.rowCount = rowCount;
        this.categoryName = catName;
        int n = this.columnCount = columns.length;
        if (this.columnNames == null || this.columnNames.length < n) {
            this.columnNames = new String[n];
        }
        for (int i = 0; i < n; ++i) {
            this.columnNames[i] = (catName + "_" + ((Map)columns[i]).get("name")).toLowerCase();
        }
    }

    @Override
    public void parseDataBlockParameters(String[] fieldNames, String key, String data, int[] key2col, int[] col2key) throws Exception {
        this.haveData = false;
        this.rowPt = -1;
        if (!htFields.containsKey(fieldNames[0])) {
            int i = fieldNames.length;
            while (--i >= 0) {
                htFields.put(fieldNames[i], i);
            }
        }
        this.columnDcoders = new BCIFDecoder[this.columnCount];
        for (int pt = 0; pt < this.columnCount; ++pt) {
            BCIFDecoder d;
            String s = this.columnNames[pt];
            Integer iField = (Integer)htFields.get(s);
            col2key[pt] = iField == null ? -1 : iField;
            int keyIndex = col2key[pt];
            BCIFDecoder bCIFDecoder = d = keyIndex == -1 ? null : this.getDecoder(null, this.getDataColumn(pt), this.rowCount, this.categoryName);
            if (d == null) {
                System.out.println("BCIFDataParser skipping " + s);
                continue;
            }
            this.columnDcoders[pt] = d;
            key2col[keyIndex] = pt;
            this.haveData = true;
        }
    }

    void decodeAndGetData(int icol) {
        this.columnDcoders = new BCIFDecoder[]{this.getDecoder(null, this.getDataColumn(icol), this.rowCount, this.categoryName)};
        this.getColumnData(0);
        this.columnDcoders = null;
    }

    @Override
    public boolean getData() throws Exception {
        boolean done;
        ++this.rowPt;
        boolean bl = done = this.rowPt >= this.rowCount;
        if (done) {
            int i = this.columnDcoders.length;
            while (--i >= 0) {
                this.columnDcoders[i] = null;
            }
        }
        return !done;
    }

    @Override
    public Object getColumnData(int colPt) {
        this.rdr.key = this.getColumnName(colPt);
        this.ifield = Integer.MIN_VALUE;
        this.dfield = Float.NaN;
        if (this.columnDcoders[colPt] == null) {
            this.fieldIsValid = false;
            this.fieldStr = this.nullString;
            return this.fieldStr;
        }
        switch (this.columnDcoders[colPt].dataType) {
            case 1: {
                this.ifield = this.columnDcoders[colPt].getIntValue(this.rowPt);
                this.fieldStr = this.ifield == Integer.MIN_VALUE ? this.nullString : "_";
                break;
            }
            case 2: {
                this.dfield = this.columnDcoders[colPt].getFixedPtValue(this.rowPt);
                this.fieldStr = Double.isNaN(this.dfield) ? this.nullString : "_";
                break;
            }
            case 3: {
                this.fieldStr = this.columnDcoders[colPt].getStringValue(this.rowPt);
            }
        }
        this.fieldIsValid = this.fieldStr != this.nullString;
        return this.fieldStr;
    }

    protected boolean isFieldValid() {
        return this.fieldIsValid;
    }

    private Map<String, Object> getDataColumn(int icol) {
        return icol >= 0 && icol < this.columnCount ? (Map)this.columnMaps[icol] : null;
    }

    @Override
    public Map<String, Object> getAllCifData() {
        return null;
    }

    void debugConstructCifMap(Map<String, Object> msgMap) {
        SB sb = new SB();
        try {
            this.cifMap = new Hashtable();
            String header = (String)msgMap.get("header");
            System.out.println("BCIFDataParser header is " + header);
            Map dataBlock = (Map)((Object[])msgMap.get("dataBlocks"))[0];
            BCIFDataParser.dumpMap(sb, dataBlock, "");
            Object[] categories = (Object[])dataBlock.get("categories");
            for (int j = 0; j < categories.length; ++j) {
                int ncol;
                Map cat = (Map)categories[j];
                if (cat.isEmpty()) continue;
                int rowCount = BCIFDecoder.geMapInt(cat.get("rowCount"));
                String catName = ((String)cat.get("name")).toLowerCase();
                Object[] columns = (Object[])cat.get("columns");
                Lst<String> lst = new Lst<String>();
                int k = ncol = columns == null ? 0 : columns.length;
                while (--k >= 0) {
                    Map col = (Map)columns[k];
                    String key = catName + "_" + ((String)col.get("name")).toLowerCase();
                    lst.addLast(key);
                    BCIFDecoder d = new BCIFDecoder(key, col, sb).setRowCount(rowCount, catName);
                    d.debugDecode(sb);
                    this.cifMap.put(key, d);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            FileOutputStream fos = new FileOutputStream("c:/temp/t.log");
            fos.write(sb.toString().getBytes());
            fos.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void dumpMap(SB sb, Map<String, Object> value, String key) {
        for (String k : value.keySet()) {
            Object v = value.get(k);
            if (v instanceof Map) {
                BCIFDataParser.dumpMap(sb, (Map)v, key + ":" + k);
                continue;
            }
            if (v instanceof String || v instanceof Number || v instanceof Boolean) {
                sb.append(key + ":" + k + "=" + v + "\n");
                continue;
            }
            if (v instanceof Object[]) {
                Object[] a = (Object[])v;
                for (int i = 0; i < a.length; ++i) {
                    BCIFDataParser.dumpMap(sb, (Map)a[i], key + ":" + k + "[" + i + "]");
                }
                continue;
            }
            if (k.equals("offsets") || k.equals("data")) {
                sb.append(key + ":" + k + " is " + ((byte[])v).length + " " + Arrays.toString((byte[])v) + "\n");
                continue;
            }
            if (v instanceof byte[]) {
                sb.append(key + ":" + k + " is byte[" + ((byte[])v).length + "]\n");
                continue;
            }
            sb.append(key + ":" + k + " is " + v.getClass().getName() + "\n");
        }
    }

    public static void main(String[] args) {
        try {
            String testFile = args.length == 0 ? "c:/temp/1cbs.bcif" : args[0];
            BinaryDocument binaryDoc = new BinaryDocument();
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(testFile));
            binaryDoc.setStream(bis, true);
            Map<String, Object> msgMap = new MessagePackReader(binaryDoc, false).readMap();
            BCIFDataParser parser = new BCIFDataParser(null, true);
            parser.debugConstructCifMap(msgMap);
            binaryDoc.close();
            System.out.println("OK - DONE");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

