/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.transport;

import java.io.IOException;
import java.util.Map;
import org.opensearch.action.support.nodes.BaseNodeResponse;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;

public class ADStatsNodeResponse
extends BaseNodeResponse
implements ToXContentFragment {
    private Map<String, Object> statsMap;

    public ADStatsNodeResponse(StreamInput in) throws IOException {
        super(in);
        this.statsMap = in.readMap(StreamInput::readString, StreamInput::readGenericValue);
    }

    public ADStatsNodeResponse(DiscoveryNode node, Map<String, Object> statsToValues) {
        super(node);
        this.statsMap = statsToValues;
    }

    public static ADStatsNodeResponse readStats(StreamInput in) throws IOException {
        return new ADStatsNodeResponse(in);
    }

    public Map<String, Object> getStatsMap() {
        return this.statsMap;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeMap(this.statsMap, StreamOutput::writeString, StreamOutput::writeGenericValue);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        for (String stat : this.statsMap.keySet()) {
            builder.field(stat, this.statsMap.get(stat));
        }
        return builder;
    }
}

