/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.transport;

import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.nodes.TransportNodesAction;
import org.opensearch.ad.NodeStateManager;
import org.opensearch.ad.caching.CacheProvider;
import org.opensearch.ad.feature.FeatureManager;
import org.opensearch.ad.ml.EntityColdStarter;
import org.opensearch.ad.ml.ModelManager;
import org.opensearch.ad.task.ADTaskManager;
import org.opensearch.ad.transport.CronAction;
import org.opensearch.ad.transport.CronNodeRequest;
import org.opensearch.ad.transport.CronNodeResponse;
import org.opensearch.ad.transport.CronRequest;
import org.opensearch.ad.transport.CronResponse;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class CronTransportAction
extends TransportNodesAction<CronRequest, CronResponse, CronNodeRequest, CronNodeResponse> {
    private final Logger LOG = LogManager.getLogger(CronTransportAction.class);
    private NodeStateManager transportStateManager;
    private ModelManager modelManager;
    private FeatureManager featureManager;
    private CacheProvider cacheProvider;
    private EntityColdStarter entityColdStarter;
    private ADTaskManager adTaskManager;

    @Inject
    public CronTransportAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, NodeStateManager tarnsportStatemanager, ModelManager modelManager, FeatureManager featureManager, CacheProvider cacheProvider, EntityColdStarter entityColdStarter, ADTaskManager adTaskManager) {
        super(CronAction.NAME, threadPool, clusterService, transportService, actionFilters, CronRequest::new, CronNodeRequest::new, "management", CronNodeResponse.class);
        this.transportStateManager = tarnsportStatemanager;
        this.modelManager = modelManager;
        this.featureManager = featureManager;
        this.cacheProvider = cacheProvider;
        this.entityColdStarter = entityColdStarter;
        this.adTaskManager = adTaskManager;
    }

    protected CronResponse newResponse(CronRequest request, List<CronNodeResponse> responses, List<FailedNodeException> failures) {
        return new CronResponse(this.clusterService.getClusterName(), responses, failures);
    }

    protected CronNodeRequest newNodeRequest(CronRequest request) {
        return new CronNodeRequest();
    }

    protected CronNodeResponse newNodeResponse(StreamInput in) throws IOException {
        return new CronNodeResponse(in);
    }

    protected CronNodeResponse nodeOperation(CronNodeRequest request) {
        this.LOG.info("Start running AD hourly cron.");
        this.modelManager.maintenance((ActionListener<Void>)ActionListener.wrap(v -> this.LOG.debug("model maintenance done"), e -> this.LOG.error("Error maintaining model", (Throwable)e)));
        this.cacheProvider.get().maintenance();
        this.featureManager.maintenance();
        this.transportStateManager.maintenance();
        this.entityColdStarter.maintenance();
        this.adTaskManager.cleanChildTasksAndADResultsOfDeletedTask();
        this.adTaskManager.cleanADResultOfDeletedDetector();
        this.adTaskManager.maintainRunningHistoricalTasks(this.transportService, 100);
        this.adTaskManager.maintainRunningRealtimeTasks();
        return new CronNodeResponse(this.clusterService.localNode());
    }
}

