/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.notifications.model;

import java.io.IOException;
import java.util.Map;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.commons.notifications.model.BaseConfigData;
import org.opensearch.commons.notifications.model.HttpMethodType;
import org.opensearch.commons.notifications.model.XParser;
import org.opensearch.commons.utils.HelpersKt;
import org.opensearch.commons.utils.TransportHelpersKt;
import org.opensearch.commons.utils.ValidationHelpersKt;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 &2\u00020\u0001:\u0001&B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B-\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0012\u001a\u00020\u0006H\u00c6\u0003J\u0015\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\bH\u00c6\u0003J\t\u0010\u0014\u001a\u00020\nH\u00c6\u0003J3\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0006H\u00d6\u0001J\u001c\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001e2\b\u0010 \u001a\u0004\u0018\u00010!H\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006'"}, d2={"Lorg/opensearch/commons/notifications/model/Webhook;", "Lorg/opensearch/commons/notifications/model/BaseConfigData;", "input", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "url", "", "headerParams", "", "method", "Lorg/opensearch/commons/notifications/model/HttpMethodType;", "(Ljava/lang/String;Ljava/util/Map;Lorg/opensearch/commons/notifications/model/HttpMethodType;)V", "getHeaderParams", "()Ljava/util/Map;", "getMethod", "()Lorg/opensearch/commons/notifications/model/HttpMethodType;", "getUrl", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "writeTo", "", "output", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "Companion", "common-utils"})
@SourceDebugExtension(value={"SMAP\nWebhook.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Webhook.kt\norg/opensearch/commons/notifications/model/Webhook\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,116:1\n1#2:117\n*E\n"})
public final class Webhook
implements BaseConfigData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String url;
    @NotNull
    private final Map<String, String> headerParams;
    @NotNull
    private final HttpMethodType method;
    @NotNull
    private static final Lazy<Logger> log$delegate = HelpersKt.logger(Webhook.class);
    @NotNull
    private static final Writeable.Reader<Webhook> reader = Webhook::reader$lambda$1;
    @NotNull
    private static final XParser<Webhook> xParser = Webhook::xParser$lambda$2;

    public Webhook(@NotNull String url, @NotNull Map<String, String> headerParams, @NotNull HttpMethodType method) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(headerParams, (String)"headerParams");
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
        this.url = url;
        this.headerParams = headerParams;
        this.method = method;
        if (!(!Strings.isNullOrEmpty((String)this.url))) {
            boolean bl = false;
            String string = "URL is null or empty";
            throw new IllegalArgumentException(string.toString());
        }
        ValidationHelpersKt.validateUrl(this.url);
    }

    public /* synthetic */ Webhook(String string, Map map, HttpMethodType httpMethodType, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 4) != 0) {
            httpMethodType = HttpMethodType.POST;
        }
        this(string, map, httpMethodType);
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    @NotNull
    public final Map<String, String> getHeaderParams() {
        return this.headerParams;
    }

    @NotNull
    public final HttpMethodType getMethod() {
        return this.method;
    }

    @NotNull
    public XContentBuilder toXContent(@Nullable XContentBuilder builder, @Nullable ToXContent.Params params) {
        Intrinsics.checkNotNull((Object)builder);
        XContentBuilder xContentBuilder = builder.startObject().field("url", this.url).field("header_params", this.headerParams).field("method", this.method.getTag()).endObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"builder.startObject()\n  \u2026\n            .endObject()");
        return xContentBuilder;
    }

    public Webhook(@NotNull StreamInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        String string = input.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"input.readString()");
        Map map = input.readMap(TransportHelpersKt.getSTRING_READER(), TransportHelpersKt.getSTRING_READER());
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"input.readMap(STRING_READER, STRING_READER)");
        Enum enum_ = input.readEnum(HttpMethodType.class);
        Intrinsics.checkNotNullExpressionValue((Object)enum_, (String)"input.readEnum(HttpMethodType::class.java)");
        this(string, map, (HttpMethodType)enum_);
    }

    public void writeTo(@NotNull StreamOutput output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        output.writeString(this.url);
        output.writeMap(this.headerParams, TransportHelpersKt.getSTRING_WRITER(), TransportHelpersKt.getSTRING_WRITER());
        output.writeEnum((Enum)this.method);
    }

    @NotNull
    public final String component1() {
        return this.url;
    }

    @NotNull
    public final Map<String, String> component2() {
        return this.headerParams;
    }

    @NotNull
    public final HttpMethodType component3() {
        return this.method;
    }

    @NotNull
    public final Webhook copy(@NotNull String url, @NotNull Map<String, String> headerParams, @NotNull HttpMethodType method) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(headerParams, (String)"headerParams");
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
        return new Webhook(url, headerParams, method);
    }

    public static /* synthetic */ Webhook copy$default(Webhook webhook, String string, Map map, HttpMethodType httpMethodType, int n, Object object) {
        if ((n & 1) != 0) {
            string = webhook.url;
        }
        if ((n & 2) != 0) {
            map = webhook.headerParams;
        }
        if ((n & 4) != 0) {
            httpMethodType = webhook.method;
        }
        return webhook.copy(string, map, httpMethodType);
    }

    @NotNull
    public String toString() {
        return "Webhook(url=" + this.url + ", headerParams=" + this.headerParams + ", method=" + this.method + ")";
    }

    public int hashCode() {
        int result = this.url.hashCode();
        result = result * 31 + ((Object)this.headerParams).hashCode();
        result = result * 31 + this.method.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Webhook)) {
            return false;
        }
        Webhook webhook = (Webhook)other;
        if (!Intrinsics.areEqual((Object)this.url, (Object)webhook.url)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.headerParams, webhook.headerParams)) {
            return false;
        }
        return this.method == webhook.method;
    }

    private static final Webhook reader$lambda$1(StreamInput it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return new Webhook(it);
    }

    private static final Webhook xParser$lambda$2(XContentParser it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Companion.parse(it);
    }

    @JvmStatic
    @NotNull
    public static final Webhook parse(@NotNull XContentParser parser) throws IOException {
        return Companion.parse(parser);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001f\u0010\t\u001a\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0016"}, d2={"Lorg/opensearch/commons/notifications/model/Webhook$Companion;", "", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "reader", "Lorg/opensearch/core/common/io/stream/Writeable$Reader;", "Lorg/opensearch/commons/notifications/model/Webhook;", "kotlin.jvm.PlatformType", "getReader", "()Lorg/opensearch/core/common/io/stream/Writeable$Reader;", "xParser", "Lorg/opensearch/commons/notifications/model/XParser;", "getXParser", "()Lorg/opensearch/commons/notifications/model/XParser;", "parse", "parser", "Lorg/opensearch/core/xcontent/XContentParser;", "common-utils"})
    public static final class Companion {
        private Companion() {
        }

        private final Logger getLog() {
            Lazy lazy = log$delegate;
            return (Logger)lazy.getValue();
        }

        @NotNull
        public final Writeable.Reader<Webhook> getReader() {
            return reader;
        }

        @NotNull
        public final XParser<Webhook> getXParser() {
            return xParser;
        }

        /*
         * Unable to fully structure code
         */
        @JvmStatic
        @NotNull
        public final Webhook parse(@NotNull XContentParser parser) throws IOException {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            url = null;
            headerParams = MapsKt.emptyMap();
            method = HttpMethodType.POST;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
            block5: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                block8: {
                    block9: {
                        fieldName = parser.currentName();
                        parser.nextToken();
                        var6_6 = fieldName;
                        if (var6_6 == null) break block8;
                        switch (var6_6.hashCode()) {
                            case -318141576: {
                                if (var6_6.equals("header_params")) break;
                                ** break;
                            }
                            case -1077554975: {
                                if (!var6_6.equals("method")) {
                                    ** break;
                                }
                                break block9;
                            }
                            case 116079: {
                                if (!var6_6.equals("url")) ** break;
                                url = parser.text();
                                continue block5;
                            }
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)parser.mapStrings(), (String)"parser.mapStrings()");
                        continue;
                    }
                    v0 = parser.text();
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"parser.text()");
                    method = HttpMethodType.Companion.fromTagOrDefault(v0);
                    continue;
                }
                parser.skipChildren();
                this.getLog().info("Unexpected field: " + fieldName + ", while parsing Webhook destination");
            }
            if (url == null) {
                throw new IllegalArgumentException("url field absent");
            }
            return new Webhook(url, headerParams, method);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

