/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapidiff.core.model.deferred;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.openapitools.openapidiff.core.model.deferred.DeferredChanged;
import org.openapitools.openapidiff.core.model.deferred.DeferredLogger;
import org.openapitools.openapidiff.core.model.deferred.RealizedChanged;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PendingChanged<T>
implements DeferredChanged<T> {
    private static final Logger log = LoggerFactory.getLogger(PendingChanged.class);
    private final List<Consumer<T>> ifPresentConsumers = new ArrayList<Consumer<T>>();
    private final List<Consumer<Optional<T>>> whenSetConsumers = new ArrayList<Consumer<Optional<T>>>();
    @Nullable
    private T value;
    private Optional<T> valueOptional = Optional.empty();
    private boolean valueIsPresent;
    private boolean valueSet;
    private static final AtomicInteger deferredCounter = new AtomicInteger();
    private static final AtomicInteger resolvedCounter = new AtomicInteger();

    @Override
    public void ifPresent(Consumer<T> consumer) {
        if (this.valueSet) {
            if (this.valueIsPresent) {
                consumer.accept(this.value);
            }
        } else {
            this.ifPresentConsumers.add(consumer);
        }
    }

    public void setValue(Optional<T> value) {
        if (!this.valueSet) {
            this.valueSet = true;
            this.valueIsPresent = value.isPresent();
            this.value = value.orElse(null);
            this.valueOptional = value;
            log.debug("set {}", DeferredLogger.logValue(this.value));
            if (this.valueIsPresent) {
                this.ifPresentConsumers.forEach(c -> c.accept(this.value));
            }
        } else {
            throw new IllegalStateException("PendingChanged may not be set more than once. Value was already set.");
        }
        this.whenSetConsumers.forEach(c -> c.accept(this.valueOptional));
    }

    @Override
    public boolean isPresent() {
        return this.valueSet && this.valueIsPresent;
    }

    @Override
    public T get() {
        return this.valueOptional.get();
    }

    @Override
    public boolean isValueSet() {
        return this.valueSet;
    }

    @Override
    public void whenSet(Consumer<Optional<T>> consumer) {
        if (this.valueSet) {
            consumer.accept(this.valueOptional);
        } else {
            this.whenSetConsumers.add(consumer);
        }
    }

    @Override
    public <Q> DeferredChanged<Q> map(Function<Optional<T>, Q> function) {
        return this.mapOptional(v -> Optional.ofNullable(function.apply((Optional)v)));
    }

    @Override
    public <Q> DeferredChanged<Q> mapOptional(Function<Optional<T>, Optional<Q>> function) {
        if (this.valueSet) {
            Optional<Q> result = function.apply(this.valueOptional);
            log.debug("map resolved {} {} -> {}", function, DeferredLogger.logValue(this.value), DeferredLogger.logValue(result));
            return new RealizedChanged<Q>(result);
        }
        PendingChanged<T> mappedChanged = new PendingChanged<T>();
        log.debug("map deferred {} ? -> ?", (Object)function);
        deferredCounter.incrementAndGet();
        this.whenSet(value -> {
            Optional result = (Optional)function.apply(this.valueOptional);
            log.debug("map resolved {} {} -> {}", function, DeferredLogger.logValue(this.value), DeferredLogger.logValue(result));
            resolvedCounter.incrementAndGet();
            mappedChanged.setValue(result);
        });
        return mappedChanged;
    }

    @Override
    public <Q> DeferredChanged<Q> flatMap(Function<Optional<T>, DeferredChanged<Q>> function) {
        if (this.valueSet) {
            DeferredChanged<Q> nextDeferred = function.apply(this.valueOptional);
            log.debug("flat map deferred {} {} -> ?", (Object)function, DeferredLogger.logValue(this.value));
            deferredCounter.incrementAndGet();
            nextDeferred.whenSet(nextValue -> {
                log.debug("flat map resolved {} {} -> {}", function, DeferredLogger.logValue(this.value), DeferredLogger.logValue(nextValue));
                resolvedCounter.incrementAndGet();
            });
            return nextDeferred;
        }
        PendingChanged<T> mappedChanged = new PendingChanged<T>();
        log.debug("flat map deferred {} ? -> ?", (Object)function);
        deferredCounter.incrementAndGet();
        this.whenSet(value -> {
            DeferredChanged nextDeferred = (DeferredChanged)function.apply((Optional<Optional<T>>)value);
            nextDeferred.whenSet(nextValue -> {
                log.debug("flat map deferred {} {} -> {}", function, DeferredLogger.logValue(this.value), DeferredLogger.logValue(nextValue));
                resolvedCounter.incrementAndGet();
                mappedChanged.setValue((Optional<T>)nextValue);
            });
            log.debug("flat map resolved {} {} -> ?", (Object)function, DeferredLogger.logValue(value));
        });
        return mappedChanged;
    }

    public String toString() {
        return "PendingChanged{value=" + DeferredLogger.logValue(this.value) + ", valueSet=" + this.valueSet + ", ifPresentConsumers.size=" + this.ifPresentConsumers.size() + ", whenSetConsumers.size=" + this.whenSetConsumers.size() + '}';
    }

    public static void logResolved() {
        int deferred = deferredCounter.get();
        int resolved = resolvedCounter.get();
        log.debug("Outstanding: {}  Deferred: {}  Resolved {}", deferred - resolved, deferred, resolved);
    }
}

