/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.service;

import java.util.Collections;
import java.util.Map;
import org.opensearch.cluster.ClusterName;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.ClusterStateApplier;
import org.opensearch.cluster.ClusterStateListener;
import org.opensearch.cluster.ClusterStateTaskConfig;
import org.opensearch.cluster.ClusterStateTaskExecutor;
import org.opensearch.cluster.ClusterStateTaskListener;
import org.opensearch.cluster.LocalNodeClusterManagerListener;
import org.opensearch.cluster.LocalNodeMasterListener;
import org.opensearch.cluster.NodeConnectionsService;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.routing.OperationRouting;
import org.opensearch.cluster.routing.RerouteService;
import org.opensearch.cluster.service.ClusterApplierService;
import org.opensearch.cluster.service.ClusterManagerService;
import org.opensearch.cluster.service.ClusterManagerTaskThrottler;
import org.opensearch.cluster.service.MasterService;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.lifecycle.AbstractLifecycleComponent;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.index.IndexingPressureService;
import org.opensearch.node.Node;
import org.opensearch.threadpool.ThreadPool;

@PublicApi(since="1.0.0")
public class ClusterService
extends AbstractLifecycleComponent {
    private final ClusterManagerService clusterManagerService;
    private final ClusterApplierService clusterApplierService;
    public static final Setting.AffixSetting<String> USER_DEFINED_METADATA = Setting.prefixKeySetting("cluster.metadata.", key -> Setting.simpleString(key, Setting.Property.Dynamic, Setting.Property.NodeScope));
    private final Settings settings;
    private final ClusterName clusterName;
    private final OperationRouting operationRouting;
    private final ClusterSettings clusterSettings;
    private final String nodeName;
    private RerouteService rerouteService;
    private IndexingPressureService indexingPressureService;

    public ClusterService(Settings settings, ClusterSettings clusterSettings, ThreadPool threadPool) {
        this(settings, clusterSettings, new ClusterManagerService(settings, clusterSettings, threadPool), new ClusterApplierService(Node.NODE_NAME_SETTING.get(settings), settings, clusterSettings, threadPool));
    }

    public ClusterService(Settings settings, ClusterSettings clusterSettings, ClusterManagerService clusterManagerService, ClusterApplierService clusterApplierService) {
        this.settings = settings;
        this.nodeName = Node.NODE_NAME_SETTING.get(settings);
        this.clusterManagerService = clusterManagerService;
        this.operationRouting = new OperationRouting(settings, clusterSettings);
        this.clusterSettings = clusterSettings;
        this.clusterName = ClusterName.CLUSTER_NAME_SETTING.get(settings);
        this.clusterSettings.addAffixUpdateConsumer(USER_DEFINED_METADATA, (first, second) -> {}, (first, second) -> {});
        this.clusterApplierService = clusterApplierService;
    }

    public synchronized void setNodeConnectionsService(NodeConnectionsService nodeConnectionsService) {
        this.clusterApplierService.setNodeConnectionsService(nodeConnectionsService);
    }

    public void setRerouteService(RerouteService rerouteService) {
        assert (this.rerouteService == null) : "RerouteService is already set";
        this.rerouteService = rerouteService;
    }

    public RerouteService getRerouteService() {
        assert (this.rerouteService != null) : "RerouteService not set";
        return this.rerouteService;
    }

    protected synchronized void doStart() {
        this.clusterApplierService.start();
        this.clusterManagerService.start();
    }

    protected synchronized void doStop() {
        this.clusterManagerService.stop();
        this.clusterApplierService.stop();
    }

    protected synchronized void doClose() {
        this.clusterManagerService.close();
        this.clusterApplierService.close();
    }

    public DiscoveryNode localNode() {
        DiscoveryNode localNode = this.state().getNodes().getLocalNode();
        if (localNode == null) {
            throw new IllegalStateException("No local node found. Is the node started?");
        }
        return localNode;
    }

    public OperationRouting operationRouting() {
        return this.operationRouting;
    }

    public ClusterState state() {
        return this.clusterApplierService.state();
    }

    public void addHighPriorityApplier(ClusterStateApplier applier) {
        this.clusterApplierService.addHighPriorityApplier(applier);
    }

    public void addLowPriorityApplier(ClusterStateApplier applier) {
        this.clusterApplierService.addLowPriorityApplier(applier);
    }

    public void addStateApplier(ClusterStateApplier applier) {
        this.clusterApplierService.addStateApplier(applier);
    }

    public void removeApplier(ClusterStateApplier applier) {
        this.clusterApplierService.removeApplier(applier);
    }

    public void addListener(ClusterStateListener listener) {
        this.clusterApplierService.addListener(listener);
    }

    public void removeListener(ClusterStateListener listener) {
        this.clusterApplierService.removeListener(listener);
    }

    public void addLocalNodeClusterManagerListener(LocalNodeClusterManagerListener listener) {
        this.clusterApplierService.addLocalNodeClusterManagerListener(listener);
    }

    @Deprecated
    public void addLocalNodeMasterListener(LocalNodeMasterListener listener) {
        this.addLocalNodeClusterManagerListener(listener);
    }

    public ClusterManagerService getClusterManagerService() {
        return this.clusterManagerService;
    }

    @Deprecated
    public MasterService getMasterService() {
        return this.clusterManagerService;
    }

    public void setIndexingPressureService(IndexingPressureService indexingPressureService) {
        this.indexingPressureService = indexingPressureService;
    }

    public IndexingPressureService getIndexingPressureService() {
        return this.indexingPressureService;
    }

    public ClusterApplierService getClusterApplierService() {
        return this.clusterApplierService;
    }

    public static boolean assertClusterOrClusterManagerStateThread() {
        assert (Thread.currentThread().getName().contains("clusterApplierService#updateTask") || Thread.currentThread().getName().contains("clusterManagerService#updateTask")) : "not called from the master/cluster state update thread";
        return true;
    }

    @Deprecated
    public static boolean assertClusterOrMasterStateThread() {
        return ClusterService.assertClusterOrClusterManagerStateThread();
    }

    public ClusterName getClusterName() {
        return this.clusterName;
    }

    public ClusterSettings getClusterSettings() {
        return this.clusterSettings;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public final String getNodeName() {
        return this.nodeName;
    }

    public ClusterManagerTaskThrottler.ThrottlingKey registerClusterManagerTask(String taskKey, boolean throttlingEnabled) {
        return this.clusterManagerService.registerClusterManagerTask(taskKey, throttlingEnabled);
    }

    public <T extends ClusterStateTaskConfig & ClusterStateTaskExecutor<T>> void submitStateUpdateTask(String source, T updateTask) {
        this.submitStateUpdateTask(source, updateTask, updateTask, updateTask, (ClusterStateTaskListener)updateTask);
    }

    public <T> void submitStateUpdateTask(String source, T task, ClusterStateTaskConfig config, ClusterStateTaskExecutor<T> executor, ClusterStateTaskListener listener) {
        this.submitStateUpdateTasks(source, Collections.singletonMap(task, listener), config, executor);
    }

    public <T> void submitStateUpdateTasks(String source, Map<T, ClusterStateTaskListener> tasks, ClusterStateTaskConfig config, ClusterStateTaskExecutor<T> executor) {
        this.clusterManagerService.submitStateUpdateTasks(source, tasks, config, executor);
    }
}

