/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.blobstore.stream.read;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.common.io.InputStreamContainer;

@ExperimentalApi
public class ReadContext {
    private final long blobSize;
    private final List<StreamPartCreator> asyncPartStreams;
    private final String blobChecksum;

    public ReadContext(long blobSize, List<StreamPartCreator> asyncPartStreams, String blobChecksum) {
        this.blobSize = blobSize;
        this.asyncPartStreams = asyncPartStreams;
        this.blobChecksum = blobChecksum;
    }

    public ReadContext(ReadContext readContext) {
        this.blobSize = readContext.blobSize;
        this.asyncPartStreams = readContext.asyncPartStreams;
        this.blobChecksum = readContext.blobChecksum;
    }

    public String getBlobChecksum() {
        return this.blobChecksum;
    }

    public int getNumberOfParts() {
        return this.asyncPartStreams.size();
    }

    public long getBlobSize() {
        return this.blobSize;
    }

    public List<StreamPartCreator> getPartStreams() {
        return this.asyncPartStreams;
    }

    @FunctionalInterface
    public static interface StreamPartCreator
    extends Supplier<CompletableFuture<InputStreamContainer>> {
        @Override
        public CompletableFuture<InputStreamContainer> get();
    }
}

