/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.javax.el;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.hadoop.shaded.javax.el.ELContext;

class ELUtil {
    private static ThreadLocal instance = new ThreadLocal(){

        protected Object initialValue() {
            return null;
        }
    };

    private ELUtil() {
    }

    private static Map getCurrentInstance() {
        HashMap result = (HashMap)instance.get();
        if (null == result) {
            result = new HashMap();
            ELUtil.setCurrentInstance(result);
        }
        return result;
    }

    private static void setCurrentInstance(Map context) {
        instance.set(context);
    }

    public static String getExceptionMessageString(ELContext context, String messageId) {
        return ELUtil.getExceptionMessageString(context, messageId, null);
    }

    public static String getExceptionMessageString(ELContext context, String messageId, Object[] params) {
        String result = "";
        Locale locale = null;
        if (null == context || null == messageId) {
            return result;
        }
        locale = context.getLocale();
        if (null == locale) {
            locale = Locale.getDefault();
        }
        if (null != locale) {
            Map threadMap = ELUtil.getCurrentInstance();
            ResourceBundle rb = null;
            rb = (ResourceBundle)threadMap.get(locale.toString());
            if (null == rb) {
                rb = ResourceBundle.getBundle("org.apache.hadoop.shaded.javax.el.PrivateMessages", locale);
                threadMap.put(locale.toString(), rb);
            }
            if (null != rb) {
                try {
                    result = rb.getString(messageId);
                    if (null != params) {
                        result = MessageFormat.format(result, params);
                    }
                }
                catch (IllegalArgumentException iae) {
                    result = "Can't get localized message: parameters to message appear to be incorrect.  Message to format: " + messageId;
                }
                catch (MissingResourceException mre) {
                    result = "Missing Resource in EL implementation: ???" + messageId + "???";
                }
                catch (Exception e) {
                    result = "Exception resolving message in EL implementation: ???" + messageId + "???";
                }
            }
        }
        return result;
    }
}

